/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.dataconverter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Area;
import kd.data.idi.data.AreaResult;
import kd.data.idi.data.BillFlowResult;
import kd.data.idi.data.Company;
import kd.data.idi.data.Courier;
import kd.data.idi.data.CourierDataResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.FasindexConfig;
import kd.data.idi.data.FasindexResult;
import kd.data.idi.data.GradeItem;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.InvoiceCloudCodeType;
import kd.data.idi.data.InvoiceFailureEntity;
import kd.data.idi.data.InvoiceImageResult;
import kd.data.idi.data.InvoiceImageRuleResult;
import kd.data.idi.data.LineCard;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.News;
import kd.data.idi.data.NewsConfig;
import kd.data.idi.data.NewsResult;
import kd.data.idi.data.NodeLineStatusEnum;
import kd.data.idi.data.NodeStatusEnum;
import kd.data.idi.data.NumericalUnitEnum;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.data.StatisticsResult;
import kd.data.idi.data.TableDataResult;
import kd.data.idi.data.TableLineNode;
import kd.data.idi.data.attachment.CheckAttachmentTypeEnum;
import kd.data.idi.data.show.BillFlowModel;
import kd.data.idi.data.show.BusinessCatalogs;
import kd.data.idi.data.show.CardModel;
import kd.data.idi.data.show.CardRowModel;
import kd.data.idi.data.show.Carousel;
import kd.data.idi.data.show.DimensionModel;
import kd.data.idi.data.show.FasindexModel;
import kd.data.idi.data.show.FasindexTableDataModel;
import kd.data.idi.data.show.HrefItemModel;
import kd.data.idi.data.show.IconItemModel;
import kd.data.idi.data.show.ItemModel;
import kd.data.idi.data.show.LineCardModel;
import kd.data.idi.data.show.LineCardRowModel;
import kd.data.idi.data.show.PopoverModel;
import kd.data.idi.data.show.PopoverRowModel;
import kd.data.idi.data.show.StatisticModel;
import kd.data.idi.data.show.TableLineNodeModel;
import kd.data.idi.data.show.TextItemModel;
import kd.data.idi.data.show.TimeLineFlag;
import kd.data.idi.data.show.TimeLineItemModel;
import kd.data.idi.data.show.URLItemModel;
import kd.data.idi.dataconverter.IDISchemaResultDataConvert;
import kd.data.idi.decision.model.ExtDecisionInfo;
import kd.data.idi.decision.openapi.ApiDecisionResultItem;
import kd.data.idi.decision.service.DecisionTypeExtInfoService;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class IDISchemaResultPCDataConvert
extends IDISchemaResultDataConvert {
    protected static final String HEADER_LIST = "headerList";
    protected static final String CARD_MODEL_LIST = "cardModelList";
    protected static final String STATUS = "status";
    protected static final String IS_PC = "isPC";
    protected static final String GRADE_MORETHAN = "morethan";
    protected static final String GRADE_OTHER = "other";
    protected static final String ICON_AGREE = "agree";
    protected static final String ICON_EXCEPTION = "exception";
    protected static final String ISEXPEND = "isExpend";
    protected static final String ISHIGHLIGHT = "isHighLight";
    private boolean isHighLight = false;
    protected static final String SCHMEAID = "schemaId";
    private Function<String, Boolean> statusFilterResult;
    private boolean filterAI = false;

    public IDISchemaResultPCDataConvert() {
    }

    public IDISchemaResultPCDataConvert(Function<String, Boolean> filterResult, boolean filterAI) {
        this.statusFilterResult = filterResult;
        this.filterAI = filterAI;
    }

    @Override
    public Map<String, Object> convertObject(SchemaResult result, Schema schema) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(STATUS, result.getStatus());
        resultMap.put(IS_PC, Boolean.TRUE);
        resultMap.put(ISEXPEND, ParamFactory.getBoolean(ISEXPEND, true));
        resultMap.put(ISHIGHLIGHT, Boolean.FALSE);
        if (schema == null) {
            return resultMap;
        }
        SchemaExecutorLogger.info(" schema is " + schema.getNumber() + " highLight flag is" + schema.isHighLight(), new Object[0]);
        resultMap.put(SCHMEAID, String.valueOf(schema.getId()));
        try {
            if ("success".equalsIgnoreCase(result.getStatus())) {
                List<CardRowModel> cardRowModelList = this.createHeader(schema, result);
                resultMap.put(HEADER_LIST, cardRowModelList);
                this.isHighLight = schema.isHighLight();
                if (result.getAreaResults() != null && !result.getAreaResults().isEmpty()) {
                    ArrayList<CardModel> cardModelList = new ArrayList<CardModel>(result.getAreaResults().size());
                    resultMap.put(CARD_MODEL_LIST, cardModelList);
                    int index = 1;
                    for (AreaResult areaResult : result.getAreaResults()) {
                        CardModel cm;
                        if ((cm = this.createCard(index++, areaResult)) == null || cm.isEmpty()) continue;
                        cardModelList.add(cm);
                    }
                }
                resultMap.put(ISHIGHLIGHT, this.isHighLight);
            } else {
                String text = this.getErrorSchemaText(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"IDISchemaResultPCDataConvert_0", (String)"data-idi-core", (Object[])new Object[0]), result.getStatus());
                List<CardRowModel> cardRowModelList = this.createErrorHead(text);
                resultMap.put(HEADER_LIST, cardRowModelList);
            }
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error(ex);
            resultMap.put(HEADER_LIST, this.createErrorHead(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"IDISchemaResultPCDataConvert_0", (String)"data-idi-core", (Object[])new Object[0])));
            resultMap.put(CARD_MODEL_LIST, this.createErrorCard());
        }
        return resultMap;
    }

    private List<CardRowModel> createErrorHead(String warnText) {
        ArrayList<CardRowModel> list = new ArrayList<CardRowModel>();
        CardRowModel row = new CardRowModel();
        ArrayList<ItemModel> mainDesc = new ArrayList<ItemModel>();
        TextItemModel rowItemModel1 = new TextItemModel(warnText);
        rowItemModel1.addItemStyle("font-size", "14px");
        rowItemModel1.addItemStyle("color", "#666666");
        mainDesc.add(rowItemModel1);
        row.setMainDesc(mainDesc);
        row.addRowStyle("padding", "0px");
        list.add(row);
        return list;
    }

    private List<CardModel> createErrorCard() {
        CardModel cardModel = new CardModel();
        ArrayList<CardModel> list = new ArrayList<CardModel>();
        list.add(cardModel);
        ArrayList<CardRowModel> rowList = new ArrayList<CardRowModel>();
        CardRowModel firstRow = new CardRowModel();
        ArrayList<ItemModel> items = new ArrayList<ItemModel>();
        IconItemModel icon = new IconItemModel("nodata.png");
        icon.addItemStyle("width", "120px");
        icon.addImageStyle("width", "120px");
        icon.addImageStyle("height", "120px");
        items.add(icon);
        firstRow.setMainDesc(items);
        firstRow.addMainStyle("justify-content", "center");
        rowList.add(firstRow);
        cardModel.setEntity(rowList);
        cardModel.addCardStyle("height", "300px");
        cardModel.addCardStyle("border", "none");
        return list;
    }

    protected List<CardRowModel> createHeader(Schema schema, SchemaResult result) {
        List<GradeItem> gradeList = schema.getGrade();
        GradeItem matchItem = null;
        GradeItem defaultMatchItem = null;
        if (gradeList != null) {
            for (GradeItem item : gradeList) {
                if (GRADE_MORETHAN.equalsIgnoreCase(item.getCondition())) {
                    if (!((float)result.getScore() >= item.getGrade())) continue;
                    matchItem = item;
                    break;
                }
                if (!GRADE_OTHER.equalsIgnoreCase(item.getCondition()) || defaultMatchItem != null) continue;
                defaultMatchItem = item;
            }
        }
        if (matchItem == null) {
            matchItem = defaultMatchItem;
        }
        if (matchItem == null) {
            matchItem = new GradeItem();
            matchItem.setShowColor("#333333");
            matchItem.setShowScript(this.defaultHeadertxt());
        }
        ArrayList<CardRowModel> list = new ArrayList<CardRowModel>();
        CardRowModel cardRowModel = new CardRowModel();
        ArrayList<ItemModel> mainList = new ArrayList<ItemModel>();
        String showText = ResManager.loadKDString((String)"\u8bf7\u67e5\u9605\u4ee5\u4e0b\u6d1e\u5bdf\u5185\u5bb9", (String)"IDISchemaResultPCDataConvert_9", (String)"data-idi-core", (Object[])new Object[0]);
        if (result.getScore() >= 0) {
            TextItemModel rowItemModel1 = new TextItemModel(String.format(ResManager.loadKDString((String)"%d\u5206", (String)"IDISchemaResultPCDataConvert_16", (String)"data-idi-core", (Object[])new Object[0]), result.getScore()));
            mainList.add(rowItemModel1);
            rowItemModel1.addItemStyle("color", this.getColor(matchItem.getShowColor()));
            rowItemModel1.addItemStyle("font-size", "14px");
            rowItemModel1.addItemStyle("margin-right", "6px");
            if (result.getScore() == 100) {
                rowItemModel1.addItemStyle("min-width", "39px");
            } else if (result.getScore() > 9) {
                rowItemModel1.addItemStyle("min-width", "31px");
            } else {
                rowItemModel1.addItemStyle("min-width", "23px");
            }
            showText = matchItem.getShowScript();
        } else if (result.getScore() < -1) {
            showText = ResManager.loadKDString((String)"\u6d1e\u5bdf\u7ed3\u679c\u52a0\u8f7d\u4e2d\u2026\u2026", (String)"IDISchemaResultPCDataConvert_18", (String)"data-idi-core", (Object[])new Object[0]);
        }
        TextItemModel rowItemModel2 = new TextItemModel(showText);
        rowItemModel2.addItemStyle("color", "#333333");
        rowItemModel2.addItemStyle("font-size", "14px");
        cardRowModel.addMainStyle("white-space", "normal");
        rowItemModel2.addItemStyle("white-space", "normal");
        mainList.add(rowItemModel2);
        cardRowModel.setMainDesc(mainList);
        cardRowModel.addMainStyle("max-width", "192px");
        cardRowModel.addRowStyle("padding", "0px");
        list.add(cardRowModel);
        return list;
    }

    protected String defaultHeadertxt() {
        return ResManager.loadKDString((String)"\u8bf7\u67e5\u9605\u4ee5\u4e0b\u6d1e\u5bdf\u5185\u5bb9", (String)"IDISchemaResultPCDataConvert_9", (String)"data-idi-core", (Object[])new Object[0]);
    }

    protected CardModel createCard(int i, AreaResult areaResult) {
        Area area = areaResult.getArea();
        List<DecisionResult> decisionResults = areaResult.getDecisionResults();
        if (CollectionUtils.isEmpty(decisionResults)) {
            return null;
        }
        CardModel cardModel = new CardModel();
        cardModel.setId(area.getPk());
        cardModel.setTitle(area.getTitle());
        String borderTopColor = i % 2 == 0 ? "#A9BEFF" : "#32AA70";
        cardModel.addCardStyle("border-top-color", borderTopColor);
        cardModel.addCardStyle("border-top-width", "2px");
        SchemaExecutorLogger.info(String.format("createCard areaResult : %s", IDIJSONUtils.toJsonString(decisionResults)), new Object[0]);
        ArrayList<CardRowModel> statisticsList = new ArrayList<CardRowModel>();
        ArrayList<CardRowModel> cardRowModelList = new ArrayList<CardRowModel>();
        for (DecisionResult result : decisionResults) {
            String matchType;
            if (result == null) continue;
            Decision decision = result.getDecision();
            String decisionId = decision == null ? null : decision.getPk();
            String string = matchType = decision == null ? null : decision.getMatchType();
            if (result.getNewsResult() != null) {
                if (this.statusFilterResult != null) continue;
                cardModel.setName("news");
                List<CardRowModel> resultRowList = this.createNewsData(result.getNewsResult(), result.getDecision().getNews(), decisionId);
                cardRowModelList.addAll(resultRowList);
                continue;
            }
            if (result.getTableDataResult() != null) {
                if (this.statusFilterResult != null) continue;
                cardModel.setName("timeline");
                cardRowModelList.addAll(this.createTableData(result.getTableDataResult(), decisionId));
                continue;
            }
            if (result.getInvoiceImageRuleResults() != null && !result.getInvoiceImageRuleResults().isEmpty()) {
                cardModel.setButtonTitle(ResManager.loadKDString((String)"\u67e5\u770b\u7968\u636e\u5f71\u50cf", (String)"IDISchemaResultPCDataConvert_17", (String)"data-idi-core", (Object[])new Object[0]));
                cardModel.setButtonData(IDIJSONUtils.toJsonString(result.getInvoiceImageResults()));
                List<CardRowModel> rowModelList = this.createInvoiceCard(result, area.getPk(), decisionId);
                cardRowModelList.addAll(rowModelList);
                statisticsList.addAll(rowModelList);
                continue;
            }
            if (result.getLinkUpBillResults() != null && !result.getLinkUpBillResults().isEmpty()) {
                this.createCardRowByLinkupBillResult(result.getLinkUpBillResults(), cardRowModelList, statisticsList, null, area.getPk(), decisionId, matchType);
                continue;
            }
            if (result.getCourierDataResult() != null) {
                if (this.statusFilterResult != null) continue;
                Carousel carousel = this.createCarousel(result.getCourierDataResult(), decisionId);
                cardModel.setCarousel(carousel);
                continue;
            }
            if (result.getBillFlowResult() != null) {
                if (this.statusFilterResult != null) continue;
                BillFlowModel billFlow = this.createBillFlow(result.getBillFlowResult(), result, decisionId);
                cardModel.setBillFlowModel(billFlow);
                continue;
            }
            if (result.getStatisticsResult() != null) {
                if (this.statusFilterResult != null) continue;
                StatisticModel statisticModel = this.createStatistic(result.getStatisticsResult(), result);
                cardModel.addStatisticModel(statisticModel);
                continue;
            }
            if (result.getFasindexResult() != null) {
                if (this.statusFilterResult != null) continue;
                FasindexModel fasindexModel = this.createFasindex(result.getFasindexResult(), result, decisionId);
                cardModel.addFasindexModel(fasindexModel);
                continue;
            }
            if (result.getAttachmentResults() != null && !result.getAttachmentResults().isEmpty()) {
                HashSet<LinkUpBillResult> notShow = new HashSet<LinkUpBillResult>(3);
                this.createCardRowByLinkupBillResult(result.getAttachmentResults(), cardRowModelList, statisticsList, notShow, area.getPk(), result.getDecision().getPk(), matchType);
                continue;
            }
            if (result.getDecision() != null && !MatchType.containsType(result.getDecision().getMatchType())) {
                List<CardRowModel> list = this.createCardRowsOfMServiceApiResult(result.getApiDecisionResultItems(), result.getDecision(), decisionId);
                if (CollectionUtils.isNotEmpty(list)) {
                    cardRowModelList.addAll(list);
                    statisticsList.addAll(list);
                    continue;
                }
                if (this.statusFilterResult != null && !this.statusFilterResult.apply(result.getStatus()).booleanValue() || this.filterAI && !result.isAiParticipation()) continue;
                CardRowModel resultRow = this.createCardRow(result, null, decisionId, matchType);
                cardRowModelList.add(resultRow);
                statisticsList.add(resultRow);
                continue;
            }
            if (this.statusFilterResult != null && !this.statusFilterResult.apply(result.getStatus()).booleanValue() || this.filterAI && !result.isAiParticipation()) continue;
            CardRowModel resultRow = this.createCardRow(result, area.getPk(), decisionId, matchType);
            cardRowModelList.add(resultRow);
            statisticsList.add(resultRow);
        }
        this.createTotalRow(cardRowModelList, statisticsList);
        cardModel.setEntity(cardRowModelList);
        return cardModel;
    }

    private List<CardRowModel> createCardRowsOfMServiceApiResult(List<ApiDecisionResultItem> results, Decision decision, String decisionId) {
        ArrayList<CardRowModel> cardRowModelList = new ArrayList<CardRowModel>(10);
        if (CollectionUtils.isEmpty(results)) {
            return cardRowModelList;
        }
        DecisionTypeExtInfoService decisionTypeExtInfoService = new DecisionTypeExtInfoService();
        ExtDecisionInfo extDecisionInfo = decisionTypeExtInfoService.queryByMatchType(decision.getMatchType());
        for (ApiDecisionResultItem item : results) {
            DecisionResult tmpResult = new DecisionResult();
            tmpResult.setDecision(decision);
            tmpResult.setStatus(item.getStatus());
            if (this.statusFilterResult != null && !this.statusFilterResult.apply(item.getStatus()).booleanValue() || this.filterAI) continue;
            tmpResult.setShowText(item.getShowText());
            if (CollectionUtils.isNotEmpty(item.getHoverContents())) {
                DecisionFrontEndResult decisionFrontEndResult = new DecisionFrontEndResult();
                decisionFrontEndResult.setHoverContent(item.getHoverContents());
                tmpResult.setFrontEndResult(decisionFrontEndResult);
            }
            CardRowModel resultRow = this.createCardRow(tmpResult, null, decisionId, null);
            if (extDecisionInfo != null) {
                resultRow.setDetailDisplayType(extDecisionInfo.getDetailDisplayType());
            }
            if ("ANCHOR".equals(item.getType())) {
                resultRow.setEventName(item.getEventName());
                resultRow.setEventArgs(item.getEventArgs());
            }
            cardRowModelList.add(resultRow);
        }
        return cardRowModelList;
    }

    private void createCardRowByLinkupBillResult(List<LinkUpBillResult> linkUpBillResultList, List<CardRowModel> cardRowModelList, List<CardRowModel> statisticsList, Set<LinkUpBillResult> notShow, String areaPk, String decisionPk, String matchType) {
        for (LinkUpBillResult billResult : linkUpBillResultList) {
            if (notShow != null && notShow.contains(billResult)) continue;
            String status = billResult.getStatus();
            if (this.statusFilterResult != null && !this.statusFilterResult.apply(status).booleanValue() || this.filterAI && !billResult.isAiParticipation()) continue;
            CardRowModel resultRow = this.createCardRow(billResult, areaPk, decisionPk);
            cardRowModelList.add(resultRow);
            statisticsList.add(resultRow);
        }
    }

    private FasindexModel createFasindex(FasindexResult fasindexResult, DecisionResult result, String decisionId) {
        FasindexModel fasindexModel = new FasindexModel();
        fasindexModel.setTitle(fasindexResult.getTitle());
        fasindexModel.setDecisionId(decisionId);
        List<FasindexResult.FasindexCardDataResult> fasindexCardDataResultList = fasindexResult.getCardData();
        ArrayList<FasindexTableDataModel> fasindexTableDataModelList = new ArrayList<FasindexTableDataModel>(fasindexCardDataResultList.size());
        FasindexConfig fc = result.getDecision().getFasindexConfig();
        int precision = fc.getPrecision();
        precision = precision >= 10 ? 10 : precision;
        NumericalUnitEnum numericalUnitEnum = fc.getNumericalUnit();
        ArrayList<FasindexTableDataModel> nullFasindexTableDataModelList = new ArrayList<FasindexTableDataModel>(fasindexCardDataResultList.size());
        for (FasindexResult.FasindexCardDataResult cardDataResult : fasindexCardDataResultList) {
            FasindexTableDataModel fasindexTableDataModel = new FasindexTableDataModel();
            String valueTypeAlias = cardDataResult.getValueType().getAlias();
            NumericalUnitEnum processEnum = cardDataResult.getValueType() == FasindexConfig.ValueTypeEnum.C_03 || cardDataResult.getValueType() == FasindexConfig.ValueTypeEnum.C_01 ? NumericalUnitEnum.PERCENTAGE : (numericalUnitEnum == null ? NumericalUnitEnum.NULL : numericalUnitEnum);
            Object value = cardDataResult.getValue();
            String valueTxt = null;
            if (value != null) {
                BigDecimal castValue = new BigDecimal(String.valueOf(value));
                BigDecimal processValue = BigDecimal.ZERO.compareTo(castValue) == 0 ? BigDecimal.ZERO : processEnum.calUnitScale(castValue, precision);
                valueTxt = processValue + processEnum.getName();
                fasindexTableDataModelList.add(fasindexTableDataModel);
            } else {
                nullFasindexTableDataModelList.add(fasindexTableDataModel);
            }
            fasindexTableDataModel.setValue(valueTxt);
            fasindexTableDataModel.setValueType(valueTypeAlias);
            List<FasindexResult.FasindexRow> pairList = cardDataResult.getDimension();
            ArrayList<DimensionModel> dimensionModelList = new ArrayList<DimensionModel>(pairList.size());
            for (FasindexResult.FasindexRow row : pairList) {
                DimensionModel dm = new DimensionModel();
                dm.setKey(String.valueOf(row.displayDimension));
                dm.setValue(String.valueOf(row.value));
                dimensionModelList.add(dm);
            }
            fasindexTableDataModel.setDimension(dimensionModelList);
        }
        fasindexTableDataModelList.addAll(nullFasindexTableDataModelList);
        fasindexModel.setTableData(fasindexTableDataModelList);
        return fasindexModel;
    }

    private StatisticModel createStatistic(StatisticsResult statisticsResult, DecisionResult result) {
        StatisticModel sm = new StatisticModel();
        sm.setTitle(result.getDecision().getName());
        if (!statisticsResult.isHeadMode()) {
            List<List<Object>> table = statisticsResult.getDataTable();
            if (table != null && !table.isEmpty()) {
                sm.setTable(!statisticsResult.isNotTable());
                sm.setHeadList(statisticsResult.getTitleList());
                sm.setTableData(statisticsResult.getDataTable());
            }
        } else {
            List<List<Object>> table = statisticsResult.getDataTable();
            if (table != null && !table.isEmpty()) {
                if (table.size() > 1) {
                    sm.setTable(true);
                    List<String> oldTitleList = statisticsResult.getTitleList();
                    List<String> titleList = oldTitleList.subList(1, oldTitleList.size());
                    ArrayList<List<Object>> tableDataList = new ArrayList<List<Object>>(table.size());
                    for (int i = 0; i < table.size(); ++i) {
                        List<Object> rowDataList = table.get(i);
                        tableDataList.add(rowDataList.subList(1, rowDataList.size()));
                    }
                    sm.setHeadList(titleList);
                    sm.setTableData(tableDataList);
                } else {
                    List<Object> rowDataList = table.get(0);
                    List<String> oldTitleList = statisticsResult.getTitleList();
                    ArrayList<List<Object>> tableDataList = new ArrayList<List<Object>>(rowDataList.size());
                    sm.setTable(false);
                    sm.setTableData(tableDataList);
                    boolean notLast = oldTitleList.size() > rowDataList.size();
                    for (int i = 0; i < rowDataList.size(); ++i) {
                        ArrayList<Object> newRowDataList = new ArrayList<Object>(2);
                        newRowDataList.add(notLast ? oldTitleList.get(i + 1) : oldTitleList.get(i));
                        newRowDataList.add(rowDataList.get(i));
                        tableDataList.add(newRowDataList);
                    }
                }
            }
        }
        return sm;
    }

    private BillFlowModel createBillFlow(BillFlowResult billFlowResult, DecisionResult result, String decisionId) {
        List<TableLineNode> list;
        BillFlowModel billFlowModel = new BillFlowModel();
        billFlowModel.setDecisionId(decisionId);
        String title = result.getDecision().getName();
        if (!StringUtils.isEmpty((String)title)) {
            CardRowModel titleRow = new CardRowModel();
            ArrayList<ItemModel> itemList = new ArrayList<ItemModel>();
            TextItemModel titleModel = new TextItemModel(result.getDecision().getName());
            titleModel.addItemStyle("color", "#333333");
            titleModel.addItemStyle("font-size", "12px");
            itemList.add(titleModel);
            titleRow.setMainDesc(itemList);
            titleRow.addMainStyle("width", "80%");
            titleRow.addMainStyle("margin-bottom", "4px");
            titleRow.setDecisionId(decisionId);
            billFlowModel.setTitle(titleRow);
        }
        if ((list = billFlowResult.getNodeList()) != null && !list.isEmpty()) {
            List<TableLineNodeModel> modelList = this.createTableLine(list, false);
            billFlowModel.setTableLineNodeList(modelList);
        }
        return billFlowModel;
    }

    protected void createTotalRow(List<CardRowModel> cardRowModelList, List<CardRowModel> statisticCardRowModelList) {
        ItemModel item;
        List<ItemModel> itemList;
        int successCount = 0;
        int errorCount = 0;
        for (CardRowModel cardRowModel : statisticCardRowModelList) {
            itemList = cardRowModel.getMainDesc();
            item = itemList.get(0);
            String iconName = ((IconItemModel)item).getIconName();
            if (iconName.contains(ICON_AGREE)) {
                ++successCount;
                continue;
            }
            if (!iconName.contains(ICON_EXCEPTION)) continue;
            IconItemModel iconItemModel = (IconItemModel)item;
            iconItemModel.addImageStyle("width", "16px");
            iconItemModel.addImageStyle("height", "16px");
            ++errorCount;
        }
        if (errorCount > 1) {
            DecisionResult errorResult = new DecisionResult();
            errorResult.setShowText(String.format(ResManager.loadKDString((String)"%d\u9879\u68c0\u67e5\u9879\u672a\u6b63\u5e38\u68c0\u6d4b\u51fa", (String)"IDISchemaResultPCDataConvert_5", (String)"data-idi-core", (Object[])new Object[0]), errorCount));
            errorResult.setStatus("none");
            CardRowModel errorCardRow = this.createCardRow(errorResult, null, null, null);
            errorCardRow.addRowStyle("background", " #fff");
            itemList = errorCardRow.getMainDesc();
            item = itemList.get(0);
            IconItemModel iconItemModel = (IconItemModel)item;
            iconItemModel.addImageStyle("width", "16px");
            iconItemModel.addImageStyle("height", "16px");
            cardRowModelList.add(0, errorCardRow);
        }
        if (successCount > 1) {
            DecisionResult successResult = new DecisionResult();
            successResult.setShowText(String.format(ResManager.loadKDString((String)"%d\u9879\u68c0\u67e5\u9879\u5408\u89c4", (String)"IDISchemaResultPCDataConvert_4", (String)"data-idi-core", (Object[])new Object[0]), successCount));
            successResult.setStatus("green");
            CardRowModel successCardRow = this.createCardRow(successResult, null, null, null);
            successCardRow.addRowStyle("background", " #fff");
            cardRowModelList.add(0, successCardRow);
        }
    }

    private List<CardRowModel> createNewsData(NewsResult newsResult, NewsConfig newsConfig, String decisionId) {
        ArrayList<ItemModel> secondList;
        List<News> newsList;
        CardRowModel cardRowModel;
        Company company;
        ArrayList<CardRowModel> rtn = new ArrayList<CardRowModel>();
        List<Company> companyList = newsResult.getCompanyList();
        if (companyList != null && !companyList.isEmpty() && (company = companyList.get(0)) != null) {
            cardRowModel = new CardRowModel();
            cardRowModel.setDecisionId(decisionId);
            ArrayList itemList = new ArrayList();
            TextItemModel textItemModel = new TextItemModel(company.getCompanyName());
            textItemModel.addItemStyle("color", "#4570D3");
            itemList.add(textItemModel);
            DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
            List<String> newsCatalogs = newsConfig.getBusinessCatalogs();
            if (newsCatalogs != null && !newsCatalogs.isEmpty()) {
                for (String catalogs : newsCatalogs) {
                    BusinessCatalogs businessCatalogs = BusinessCatalogs.convertFromKeyWord(catalogs);
                    String value = null;
                    try {
                        Object val = FieldUtils.readDeclaredField((Object)company, (String)BusinessCatalogs.newsCatalogChange(catalogs), (boolean)true);
                        if (val != null) {
                            value = (String)val;
                        }
                    }
                    catch (IllegalAccessException ex) {
                        SchemaExecutorLogger.error(catalogs, ex);
                    }
                    frontEndResult.addHoverContent(HoverContent.createText(businessCatalogs.getCaption()), HoverContent.createText(value));
                }
            }
            PopoverModel popover = this.createCardPopover(frontEndResult, new String[0]);
            textItemModel.addItemStyle("cursor", "pointer");
            textItemModel.addItemStyle("color", "#5582F3");
            textItemModel.setPopover(popover);
            cardRowModel.setMainDesc(itemList);
            cardRowModel.addMainStyle("width", "80%");
            rtn.add(cardRowModel);
        }
        if ((newsList = newsResult.getNewsList()) != null && !newsList.isEmpty()) {
            for (News news : newsList) {
                cardRowModel = new CardRowModel();
                URLItemModel main = new URLItemModel(news.getTitle(), news.getNewsUrl());
                main.addItemStyle("color", "#666");
                main.addItemStyle("font-size", "12px");
                ArrayList<ItemModel> mainList = new ArrayList<ItemModel>();
                mainList.add(main);
                secondList = new ArrayList(3);
                for (String s : new String[]{news.getNewsSource(), " \u00b7 ", news.getPublishTime()}) {
                    TextItemModel rowItemModel = new TextItemModel(s);
                    secondList.add(rowItemModel);
                }
                cardRowModel.addRowStyle("flex-direction", "column");
                cardRowModel.addRowStyle("align-items", "flex-start");
                cardRowModel.setMainDesc(mainList);
                cardRowModel.setSecondDesc(secondList);
                cardRowModel.addSecondStyle("color", "#A4A8AB");
                cardRowModel.addSecondStyle("font-size", "10px");
                cardRowModel.addSecondStyle("line-height", "16px");
                cardRowModel.addSecondStyle("margin-top", "4px");
                rtn.add(cardRowModel);
            }
        } else {
            String noNewsMesg = ResManager.loadKDString((String)"\u672a\u68c0\u7d22\u5230\u65b0\u95fb", (String)"IDISchemaResultPCDataConvert_22", (String)"data-idi-core", (Object[])new Object[0]);
            CardRowModel noNewCardRowModel = new CardRowModel();
            ArrayList<ItemModel> mainList = new ArrayList<ItemModel>();
            IconItemModel iconItemModel = new IconItemModel("none.png");
            mainList.add(iconItemModel);
            mainList.add(new TextItemModel(noNewsMesg));
            noNewCardRowModel.setMainDesc(mainList);
            secondList = new ArrayList<ItemModel>();
            this.cardRowStyle(noNewCardRowModel, null, secondList);
            rtn.add(noNewCardRowModel);
        }
        return rtn;
    }

    private List<CardRowModel> createTableData(TableDataResult tableDataResult, String decisionId) {
        ArrayList<CardRowModel> rtn = new ArrayList<CardRowModel>(10);
        CardRowModel cardRowModel = new CardRowModel();
        ArrayList<ItemModel> itemList = new ArrayList<ItemModel>();
        itemList.add(new TextItemModel(tableDataResult.getTitle()));
        cardRowModel.setMainDesc(itemList);
        cardRowModel.addMainStyle("width", "50%");
        cardRowModel.setDecisionId(decisionId);
        rtn.add(cardRowModel);
        List<List<HoverContent>> tableList = tableDataResult.getData();
        if (tableList != null && !tableList.isEmpty()) {
            int len = tableList.size();
            for (int i = 0; i < len; ++i) {
                List<HoverContent> row = tableDataResult.getData().get(i);
                HoverContent popover = tableDataResult.getPopover().get(i);
                cardRowModel = new CardRowModel();
                cardRowModel.setDecisionId(decisionId);
                ArrayList<ItemModel> itemList2 = new ArrayList<ItemModel>();
                TimeLineItemModel timeLineModel = new TimeLineItemModel(row.get(0).getContent());
                timeLineModel.setId(i);
                if (i == 0) {
                    timeLineModel.setFlag(TimeLineFlag.First);
                } else if (i == len - 1) {
                    timeLineModel.setFlag(TimeLineFlag.Lastest);
                }
                itemList2.add(timeLineModel);
                IconItemModel iconModel = new IconItemModel("remark_hover.png");
                iconModel.setItemStyle((Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("visibility", "hidden");
                        this.put("margin-left", "20px");
                    }
                });
                itemList2.add(iconModel);
                if (popover != null && StringUtils.isNotEmpty((String)popover.getContent())) {
                    iconModel.addItemStyle("cursor", "pointer");
                    iconModel.setPopover(this.createCardPopover(popover));
                }
                this.tableDataIconStyleChange(iconModel);
                cardRowModel.setMainDesc(itemList2);
                cardRowModel.addMainStyle("width", "60%");
                itemList2 = new ArrayList();
                HoverContent rightHoverContent = row.get(1);
                TextItemModel textItemModel = HoverContent.ContentType.HREF == rightHoverContent.getType() || HoverContent.ContentType.CHAT == rightHoverContent.getType() ? new HrefItemModel(rightHoverContent.getContent(), rightHoverContent.getData()) : new TextItemModel(rightHoverContent.getContent());
                itemList2.add(textItemModel);
                cardRowModel.setSecondDesc(itemList2);
                cardRowModel.addSecondStyle("width", "36%");
                cardRowModel.addSecondStyle("justify-content", "flex-end");
                rtn.add(cardRowModel);
            }
        }
        return rtn;
    }

    protected void tableDataIconStyleChange(IconItemModel iconModel) {
    }

    private List<CardRowModel> createInvoiceCard(DecisionResult decisionResult, String areaPk, String decisionId) {
        ArrayList<CardRowModel> rtn = new ArrayList<CardRowModel>(decisionResult.getInvoiceImageRuleResults().size());
        List<InvoiceImageResult> invoiceResultList = decisionResult.getInvoiceImageResults();
        HashMap<String, List> invoiceResultMap = new HashMap<String, List>();
        for (InvoiceImageResult invoiceResult : invoiceResultList) {
            List<InvoiceImageRuleResult> ruleResults = invoiceResult.getRuleResults();
            for (InvoiceImageRuleResult ruleResult : ruleResults) {
                if (ruleResult.isPass()) continue;
                String ruleNo = ruleResult.getRuleNo();
                List list = invoiceResultMap.computeIfAbsent(ruleNo, k -> new ArrayList());
                list.add(invoiceResult);
            }
        }
        boolean notShowImagePage = QueryServiceHelper.exists((String)"bas_imageconfig", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"FPY"), new QFilter("enable", "=", (Object)"A")});
        CardRowModel continuousCardRowModel = null;
        HashMap<Long, List> invoiceCloudContinuousListMap = null;
        for (InvoiceImageRuleResult ruleResult : decisionResult.getInvoiceImageRuleResults()) {
            Map<String, List<InvoiceFailureEntity>> invoiceFailureMap;
            if (ruleResult == null) continue;
            CardRowModel cardRowModel = new CardRowModel();
            DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
            ArrayList<ItemModel> mainList = new ArrayList<ItemModel>();
            IconItemModel iconItemModel = new IconItemModel("block.png");
            mainList.add(iconItemModel);
            String showText = ruleResult.getText();
            String status = ruleResult.getStatus();
            if (this.statusFilterResult != null && !this.statusFilterResult.apply(status).booleanValue() || this.filterAI) continue;
            if (!StringUtils.isEmpty((String)status)) {
                iconItemModel.setIconName(this.getIcon(status));
            }
            mainList.add(new TextItemModel(showText));
            cardRowModel.setMainDesc(mainList);
            cardRowModel.addMainStyle("width", "91%");
            cardRowModel.setDecisionId(decisionId);
            cardRowModel.setRuleNo(ruleResult.getRuleNo());
            List<List<HoverContent>> hoverContent = new ArrayList<List<HoverContent>>();
            if (!"A009".equalsIgnoreCase(ruleResult.getRuleNo())) {
                ArrayList<HoverContent> title = new ArrayList<HoverContent>();
                if ("A003".equalsIgnoreCase(ruleResult.getRuleNo())) {
                    if (!notShowImagePage) {
                        title.add(HoverContent.createTitle(ResManager.loadKDString((String)"\u672c\u5355\u9875\u7801", (String)"IDISchemaResultPCDataConvert_14", (String)"data-idi-core", (Object[])new Object[0])));
                        title.add(HoverContent.createTitle(ResManager.loadKDString((String)"\u91cd\u590d\u53d1\u7968\u7684\u5f71\u50cf\u9875\u7801", (String)"IDISchemaResultPCDataConvert_12", (String)"data-idi-core", (Object[])new Object[0])));
                    }
                    title.add(HoverContent.createTitle(ResManager.loadKDString((String)"\u91cd\u590d\u53d1\u7968\u7684\u5f71\u50cf\u7f16\u53f7", (String)"IDISchemaResultPCDataConvert_13", (String)"data-idi-core", (Object[])new Object[0])));
                } else {
                    if (!notShowImagePage) {
                        title.add(HoverContent.createTitle(ResManager.loadKDString((String)"\u5f71\u50cf\u9875\u7801", (String)"IDISchemaResultPCDataConvert_6", (String)"data-idi-core", (Object[])new Object[0])));
                    }
                    title.add(HoverContent.createTitle(ResManager.loadKDString((String)"\u5f71\u50cf\u7f16\u53f7", (String)"IDISchemaResultPCDataConvert_8", (String)"data-idi-core", (Object[])new Object[0])));
                }
                title.add(HoverContent.createTitle(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"IDISchemaResultPCDataConvert_7", (String)"data-idi-core", (Object[])new Object[0])));
                hoverContent.add(title);
                List list = (List)invoiceResultMap.get(ruleResult.getRuleNo());
                if (list != null && !list.isEmpty()) {
                    HashMap<Long, List> continuousListMap = new HashMap<Long, List>(8);
                    for (InvoiceImageResult invoiceResult : list) {
                        if ("A003".equalsIgnoreCase(ruleResult.getRuleNo())) {
                            List<List<String>> duplicatedList = invoiceResult.getDuplicatedList();
                            if (duplicatedList == null) continue;
                            for (List<String> rowList : duplicatedList) {
                                int index;
                                if (rowList == null) continue;
                                ArrayList<HoverContent> rowHoverContentList = new ArrayList<HoverContent>(rowList.size());
                                if (!notShowImagePage) {
                                    rowHoverContentList.add(HoverContent.createText(invoiceResult.getImagePage()));
                                }
                                boolean lastNoProcess = rowList.size() >= 4;
                                int n = index = notShowImagePage ? 1 : 0;
                                while (index < rowList.size()) {
                                    String s = rowList.get(index);
                                    if (lastNoProcess && index == rowList.size() - 2) {
                                        rowHoverContentList.add(HoverContent.createViewInvoice(s, rowList.get(index + 1)));
                                        ++index;
                                    } else {
                                        rowHoverContentList.add(HoverContent.createText(s));
                                    }
                                    ++index;
                                }
                                hoverContent.add(rowHoverContentList);
                            }
                            continue;
                        }
                        if ("A011".equalsIgnoreCase(ruleResult.getRuleNo())) {
                            continuousListMap.putAll(invoiceResult.getContinuousListMap());
                            continue;
                        }
                        ArrayList<HoverContent> row = new ArrayList<HoverContent>();
                        if (!notShowImagePage) {
                            row.add(HoverContent.createText(invoiceResult.getImagePage()));
                        }
                        row.add(HoverContent.createText(invoiceResult.getImageNo()));
                        row.add(StringUtils.isEmpty((String)invoiceResult.getSerialNo()) ? HoverContent.createText(invoiceResult.getInvoiceNo()) : HoverContent.createViewInvoice(invoiceResult.getInvoiceNo(), invoiceResult.getSerialNo()));
                        hoverContent.add(row);
                    }
                    if (!continuousListMap.isEmpty()) {
                        Optional<Long> invocieCloudcontinuousId = continuousListMap.keySet().stream().filter(k -> k < 0L).findAny();
                        if (!invocieCloudcontinuousId.isPresent()) {
                            ArrayList continuousList = new ArrayList(continuousListMap.values());
                            continuousList.sort((v1, v2) -> Math.toIntExact(new BigDecimal((String)v1.get(2)).compareTo(new BigDecimal((String)v2.get(2)))));
                            for (List rowList : continuousList) {
                                boolean linkInvoice;
                                if (rowList == null) continue;
                                ArrayList<HoverContent> rowHoverContentList = new ArrayList<HoverContent>(rowList.size());
                                boolean bl = linkInvoice = rowList.size() > 3;
                                for (int index = notShowImagePage ? 1 : 0; index < rowList.size(); ++index) {
                                    String s = (String)rowList.get(index);
                                    if (linkInvoice && index == rowList.size() - 2) {
                                        String serno = (String)rowList.get(index + 1);
                                        rowHoverContentList.add(StringUtils.isEmpty((String)serno) ? HoverContent.createText(s) : HoverContent.createViewInvoice(s, serno));
                                        break;
                                    }
                                    rowHoverContentList.add(HoverContent.createText(s));
                                }
                                hoverContent.add(rowHoverContentList);
                            }
                        } else {
                            continuousCardRowModel = cardRowModel;
                            invoiceCloudContinuousListMap = continuousListMap;
                        }
                    }
                }
                frontEndResult.setTableStyle(true);
            }
            if ("none".equalsIgnoreCase(status) && "A010".equalsIgnoreCase(ruleResult.getRuleNo()) && (invoiceFailureMap = decisionResult.getFailureInvoiceMap()) != null && !invoiceFailureMap.isEmpty()) {
                hoverContent = this.addFailureInvoiceHoverContent(hoverContent, invoiceFailureMap);
                frontEndResult.setTableStyle(true);
            }
            if (ruleResult.getFullAmounts() != null) {
                String[] amounts = ruleResult.getFullAmounts();
                int invoiceAmount = 0;
                int billAmount = 1;
                ArrayList<HoverContent> invoiceRow = new ArrayList<HoverContent>();
                invoiceRow.add(HoverContent.createText(ResManager.loadKDString((String)"\u53d1\u7968\u603b\u91d1\u989d", (String)"IDISchemaResultPCDataConvert_10", (String)"data-idi-core", (Object[])new Object[0])));
                invoiceRow.add(HoverContent.createText(amounts[invoiceAmount]));
                hoverContent.add(invoiceRow);
                ArrayList<HoverContent> billRow = new ArrayList<HoverContent>();
                billRow.add(HoverContent.createText(ResManager.loadKDString((String)"\u6e90\u5355\u91d1\u989d", (String)"IDISchemaResultPCDataConvert_11", (String)"data-idi-core", (Object[])new Object[0])));
                billRow.add(HoverContent.createText(amounts[billAmount]));
                hoverContent.add(billRow);
                frontEndResult.setTableStyle(false);
            }
            if (hoverContent.size() > 1) {
                List<PopoverRowModel> rowList;
                frontEndResult.setHoverContent(hoverContent);
                PopoverModel popover = this.createCardPopover(frontEndResult, new String[0]);
                if (("A003".equalsIgnoreCase(ruleResult.getRuleNo()) || "A011".equalsIgnoreCase(ruleResult.getRuleNo())) && !notShowImagePage && (rowList = popover.getPopoverItemList()) != null && !rowList.isEmpty()) {
                    for (PopoverRowModel row : rowList) {
                        List<ItemModel> itemList = row.getPopoverRow();
                        if (itemList == null || itemList.isEmpty()) continue;
                        itemList.get(0).addItemStyle("width", "60px");
                        if (!"A011".equalsIgnoreCase(ruleResult.getRuleNo())) continue;
                        itemList.get(1).addItemStyle("width", "200px");
                        itemList.get(2).addItemStyle("width", "100px");
                    }
                }
                ArrayList<ItemModel> secondList = new ArrayList<ItemModel>();
                IconItemModel iconModel = new IconItemModel("attach_data.png");
                iconModel.setPopover(popover);
                secondList.add(iconModel);
                cardRowModel.setSecondDesc(secondList);
                this.invoiceRowStyle(iconModel, cardRowModel);
            }
            if (ruleResult.getRuleNo().startsWith("C00")) {
                cardRowModel.setHighLightAttr(areaPk + "_" + decisionResult.getDecision().getPk() + "_" + ruleResult.getRuleNo());
            }
            rtn.add(cardRowModel);
        }
        if (continuousCardRowModel != null && invoiceCloudContinuousListMap != null && !invoiceCloudContinuousListMap.isEmpty()) {
            DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
            frontEndResult.setTableStyle(true);
            ArrayList<HoverContent> title = new ArrayList<HoverContent>();
            title.add(HoverContent.createTitle(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"IDISchemaResultPCDataConvert_7", (String)"data-idi-core", (Object[])new Object[0])));
            title.add(HoverContent.createTitle(ResManager.loadKDString((String)"\u8fde\u53f7\u4fe1\u606f", (String)"IDISchemaResultPCDataConvert_23", (String)"data-idi-core", (Object[])new Object[0])));
            ArrayList<List<HoverContent>> contentList = new ArrayList<List<HoverContent>>(2);
            contentList.add(title);
            invoiceCloudContinuousListMap.forEach((invoiceId, msg) -> {
                if (invoiceId < 0L && CollectionUtils.isNotEmpty((Collection)msg)) {
                    ArrayList<HoverContent> hoverContentList = new ArrayList<HoverContent>(5);
                    for (String s : msg) {
                        hoverContentList.add(HoverContent.createText(s));
                    }
                    contentList.add(hoverContentList);
                }
            });
            frontEndResult.setHoverContent(contentList);
            PopoverModel popover = this.createCardPopover(frontEndResult, new String[0]);
            List<ItemModel> secondList = continuousCardRowModel.getSecondDesc();
            if (CollectionUtils.isEmpty(secondList)) {
                secondList = new ArrayList<ItemModel>(2);
                IconItemModel iconModel = new IconItemModel("attach_data.png");
                iconModel.setPopover(popover);
                secondList.add(iconModel);
                continuousCardRowModel.setSecondDesc(secondList);
                this.invoiceRowStyle(iconModel, continuousCardRowModel);
            } else {
                secondList.get(0).setPopover(popover);
            }
            List<PopoverRowModel> rowModelList = popover.getPopoverItemList();
            for (PopoverRowModel popoverRowModel : rowModelList) {
                List<ItemModel> itemList = popoverRowModel.getPopoverRow();
                if (itemList.size() <= 1) continue;
                ItemModel itemModel = itemList.get(1);
                Map<String, String> styleMap = itemModel.getItemStyle();
                if (styleMap == null) {
                    styleMap = new HashMap<String, String>(2);
                    itemModel.setItemStyle(styleMap);
                }
                styleMap.put("width", "300px");
            }
        }
        return rtn;
    }

    protected void invoiceRowStyle(IconItemModel iconModel, CardRowModel cardRowModel) {
        iconModel.setItemStyle((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("margin-left", "20px");
            }
        });
        iconModel.addItemStyle("cursor", "pointer");
        cardRowModel.addSecondStyle("width", "22%");
        cardRowModel.addSecondStyle("justify-content", "flex-end");
        cardRowModel.addMainStyle("width", "78%");
    }

    protected CardRowModel createCardRow(DecisionResult decisionResult, String areaPk, String decisionId, String matchType) {
        String showText;
        Decision decision = decisionResult.getDecision();
        CardRowModel cardRowModel = new CardRowModel();
        cardRowModel.setDecisionId(decisionId);
        ArrayList<ItemModel> mainList = new ArrayList<ItemModel>();
        IconItemModel iconItemModel = this.createCardRowIcon(decisionResult);
        if (iconItemModel != null) {
            mainList.add(iconItemModel);
        }
        if (StringUtils.isEmpty((String)(showText = decisionResult.getShowText()))) {
            showText = decision.getName();
        }
        mainList.add(new TextItemModel(showText));
        cardRowModel.setMainDesc(mainList);
        if (decision != null) {
            if (MatchType.KEYWORD.getType().equals(decision.getMatchType())) {
                cardRowModel.setHighLightAttr(areaPk + "_" + decision.getPk());
            } else if (MatchType.ATTACHMENT.getType().equals(decision.getMatchType()) && decision.getAttachmentConfig().getCheckType() == CheckAttachmentTypeEnum.CHECKEXISTS && decisionResult.getStatus().equals("green")) {
                cardRowModel.setHighLightAttr(areaPk + "_" + decision.getPk() + "_" + Integer.MAX_VALUE);
            }
        }
        ArrayList<ItemModel> secondList = new ArrayList<ItemModel>();
        if (decisionResult.isAiParticipation()) {
            IconItemModel aiIconModel = new IconItemModel();
            String image = "5".equals(decisionResult.getLlmParticipateStatus()) ? "sai.svg" : "qai.svg";
            aiIconModel.setIconName(image);
            String title = "5".equals(decisionResult.getLlmParticipateStatus()) ? ResManager.loadKDString((String)"AI\u53c2\u4e0e\u9644\u4ef6\u5185\u5bb9\u63d0\u53d6\u4e0e\u5ba1\u6838\u5206\u6790\u3002", (String)"IDISchemaResultPCDataConvert_24", (String)"data-idi-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"AI\u53c2\u4e0e\u9644\u4ef6\u5185\u5bb9\u63d0\u53d6", (String)"IDISchemaResultPCDataConvert_25", (String)"data-idi-core", (Object[])new Object[0]);
            aiIconModel.setTitle(title);
            secondList.add(aiIconModel);
        }
        IconItemModel iconModel = null;
        DecisionFrontEndResult frontEndResult = decisionResult.getFrontEndResult();
        if (frontEndResult != null) {
            Map<String, Object> customParamMap = frontEndResult.getCustomParamMap();
            if (customParamMap != null && !customParamMap.isEmpty() && MatchType.AIATTACHMENT.getType().equals(matchType)) {
                frontEndResult.setCustomParamMap(null);
                cardRowModel.setDetailDisplayType(Integer.valueOf((String)customParamMap.get("setDetailDisplayType")));
            }
            if (this.isHighLight) {
                this.increaseHighLightMesg(cardRowModel, frontEndResult);
            }
            PopoverModel popover = this.createCardPopover(frontEndResult, decision != null ? decision.getMatchType() : null);
            if (!StringUtils.isEmpty((String)frontEndResult.getHoverText())) {
                String content = frontEndResult.getHoverText();
                TextItemModel dataContent = new TextItemModel(content);
                if (popover != null) {
                    dataContent.addItemStyle("cursor", "pointer");
                    dataContent.addItemStyle("color", "#5582F3");
                    dataContent.setPopover(popover);
                }
                secondList.add(dataContent);
            } else {
                iconModel = new IconItemModel("attach_data.png");
                iconModel.setPopover(popover);
                secondList.add(iconModel);
            }
        }
        this.cardRowStyle(cardRowModel, iconModel, secondList);
        if (decision != null && MatchType.GENERALLEDGER.getType().equals(decision.getMatchType())) {
            cardRowModel.addMainStyle("width", "50%");
            cardRowModel.addSecondStyle("width", "50%");
        }
        if (decisionResult.isAiParticipation() && secondList.size() == 1) {
            IconItemModel aiIconModel = (IconItemModel)secondList.get(0);
            HashMap<String, String> itemStyle = new HashMap<String, String>(10);
            itemStyle.put("margin-right", "24px");
            aiIconModel.setItemStyle(itemStyle);
        }
        return cardRowModel;
    }

    private void increaseHighLightMesg(CardRowModel cardRowModel, DecisionFrontEndResult frontEndResult) {
        String highLightAttr = cardRowModel.getHighLightAttr();
        if (StringUtils.isEmpty((String)highLightAttr)) {
            return;
        }
        List<List<HoverContent>> contentList = frontEndResult.getHoverContent();
        if (CollectionUtils.isNotEmpty(contentList)) {
            for (List<HoverContent> hoverContents : contentList) {
                if (CollectionUtils.isEmpty(hoverContents)) continue;
                for (HoverContent hoverContent : hoverContents) {
                    if (hoverContent == null || !hoverContent.showBillFormAction()) continue;
                    hoverContent.getData().put("highLightKey", highLightAttr);
                }
            }
        }
    }

    protected IconItemModel createCardRowIcon(DecisionResult decisionResult) {
        IconItemModel iconItemModel = new IconItemModel("block.png");
        String status = decisionResult.getStatus();
        if (!StringUtils.isEmpty((String)status)) {
            iconItemModel.setIconName(this.getIcon(status));
        }
        return iconItemModel;
    }

    protected void cardRowStyle(CardRowModel cardRowModel, IconItemModel iconModel, List<ItemModel> secondList) {
        if (iconModel != null) {
            iconModel.addItemStyle("cursor", "pointer");
        }
        if (CollectionUtils.isEmpty(secondList)) {
            cardRowModel.addMainStyle("width", "91%");
        } else {
            cardRowModel.addMainStyle("width", "78%");
            cardRowModel.setSecondDesc(secondList);
            cardRowModel.addSecondStyle("width", "22%");
            cardRowModel.addSecondStyle("justify-content", "flex-end");
        }
    }

    private CardRowModel createCardRow(LinkUpBillResult linkUpBillResult, String areaPk, String decisionPk) {
        CardRowModel cardRowModel = new CardRowModel();
        cardRowModel.setDecisionId(decisionPk);
        cardRowModel.setRuleNo(String.valueOf(linkUpBillResult.getMatchRule()));
        ArrayList<ItemModel> mainList = new ArrayList<ItemModel>();
        IconItemModel iconItemModel = this.createCardRowIcon(linkUpBillResult);
        if (iconItemModel != null) {
            mainList.add(iconItemModel);
        }
        String showText = linkUpBillResult.getShowText();
        mainList.add(new TextItemModel(showText));
        cardRowModel.setMainDesc(mainList);
        if (linkUpBillResult.getMatchRule() > -1) {
            cardRowModel.setHighLightAttr(areaPk + "_" + decisionPk + "_" + linkUpBillResult.getMatchRule());
        }
        ArrayList<ItemModel> secondList = new ArrayList<ItemModel>();
        if (linkUpBillResult.isAiParticipation()) {
            IconItemModel aiIconModel = new IconItemModel();
            aiIconModel.setIconName("qai.svg");
            String title = ResManager.loadKDString((String)"AI\u53c2\u4e0e\u9644\u4ef6\u5185\u5bb9\u63d0\u53d6", (String)"IDISchemaResultPCDataConvert_25", (String)"data-idi-core", (Object[])new Object[0]);
            aiIconModel.setTitle(title);
            secondList.add(aiIconModel);
        }
        IconItemModel iconModel = null;
        DecisionFrontEndResult frontEndResult = linkUpBillResult.getFrontEndResult();
        if (frontEndResult != null) {
            if (this.isHighLight) {
                this.increaseHighLightMesg(cardRowModel, frontEndResult);
            }
            PopoverModel popover = this.createCardPopover(frontEndResult, new String[0]);
            if (!StringUtils.isEmpty((String)frontEndResult.getHoverText())) {
                String content = frontEndResult.getHoverText();
                TextItemModel dataContent = new TextItemModel(content);
                if (popover != null) {
                    dataContent.addItemStyle("cursor", "pointer");
                    dataContent.addItemStyle("color", "#5582F3");
                    dataContent.setPopover(popover);
                }
                secondList.add(dataContent);
            } else {
                iconModel = new IconItemModel("attach_data.png");
                iconModel.setPopover(popover);
                secondList.add(iconModel);
            }
        }
        this.cardRowStyle(cardRowModel, iconModel, secondList);
        if (linkUpBillResult.isAiParticipation() && secondList.size() == 1) {
            IconItemModel aiIconModel = (IconItemModel)secondList.get(0);
            HashMap<String, String> itemStyle = new HashMap<String, String>(10);
            itemStyle.put("margin-right", "24px");
            aiIconModel.setItemStyle(itemStyle);
        }
        return cardRowModel;
    }

    protected IconItemModel createCardRowIcon(LinkUpBillResult linkUpBillResult) {
        IconItemModel iconItemModel = new IconItemModel("block.png");
        String status = linkUpBillResult.getStatus();
        if (!StringUtils.isEmpty((String)status)) {
            iconItemModel.setIconName(this.getIcon(status));
        }
        return iconItemModel;
    }

    private Carousel createCarousel(CourierDataResult courierDataResult, String decisionId) {
        List<Courier> courierList = courierDataResult.getCourierList();
        ArrayList<CardRowModel> rtn = new ArrayList<CardRowModel>(2);
        Carousel carousel = new Carousel();
        carousel.setItems(rtn);
        carousel.setDecisionId(decisionId);
        int size = 5;
        carousel.setSize(size);
        CardRowModel cardRowModel = new CardRowModel();
        cardRowModel.setDecisionId(decisionId);
        ArrayList<ItemModel> itemList = new ArrayList<ItemModel>();
        TextItemModel titleModel = new TextItemModel(courierDataResult.getTitle());
        titleModel.addItemStyle("color", "#333333");
        itemList.add(titleModel);
        if (!StringUtils.isEmpty((String)courierDataResult.getTotalDesc())) {
            TextItemModel descModel = new TextItemModel();
            descModel.addItemStyle("font-size", "10px");
            descModel.addItemStyle("color", "#98A1A8");
            descModel.addItemStyle("margin-left", "4px");
            descModel.setContent(courierDataResult.getTotalDesc());
            itemList.add(descModel);
        }
        cardRowModel.setMainDesc(itemList);
        cardRowModel.addMainStyle("width", "80%");
        rtn.add(cardRowModel);
        if (courierList != null && !courierList.isEmpty()) {
            int total = courierList.size();
            for (Courier courier : courierList) {
                cardRowModel = new CardRowModel();
                cardRowModel.setDecisionId(decisionId);
                ArrayList<ItemModel> mainList = new ArrayList<ItemModel>(2);
                TextItemModel company = new TextItemModel(courier.getCompany());
                company.addItemStyle("color", "#333333");
                company.addItemStyle("font-size", "12px");
                mainList.add(company);
                TextItemModel order = new TextItemModel(courier.getOrder());
                if (courier.isSuccess()) {
                    order.addItemStyle("color", "#5582F3");
                } else {
                    order.addItemStyle("color", "#666666");
                }
                order.addItemStyle("cursor", "default");
                order.addItemStyle("font-size", "12px");
                order.addItemStyle("margin-left", "6px");
                List<TableLineNodeModel> orderTableLine = this.createTableLine(courier.getTableLine(), true);
                if (orderTableLine != null) {
                    PopoverModel pm = new PopoverModel();
                    pm.setTableLineNodeList(orderTableLine);
                    order.setPopover(pm);
                }
                mainList.add(order);
                cardRowModel.setMainDesc(mainList);
                cardRowModel.addMainStyle("flex-direction", "row");
                cardRowModel.addMainStyle("align-items", "flex-start");
                ArrayList<ItemModel> secondList = new ArrayList<ItemModel>(1);
                TextItemModel time = new TextItemModel(courier.getTimeDesc());
                time.addItemStyle("color", "#98A1A8");
                time.addItemStyle("font-size", "12px");
                secondList.add(time);
                cardRowModel.setSecondDesc(secondList);
                cardRowModel.addSecondStyle("margin-top", "4px");
                cardRowModel.addRowStyle("flex-direction", "column");
                cardRowModel.addRowStyle("align-items", "flex-start");
                cardRowModel.addRowStyle("padding-bottom", "8px");
                rtn.add(cardRowModel);
            }
            int pageCount = total % size != 0 ? total / size + 1 : total / size;
            boolean isMore = pageCount > 0;
            carousel.setPage(pageCount);
            carousel.setHasNext(isMore);
            carousel.addNextStyle("width", "18px");
            carousel.addNextStyle("height", "40px");
            carousel.addNextStyle("background-color", "#F6F7F9");
            carousel.addNextStyle("cursor", "pointer");
            carousel.setHasPage(isMore);
            carousel.setHasPrevious(isMore);
            carousel.addPreviousStyle("width", "18px");
            carousel.addPreviousStyle("height", "40px");
            carousel.addPreviousStyle("background-color", "#F6F7F9");
            carousel.addPreviousStyle("cursor", "pointer");
            carousel.addPageWrapperStyle("height", "280px");
            carousel.addPageWrapperStyle("width", "100%");
            carousel.addPageWrapperStyle("background-color", "#ffffff");
            carousel.addPageWrapperStyle("overflow", "hidden");
            carousel.addPageNumberStyle("text-align", "center");
        }
        return carousel;
    }

    private List<TableLineNodeModel> createTableLine(List<TableLineNode> tableLineNodes, boolean isPopover) {
        if (tableLineNodes != null && !tableLineNodes.isEmpty()) {
            ArrayList<TableLineNodeModel> list = new ArrayList<TableLineNodeModel>(tableLineNodes.size());
            for (TableLineNode node : tableLineNodes) {
                TableLineNodeModel nodeModel = new TableLineNodeModel();
                NodeStatusEnum nodeStatus = node.getStatus();
                IconItemModel imgModel = new IconItemModel(this.getTableNodeIcon(nodeStatus));
                nodeModel.setImgModel(imgModel);
                imgModel.addItemStyle("width", "18px");
                TextItemModel titleModel = new TextItemModel(node.getTitle());
                titleModel.addItemStyle("color", "#333333");
                titleModel.addItemStyle("font-size", "12px");
                nodeModel.setTitleModel(titleModel);
                List<HoverContent> titleDescriptList = node.getTitleDescrpt();
                if (titleDescriptList != null && !titleDescriptList.isEmpty()) {
                    ArrayList<TextItemModel> titleDescrptModels = new ArrayList<TextItemModel>(titleDescriptList.size());
                    nodeModel.setTitleDescrptModels(titleDescrptModels);
                    for (HoverContent hc : titleDescriptList) {
                        Object color;
                        TextItemModel titleDescModel = new TextItemModel(hc.getContent());
                        titleDescModel.addItemStyle("color", "#98A1A8");
                        Map<String, Object> colorMap = hc.getData();
                        Object object = color = colorMap == null || colorMap.isEmpty() ? null : colorMap.get("color");
                        if (color != null) {
                            titleDescModel.addItemStyle("color", String.valueOf(color));
                        }
                        titleDescrptModels.add(titleDescModel);
                    }
                    nodeModel.addTitleDescrptWrapperStyle("display", "flex");
                    nodeModel.addTitleDescrptWrapperStyle("flex-grow", "1");
                    nodeModel.addTitleDescrptWrapperStyle("justify-content", "flex-end");
                }
                nodeModel.addHeaderWrapperStyle("display", "flex");
                if (node.getLineStatus() != null) {
                    nodeModel.addLineStatusStyle("background", this.getTableLineColor(node.getLineStatus()));
                }
                nodeModel.addLineStatusStyle("width", "1px");
                nodeModel.addLineStatusStyle("height", "100%");
                nodeModel.addLineStatusStyle("margin-left", "7px");
                nodeModel.addLineStatusStyle("min-height", "12px");
                nodeModel.addLineCardWrapperStyle("background", "#F8F9FB");
                nodeModel.addLineCardWrapperStyle("margin-left", "6px");
                nodeModel.addLineCardWrapperStyle("margin-top", "4px");
                nodeModel.addLineCardWrapperStyle("margin-bottom", "12px");
                nodeModel.addLineCardWrapperStyle("width", "100%");
                List<LineCard> lineCards = node.getCardList();
                if (lineCards != null && !lineCards.isEmpty()) {
                    for (int i = 0; i < lineCards.size(); ++i) {
                        LineCard lc = lineCards.get(i);
                        List<HoverContent> titles = lc.getLeftText();
                        List<List<HoverContent>> valueOrDescList = lc.getRightText();
                        if (titles == null || titles.isEmpty()) continue;
                        LineCardModel lcm = new LineCardModel();
                        lcm.addLineCardStyle("backeground", "#F8F9FB");
                        lcm.addLineCardStyle("padding-top", "4px");
                        lcm.addLineCardStyle("padding-bottom", "4px");
                        lcm.addLineCardStyle("padding-left", "6px");
                        if (i > 1) {
                            lcm.addLineCardStyle("border-top-color", "#E6E8EE");
                            lcm.addLineCardStyle("border-top-width", "1px");
                            lcm.addLineCardStyle("border-top-style", "solid");
                        }
                        for (int j = 0; j < titles.size(); ++j) {
                            HoverContent rowHoverContent = titles.get(j);
                            List<HoverContent> valueOrDescs = valueOrDescList != null && valueOrDescList.size() > j ? valueOrDescList.get(j) : null;
                            LineCardRowModel rowModel = new LineCardRowModel();
                            TextItemModel rowTitleModel = new TextItemModel(rowHoverContent.getContent());
                            rowTitleModel.addItemStyle("color", "#666666");
                            rowTitleModel.addItemStyle("font-size", "12px");
                            rowTitleModel.addItemStyle("text-overflow", "inherit");
                            rowTitleModel.addItemStyle("white-space", "inherit");
                            rowModel.addRowStyle("padding-bottom", "4px");
                            rowModel.addLeftStyle("width", isPopover ? "90%" : "40%");
                            rowModel.addLeftStyle("text-align", "left");
                            rowModel.setLeftModel(rowTitleModel);
                            if (valueOrDescs != null && !valueOrDescs.isEmpty()) {
                                for (HoverContent hc : valueOrDescs) {
                                    Object color;
                                    if (HoverContent.ContentType.HREF == hc.getType() || HoverContent.ContentType.CHAT == hc.getType()) {
                                        rowModel.addRightModels(new HrefItemModel(hc.getContent(), hc.getData()));
                                        continue;
                                    }
                                    TextItemModel rowValueOrDescModel = new TextItemModel(hc.getContent());
                                    rowValueOrDescModel.addItemStyle("color", "#333333");
                                    rowValueOrDescModel.addItemStyle("font-size", "12px");
                                    Map<String, Object> colorMap = hc.getData();
                                    Object object = color = colorMap == null || colorMap.isEmpty() ? null : colorMap.get("color");
                                    if (color != null) {
                                        rowValueOrDescModel.addItemStyle("color", String.valueOf(color));
                                    }
                                    rowModel.addRightModels(rowValueOrDescModel);
                                }
                            }
                            rowModel.addRightStyle("width", "60%");
                            rowModel.addRightStyle("text-align", "right");
                            rowModel.addRightStyle("display", "flex");
                            rowModel.addRightStyle("justify-content", "flex-end");
                            rowModel.addRightStyle("flex-grow", "1");
                            rowModel.addRowStyle("display", "flex");
                            rowModel.addRowStyle("flex-direction", "row");
                            lcm.addlineRows(rowModel);
                        }
                        nodeModel.addLineCard(lcm);
                    }
                }
                list.add(nodeModel);
            }
            return list;
        }
        return null;
    }

    public List<List<HoverContent>> addFailureInvoiceHoverContent(List<List<HoverContent>> hoverContent, Map<String, List<InvoiceFailureEntity>> invoiceFailureMap) {
        ArrayList<HoverContent> title = new ArrayList<HoverContent>();
        ArrayList<List<HoverContent>> newHoverContent = new ArrayList<List<HoverContent>>();
        title.add(HoverContent.createTitle(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0", (String)"IDISchemaResultPCDataConvert_15", (String)"data-idi-core", (Object[])new Object[0])));
        title.add(HoverContent.createTitle(ResManager.loadKDString((String)"\u5f71\u50cf\u7f16\u53f7", (String)"IDISchemaResultPCDataConvert_8", (String)"data-idi-core", (Object[])new Object[0])));
        title.add(HoverContent.createTitle(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"IDISchemaResultPCDataConvert_7", (String)"data-idi-core", (Object[])new Object[0])));
        newHoverContent.add(title);
        for (Map.Entry<String, List<InvoiceFailureEntity>> invoiceFailureEntry : invoiceFailureMap.entrySet()) {
            String errorCode = invoiceFailureEntry.getKey();
            List<InvoiceFailureEntity> invoiceFailureEntityList = invoiceFailureEntry.getValue();
            String errorMessage = InvoiceCloudCodeType.typeToCloudCodeType(errorCode).getErrorMessage();
            for (int i = 0; i < invoiceFailureEntityList.size(); ++i) {
                ArrayList<HoverContent> rowHoverContentList = new ArrayList<HoverContent>(invoiceFailureEntityList.size());
                rowHoverContentList.add(HoverContent.createText(errorMessage));
                rowHoverContentList.add(HoverContent.createText(invoiceFailureEntityList.get(i).getImageNumber()));
                rowHoverContentList.add(HoverContent.createText(invoiceFailureEntityList.get(i).getInvoiceNo()));
                newHoverContent.add(rowHoverContentList);
            }
        }
        return newHoverContent;
    }

    private String getTableNodeIcon(NodeStatusEnum nodeStatus) {
        switch (nodeStatus) {
            case PAST: {
                return "agree_13_13.png";
            }
            case NOW: {
                return "running.png";
            }
            case FUTURE: {
                return "end.png";
            }
        }
        return null;
    }

    private String getTableLineColor(NodeLineStatusEnum nodeLineStatus) {
        switch (nodeLineStatus) {
            case COMPLETE: {
                return "#26B175";
            }
            case PLAN: {
                return "#CCCCCC";
            }
        }
        return null;
    }
}

