/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.decision.executor;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.mservice.result.ServiceResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.decision.constant.MicroServiceType;
import kd.data.idi.decision.executor.AbstractExtDecisionExecutor;
import kd.data.idi.decision.model.ExtDecisionInfo;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;

public class MServiceDecisionExecutor
extends AbstractExtDecisionExecutor {
    public MServiceDecisionExecutor(ExtDecisionInfo extDecisionInfo) {
        super(extDecisionInfo);
    }

    @Override
    protected String executeDecision(SchemaContext context, Decision decision, ExtDecisionInfo decisionTypeExtInfo) {
        DynamicObject srcBillObj;
        String srcEntityNum = context.getEntityType();
        ServiceResult<Object> serviceResult = this.invokeService(srcEntityNum, srcBillObj = context.getSelfBill(), decision, decisionTypeExtInfo);
        if (serviceResult == null || !serviceResult.getSuccess().booleanValue() || serviceResult.getData() == null) {
            SchemaExecutorLogger.error("mservice decision result is null or empty");
            String errorMessage = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5fae\u670d\u52a1\u68c0\u67e5\u9879\u8c03\u7528\u5f02\u5e38", (String)"MServiceDecisionExecutor_0", (String)"data-idi-core", (Object[])new Object[0]);
            throw new KDBizException(errorMessage);
        }
        return IDIJSONUtils.toJsonString((Object)serviceResult.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResult<Object> invokeService(String srcEntityNum, DynamicObject srcBillObj, Decision decision, ExtDecisionInfo extDecisionInfo) {
        ServiceResult serviceResult;
        long start;
        block5: {
            MicroServiceType serviceType;
            DynamicObject srcEntityObject = BusinessDataServiceHelper.loadSingleFromCache((Object)srcEntityNum, (String)"bos_entityobject");
            String cloudId = srcEntityObject.getString("bizappid.bizcloud.number").toLowerCase();
            String appId = srcEntityObject.getString("bizappid.number").toLowerCase();
            MicroServiceType microServiceType = serviceType = extDecisionInfo.getServiceType() == null ? MicroServiceType.BIZ : extDecisionInfo.getServiceType();
            if (StringUtils.isNotEmpty((String)extDecisionInfo.getCloudId())) {
                cloudId = extDecisionInfo.getCloudId().trim();
            }
            String configAppId = extDecisionInfo.getAppId();
            String factoryQualifiedPrefix = String.format("kd.%s.%s.servicehelper", cloudId, StringUtils.isNotEmpty((String)configAppId) ? configAppId : appId);
            Map<String, String> paramMap = this.buildServiceParams(extDecisionInfo);
            start = System.currentTimeMillis();
            SchemaExecutorLogger.info("invoke mservice decision start. appId: %s, serviceFactory: %s.ServiceFactory, service: %s, method: %s", appId, factoryQualifiedPrefix, extDecisionInfo.getServiceName(), extDecisionInfo.getMethodName());
            serviceResult = null;
            try {
                if (MicroServiceType.BIZ != serviceType) break block5;
                serviceResult = paramMap.isEmpty() ? (ServiceResult)DispatchServiceHelper.invokeService((String)factoryQualifiedPrefix, (String)appId, (String)extDecisionInfo.getServiceName(), (String)extDecisionInfo.getMethodName(), (Object[])new Object[]{srcEntityNum, srcBillObj.getPkValue(), decision.getName()}) : (ServiceResult)DispatchServiceHelper.invokeService((String)factoryQualifiedPrefix, (String)appId, (String)extDecisionInfo.getServiceName(), (String)extDecisionInfo.getMethodName(), (Object[])new Object[]{srcEntityNum, srcBillObj.getPkValue(), decision.getName(), paramMap});
                SchemaExecutorLogger.info("invoke mservice decision result: %s", IDIJSONUtils.toJsonString((Object)serviceResult));
            }
            catch (Exception e) {
                try {
                    SchemaExecutorLogger.error("invoke mservice decision error", e);
                }
                catch (Throwable throwable) {
                    long end = System.currentTimeMillis();
                    SchemaExecutorLogger.info("invoke mservice decision end, cost time %dms", end - start);
                    throw throwable;
                }
                long end = System.currentTimeMillis();
                SchemaExecutorLogger.info("invoke mservice decision end, cost time %dms", end - start);
            }
        }
        long end = System.currentTimeMillis();
        SchemaExecutorLogger.info("invoke mservice decision end, cost time %dms", end - start);
        return serviceResult;
    }
}

