/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.decision.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.data.idi.decision.model.SchemaDecisionRelation;

public class SchemaDecisionService {
    public static final String FORMID_IDI_SCHEMA_DECISION = "idi_schema_decision";

    public List<SchemaDecisionRelation> querySchemaByDecision(String ... decisionNums) {
        QFilter filter = new QFilter("decision_num", "in", (Object)decisionNums);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)FORMID_IDI_SCHEMA_DECISION, (String)"schema_num,decision_num", (QFilter[])new QFilter[]{filter});
        ArrayList<SchemaDecisionRelation> relations = new ArrayList<SchemaDecisionRelation>();
        for (DynamicObject dObject : doc) {
            SchemaDecisionRelation relation = new SchemaDecisionRelation();
            relation.setSchemaNum(dObject.getString("schema_num"));
            relation.setDecisionNum(dObject.getString("decision_num"));
            relations.add(relation);
        }
        return relations;
    }

    public void save(List<SchemaDecisionRelation> relations) {
        if (CollectionUtils.isEmpty(relations)) {
            return;
        }
        DynamicObject[] dos = (DynamicObject[])relations.stream().map(relation -> {
            DynamicObject decisionType = BusinessDataServiceHelper.newDynamicObject((String)FORMID_IDI_SCHEMA_DECISION);
            decisionType.set("schema_num", (Object)relation.getSchemaNum());
            decisionType.set("decision_num", (Object)relation.getDecisionNum());
            return decisionType;
        }).toArray(DynamicObject[]::new);
        SaveServiceHelper.save((DynamicObject[])dos);
    }

    public void deleteBySchemaNum(String ... schemaNums) {
        QFilter filter = new QFilter("schema_num", "in", (Object)schemaNums);
        DeleteServiceHelper.delete((String)FORMID_IDI_SCHEMA_DECISION, (QFilter[])new QFilter[]{filter});
    }
}

