/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AlarmConfig;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.DeductionGrade;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ai.service.ISimilarService;
import kd.data.idi.util.IDIDateUtils;
import kd.data.idi.util.IDIJSONUtils;

@Deprecated
public class AlarmExecutorHistory
implements DecisionExecutor {
    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        AlarmConfig alarmConfig = decision.getAlarm();
        if (alarmConfig == null) {
            return null;
        }
        FilterCondition filterCondition = alarmConfig.getFilterCondition();
        if (filterCondition == null || filterCondition.getFilterRow() == null || filterCondition.getFilterRow().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u7b5b\u9009\u51fa\u5386\u53f2\u5bf9\u6bd4\u5355\u636e", (String)"AlarmExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        DynamicObject billObj = ExecutorHelper.getSelfBill(context);
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)context.getEntityType());
        String billStatusField = billType instanceof BillEntityType ? ((BillEntityType)billType).getBillStatus() : null;
        IDataEntityType currentBillType = billObj.getDataEntityType();
        Map fieldMap = null;
        if (currentBillType instanceof MainEntityType) {
            fieldMap = ((MainEntityType)currentBillType).getAllFields();
        }
        HashSet<String> similarProps = new HashSet<String>();
        int index = 0;
        Pattern pattern = Pattern.compile("^IDI_BETWEEN_([0-9]+)([MWC])$");
        DateFormat dateFormat = KDDateFormatUtils.getDateTimeFormat();
        List rows = filterCondition.getFilterRow();
        while (index < rows.size()) {
            FilterValue filterValue;
            SimpleFilterRow filterRow = (SimpleFilterRow)rows.get(index);
            String fieldName = filterRow.getFieldName();
            if (StringUtils.isNotEmpty((String)billStatusField) && billStatusField.equals(fieldName)) {
                ++index;
                continue;
            }
            String fullFieldName = this.getFullFieldName(fieldName, fieldMap, billType.getName());
            Object fieldValue = ExecutorHelper.getValueAndNameByName(billObj, fullFieldName, false).getValue();
            SchemaExecutorLogger.info("field:" + fieldName + ", value:" + fieldValue, new Object[0]);
            Matcher matcher = pattern.matcher(filterRow.getCompareType());
            if (matcher.matches()) {
                if (fieldValue instanceof Date) {
                    Date beginDate;
                    Date endDate = (Date)fieldValue;
                    filterRow.setCompareType(CompareTypeEnum.BETWEEN.getId());
                    String d = matcher.group(1);
                    String t = matcher.group(2);
                    int dt = 1;
                    if (!StringUtils.isEmpty((String)d)) {
                        try {
                            dt = Integer.parseInt(d);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if ("M".equals(t)) {
                        beginDate = KDDateUtils.addMonths((Date)endDate, (int)(-1 * dt));
                    } else if ("W".equals(filterRow.getCompareType())) {
                        beginDate = KDDateUtils.addWeeks((Date)endDate, (int)(-1 * dt));
                    } else if ("C".equals(t)) {
                        beginDate = IDIDateUtils.getTheMonthStartTime((Date)endDate);
                        endDate = IDIDateUtils.getTheMonthEndTime((Date)endDate);
                    } else {
                        beginDate = KDDateUtils.addDays((Date)endDate, (int)-1);
                    }
                    ArrayList<FilterValue> fvList = new ArrayList<FilterValue>();
                    FilterValue filterValue2 = new FilterValue();
                    filterValue2.setValue((Object)dateFormat.format(beginDate));
                    fvList.add(filterValue2);
                    filterValue2 = new FilterValue();
                    filterValue2.setValue((Object)dateFormat.format(endDate));
                    fvList.add(filterValue2);
                    filterRow.setValue(fvList);
                } else if (fieldValue == null) {
                    filterRow.setCompareType(CompareTypeEnum.ISNULL.getId());
                    filterRow.setValue(Collections.emptyList());
                } else {
                    filterRow.setCompareType(CompareTypeEnum.EQUAL.getId());
                    filterValue = new FilterValue();
                    filterValue.setValue((Object)fieldValue.toString());
                    filterRow.setValue(Collections.singletonList(filterValue));
                }
            } else if (!(CompareTypeEnum.TODAY.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.YESTERDAY.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.LESS.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.LESSOREQUAL.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.GREATER.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.GREATEROREQUAL.getId().equals(filterRow.getCompareType()))) {
                if ("SIMILAR".equals(filterRow.getCompareType())) {
                    similarProps.add(filterRow.getFieldName());
                    rows.remove(index);
                    --index;
                } else if (fieldValue == null) {
                    filterRow.setCompareType(CompareTypeEnum.ISNULL.getId());
                    filterRow.setValue(Collections.emptyList());
                } else {
                    filterValue = new FilterValue();
                    Object value = fieldValue instanceof List ? ((List)fieldValue).get(0) : fieldValue;
                    filterValue.setValue((Object)value.toString());
                    filterRow.setValue(Collections.singletonList(filterValue));
                }
            }
            ++index;
        }
        FilterBuilder filterBuilder = new FilterBuilder(billType, filterCondition);
        try {
            filterBuilder.buildFilter(false);
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error(IDIJSONUtils.toJsonString((Object)filterCondition), ex);
            filterBuilder.setQFilter(null);
        }
        QFilter qFilter = filterBuilder.getQFilter();
        if (qFilter == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u7b5b\u9009\u51fa\u5386\u53f2\u5bf9\u6bd4\u5355\u636e", (String)"AlarmExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        if (context.getBillId() != null) {
            QFilter ignoreSelfBill = new QFilter(billType.getPrimaryKey().getName(), "!=", context.getBillId());
            qFilter = FilterUtil.combineFilter((QFilter)ignoreSelfBill, (QFilter)qFilter);
        }
        String noOrNumberField = billType instanceof BasedataEntityType ? "number" : "billno";
        StringBuilder selectProperties = new StringBuilder(noOrNumberField);
        for (String similarProp : similarProps) {
            selectProperties.append(',').append(similarProp);
        }
        selectProperties.append(',').append("id");
        DynamicObjectCollection sameBillList = QueryServiceHelper.query((String)context.getEntityType(), (String)selectProperties.toString(), (QFilter[])new QFilter[]{qFilter});
        SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u91cd\u590d\u5355\u636e\u8fc7\u6ee4\u6761\u4ef6\uff1a%s", (String)"AlarmExecutor_2", (String)"data-idi-core", (Object[])new Object[0]), qFilter.toString()), new Object[0]);
        DecisionResult result = new DecisionResult();
        result.setDecision(decision);
        boolean isSame = false;
        if (sameBillList != null && sameBillList.size() > 0) {
            HashSet<Long> repeatBillId = new HashSet<Long>(3);
            if (!similarProps.isEmpty()) {
                List<Integer> similarTextSeqs = this.similar(similarProps, billObj, sameBillList);
                if (similarTextSeqs != null && similarTextSeqs.size() > 0) {
                    isSame = true;
                    DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
                    for (int i = 0; repeatBillId.size() < 3 && i < similarTextSeqs.size(); ++i) {
                        DynamicObject sameBill = (DynamicObject)sameBillList.get(similarTextSeqs.get(i).intValue());
                        if (!repeatBillId.add(sameBill.getLong("id"))) continue;
                        frontEndResult.addHoverContent(HoverContent.createHref(sameBill.getString(noOrNumberField), sameBill.get("id"), context.getEntityType()));
                    }
                    result.setFrontEndResult(frontEndResult);
                }
            } else {
                isSame = true;
                DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
                for (int i = 0; repeatBillId.size() < 3 && i < sameBillList.size(); ++i) {
                    DynamicObject sameBill = (DynamicObject)sameBillList.get(i);
                    if (!repeatBillId.add(sameBill.getLong("id"))) continue;
                    frontEndResult.addHoverContent(HoverContent.createHref(sameBill.getString(noOrNumberField), sameBill.get("id"), context.getEntityType()));
                }
                result.setFrontEndResult(frontEndResult);
            }
        }
        DeductionGrade deductionGrade = new DeductionGrade(context);
        if (isSame) {
            result.setShowText(alarmConfig.getFailText());
            result.setStatus("alarming");
            if (alarmConfig.isCheckVote()) {
                result.setOneVoteVeto(true);
            }
            deductionGrade.deduct(100);
        } else {
            result.setShowText(alarmConfig.getSuccessText());
            result.setStatus("green");
            deductionGrade.deduct(0);
        }
        result.setDeductPercent(deductionGrade.getValue());
        SchemaExecutorLogger.info(decision.getName() + "\nfilter:" + qFilter + "\nmatch count:" + (sameBillList == null ? 0 : sameBillList.size()), new Object[0]);
        return result;
    }

    private String getFullFieldName(String fieldName, Map<String, IDataEntityProperty> fieldMap, String entityNumber) {
        if (fieldMap == null || fieldMap.isEmpty() || StringUtils.isEmpty((String)fieldName)) {
            return fieldName;
        }
        String onlyField = fieldName.indexOf(46) > 0 ? fieldName.substring(0, fieldName.indexOf(46)) : fieldName;
        String fullFieldName = fieldName;
        IDataEntityProperty property = fieldMap.get(onlyField);
        for (IDataEntityType entityType = property.getParent(); entityType != null && !entityNumber.equals(entityType.getName()); entityType = entityType.getParent()) {
            fullFieldName = entityType.getName() + "." + fullFieldName;
        }
        return fullFieldName;
    }

    private List<Integer> similar(Set<String> similarProps, DynamicObject billObj, DynamicObjectCollection sameBillList) {
        for (String similarProp : similarProps) {
            List<String> theBillValues = this.getPropValues(billObj, similarProp);
            ArrayList<String> textList = new ArrayList<String>();
            for (DynamicObject sameBill : sameBillList) {
                String val = sameBill.getString(similarProp);
                if (!StringUtils.isNotEmpty((String)val)) continue;
                textList.add(val);
            }
            for (String text : theBillValues) {
                List<Integer> similarTextSeqs = ISimilarService.getInstance().textSimilar(text, textList);
                if (similarTextSeqs == null || similarTextSeqs.size() <= 0) continue;
                return similarTextSeqs;
            }
        }
        return null;
    }

    private List<String> getPropValues(DynamicObject billObj, String similarProp) {
        ArrayList<String> theBillValues = new ArrayList<String>();
        Object value = ExecutorHelper.getValueAndNameByName(billObj, similarProp, false).getValue();
        if (value instanceof List) {
            List objs = (List)value;
            for (Object val : objs) {
                String valStr = val.toString();
                if (!StringUtils.isNotEmpty((String)valStr)) continue;
                theBillValues.add(valStr);
            }
        } else {
            String valueStr = (String)value;
            if (StringUtils.isNotEmpty((String)valueStr)) {
                theBillValues.add(valueStr);
            }
        }
        return theBillValues;
    }
}

