/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.data.idi.engine.AlarmExecutor;

public class AlarmFormula {
    private List<SimpleFilterRow> symbols;
    private AlarmFormula leftFactor;
    private String logic;
    private AlarmFormula rightFactor;
    private AlarmExecutor executor;

    public static AlarmFormula createFormula(List<SimpleFilterRow> rows, AlarmExecutor executor) {
        AlarmFormula.removeOuterBracket(rows);
        return new AlarmFormula(rows, executor);
    }

    public AlarmFormula(List<SimpleFilterRow> symbols, AlarmExecutor executor) {
        this.executor = executor;
        this.symbols = symbols;
        if (symbols.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (String)"AlarmFormula_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        int opIndex = 0;
        int leftBracketIndex = 0;
        int rightBracketIndex = 0;
        int lastOrIndex = -1;
        int pos = symbols.size() - 1;
        int bracketStat = 0;
        int leftCount = 0;
        for (int i = pos; i >= 0; --i) {
            SimpleFilterRow filterRow = symbols.get(i);
            leftCount += filterRow.getLeftBracket().length();
            if (bracketStat == 0 && filterRow.getRightBracket().length() != 0) {
                rightBracketIndex = i;
            }
            bracketStat += filterRow.getRightBracket().length();
            if ((bracketStat -= filterRow.getLeftBracket().length()) == 0 && filterRow.getLeftBracket().length() != 0) {
                leftBracketIndex = i;
            }
            if (!"1".equals(filterRow.getLogic())) continue;
            lastOrIndex = i;
        }
        if (bracketStat != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u67e5\u6761\u4ef6\u7684\u62ec\u53f7\u4e0d\u5bf9\u79f0\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"AlarmFormula_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        if (leftCount == 0) {
            this.leftFactor = null;
            this.logic = "";
            this.rightFactor = null;
        } else {
            opIndex = leftBracketIndex == 0 ? rightBracketIndex + 1 : (lastOrIndex < 0 || leftBracketIndex <= lastOrIndex ? leftBracketIndex : lastOrIndex + 1);
            this.leftFactor = this.createSub(0, opIndex, executor);
            this.logic = symbols.get(opIndex - 1).getLogic();
            this.rightFactor = this.createSub(opIndex, symbols.size(), executor);
        }
    }

    private AlarmFormula createSub(int fromIndex, int toIndex, AlarmExecutor executor) {
        if (fromIndex == toIndex) {
            return null;
        }
        List<SimpleFilterRow> subList = this.symbols.subList(fromIndex, toIndex);
        return AlarmFormula.createFormula(subList, executor);
    }

    private static void removeOuterBracket(List<SimpleFilterRow> filterRows) {
        boolean continueRemove;
        do {
            int leftBracketIndex = 0;
            int rightBracketIndex = 0;
            int pos = filterRows.size() - 1;
            int bracketStat = 0;
            int bracketCount = 0;
            for (int i = pos; i >= 0; --i) {
                SimpleFilterRow filterRow = filterRows.get(i);
                bracketCount += filterRow.getLeftBracket().length();
                bracketCount += filterRow.getRightBracket().length();
                if (bracketStat == 0 && filterRow.getRightBracket().length() != 0) {
                    rightBracketIndex = i;
                }
                bracketStat += filterRow.getRightBracket().length();
                if ((bracketStat -= filterRow.getLeftBracket().length()) != 0 || filterRow.getLeftBracket().length() == 0) continue;
                leftBracketIndex = i;
            }
            if (bracketCount > 0 && leftBracketIndex == 0 && rightBracketIndex == pos) {
                SimpleFilterRow simpleFilterRow = filterRows.get(0);
                SimpleFilterRow simpleFilterRowEnd = filterRows.get(filterRows.size() - 1);
                simpleFilterRow.setLeftBracket(simpleFilterRow.getLeftBracket().substring(1));
                simpleFilterRowEnd.setRightBracket(simpleFilterRowEnd.getRightBracket().substring(1));
                continueRemove = true;
                continue;
            }
            continueRemove = false;
        } while (continueRemove);
    }

    public Map<Object, Map<String, Set<Object>>> calculate() {
        if (StringUtils.isEmpty((CharSequence)this.logic)) {
            return this.executor.executeFilter(this.symbols);
        }
        return this.executor.logicCalculate(this.leftFactor.calculate(), this.rightFactor.calculate(), this.logic);
    }
}

