/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Courier;
import kd.data.idi.data.CourierDataResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.LineCard;
import kd.data.idi.data.NodeLineStatusEnum;
import kd.data.idi.data.NodeStatusEnum;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.TableLineNode;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SelectDecisionExecutor;
import kd.data.idi.engine.courier.service.CourierParam;
import kd.data.idi.engine.courier.service.ICourierService;

public class CourierExecutor
extends SelectDecisionExecutor
implements DecisionExecutor {
    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        DynamicObject[] addObjs;
        SelectDecisionExecutor.StartConditionParam param;
        DynamicObject billObj = ExecutorHelper.getSelfBill(context);
        Map<String, CourierParam> map = this.buildParam(context, billObj);
        if (map.isEmpty()) {
            return null;
        }
        IDICondition startCondition = decision.getStartCondition();
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript()) && !this.checkStartCondition(param = new SelectDecisionExecutor.StartConditionParam(context.getSelfBill(), context.getSrcEntityType(), startCondition, false))) {
            DecisionResult result = new DecisionResult();
            result.setStatus("empty");
            result.setDecision(decision);
            result.setShowText(String.format(ResManager.loadKDString((String)"%s : \u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"GeneralLedgerExecutor_7", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()));
            return result;
        }
        List<DynamicObject> existArray = this.queryCourier(map);
        ArrayList<CourierParam> noExistList = new ArrayList<CourierParam>(map.size());
        for (Map.Entry<String, CourierParam> entry : map.entrySet()) {
            noExistList.add(entry.getValue());
        }
        List<DynamicObject> noExistObjs = ICourierService.getInstance().query(noExistList);
        ArrayList<DynamicObject> errorObjs = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>(2);
        if (noExistObjs != null && !noExistObjs.isEmpty()) {
            for (DynamicObject obj : noExistObjs) {
                String entityName = obj.getDataEntityType().getName();
                if ("idi_logistics_errorinfo".equals(entityName)) {
                    errorObjs.add(obj);
                    continue;
                }
                successObjs.add(obj);
            }
        }
        if (!successObjs.isEmpty()) {
            addObjs = successObjs.toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])addObjs);
        }
        if (!errorObjs.isEmpty()) {
            addObjs = errorObjs.toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])addObjs);
        }
        existArray.addAll(successObjs);
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setDecision(decision);
        CourierDataResult courierData = this.buildResult(existArray, errorObjs);
        courierData.setTitle(decision.getName());
        decisionResult.setCourierDataResult(courierData);
        return decisionResult;
    }

    private CourierDataResult buildResult(List<DynamicObject> kuaidiList, List<DynamicObject> errorList) {
        Courier courier;
        CourierDataResult courierDataResult = new CourierDataResult();
        if (kuaidiList != null && !kuaidiList.isEmpty()) {
            for (DynamicObject dobj : kuaidiList) {
                courier = new Courier();
                courier.setCompany(dobj.getString("kuadicomname"));
                courier.setOrder(dobj.getString("kuaidinum"));
                courier.setTimeDesc(String.format(ResManager.loadKDString((String)"\u53d1\u5e03\u65f6\u95f4\uff1a%s", (String)"CourierExecutor_0", (String)"data-idi-core", (Object[])new Object[0]), dobj.getString("sendtime")));
                courier.setSuccess(true);
                String isCheckStr = dobj.getString("ischeck");
                DynamicObjectCollection entryCols = dobj.getDynamicObjectCollection("dataentryentity");
                if (entryCols == null || entryCols.isEmpty()) continue;
                for (int i = entryCols.size() - 1; i > -1; --i) {
                    DynamicObject entry = (DynamicObject)entryCols.get(i);
                    TableLineNode node = new TableLineNode();
                    String time = entry.getString("ftime");
                    String context = entry.getString("context");
                    if ("1".equals(isCheckStr)) {
                        node.setStatus(NodeStatusEnum.PAST);
                    } else {
                        node.setStatus(i == entryCols.size() - 1 ? NodeStatusEnum.NOW : NodeStatusEnum.PAST);
                    }
                    node.setTitle(time);
                    if (StringUtils.isNotEmpty((String)context)) {
                        LineCard contextCrad = new LineCard();
                        contextCrad.addLeftText(HoverContent.createText(context));
                        node.addCard(contextCrad);
                        node.setLineStatus(NodeLineStatusEnum.COMPLETE);
                    }
                    if (i == 0) {
                        node.setLineStatus(null);
                    }
                    courier.addTableLineNode(node);
                }
                courierDataResult.addCourier(courier);
            }
        }
        if (errorList != null && !errorList.isEmpty()) {
            for (DynamicObject dobj : errorList) {
                courier = new Courier();
                courier.setCompany(dobj.getString("companyname"));
                courier.setOrder(dobj.getString("order"));
                courier.setTimeDesc(dobj.getString("message"));
                courier.setSuccess(false);
                courierDataResult.addCourier(courier);
            }
        }
        return courierDataResult;
    }

    private List<DynamicObject> queryCourier(Map<String, CourierParam> map) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(2);
        if (map != null && !map.isEmpty()) {
            DynamicObject[] dataObjs;
            HashSet<String> orderSet = new HashSet<String>(map.size());
            for (Map.Entry<String, CourierParam> entry : map.entrySet()) {
                orderSet.add(entry.getValue().getOrder());
            }
            StringBuilder sb = new StringBuilder();
            sb.append("kuaidinum").append(',').append("companycode").append(",id");
            ArrayList<Object> list = new ArrayList<Object>(2);
            DynamicObject[] dynamicObjectArray = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CourierExecutor.queryCourier", (String)"idi_logistics_info", (String)sb.toString(), (QFilter[])new QFilter[]{new QFilter("kuaidinum", "in", (Object)orderSet.toArray(new String[0]))}, null);){
                for (Row row : dataSet) {
                    String order = row.getString("kuaidinum");
                    String companyCode = row.getString("companycode");
                    String key = order + "_" + companyCode;
                    if (!map.containsKey(key)) continue;
                    map.remove(key);
                    list.add(row.get("id"));
                }
            }
            catch (Throwable object) {
                dynamicObjectArray = object;
                throw object;
            }
            if (!list.isEmpty() && (dataObjs = BusinessDataServiceHelper.load((Object[])list.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"idi_logistics_info"))) != null && dataObjs.length > 0) {
                for (DynamicObject data : dataObjs) {
                    result.add(data);
                }
            }
        }
        return result;
    }

    private Map<String, CourierParam> buildParam(SchemaContext context, DynamicObject billObj) {
        Map<String, CourierParam> map = context.getCourierParam();
        if (map == null || map.isEmpty()) {
            map = new HashMap<String, CourierParam>();
            IDataEntityType mainType = billObj.getDataEntityType();
            String entityNumber = mainType.getName();
            billObj = BusinessDataServiceHelper.loadSingle((Object)billObj.getPkValue(), (String)entityNumber, (String)"id,billno");
            String logisticNumber = entityNumber.startsWith("sm") ? "sm_logisticsinfo" : "pm_logisticsinfo";
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CourierExecutor.buildParam", (String)logisticNumber, (String)"entryentity.logisticscomp.number,entryentity.logisticscomp.name,entryentity.logisticsnum,entryentity.receivephone", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billObj.getString("billno"))}, null);){
                if (dataSet != null) {
                    for (Row row : dataSet) {
                        String key;
                        String companyNum = row.getString("entryentity.logisticscomp.number");
                        String companyName = row.getString("entryentity.logisticscomp.name");
                        String order = row.getString("entryentity.logisticsnum");
                        String mobile = row.getString("entryentity.receivephone");
                        if (StringUtils.isEmpty((String)order) || StringUtils.isEmpty((String)companyNum) || map.containsKey(key = order + "_" + companyNum)) continue;
                        map.put(key, new CourierParam(order, companyNum, companyName, mobile));
                    }
                }
            }
        }
        return map;
    }
}

