/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.BillInfo;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndConfig;
import kd.data.idi.data.DecisionFrontEndConfigField;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.LinkUpBillConfig;
import kd.data.idi.engine.BillLinkRelation;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.ScriptFormIdHandler;

public class CustomizedRelationBillChecker {
    private static final int MAX_CONTENT = 1000;
    private static final int MAX_EXISTS = 100;
    private DynamicObject srcBillObj;
    private BillInfo matchBill;
    private LinkUpBillConfig billConfig;
    private Decision decision;
    private Conditions conditions;
    private MainEntityType srcType;
    private MainEntityType targetType;

    public CustomizedRelationBillChecker(DynamicObject srcBillObj, BillInfo matchBill, Decision decision, LinkUpBillConfig billConfig) {
        this.srcBillObj = srcBillObj;
        this.matchBill = matchBill;
        this.decision = decision;
        this.billConfig = billConfig;
        this.srcType = (MainEntityType)srcBillObj.getDataEntityType();
        this.targetType = matchBill.achieveBIllEntityType();
        this.conditions = new Conditions();
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public List<BillLinkRelation> queryBills() {
        this.parseBillRelation();
        QFilter filter = this.conditions.valueFilter;
        String selectors = this.getSelectors(this.conditions, this.decision, this.matchBill.getEntityNumber());
        int top = 1000;
        if (this.decision.getLinkUpBillConfig().getCheckType() == LinkUpBillConfig.CheckType.CheckBillExists) {
            top = 100;
        }
        HashSet<Object> idSet = new HashSet<Object>(2);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryBills", (String)this.matchBill.getEntityNumber(), (String)"id", (QFilter[])new QFilter[]{filter}, null, (int)top);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    idSet.add(row.get("id"));
                }
            }
        }
        DynamicObject[] targetBills = null;
        if (idSet.isEmpty()) {
            return new ArrayList<BillLinkRelation>();
        }
        Object[] pkValues = idSet.toArray();
        targetBills = new DynamicObject[pkValues.length];
        String[] fields = selectors.split(",");
        HashSet fieldSet = Sets.newHashSetWithExpectedSize((int)fields.length);
        for (String field : fields) {
            fieldSet.add(field);
        }
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)this.matchBill.getEntityNumber(), ExecutorHelper.trimEntry(this.matchBill.getEntityNumber(), fieldSet));
        for (int i = 0; i < pkValues.length; ++i) {
            targetBills[i] = BusinessDataReader.loadSingle((Object)pkValues[i], (DynamicObjectType)type);
        }
        return this.buildBillRelation(targetBills);
    }

    private List<BillLinkRelation> buildBillRelation(DynamicObject[] targetBills) {
        ArrayList<BillLinkRelation> billRelations = new ArrayList<BillLinkRelation>();
        int loopSize = Math.max(1, this.conditions.src_entry_size);
        for (int srcEntryIndex = 0; srcEntryIndex < loopSize; ++srcEntryIndex) {
            List<DynamicObject> linkObjs = this.findLinkObjects(targetBills, this.conditions, srcEntryIndex);
            if (!linkObjs.isEmpty()) {
                BillLinkRelation relation = new BillLinkRelation();
                relation.setSrcBillObj(this.srcBillObj);
                if (this.conditions.src_entry_name != null) {
                    relation.setSrcEntryName(this.conditions.src_entry_name);
                    relation.setSrcEntryIndex(srcEntryIndex);
                }
                if (this.conditions.entryParams.isEmpty()) {
                    relation.setLinkBillObjs(linkObjs);
                    billRelations.add(relation);
                } else if (this.conditions.link_entry_name != null) {
                    relation.setLinkEntryName(this.conditions.link_entry_name);
                    relation.setLinkEntryIndexList(new ArrayList<List<Integer>>());
                    relation.setLinkBillObjs(new ArrayList<DynamicObject>());
                    for (DynamicObject linkObj : linkObjs) {
                        List<Integer> entryIndex = this.findLinkEntries(linkObj, this.conditions, srcEntryIndex);
                        if (entryIndex.isEmpty()) continue;
                        relation.getLinkBillObjs().add(linkObj);
                        relation.getLinkEntryIndexList().add(entryIndex);
                    }
                    if (relation.getLinkBillObjs().size() > 0) {
                        billRelations.add(relation);
                    }
                }
            }
            if (this.count(billRelations) >= 1000) break;
        }
        return billRelations;
    }

    private int count(List<BillLinkRelation> billRelations) {
        int count = 0;
        for (BillLinkRelation relation : billRelations) {
            count += relation.getLinkBillObjs().size();
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FilterCondition buildValueFilter(IDICondition matchCondition) {
        FilterCondition valueFilterCondition = new FilterCondition();
        FilterCondition filterCondition = matchCondition.getFilterCondition();
        int index = 0;
        Pattern pattern = Pattern.compile("^IDI_BETWEEN_([0-9|H]+)([MWY])$");
        DateFormat dateTimeFormat = KDDateFormatUtils.getDateTimeFormat();
        List rows = filterCondition.getFilterRow();
        while (index < rows.size()) {
            boolean isValueFilter = true;
            SimpleFilterRow filterRow = (SimpleFilterRow)rows.get(index);
            Matcher matcher = pattern.matcher(filterRow.getCompareType());
            if (matcher.matches()) {
                Date theDate = new Date();
                filterRow.setCompareType(CompareTypeEnum.BETWEEN.getId());
                String d = matcher.group(1);
                String t = matcher.group(2);
                int dt = 1;
                if (!StringUtils.isEmpty((String)d)) {
                    if ("H".equals(d)) {
                        dt = 6;
                        if (!"Y".equals(t)) {
                            String text = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u65e5\u671f\u671f\u95f4", (String)"CustomizedRelationBillChecker_0", (String)"data-idi-core", (Object[])new Object[0]);
                            throw new KDBizException(text);
                        }
                        t = "M";
                    } else {
                        try {
                            dt = Integer.parseInt(d);
                        }
                        catch (Throwable text) {
                            // empty catch block
                        }
                    }
                }
                Date beginDate = "M".equals(t) ? KDDateUtils.addMonths((Date)theDate, (int)(-1 * dt)) : ("W".equals(t) ? KDDateUtils.addWeeks((Date)theDate, (int)(-1 * dt)) : ("Y".equals(t) ? KDDateUtils.addYears((Date)theDate, (int)(-1 * dt)) : KDDateUtils.addDays((Date)theDate, (int)-1)));
                ArrayList<FilterValue> fvList = new ArrayList<FilterValue>();
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)dateTimeFormat.format(beginDate));
                fvList.add(filterValue);
                filterValue = new FilterValue();
                filterValue.setValue((Object)dateTimeFormat.format(theDate));
                fvList.add(filterValue);
                filterRow.setValue(fvList);
            } else if (CompareTypeEnum.TODAY.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.YESTERDAY.getId().equals(filterRow.getCompareType())) {
                Date date = CompareTypeEnum.TODAY.getId().equals(filterRow.getCompareType()) ? KDDateUtils.today() : KDDateUtils.addDays((Date)new Date(), (int)-1);
                filterRow.setCompareType(CompareTypeEnum.EQUAL.getId());
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)dateTimeFormat.format(date));
                filterRow.setValue(Collections.singletonList(filterValue));
            } else if (CompareTypeEnum.FIELDEQUAL.getId().equals(filterRow.getCompareType())) {
                isValueFilter = false;
            }
            if (isValueFilter) {
                rows.remove(index);
                --index;
            }
            valueFilterCondition.addFilterRow(filterRow);
            ++index;
        }
        return valueFilterCondition;
    }

    private void parseBillRelation() {
        QFilter filter;
        IDICondition matchCondition = this.billConfig.getMatchCondition();
        FilterCondition valueFilterCondition = this.buildValueFilter(matchCondition);
        if (matchCondition.getFilterCondition().getFilterRow().isEmpty()) {
            String text = ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6e90\u5355\u548c\u76ee\u6807\u5355\u5b57\u6bb5\u5173\u7cfb", (String)"CustomizedRelationBillChecker_2", (String)"data-idi-core", (Object[])new Object[0]);
            throw new KDBizException(text);
        }
        Set<String> srcEntryKeySet = this.allEntryKey(this.srcType);
        Set<String> targetEntryKeySet = this.allEntryKey(this.targetType);
        DateFormat dateTimeFormat = KDDateFormatUtils.getDateTimeFormat((TimeZone)KDDateUtils.getSysTimeZone());
        DateFormat dateformat = KDDateFormatUtils.getDateFormat((TimeZone)KDDateUtils.getSysTimeZone());
        HashMap<SimpleFilterRow, Condition> mulDateConditionMap = new HashMap<SimpleFilterRow, Condition>(10);
        for (SimpleFilterRow row : matchCondition.getFilterCondition().getFilterRow()) {
            String text;
            IDataEntityProperty entityProperty;
            String targetPropName = row.getFieldName();
            String srcPropName = (String)((FilterValue)row.getValue().get(0)).getValue();
            String[] props = targetPropName.split("\\.");
            Condition condition = new Condition();
            condition.link_prop_name = targetPropName;
            String entryName = props[0];
            if (props.length >= 2 && targetEntryKeySet.contains(entryName)) {
                entityProperty = this.targetType.findProperty(entryName);
                if (entityProperty instanceof ICollectionProperty) {
                    if (this.conditions.link_entry_name != null && !entryName.equals(this.conditions.link_entry_name)) {
                        text = ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u5b58\u5728\u591a\u4e2a\u76ee\u6807\u5355\u7684\u5206\u5f55", (String)"CustomizedRelationBillChecker_3", (String)"data-idi-core", (Object[])new Object[0]);
                        throw new KDBizException(text);
                    }
                    this.conditions.link_entry_name = entryName;
                }
                this.conditions.entryParams.add(condition);
                condition.isEntry_link_pro_name = true;
            } else {
                this.conditions.headParams.add(condition);
                condition.isEntry_link_pro_name = false;
            }
            props = srcPropName.split("\\.");
            entryName = props[0];
            if (props.length >= 2 && srcEntryKeySet.contains(entryName)) {
                entityProperty = this.srcType.findProperty(entryName);
                if (entityProperty instanceof ICollectionProperty) {
                    if (this.conditions.src_entry_name != null && !entryName.equals(this.conditions.src_entry_name)) {
                        text = ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u5b58\u5728\u591a\u4e2a\u6e90\u5355\u7684\u5206\u5f55", (String)"CustomizedRelationBillChecker_4", (String)"data-idi-core", (Object[])new Object[0]);
                        throw new KDBizException(text);
                    }
                    if (this.conditions.src_entry_name == null) {
                        this.conditions.src_entry_name = entryName;
                        DynamicObjectCollection entryCol = this.srcBillObj.getDynamicObjectCollection(entryName);
                        if (entryCol != null) {
                            this.conditions.src_entry_size = entryCol.size();
                        }
                    }
                }
                condition.isEntry_src_prop_name = true;
            } else {
                condition.isEntry_src_prop_name = false;
            }
            condition.src_prop_value = this.getSrcPropValue(this.srcBillObj, srcPropName);
            ArrayList<FilterValue> fvList = new ArrayList<FilterValue>(10);
            if (condition.isEntry_src_prop_name) {
                List objs = (List)condition.src_prop_value;
                row.setCompareType(CompareTypeEnum.IN.getId());
                if (CollectionUtils.isNotEmpty((Collection)objs)) {
                    boolean isMulDate = false;
                    for (Object obj : objs) {
                        FilterValue filterValue = new FilterValue();
                        if (obj instanceof Date) {
                            filterValue.setValue((Object)dateTimeFormat.format(obj));
                            row.setCompareType(CompareTypeEnum.LESS.getId());
                            isMulDate = true;
                        } else {
                            filterValue.setValue((Object)(obj == null ? null : String.valueOf(obj)));
                        }
                        fvList.add(filterValue);
                    }
                    if (isMulDate) {
                        mulDateConditionMap.put(row, condition);
                    }
                }
            } else {
                row.setCompareType(CompareTypeEnum.EQUAL.getId());
                FilterValue filterValue = new FilterValue();
                if (condition.src_prop_value instanceof Date) {
                    filterValue.setValue((Object)dateTimeFormat.format(condition.src_prop_value));
                } else {
                    filterValue.setValue(condition.src_prop_value == null ? null : String.valueOf(condition.src_prop_value));
                }
                fvList.add(filterValue);
            }
            row.setValue(fvList);
        }
        if (!valueFilterCondition.getFilterRow().isEmpty()) {
            FilterBuilder filterBuilder = new FilterBuilder(this.targetType, valueFilterCondition);
            try {
                filterBuilder.buildFilter(false);
            }
            catch (Exception ex) {
                String text = ResManager.loadKDString((String)"\u67e5\u627e\u89c4\u5219\u6709\u9519\u8bef", (String)"CustomizedRelationBillChecker_1", (String)"data-idi-core", (Object[])new Object[0]);
                throw new KDBizException(text + "," + ex.getMessage());
            }
            filter = filterBuilder.getQFilter();
            if (filter != null && !mulDateConditionMap.isEmpty()) {
                List otherFilter = filter.getNests(true);
                Set entrySet = mulDateConditionMap.entrySet();
                for (Map.Entry simpleFilterRowConditionEntry : entrySet) {
                    SimpleFilterRow row = (SimpleFilterRow)simpleFilterRowConditionEntry.getKey();
                    Condition condition = (Condition)simpleFilterRowConditionEntry.getValue();
                    String srcPropName = row.getFieldName();
                    List objs = (List)condition.src_prop_value;
                    if (filter.getProperty().equals(srcPropName)) {
                        Date[] dates = this.processMulDate(filter, dateformat, objs);
                        condition.src_prop_value = Arrays.asList(dates);
                        continue;
                    }
                    for (QFilter.QFilterNest qFilterNest : otherFilter) {
                        QFilter currentQFilter = qFilterNest.getFilter();
                        if (!currentQFilter.getProperty().equals(srcPropName)) continue;
                        Date[] dates = this.processMulDate(currentQFilter, dateformat, objs);
                        condition.src_prop_value = Arrays.asList(dates);
                    }
                }
            }
        } else {
            String text = ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u6e90\u5355\u548c\u76ee\u6807\u5355\u5b57\u6bb5\u5173\u7cfb", (String)"CustomizedRelationBillChecker_2", (String)"data-idi-core", (Object[])new Object[0]);
            throw new KDBizException(text);
        }
        QFilter notSrcFilter = new QFilter(this.targetType.getPrimaryKey().getName(), "!=", this.srcBillObj.get(this.targetType.getPrimaryKey().getName()));
        this.conditions.valueFilter = !this.srcType.getName().equalsIgnoreCase(this.targetType.getName()) ? filter : (filter == null ? notSrcFilter : filter.and(notSrcFilter));
    }

    private Date[] processMulDate(QFilter filter, DateFormat dateformat, List objs) {
        filter.__setCP("in");
        Date[] dates = new Date[objs.size()];
        for (int i = 0; i < dates.length; ++i) {
            String dateStr = dateformat.format((Date)objs.get(i));
            try {
                dates[i] = dateformat.parse(dateStr);
                continue;
            }
            catch (ParseException e) {
                throw new KDBizException(new ErrorCode("", e.getMessage()), new Object[]{String.format(ResManager.loadKDString((String)"%s\u4e0d\u662f\u6709\u6548\u7684\u5f53\u524d\u65f6\u533a\u65f6\u95f4\u683c\u5f0f", (String)"CustomizedRelationBillChecker_5", (String)"data-idi-core", (Object[])new Object[0]), dateStr)});
            }
        }
        filter.__setValue((Object)dates);
        return dates;
    }

    private Object getSrcPropValue(DynamicObject srcBillObj, String srcPropName) {
        ArrayList value = ExecutorHelper.getValueAndNameByName(srcBillObj, srcPropName, false, true).getValue();
        if (value instanceof List) {
            List valList = value;
            ArrayList newList = new ArrayList(valList.size());
            for (Object vObj : valList) {
                if (vObj != null) {
                    if (vObj instanceof String) {
                        if (StringUtils.isNotEmpty((String)((String)vObj))) {
                            newList.add(vObj);
                            continue;
                        }
                        newList.add("NULL_NULL_NULL");
                        continue;
                    }
                    newList.add(vObj);
                    continue;
                }
                newList.add("NULL_NULL_NULL");
            }
            value = newList;
        } else if (value instanceof String && StringUtils.isEmpty((String)((String)((Object)value)))) {
            value = "NULL_NULL_NULL";
        }
        return value;
    }

    private List<DynamicObject> findLinkObjects(DynamicObject[] targetBills, Conditions conditions, int srcEntryIndex) {
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>();
        if (this.billConfig.getCheckType() == LinkUpBillConfig.CheckType.CheckBillExists) {
            for (DynamicObject dynamicObject : targetBills) {
                objects.add(dynamicObject);
            }
            return objects;
        }
        if (conditions.headParams.isEmpty()) {
            Collections.addAll(objects, targetBills);
            return objects;
        }
        if (this.billConfig.getCheckType() == LinkUpBillConfig.CheckType.CheckBillContent) {
            for (DynamicObject dynamicObject : targetBills) {
                objects.add(dynamicObject);
            }
            return objects;
        }
        return objects;
    }

    private List<Integer> findLinkEntries(DynamicObject targetBill, Conditions conditions, int srcEntryIndex) {
        Object[] srcValues = new Object[conditions.entryParams.size()];
        Object[] targetValues = new Object[conditions.entryParams.size()];
        ArrayList<Integer> entryIndexList = new ArrayList<Integer>();
        DynamicObjectCollection entris = targetBill.getDynamicObjectCollection(conditions.link_entry_name);
        if (entris == null || entris.isEmpty()) {
            return entryIndexList;
        }
        int fieldIndex = 0;
        for (Condition condition : conditions.entryParams) {
            Object value = condition.src_prop_value;
            if (condition.isEntry_src_prop_name) {
                List objs = (List)value;
                value = objs.get(srcEntryIndex);
            }
            srcValues[fieldIndex] = value;
            targetValues[fieldIndex] = ExecutorHelper.getValueAndNameByName(targetBill, condition.link_prop_name, false, true).getValue();
            ++fieldIndex;
        }
        Object[] entryValues = new Object[conditions.entryParams.size()];
        int link_entry_size = entris.size();
        for (int entryIndex = 0; entryIndex < link_entry_size; ++entryIndex) {
            fieldIndex = 0;
            for (Condition condition : conditions.entryParams) {
                Object entryValue = targetValues[fieldIndex];
                if (condition.isEntry_link_pro_name) {
                    List objs = (List)entryValue;
                    entryValue = objs.get(entryIndex);
                }
                entryValues[fieldIndex] = entryValue;
                ++fieldIndex;
            }
            if (!this.objectArrayEquals(srcValues, entryValues)) continue;
            entryIndexList.add(entryIndex);
        }
        return entryIndexList;
    }

    private String getSelectors(Conditions conditions, Decision decision, String linkObjectType) {
        DecisionFrontEndConfig frontEndConfig;
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<String> propNameSet = new HashSet<String>();
        for (Condition condition : conditions.headParams) {
            if (propNameSet.contains(condition.link_prop_name)) continue;
            propNameSet.add(condition.link_prop_name);
            stringBuilder.append(condition.link_prop_name).append(',');
        }
        for (Condition condition : conditions.entryParams) {
            if (propNameSet.contains(condition.link_prop_name)) continue;
            propNameSet.add(condition.link_prop_name);
            stringBuilder.append(condition.link_prop_name).append(',');
        }
        boolean targetSelf = this.srcType.getName().equals(this.targetType.getName());
        linkObjectType = targetSelf ? "targetisself_" + linkObjectType + "_billObj." : linkObjectType + "_billObj.";
        List<DecisionRule> ruleList = decision.getRules();
        if (ruleList != null) {
            String[] stringArray;
            if (targetSelf) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = this.srcType.getName();
                stringArray = stringArray2;
                stringArray2[1] = "targetisself_" + this.targetType.getName();
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = this.srcType.getName();
                stringArray = stringArray3;
                stringArray3[1] = this.targetType.getName();
            }
            String[] billTypes = stringArray;
            for (DecisionRule decisionRule : ruleList) {
                String script;
                if (decisionRule.getRule() == null || !StringUtils.isNotEmpty((String)(script = decisionRule.getRule().getScript()))) continue;
                Set<String> vars = ScriptFormIdHandler.extractVariables(script, billTypes);
                for (String var : vars) {
                    String propName;
                    if (!var.startsWith(linkObjectType) || !StringUtils.isNotEmpty((String)(propName = var.substring(linkObjectType.length()))) || !propNameSet.add(propName)) continue;
                    stringBuilder.append(propName).append(',');
                }
            }
        }
        if ((frontEndConfig = decision.getFrontEndConfig()) != null && frontEndConfig.getHoverFieldContents() != null) {
            for (DecisionFrontEndConfigField field : frontEndConfig.getHoverFieldContents()) {
                if ("srcbill".equals(field.getBillType()) || !propNameSet.add(field.getPropName())) continue;
                stringBuilder.append(field.getPropName()).append(',');
            }
        }
        stringBuilder.append("id");
        return stringBuilder.toString();
    }

    private boolean paramExisted(List<Object[]> batchParams, Object[] param) {
        for (Object[] pArr : batchParams) {
            boolean allEq = true;
            for (int i = 0; i < pArr.length; ++i) {
                if (this.objectEquals(pArr[i], param[i])) continue;
                allEq = false;
                break;
            }
            if (!allEq) continue;
            return true;
        }
        return false;
    }

    private boolean objectArrayEquals(Object[] src, Object[] target) {
        boolean allEq = true;
        for (int i = 0; i < src.length; ++i) {
            if (this.objectEquals(src[i], target[i])) continue;
            allEq = false;
            break;
        }
        return allEq;
    }

    private boolean objectEquals(Object src, Object target) {
        if (src == null || target == null) {
            return false;
        }
        if (src instanceof OrmLocaleValue || target instanceof OrmLocaleValue) {
            String srcStr = this.toString(src);
            String targetSrc = this.toString(target);
            return srcStr.equals(targetSrc);
        }
        if (src instanceof BigDecimal || target instanceof BigDecimal) {
            BigDecimal targetBd;
            BigDecimal srcBd = this.toBigDecimal(src);
            return srcBd.compareTo(targetBd = this.toBigDecimal(target)) == 0;
        }
        return src.equals(target);
    }

    private BigDecimal toBigDecimal(Object obj) {
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        return new BigDecimal(obj.toString());
    }

    private String toString(Object objVal) {
        if (objVal instanceof OrmLocaleValue) {
            return ((OrmLocaleValue)objVal).getLocaleValue();
        }
        if (objVal instanceof String) {
            return (String)objVal;
        }
        return objVal.toString();
    }

    private Set<String> allEntryKey(MainEntityType mainType) {
        Map entityMap = mainType.getAllEntities();
        HashSet<String> entrySet = new HashSet<String>();
        entrySet.addAll(entityMap.keySet());
        entrySet.remove(mainType.getName());
        DataEntityPropertyCollection propertyCollection = mainType.getProperties();
        for (IDataEntityProperty prop : propertyCollection) {
            MulBasedataProp mulBasedataProp;
            if (!(prop instanceof MulBasedataProp) || (mulBasedataProp = (MulBasedataProp)prop).getParent() instanceof EntryType) continue;
            entrySet.add(prop.getName());
        }
        return entrySet;
    }

    public static class Conditions {
        private String src_entry_name = null;
        private String link_entry_name = null;
        private int src_entry_size = 0;
        private List<Condition> headParams = new ArrayList<Condition>();
        private List<Condition> entryParams = new ArrayList<Condition>();
        private QFilter valueFilter = null;

        public String getSrc_entry_name() {
            return this.src_entry_name;
        }

        public void setSrc_entry_name(String src_entry_name) {
            this.src_entry_name = src_entry_name;
        }

        public String getLink_entry_name() {
            return this.link_entry_name;
        }

        public void setLink_entry_name(String link_entry_name) {
            this.link_entry_name = link_entry_name;
        }

        public int getSrc_entry_size() {
            return this.src_entry_size;
        }

        public void setSrc_entry_size(int src_entry_size) {
            this.src_entry_size = src_entry_size;
        }
    }

    private static class Condition {
        private boolean isEntry_src_prop_name;
        private Object src_prop_value;
        private String link_prop_name;
        private boolean isEntry_link_pro_name;

        private Condition() {
        }
    }
}

