/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkDownNode;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.format.CurrencyFormatObject;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.format.NumberFormatObject;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.service.ctbotp.service.CtBillLkServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.HttpUtils;
import kd.bos.util.Pair;
import kd.bos.util.StringUtils;
import kd.data.idi.data.BillInfo;
import kd.data.idi.data.CustomizedRelationBillResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.LinkUpBillConfig;
import kd.data.idi.data.MulTenantBillInfo;
import kd.data.idi.data.Relation;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.decision.model.BillDecisionQueryParamApi;
import kd.data.idi.decision.model.CrossTenantInfo;
import kd.data.idi.decision.model.EntityDataQueryParamApi;
import kd.data.idi.engine.BillCheckResult;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.customrule.EntryRowRelationDTO;
import kd.data.idi.util.IDIDateUtils;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.SystemParamHelper;

public class ExecutorHelper {
    private static final Pattern dateTimePattern = Pattern.compile("^IDI_BETWEEN_([0-9|H]+)([MWY])$");

    static DynamicObject getSelfBill(SchemaContext context) {
        return context.getSelfBill();
    }

    public static List<DynamicObject> getBillBatch(String entityNumber, Set<Long> billIds, Set<String> selectors) {
        ArrayList<DynamicObject> billObjList = new ArrayList<DynamicObject>(billIds.size());
        for (Long id : billIds) {
            billObjList.add(ExecutorHelper.loadObject(id, entityNumber, selectors));
        }
        return billObjList;
    }

    public static Map<String, HashSet<Long>> getLinkUpBills(Long billId, String typeNumber) {
        return BFTrackerServiceHelper.findSourceBills((String)typeNumber, (Long[])new Long[]{billId});
    }

    public static Map<String, HashSet<Long>> loadLinkDownBillIds(Long billId, String billType) {
        return BFTrackerServiceHelper.findTargetBills((String)billType, (Long[])new Long[]{billId});
    }

    public static DynamicObject getBillCheckResultBillObj(String billType, BillCheckResult billCheckResult) {
        if (billType == null || billCheckResult == null) {
            return null;
        }
        return "srcbill".equals(billType) ? billCheckResult.getSrcObj() : billCheckResult.getLinkObj();
    }

    public static ValueAndName getValueAndNameByName(DynamicObject billObj, String propName, boolean toString) {
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)billObj.getDataEntityType().getName());
        return ExecutorHelper.getValueAndNameByName(billObj, (DynamicObjectType)billType, propName, toString, false);
    }

    public static ValueAndName getValueAndNameByName(DynamicObject billObj, DynamicObjectType billType, String propName, boolean toString) {
        return ExecutorHelper.getValueAndNameByName(billObj, billType, propName, toString, false);
    }

    public static ValueAndName getValueAndNameByName(DynamicObject billObj, String propName, boolean toString, boolean needNull) {
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)billObj.getDataEntityType().getName());
        return ExecutorHelper.getValueAndNameByName(billObj, (DynamicObjectType)billType, propName, toString, needNull);
    }

    public static ValueAndName getValueAndNameByName(DynamicObject billObj, DynamicObjectType billType, String propName, boolean toString, boolean needNull) {
        ValueAndName valueAndName = new ValueAndName();
        if (billObj == null || StringUtils.isEmpty((String)propName)) {
            return valueAndName;
        }
        String[] prop = propName.split("\\.");
        Object currentObj = billObj;
        List<Object> entryIds = new ArrayList<Object>(8);
        IDataEntityProperty entityProperty = null;
        String name = "";
        boolean isUser = false;
        Cloneable refValueObj = null;
        for (int i = 0; i < prop.length; ++i) {
            IDataEntityProperty userRefProp;
            Pair<Boolean, IDataEntityProperty> userPair;
            LinkedHashMap<Integer, ArrayList<Object>> entryIndexToSubRefDataMap;
            Pair<IDataEntityProperty, String> propPair;
            LinkedHashMap<Integer, List> entryIndexToSubDataMap;
            String s = prop[i];
            if (currentObj instanceof DynamicObject && billType.getProperties().containsKey((Object)s)) {
                entityProperty = (IDataEntityProperty)billType.getProperties().get((Object)s);
                name = name + (StringUtils.isEmpty((String)name) ? "" : ".") + entityProperty.getDisplayName();
                currentObj = currentObj.get(s);
                if (entityProperty instanceof BasedataProp) {
                    BasedataProp basedataProp = (BasedataProp)entityProperty;
                    billType = (DynamicObjectType)basedataProp.getComplexType();
                    if (!"bos_user".equals(basedataProp.getBaseEntityId())) continue;
                    isUser = true;
                    if (currentObj == null) continue;
                    refValueObj = currentObj.get("id");
                    continue;
                }
                if (!(entityProperty instanceof EntryProp) && !(entityProperty instanceof MulBasedataProp)) continue;
                billType = ((DynamicCollectionProperty)entityProperty).getDynamicCollectionItemPropertyType();
                continue;
            }
            if (currentObj instanceof DynamicObjectCollection) {
                DynamicObjectCollection entries = (DynamicObjectCollection)currentObj;
                if (entityProperty instanceof EntryProp) {
                    entryIds = entries.stream().map(dy -> dy == null ? null : dy.get("id")).collect(Collectors.toList());
                }
                List<Object> values = new ArrayList<Object>();
                if (CollectionUtils.isEmpty((Collection)entries)) {
                    currentObj = values;
                    break;
                }
                billType = ((DynamicObject)entries.get(0)).getDynamicObjectType();
                Pair<IDataEntityProperty, String> propPair2 = ExecutorHelper.processEntityProp(billType, s, name);
                entityProperty = (IDataEntityProperty)propPair2.getKey();
                name = (String)propPair2.getValue();
                ArrayList<Object> refValues = new ArrayList<Object>();
                Pair<Boolean, IDataEntityProperty> userPair2 = ExecutorHelper.processUserProp(i < prop.length - 1, entityProperty);
                isUser = (Boolean)userPair2.getKey();
                IDataEntityProperty userRefProp2 = (IDataEntityProperty)userPair2.getValue();
                if (s.equals(prop[prop.length - 1])) {
                    values = entries.stream().map(dy -> dy == null ? null : dy.get(s)).collect(Collectors.toList());
                    currentObj = values;
                    break;
                }
                DynamicObjectType dynamicObjectType = ExecutorHelper.processEntry(entries, entityProperty, s, isUser, userRefProp2, refValues, values, needNull);
                if (CollectionUtils.isNotEmpty(values)) {
                    if (entityProperty instanceof SubEntryProp) {
                        currentObj = values;
                        continue;
                    }
                    currentObj = new DynamicObjectCollection(dynamicObjectType, null);
                    for (Object value : values) {
                        ((DynamicObjectCollection)currentObj).add((Object)(value == null ? new DynamicObject(dynamicObjectType) : (DynamicObject)value));
                    }
                    refValueObj = refValues;
                    continue;
                }
                currentObj = values;
                break;
            }
            if (currentObj != null && List.class.isAssignableFrom(currentObj.getClass())) {
                DynamicObjectCollection subEntry;
                int entryIndex;
                List subEntryCols = (List)currentObj;
                entryIndexToSubDataMap = new LinkedHashMap<Integer, List>(subEntryCols.size());
                if (CollectionUtils.isEmpty((Collection)subEntryCols)) {
                    currentObj = entryIndexToSubDataMap;
                    break;
                }
                Optional<DynamicObjectCollection> firstSub = subEntryCols.stream().filter(Objects::nonNull).findFirst();
                if (!firstSub.isPresent()) {
                    currentObj = entryIndexToSubDataMap;
                    break;
                }
                billType = firstSub.get().getDynamicObjectType();
                propPair = ExecutorHelper.processEntityProp(billType, s, name);
                entityProperty = (IDataEntityProperty)propPair.getKey();
                name = (String)propPair.getValue();
                entryIndexToSubRefDataMap = new LinkedHashMap(subEntryCols.size());
                userPair = ExecutorHelper.processUserProp(i < prop.length - 1, entityProperty);
                isUser = (Boolean)userPair.getKey();
                userRefProp = (IDataEntityProperty)userPair.getValue();
                if (s.equals(prop[prop.length - 1])) {
                    for (entryIndex = 0; entryIndex < subEntryCols.size(); ++entryIndex) {
                        subEntry = (DynamicObjectCollection)subEntryCols.get(entryIndex);
                        if (subEntry == null) {
                            entryIndexToSubDataMap.put(entryIndex, null);
                            continue;
                        }
                        List subDataList = subEntry.stream().map(dy -> dy.get(s)).collect(Collectors.toList());
                        entryIndexToSubDataMap.put(entryIndex, subDataList);
                    }
                } else {
                    for (entryIndex = 0; entryIndex < subEntryCols.size(); ++entryIndex) {
                        subEntry = (DynamicObjectCollection)subEntryCols.get(entryIndex);
                        if (subEntry == null) {
                            entryIndexToSubDataMap.put(entryIndex, null);
                            entryIndexToSubRefDataMap.put(entryIndex, null);
                            continue;
                        }
                        ArrayList<Object> values = new ArrayList<Object>(subEntry.size());
                        entryIndexToSubDataMap.put(entryIndex, values);
                        ArrayList<Object> refValues = new ArrayList<Object>(subEntry.size());
                        entryIndexToSubRefDataMap.put(entryIndex, refValues);
                        ExecutorHelper.processEntry(subEntry, entityProperty, s, isUser, userRefProp, refValues, values, needNull);
                    }
                    refValueObj = entryIndexToSubRefDataMap;
                }
                currentObj = entryIndexToSubDataMap;
                continue;
            }
            if (currentObj != null && Map.class.isAssignableFrom(currentObj.getClass())) {
                List dataList;
                Integer entryIndex;
                Map subDataMap = (Map)currentObj;
                entryIndexToSubDataMap = new LinkedHashMap(subDataMap.size());
                if (subDataMap.isEmpty()) {
                    currentObj = entryIndexToSubDataMap;
                    break;
                }
                Optional<DynamicObject> notNullValue = ExecutorHelper.findFirstFromMap(subDataMap);
                if (!notNullValue.isPresent()) break;
                billType = notNullValue.get().getDynamicObjectType();
                propPair = ExecutorHelper.processEntityProp(billType, s, name);
                entityProperty = (IDataEntityProperty)propPair.getKey();
                name = (String)propPair.getValue();
                entryIndexToSubRefDataMap = new LinkedHashMap<Integer, ArrayList<Object>>(subDataMap.size());
                userPair = ExecutorHelper.processUserProp(i < prop.length - 1, entityProperty);
                isUser = (Boolean)userPair.getKey();
                userRefProp = (IDataEntityProperty)userPair.getValue();
                Set subDataSet = subDataMap.entrySet();
                if (s.equals(prop[prop.length - 1])) {
                    for (Map.Entry subDataEntry : subDataSet) {
                        entryIndex = (Integer)subDataEntry.getKey();
                        dataList = (List)subDataEntry.getValue();
                        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
                            ArrayList<Object> newDataList = new ArrayList<Object>(dataList.size());
                            for (Object o : dataList) {
                                if (o == null) {
                                    newDataList.add(null);
                                    continue;
                                }
                                newDataList.add(((DynamicObject)o).get(s));
                            }
                            entryIndexToSubDataMap.put(entryIndex, newDataList);
                            continue;
                        }
                        entryIndexToSubDataMap.put(entryIndex, dataList);
                    }
                    currentObj = entryIndexToSubDataMap;
                    break;
                }
                for (Map.Entry subDataEntry : subDataSet) {
                    entryIndex = (Integer)subDataEntry.getKey();
                    dataList = (List)subDataEntry.getValue();
                    if (CollectionUtils.isNotEmpty((Collection)dataList)) {
                        entryIndexToSubDataMap.put(entryIndex, null);
                        entryIndexToSubRefDataMap.put(entryIndex, null);
                        continue;
                    }
                    ArrayList<Object> values = new ArrayList<Object>(dataList.size());
                    entryIndexToSubDataMap.put(entryIndex, values);
                    ArrayList<Object> refValues = new ArrayList<Object>(dataList.size());
                    entryIndexToSubRefDataMap.put(entryIndex, refValues);
                    ExecutorHelper.processEntryByList(dataList, entityProperty, s, isUser, userRefProp, refValues, values, needNull);
                }
                refValueObj = entryIndexToSubRefDataMap;
                currentObj = entryIndexToSubDataMap;
                continue;
            }
            currentObj = null;
            break;
        }
        if (entityProperty != null && toString) {
            valueAndName.setEntityProperty(entityProperty);
        }
        valueAndName.setValue(currentObj);
        valueAndName.setName(name);
        valueAndName.setUser(isUser);
        valueAndName.setRefValue(refValueObj);
        valueAndName.setEntryIds(entryIds);
        return valueAndName;
    }

    private static Optional<DynamicObject> findFirstFromMap(Map<Integer, List<Object>> subDataMap) {
        for (List<Object> valueList : subDataMap.values()) {
            Optional<Object> notNullValue;
            if (!CollectionUtils.isNotEmpty(valueList) || !(notNullValue = valueList.stream().filter(Objects::nonNull).findFirst()).isPresent()) continue;
            return Optional.of((DynamicObject)notNullValue.get());
        }
        return Optional.empty();
    }

    private static Pair<IDataEntityProperty, String> processEntityProp(DynamicObjectType billType, String field, String fieldPrefix) {
        DynamicProperty entityProperty = billType.getProperty(field);
        String name = fieldPrefix + (StringUtils.isEmpty((String)fieldPrefix) ? "" : ".");
        LocaleString displayName = entityProperty.getDisplayName();
        if (displayName != null) {
            name = name + displayName;
        } else if (!name.isEmpty() && name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        return new Pair((Object)entityProperty, (Object)name);
    }

    private static Pair<Boolean, IDataEntityProperty> processUserProp(boolean isSupper, IDataEntityProperty entityProperty) {
        BasedataProp basedataProp;
        String entityNumber;
        Pair result = new Pair((Object)false, null);
        if (isSupper && entityProperty instanceof BasedataProp && "bos_user".equals(entityNumber = (basedataProp = (BasedataProp)entityProperty).getBaseEntityId())) {
            return new Pair((Object)true, (Object)basedataProp.getRefIdProp());
        }
        return result;
    }

    private static void processEntryByList(List<Object> entries, IDataEntityProperty entityProperty, String field, boolean isUser, IDataEntityProperty userRefProp, List<Object> refValues, List<Object> values, boolean needNull) {
        for (Object obj : entries) {
            ExecutorHelper.processEntryCore((DynamicObject)obj, entityProperty, field, isUser, userRefProp, refValues, values, needNull);
        }
    }

    private static DynamicObjectType processEntry(DynamicObjectCollection entries, IDataEntityProperty entityProperty, String field, boolean isUser, IDataEntityProperty userRefProp, List<Object> refValues, List<Object> values, boolean needNull) {
        DynamicObjectType dynamicObjectType = null;
        for (DynamicObject obj : entries) {
            dynamicObjectType = ExecutorHelper.processEntryCore(obj, entityProperty, field, isUser, userRefProp, refValues, values, needNull);
        }
        return dynamicObjectType;
    }

    private static DynamicObjectType processEntryCore(DynamicObject entryItem, IDataEntityProperty entityProperty, String field, boolean isUser, IDataEntityProperty userRefProp, List<Object> refValues, List<Object> values, boolean needNull) {
        DynamicObjectType dynamicObjectType = null;
        if (entityProperty instanceof SubEntryProp) {
            DynamicObjectCollection subObj = null;
            try {
                subObj = entryItem.getDynamicObjectCollection(field);
            }
            catch (ORMDesignException e) {
                SchemaExecutorLogger.error(e.getMessage());
            }
            values.add(subObj);
        } else {
            DynamicObject bdObj = null;
            try {
                bdObj = entryItem.getDynamicObject(field);
                BasedataProp basedataProp = (BasedataProp)entityProperty;
                dynamicObjectType = basedataProp.getDynamicComplexPropertyType();
            }
            catch (ORMDesignException e) {
                SchemaExecutorLogger.error(e.getMessage());
            }
            if (bdObj != null) {
                if (isUser) {
                    refValues.add(entryItem.get(userRefProp));
                }
                values.add(bdObj);
            } else if (needNull) {
                values.add(null);
                if (isUser) {
                    refValues.add(null);
                }
            }
        }
        return dynamicObjectType;
    }

    public static ValueAndName alarmGetValueAndNameByName(DynamicObject billObj, String propName, boolean toString) {
        return ExecutorHelper.getValueAndNameByName(billObj, propName, toString, true);
    }

    public static HoverContent getHoverContent(EntryRowRelationDTO relationDTO, String[] propNameSplit, BillCheckResult billCheckResult, DynamicObject billObj, int subEntryIndex, boolean entryProp, MainEntityType mainEntityType) {
        String srcEntryName = billCheckResult.getSrcEntryName();
        int srcEntryIndex = billCheckResult.getSrcEntryIndex();
        int linkEntryIndex = billCheckResult.getLinkEntryIndex();
        HoverContent valueHoverContent = null;
        boolean isUser = false;
        DynamicObject subObj = null;
        if (relationDTO.isTrueSubEntry()) {
            String targetEntryFlag = relationDTO.getTargetEntryFlag();
            int parentIndex = targetEntryFlag.equals(srcEntryName) ? linkEntryIndex : srcEntryIndex;
            int subIndex = targetEntryFlag.equals(srcEntryName) ? srcEntryIndex : linkEntryIndex;
            Map<Integer, DynamicObjectCollection> trueSubEntryCollectionMap = relationDTO.getTrueSubEntryCollectionMap();
            subObj = (DynamicObject)trueSubEntryCollectionMap.get(parentIndex).get(subIndex);
        } else if (!entryProp) {
            Map<String, DynamicObjectCollection> entryCollectionMap = relationDTO.getEntryCollectionMap();
            String subEntryNumber = propNameSplit[subEntryIndex];
            DynamicObjectCollection collection = entryCollectionMap.get(subEntryNumber);
            int index = srcEntryName.equals(subEntryNumber) ? srcEntryIndex : linkEntryIndex;
            subObj = (DynamicObject)collection.get(index);
        } else {
            Map<String, Map<Integer, Integer>> parentEntryIndexMap = relationDTO.getParentEntryIndexMap();
            String entryNumber = propNameSplit[0];
            String subEntryNumber = null;
            for (Map.Entry<String, String> entry : relationDTO.getSubParentEntryMap().entrySet()) {
                if (!entryNumber.equals(entry.getValue())) continue;
                subEntryNumber = entry.getKey();
            }
            if (subEntryNumber != null) {
                int index = srcEntryName.equals(subEntryNumber) ? srcEntryIndex : linkEntryIndex;
                Integer entryIndex = parentEntryIndexMap.get(entryNumber).get(index);
                if (entryIndex != null) {
                    subObj = (DynamicObject)billObj.getDynamicObjectCollection(entryNumber).get(entryIndex.intValue());
                }
            }
        }
        Map allFields = mainEntityType.getAllFields();
        IDataEntityProperty entityProperty = null;
        Object value = null;
        Object refValue = null;
        Object currentObj = subObj;
        Object refValueObj = null;
        for (int i = subEntryIndex + 1; i < propNameSplit.length; ++i) {
            BasedataProp basedataProp;
            String entityNumber;
            String s = propNameSplit[i];
            if (currentObj == null) break;
            DynamicObject obj = currentObj;
            entityProperty = (IDataEntityProperty)allFields.get(s);
            IDataEntityProperty userRefProp = null;
            if (i < propNameSplit.length - 1 && entityProperty instanceof BasedataProp && "bos_user".equals(entityNumber = (basedataProp = (BasedataProp)entityProperty).getBaseEntityId())) {
                isUser = true;
                userRefProp = basedataProp.getRefIdProp();
            }
            if (s.equals(propNameSplit[propNameSplit.length - 1])) {
                value = obj.get(s);
                currentObj = value;
                break;
            }
            DynamicObject bdObj = null;
            try {
                bdObj = obj.getDynamicObject(s);
            }
            catch (ORMDesignException e) {
                SchemaExecutorLogger.error(e.getMessage());
            }
            if (bdObj != null) {
                String entityTypeName = bdObj.getDataEntityType().getName();
                if ("bd_materialinventoryinfo".equals(entityTypeName) || "bd_materialmftinfo".equals(entityTypeName) || "bd_materialpurchaseinfo".equals(entityTypeName) || "bd_materialsalinfo".equals(entityTypeName)) {
                    bdObj = bdObj.getDynamicObject("masterid");
                }
                if (isUser && userRefProp != null) {
                    refValue = bdObj.get(userRefProp);
                }
                value = bdObj;
            }
            currentObj = value;
            refValueObj = refValue;
        }
        if (entityProperty != null) {
            currentObj = ExecutorHelper.tryToString(billObj, billObj, currentObj, entityProperty);
        }
        String valueString = currentObj == null ? "" : currentObj.toString();
        valueHoverContent = isUser ? HoverContent.createChat(valueString, refValueObj) : HoverContent.createText(valueString);
        return valueHoverContent;
    }

    public static Object getParentObjectIdByName(DynamicObject billObj, String propName) {
        if (billObj == null || StringUtils.isEmpty((String)propName)) {
            return null;
        }
        String[] prop = propName.split("\\.");
        Object currentObj = billObj;
        Object entityProperty = null;
        int len = prop.length - 1;
        for (int i = 0; i < len; ++i) {
            String s = prop[i];
            if (!(currentObj instanceof DynamicObject) || !currentObj.getDataEntityType().getProperties().containsKey((Object)s)) {
                currentObj = null;
                break;
            }
            currentObj = currentObj.get(s);
        }
        if (currentObj != null) {
            String s = prop[prop.length - 1];
            currentObj = currentObj instanceof DynamicObject && currentObj.getDataEntityType().getProperties().containsKey((Object)s) ? currentObj.getPkValue() : null;
        }
        return currentObj;
    }

    public static Object getValueByName(DynamicObject billObj, String propName, boolean toString) {
        if (billObj == null || StringUtils.isEmpty((String)propName)) {
            return null;
        }
        String[] prop = propName.split("\\.");
        return ExecutorHelper.innerGetValueByField(billObj, billObj, prop, 0, toString);
    }

    private static Object innerGetValueByField(DynamicObject mainBillObj, DynamicObject billObj, String[] props, int propIndex, boolean toString) {
        Object result = null;
        IDataEntityProperty property = null;
        if (billObj.getDataEntityType().getProperties().containsKey((Object)props[propIndex])) {
            property = (IDataEntityProperty)billObj.getDataEntityType().getProperties().get((Object)props[propIndex]);
            result = billObj.get(props[propIndex]);
        }
        if (propIndex < props.length - 1) {
            if (result instanceof DynamicObjectCollection) {
                ArrayList<Object> listResult = new ArrayList<Object>();
                DynamicObjectCollection collection = (DynamicObjectCollection)result;
                for (DynamicObject colItem : collection) {
                    Object colResult = ExecutorHelper.innerGetValueByField(mainBillObj, colItem, props, propIndex + 1, toString);
                    listResult.add(colResult);
                }
                return listResult;
            }
            if (result instanceof DynamicObject) {
                return ExecutorHelper.innerGetValueByField(mainBillObj, (DynamicObject)result, props, propIndex + 1, toString);
            }
            return null;
        }
        if (toString && property != null) {
            result = ExecutorHelper.tryToString(mainBillObj, billObj, result, property);
        }
        return result;
    }

    public static Object tryToString(DynamicObject mainBillObj, DynamicObject billObj, Object result, IDataEntityProperty property) {
        if (result == null) {
            return result;
        }
        if (result instanceof List) {
            List objs = (List)result;
            ArrayList<Object> newResult = new ArrayList<Object>(objs.size());
            for (Object obj : objs) {
                newResult.add(ExecutorHelper.tryToString(mainBillObj, billObj, obj, property));
            }
            return newResult;
        }
        if (result instanceof LinkedHashMap) {
            Map objMap = (Map)result;
            Set keyValueSet = objMap.entrySet();
            for (Map.Entry integerStringEntry : keyValueSet) {
                Integer key = (Integer)integerStringEntry.getKey();
                List valueList = (List)integerStringEntry.getValue();
                List newValueList = (List)ExecutorHelper.tryToString(mainBillObj, billObj, valueList, property);
                objMap.put(key, newValueList);
            }
            return objMap;
        }
        if (property instanceof DecimalProp) {
            DynamicObject controlProp;
            DecimalProp decimalProp = (DecimalProp)property;
            String controlPropName = decimalProp.getControlPropName();
            result = !StringUtils.isEmpty((String)controlPropName) && property instanceof AmountProp ? ((controlProp = ExecutorHelper.getControlProp(mainBillObj, decimalProp)) != null ? ExecutorHelper.currencyToString(result, controlProp) : ExecutorHelper.numberToString(result)) : ExecutorHelper.numberToString(result);
        } else if ((property instanceof DateProp || property instanceof DateTimeProp) && result instanceof Date) {
            result = KDDateFormatUtils.getDateFormat().format((Date)result);
        } else if (property instanceof BillStatusProp) {
            result = ((BillStatusProp)property).getItemByName(result.toString());
        } else if (property instanceof ComboProp) {
            result = ((ComboProp)property).getItemByName(result.toString());
        } else if (property instanceof MuliLangTextProp) {
            Object tempResult;
            result = tempResult = result instanceof OrmLocaleValue ? ((OrmLocaleValue)result).getLocaleValue() : result;
        } else if (property instanceof BooleanProp) {
            result = (Boolean)result != false ? ResManager.loadKDString((String)"\u662f", (String)"ScriptBuilder_4", (String)"data-idi-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ScriptBuilder_5", (String)"data-idi-core", (Object[])new Object[0]);
        }
        return result;
    }

    public static String currencyToString(Object result) {
        Format format = ExecutorHelper.getFormat(FormatTypes.Currency);
        if (format == null) {
            format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getCurrencyFormat("###,###,###", "\u00a5", 2);
        }
        return format.format(result);
    }

    public static String numberToString(Object result) {
        Format format = ExecutorHelper.getFormat(FormatTypes.Number);
        if (format == null) {
            format = FormatFactory.get((FormatTypes)FormatTypes.Number).getNumberFormat("###,###,###", 2, 3);
        }
        return format.format(result);
    }

    private static Format getFormat(FormatTypes type) {
        SchemaContext schemaContext = SchemaContext.get();
        FormatObject formatObject = null;
        if (schemaContext != null) {
            formatObject = schemaContext.getUserFormatObject();
        }
        Format format = null;
        if (formatObject != null) {
            format = FormatFactory.get((FormatTypes)type).getFormat(formatObject);
        }
        return format;
    }

    private static DynamicObject getControlProp(DynamicObject billObj, DecimalProp prop) {
        if (prop.getControlPropName() != null) {
            IDataEntityType dt = prop.getParent();
            DynamicObject controlProp = null;
            ArrayList<String> propList = new ArrayList<String>();
            if (dt instanceof SubEntryType) {
                propList.add(dt.getParent().getName() + "." + dt.getName() + "." + prop.getControlPropName());
                propList.add(dt.getParent().getName() + "." + prop.getControlPropName());
            } else if (dt instanceof EntryType) {
                propList.add(dt.getParent().getName() + "." + prop.getControlPropName());
            }
            propList.add(prop.getControlPropName());
            for (String propName : propList) {
                try {
                    controlProp = (DynamicObject)billObj.get(propName);
                }
                catch (OrmException e) {
                    SchemaExecutorLogger.error(e.getMessage());
                }
                if (controlProp == null) continue;
                break;
            }
            return controlProp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object currencyToString(Object value, DynamicObject currency) {
        String currencyNumber;
        String currencySymbols;
        String precisionField = "amtprecision";
        int minimumFractionDigits = 2;
        try {
            currencySymbols = currency.getString("sign");
            currencyNumber = currency.getString("number");
            minimumFractionDigits = currency.getInt(precisionField);
        }
        catch (KDException ignore) {
            currencyNumber = " ";
            currencySymbols = " ";
        }
        IFormat format = FormatFactory.get((FormatTypes)FormatTypes.Currency);
        SchemaContext schemaContext = SchemaContext.get();
        FormatObject fo = null;
        if (schemaContext != null) {
            fo = schemaContext.getUserFormatObject();
        }
        if (fo != null && fo.getCurrencyFormat() != null) {
            CurrencyFormatObject cfo = fo.getCurrencyFormat();
            String oldCurrencySymbols = cfo.getCurrencySymbols();
            String oldCurrencyNumber = cfo.getCurrencyNumber();
            int oldMinimumFractionDigits = cfo.getMinimumFractionDigits();
            try {
                cfo.setCurrencySymbols(currencySymbols);
                cfo.setCurrencyNumber(currencyNumber);
                cfo.setMinimumFractionDigits(minimumFractionDigits);
                String result = format.getFormat(fo).format(value);
                if (value instanceof BigDecimal) {
                    result = format.formatZeroPos(result, (BigDecimal)value, (NumberFormatObject)cfo);
                }
                String string = result;
                return string;
            }
            finally {
                cfo.setCurrencySymbols(oldCurrencySymbols);
                cfo.setCurrencyNumber(oldCurrencyNumber);
                cfo.setMinimumFractionDigits(oldMinimumFractionDigits);
            }
        }
        return format.getCurrencyFormat("###,###,###", currencySymbols, minimumFractionDigits).format(value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean parseDateTimeCondition(SimpleFilterRow filterRow) {
        DateFormat dateTimeFormat = KDDateFormatUtils.getDateTimeFormat();
        DateFormat dateFormat = KDDateFormatUtils.getDateFormat();
        boolean isDatetimeCondition = false;
        Matcher matcher = dateTimePattern.matcher(filterRow.getCompareType());
        if (matcher.matches()) {
            Date beginDate;
            Date theDate = new Date();
            filterRow.setCompareType(CompareTypeEnum.BETWEEN.getId());
            String d = matcher.group(1);
            String t = matcher.group(2);
            int dt = 1;
            if (!StringUtils.isEmpty((String)d)) {
                if ("H".equals(d)) {
                    dt = 6;
                    if (!"Y".equals(t)) {
                        String text = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u65e5\u671f\u671f\u95f4", (String)"ExecutorHelper_0", (String)"data-idi-core", (Object[])new Object[0]);
                        throw new KDBizException(text);
                    }
                    t = "M";
                } else {
                    try {
                        dt = Integer.parseInt(d);
                    }
                    catch (Throwable text) {
                        // empty catch block
                    }
                }
            }
            if ("M".equals(t)) {
                if (dt == 0) {
                    beginDate = IDIDateUtils.getTheMonthStartTime((Date)theDate);
                    theDate = IDIDateUtils.getTheMonthEndTime((Date)theDate);
                } else {
                    beginDate = KDDateUtils.addMonths((Date)theDate, (int)(-1 * dt));
                }
            } else if ("W".equals(t)) {
                beginDate = KDDateUtils.addWeeks((Date)theDate, (int)(-1 * dt));
            } else if ("Y".equals(t)) {
                if (dt == 0) {
                    beginDate = IDIDateUtils.getTheYearStartTime((Date)theDate);
                    theDate = IDIDateUtils.getTheYearEndTime((Date)theDate);
                } else {
                    beginDate = KDDateUtils.addYears((Date)theDate, (int)(-1 * dt));
                }
            } else {
                beginDate = KDDateUtils.addDays((Date)theDate, (int)-1);
            }
            ArrayList<FilterValue> fvList = new ArrayList<FilterValue>();
            FilterValue filterValue = new FilterValue();
            filterValue.setValue((Object)dateTimeFormat.format(beginDate));
            fvList.add(filterValue);
            filterValue = new FilterValue();
            filterValue.setValue((Object)dateTimeFormat.format(theDate));
            fvList.add(filterValue);
            filterRow.setValue(fvList);
            return true;
        }
        if (!CompareTypeEnum.TODAY.getId().equals(filterRow.getCompareType())) {
            if (!CompareTypeEnum.YESTERDAY.getId().equals(filterRow.getCompareType())) return isDatetimeCondition;
        }
        Date date = CompareTypeEnum.TODAY.getId().equals(filterRow.getCompareType()) ? KDDateUtils.today() : KDDateUtils.addDays((Date)new Date(), (int)-1);
        filterRow.setCompareType(CompareTypeEnum.EQUAL.getId());
        FilterValue filterValue = new FilterValue();
        filterValue.setValue((Object)dateTimeFormat.format(date));
        filterRow.setValue(Collections.singletonList(filterValue));
        return true;
    }

    static boolean parseFieldEqualCondition(SimpleFilterRow filterRow, DynamicObject srcBillObj) {
        boolean srcFieldValueIsNotEmpty = false;
        String srcPropName = (String)((FilterValue)filterRow.getValue().get(0)).getValue();
        ValueAndName valueAndName = ExecutorHelper.getValueAndNameByName(srcBillObj, srcPropName, false);
        if (valueAndName.getValue() != null) {
            Object val = valueAndName.getValue();
            if (val instanceof List) {
                List objList = (List)val;
                if (objList.size() > 0) {
                    HashSet valueSet = new HashSet(objList);
                    ArrayList<FilterValue> fvList = new ArrayList<FilterValue>(valueSet.size());
                    for (Object valObj : valueSet) {
                        FilterValue filterValue = new FilterValue();
                        filterValue.setValue((Object)(valObj instanceof OrmLocaleValue || valObj instanceof Number ? valObj.toString() : valObj));
                        fvList.add(filterValue);
                    }
                    filterRow.setCompareType(CompareTypeEnum.IN.getId());
                    filterRow.setValue(fvList);
                    srcFieldValueIsNotEmpty = true;
                }
            } else {
                filterRow.setCompareType(CompareTypeEnum.EQUAL.getId());
                FilterValue filterValue = new FilterValue();
                filterValue.setValue(val instanceof OrmLocaleValue || val instanceof Number || val instanceof Timestamp ? val.toString() : val);
                filterRow.setValue(Collections.singletonList(filterValue));
                srcFieldValueIsNotEmpty = true;
            }
        }
        return srcFieldValueIsNotEmpty;
    }

    public static Set<String> trimEntry(String entityTypeName, Set<String> varSet) {
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)entityTypeName);
        Map allEntities = EntityMetadataCache.getDataEntityType((String)entityTypeName).getAllEntities();
        if (varSet.isEmpty()) {
            varSet.add("id");
        }
        HashSet afterVarSet = Sets.newHashSetWithExpectedSize((int)varSet.size());
        for (String var : varSet) {
            String[] props = var.split("\\.");
            if (props.length > 2) {
                String firstPropStr = props[0];
                String secondPropStr = props[1];
                DynamicProperty firstProp = billType.getProperty(firstPropStr);
                if (!(firstProp instanceof MulBasedataProp) && firstProp instanceof DynamicCollectionProperty) {
                    Object secondProp = allEntities.get(secondPropStr);
                    var = secondProp instanceof SubEntryType ? var.substring(var.indexOf(secondPropStr) + secondPropStr.length() + 1) : var.substring(var.indexOf(firstPropStr) + firstPropStr.length() + 1);
                }
            }
            afterVarSet.add(var);
        }
        return afterVarSet;
    }

    public static Set<String> trimEntryAddSeq(String entityTypeName, Set<String> varSet) {
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)entityTypeName);
        Map allEntities = billType.getAllEntities();
        Map fieldMap = billType.getAllFields();
        if (varSet.isEmpty()) {
            varSet.add("id");
        }
        HashSet afterVarSet = Sets.newHashSetWithExpectedSize((int)varSet.size());
        for (String var : varSet) {
            String[] props = var.split("\\.");
            if (props.length > 2) {
                String firstPropStr = props[0];
                String secondPropStr = props[1];
                DynamicProperty firstProp = billType.getProperty(firstPropStr);
                if (!(firstProp instanceof MulBasedataProp) && firstProp instanceof DynamicCollectionProperty) {
                    Object secondProp = allEntities.get(secondPropStr);
                    if (secondProp instanceof SubEntryType) {
                        var = var.substring(var.indexOf(secondPropStr) + secondPropStr.length() + 1);
                    } else {
                        var = var.substring(var.indexOf(firstPropStr) + firstPropStr.length() + 1);
                        afterVarSet.add(firstPropStr + ".seq");
                    }
                }
            } else {
                IDataEntityType dataEntityType;
                String field = props[0];
                IDataEntityProperty fieldProp = (IDataEntityProperty)fieldMap.get(field);
                if (fieldProp != null && (dataEntityType = fieldProp.getParent()) != null && !dataEntityType.getName().equals(entityTypeName) && !(dataEntityType instanceof SubEntryType)) {
                    afterVarSet.add(dataEntityType.getName() + ".seq");
                }
            }
            afterVarSet.add(var);
        }
        return afterVarSet;
    }

    public static DynamicObject loadObject(Object pk, String entityName, Set<String> varSet) {
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityName, ExecutorHelper.trimEntryAddSeq(entityName, varSet));
        return BusinessDataReader.loadSingle((Object)pk, (DynamicObjectType)type, (int)0, (int)2000);
    }

    public static DynamicObject[] loadObjects(Object[] pks, String entityName, Set<String> varSet, int entryLimit) {
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityName, ExecutorHelper.trimEntryAddSeq(entityName, varSet));
        return BusinessDataReader.load((Object[])pks, (DynamicObjectType)type, (Boolean)Boolean.TRUE, (int)0, (int)entryLimit);
    }

    public static DynamicObject[] loadObjects(Object[] pks, String entityName, Set<String> varSet) {
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityName, ExecutorHelper.trimEntryAddSeq(entityName, varSet));
        DynamicObject[] objects = new DynamicObject[pks.length];
        int i = 0;
        for (Object pk : pks) {
            objects[i++] = BusinessDataReader.loadSingle((Object)pk, (DynamicObjectType)type, (int)0, (int)2000);
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String currencyToString(SchemaContext context, BigDecimal val, String num, String sign, int prec) {
        IFormat format = FormatFactory.get((FormatTypes)FormatTypes.Currency);
        FormatObject fo = context.getUserFormatObject();
        CurrencyFormatObject cfo = fo.getCurrencyFormat();
        String oldCurrencySymbols = cfo.getCurrencySymbols();
        String oldCurrencyNumber = cfo.getCurrencyNumber();
        int oldMinimumFractionDigits = cfo.getMinimumFractionDigits();
        try {
            cfo.setCurrencySymbols(sign);
            cfo.setCurrencyNumber(num == null ? " " : num);
            cfo.setMinimumFractionDigits(prec);
            String result = format.getFormat(fo).format(val);
            String string = result = format.formatZeroPos(result, val, (NumberFormatObject)cfo);
            return string;
        }
        finally {
            cfo.setCurrencySymbols(oldCurrencySymbols);
            cfo.setCurrencyNumber(oldCurrencyNumber);
            cfo.setMinimumFractionDigits(oldMinimumFractionDigits);
        }
    }

    public static List<DynamicProperty> getPropList(DynamicObjectType billType, String propName) {
        DynamicObjectType parentType = billType;
        String[] prop = propName.split("\\.");
        ArrayList<DynamicProperty> propList = new ArrayList<DynamicProperty>(prop.length);
        for (String propStr : prop) {
            DynamicProperty property = parentType.getProperty(propStr);
            if (property != null) {
                propList.add(property);
            }
            if (property instanceof MulBasedataProp) {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                parentType = (DynamicObjectType)mulBasedataProp.getComplexType();
                continue;
            }
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                parentType = (DynamicObjectType)basedataProp.getComplexType();
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            parentType = ((EntryProp)property).getDynamicCollectionItemPropertyType();
        }
        return propList;
    }

    static DynamicProperty getLastProp(DynamicObjectType billType, String propName) {
        List<DynamicProperty> propList = ExecutorHelper.getPropList(billType, propName);
        if (propList.isEmpty()) {
            return null;
        }
        return propList.get(propList.size() - 1);
    }

    static String getFullName(DynamicObjectType billType, String propName) {
        List<DynamicProperty> propList = ExecutorHelper.getPropList(billType, propName);
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicProperty property : propList) {
            stringBuilder.append(property.getDisplayName().getLocaleValue()).append('.');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static List<Map<String, Object>> buildMulBaseDataFilter(String entityNumber, EntityTypeUtil helper) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return ExecutorHelper.buildMulBaseDataFilter(entityType, helper);
    }

    public static List<Map<String, Object>> buildMulBaseDataFilter(MainEntityType entityType, EntityTypeUtil helper) {
        ArrayList<Map<String, Object>> resultMulBaseDataList = new ArrayList<Map<String, Object>>(4);
        List<CompareType> commonCompareTypes = ExecutorHelper.getMulBaseDataCompareType();
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (IDataEntityProperty entityProperty : properties) {
            RefEntityType refPropertyType;
            String extendName;
            MulBasedataProp mulBasedataProp;
            if (!(entityProperty instanceof MulBasedataProp) || (mulBasedataProp = (MulBasedataProp)entityProperty).getParent() instanceof EntryType || mulBasedataProp.getParent() instanceof SubEntryType) continue;
            BasedataProp refBaseProp = (BasedataProp)mulBasedataProp.getRefBaseProp();
            IDataEntityProperty prop = refBaseProp.getRefIdProp();
            if (prop instanceof IFieldHandle) {
                HashMap<String, Object> idColumn = new HashMap<String, Object>();
                idColumn.put("entryEntity", entityType.getName());
                idColumn.put("fieldName", entityProperty.getName() + '.' + prop.getName());
                idColumn.put("fieldCaption", mulBasedataProp.getDisplayName().toString());
                idColumn.put("compareGroupID", "9");
                idColumn.put("compareTypes", commonCompareTypes);
                idColumn.put("type", "text");
                idColumn.put("fieldType", -5);
                resultMulBaseDataList.add(idColumn);
            }
            if ((extendName = (refPropertyType = (RefEntityType)refBaseProp.getDynamicComplexPropertyType()).getExtendName()) == null || extendName.isEmpty()) continue;
            int prefixIndex = extendName.indexOf("[");
            int suffixIndex = extendName.indexOf("]");
            if (prefixIndex <= 0 || suffixIndex <= 0 || suffixIndex <= prefixIndex || extendName.length() <= prefixIndex + 1) continue;
            String entityKey = entityProperty.getName();
            String baseEntityId = mulBasedataProp.getBaseEntityId();
            String entityName = mulBasedataProp.getDisplayName().toString();
            extendName = extendName.substring(prefixIndex + 1, suffixIndex);
            Set refPropSet = Arrays.stream(extendName.split(",")).collect(Collectors.toSet());
            MainEntityType baseEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            List baseEntityFilterField = helper.getFilterFields((IDataEntityType)baseEntityType, false);
            Set<String> billHeadColumns = ExecutorHelper.getBillHeadColumns(baseEntityId);
            for (FilterField field : baseEntityFilterField) {
                String fieldName = field.getFieldName();
                if (!refPropSet.contains(fieldName) || !billHeadColumns.contains(fieldName)) continue;
                Map columnMap = field.createFilterColumn();
                columnMap.put("entryEntity", entityType.getName());
                columnMap.put("fieldName", entityKey + ".fbasedataid." + field.getFieldName());
                columnMap.put("fieldCaption", entityName + "." + field.getCaption().toString());
                columnMap.put("compareTypes", commonCompareTypes);
                resultMulBaseDataList.add(columnMap);
            }
        }
        return resultMulBaseDataList;
    }

    public static List<CompareType> getMulBaseDataCompareType() {
        List commonCompareTypes = EntityTypeUtil.setCompareTypes(Collections.emptyList(), (boolean)true, (boolean)true);
        Iterator compareTypeIterator = commonCompareTypes.iterator();
        while (compareTypeIterator.hasNext()) {
            CompareType next = (CompareType)compareTypeIterator.next();
            String compareTypeId = next.getId();
            if (compareTypeId.equals(CompareTypeEnum.FIELDEQUAL.getId()) || compareTypeId.equals(CompareTypeEnum.FIELDNOTEQUAL.getId())) continue;
            compareTypeIterator.remove();
        }
        return commonCompareTypes;
    }

    public static List<FilterField> getMulBaseDataFilterFiled(String entityNumber, EntityTypeUtil helper) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return ExecutorHelper.getMulBaseDataFilterFiled(entityType, helper);
    }

    public static List<FilterField> getMulBaseDataFilterFiled(MainEntityType entityType, EntityTypeUtil helper) {
        ArrayList<FilterField> resultList = new ArrayList<FilterField>(4);
        List<CompareType> commonCompareTypes = ExecutorHelper.getMulBaseDataCompareType();
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (IDataEntityProperty entityProperty : properties) {
            RefEntityType refPropertyType;
            String extendName;
            MulBasedataProp mulBasedataProp;
            if (!(entityProperty instanceof MulBasedataProp) || (mulBasedataProp = (MulBasedataProp)entityProperty).getParent() instanceof EntryType || mulBasedataProp.getParent() instanceof SubEntryType) continue;
            BasedataProp refBaseProp = (BasedataProp)mulBasedataProp.getRefBaseProp();
            IDataEntityProperty prop = refBaseProp.getRefIdProp();
            if (prop instanceof IFieldHandle) {
                FilterField idFilterField = new FilterField(entityType, (IDataEntityProperty)mulBasedataProp, null, null, null);
                idFilterField.setCaption(mulBasedataProp.getDisplayName());
                idFilterField.setFieldName(entityProperty.getName() + '.' + prop.getName());
                idFilterField.setFullFieldName(idFilterField.getFullFieldName() + "_id");
                idFilterField.setCompareGroupID("9");
                idFilterField.setCompareTypes(commonCompareTypes);
                idFilterField.setFieldType(-5);
                resultList.add(idFilterField);
            }
            if ((extendName = (refPropertyType = (RefEntityType)refBaseProp.getDynamicComplexPropertyType()).getExtendName()) == null || extendName.isEmpty()) continue;
            int prefixIndex = extendName.indexOf("[");
            int suffixIndex = extendName.indexOf("]");
            if (prefixIndex <= 0 || suffixIndex <= 0 || suffixIndex <= prefixIndex || extendName.length() <= prefixIndex + 1) continue;
            String entityKey = entityProperty.getName();
            String baseEntityId = mulBasedataProp.getBaseEntityId();
            String entityName = mulBasedataProp.getDisplayName().toString();
            extendName = extendName.substring(prefixIndex + 1, suffixIndex);
            Set refPropSet = Arrays.stream(extendName.split(",")).collect(Collectors.toSet());
            MainEntityType baseEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            List baseEntityFilterField = helper.getFilterFields((IDataEntityType)baseEntityType, false);
            Set<String> billHeadColumns = ExecutorHelper.getBillHeadColumns(baseEntityId);
            for (FilterField field : baseEntityFilterField) {
                String fieldName = field.getFieldName();
                if (!refPropSet.contains(fieldName) || !billHeadColumns.contains(fieldName)) continue;
                field.setFieldName(entityKey + ".fbasedataid." + field.getFieldName());
                field.setFullFieldName(entityKey + ".fbasedataid." + field.getFullFieldName());
                field.setCaption(new LocaleString(entityName + "." + field.getCaption().toString()));
                field.setCompareTypes(commonCompareTypes);
                resultList.add(field);
            }
        }
        return resultList;
    }

    public static Set<String> getBillHeadColumns(String entityNumber) {
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber), (PropTreeBuildOption)new PropTreeBuildOption());
        HashSet<String> billHeadColumnSet = new HashSet<String>(16);
        if (treeNode != null) {
            List children = treeNode.getChildren();
            for (TreeNode node : children) {
                if (!"billhead".equals(node.getId())) continue;
                ExecutorHelper.appendBillHeadColumn(billHeadColumnSet, node);
                break;
            }
        }
        return billHeadColumnSet;
    }

    public static void appendBillHeadColumn(Set<String> billHeadColumnSet, TreeNode node) {
        billHeadColumnSet.add(node.getId());
        List children = node.getChildren();
        if (children != null && !children.isEmpty()) {
            for (TreeNode child : children) {
                ExecutorHelper.appendBillHeadColumn(billHeadColumnSet, child);
            }
        }
    }

    public static Set<String> getMulBaseDataEntity(String entityNumber) {
        HashSet<String> mulBaseDataEntitySet = new HashSet<String>(1);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allFields = entityType.getAllFields();
        for (Map.Entry entry : allFields.entrySet()) {
            IDataEntityProperty entityProperty = (IDataEntityProperty)entry.getValue();
            if (!(entityProperty instanceof MulBasedataProp)) continue;
            mulBaseDataEntitySet.add(entityProperty.getName());
        }
        return mulBaseDataEntitySet;
    }

    public static CustomizedRelationBillResult getCustomizedRelationBillByCrossTenant(DynamicObject billObj, MulTenantBillInfo matchBill, Decision decision, LinkUpBillConfig linkUpBillConfig, SchemaContext context) {
        if (ParamFactory.getBotpInterface()) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("srcBillObjBase64Str", SerializationUtils.serializeToBase64((Object)billObj));
        params.put("billInfoJsonStr", SerializationUtils.toJsonString((Object)matchBill));
        params.put("decisionJsonStr", SerializationUtils.toJsonString((Object)decision));
        params.put("linkUpBillConfigJsonStr", SerializationUtils.toJsonString((Object)linkUpBillConfig));
        String paramsJson = SerializationUtils.toJsonString(params);
        CrossTenantInfo crossTenantInfo = new CrossTenantInfo();
        crossTenantInfo.setTenantId(matchBill.getTenantId());
        crossTenantInfo.setAccountId(matchBill.getAccountId());
        DynamicObject tenant = BusinessDataServiceHelper.loadSingle((String)"ctsy_tenant", (QFilter[])new QFilter[]{new QFilter("tenantid", "=", (Object)crossTenantInfo.getTenantId()), new QFilter("accountid", "=", (Object)crossTenantInfo.getAccountId())});
        StringBuilder openApiUrl = new StringBuilder();
        openApiUrl.append(tenant.getString("serverip")).append(":").append(tenant.getString("serverport")).append(tenant.getString("web_app"));
        String tokenUrlPrefix = openApiUrl.toString();
        openApiUrl.append("/kapi/v2/idi/CtCustom/customizedRelationBill");
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("Content-Type", "application/json");
        header.put("accesstoken", ExecutorHelper.getAccessToken(tokenUrlPrefix, crossTenantInfo, tenant.getString("user"), false));
        String respStr = HttpUtils.post((String)openApiUrl.toString(), header, (String)paramsJson);
        CustomApiResult apiResult = (CustomApiResult)IDIJSONUtils.cast((String)respStr, CustomApiResult.class);
        if (apiResult.isStatus()) {
            return (CustomizedRelationBillResult)SerializationUtils.deSerializeFromBase64((String)((String)apiResult.getData()));
        }
        return null;
    }

    public static CustomizedRelationBillResult getCustomizedRelationBillByCrossTenant(DynamicObject billObj, BillInfo matchBill, Decision decision, LinkUpBillConfig linkUpBillConfig, SchemaContext context) {
        CtBFRowId rowId;
        RequestContext rc = RequestContext.get();
        Map longCtBFRowLinkUpNodeMap = CtBillLkServiceHelper.loadBillLinkUpNodes((String)rc.getTenantCode(), (String)rc.getAccountId(), (String)context.getEntityType(), (Long[])new Long[]{billObj.getLong("id")}, (boolean)false);
        Map longCtBFRowLinkDownNodeMap = CtBillLkServiceHelper.loadBillLinkDownNodes((String)rc.getTenantCode(), (String)rc.getAccountId(), (String)context.getEntityType(), (Long[])new Long[]{billObj.getLong("id")}, (boolean)false);
        HashMap<String, String> tenantAccountIdMap = new HashMap<String, String>(4);
        CtBFRowLinkUpNode upNode = (CtBFRowLinkUpNode)longCtBFRowLinkUpNodeMap.get(billObj.getLong("id"));
        CtBFRowLinkDownNode downNode = (CtBFRowLinkDownNode)longCtBFRowLinkDownNodeMap.get(billObj.getLong("id"));
        if (upNode != null) {
            for (CtBFRowLinkUpNode sourceNode : upNode.findAllSourceNodes()) {
                rowId = sourceNode.getRowId();
                tenantAccountIdMap.put(rowId.getTenantId(), rowId.getAccountId());
            }
        }
        if (downNode != null) {
            for (CtBFRowLinkDownNode childNode : downNode.findAllChildNodes()) {
                rowId = childNode.getRowId();
                tenantAccountIdMap.put(rowId.getTenantId(), rowId.getAccountId());
            }
        }
        tenantAccountIdMap.remove(rc.getTenantCode());
        CustomizedRelationBillResult relationBillResult = null;
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("srcBillObjBase64Str", SerializationUtils.serializeToBase64((Object)billObj));
        params.put("billInfoJsonStr", SerializationUtils.toJsonString((Object)matchBill));
        params.put("decisionJsonStr", SerializationUtils.toJsonString((Object)decision));
        params.put("linkUpBillConfigJsonStr", SerializationUtils.toJsonString((Object)linkUpBillConfig));
        String paramsJson = SerializationUtils.toJsonString(params);
        for (Map.Entry tenantAccountIdEntry : tenantAccountIdMap.entrySet()) {
            CrossTenantInfo crossTenantInfo = new CrossTenantInfo();
            crossTenantInfo.setTenantId((String)tenantAccountIdEntry.getKey());
            crossTenantInfo.setAccountId((String)tenantAccountIdEntry.getValue());
            DynamicObject tenant = BusinessDataServiceHelper.loadSingle((String)"ctsy_tenant", (QFilter[])new QFilter[]{new QFilter("tenantid", "=", (Object)crossTenantInfo.getTenantId()), new QFilter("accountid", "=", (Object)crossTenantInfo.getAccountId())});
            StringBuilder openApiUrl = new StringBuilder();
            openApiUrl.append(tenant.getString("serverip")).append(":").append(tenant.getString("serverport")).append(tenant.getString("web_app"));
            String tokenUrlPrefix = openApiUrl.toString();
            openApiUrl.append("/kapi/v2/idi/CtCustom/customizedRelationBill");
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("Content-Type", "application/json");
            header.put("accesstoken", ExecutorHelper.getAccessToken(tokenUrlPrefix, crossTenantInfo, tenant.getString("user"), false));
            String respStr = HttpUtils.post((String)openApiUrl.toString(), header, (String)paramsJson);
            CustomApiResult apiResult = (CustomApiResult)IDIJSONUtils.cast((String)respStr, CustomApiResult.class);
            if (!apiResult.isStatus()) continue;
            CustomizedRelationBillResult temResult = (CustomizedRelationBillResult)SerializationUtils.deSerializeFromBase64((String)((String)apiResult.getData()));
            if (relationBillResult == null) {
                relationBillResult = temResult;
                continue;
            }
            relationBillResult.getBillLinkRelationList().addAll(temResult.getBillLinkRelationList());
            relationBillResult.setConditionSrcEntrySize(relationBillResult.getConditionSrcEntrySize() + temResult.getConditionSrcEntrySize());
        }
        return relationBillResult;
    }

    public static CrossTenantInfo loadBillLinkUpNodes(String entityType, Long billObjId, String matchBillType, Relation relation) {
        CrossTenantInfo crossTenantInfo = new CrossTenantInfo();
        RequestContext requestContext = RequestContext.get();
        if (Relation.BOTP == relation) {
            Map billLinkUpNodes = CtBillLkServiceHelper.loadBillLinkUpNodes((String)requestContext.getTenantCode(), (String)requestContext.getAccountId(), (String)entityType, (Long[])new Long[]{billObjId}, (boolean)false);
            if (billLinkUpNodes.get(billObjId) != null) {
                CtBFRowLinkUpNode ctBFRowLinkUpNode = (CtBFRowLinkUpNode)billLinkUpNodes.get(billObjId);
                List allSourceNodes = ctBFRowLinkUpNode.findAllSourceNodes();
                for (CtBFRowLinkUpNode node : allSourceNodes) {
                    CtBFRowId ctBFRowId = node.getRowId();
                    if (!matchBillType.equals(ctBFRowId.getMainEntityKey())) continue;
                    crossTenantInfo.setTenantId(ctBFRowId.getTenantId());
                    crossTenantInfo.setAccountId(ctBFRowId.getAccountId());
                    crossTenantInfo.addMatchBillIds(ctBFRowId.getBillId());
                }
            }
            return crossTenantInfo;
        }
        if (Relation.LINKDOWN == relation) {
            Map billLinkDownNodes = CtBillLkServiceHelper.loadBillLinkDownNodes((String)requestContext.getTenantCode(), (String)requestContext.getAccountId(), (String)entityType, (Long[])new Long[]{billObjId}, (boolean)false);
            if (billLinkDownNodes.get(billObjId) != null) {
                CtBFRowLinkDownNode ctBFRowLinkDownNode = (CtBFRowLinkDownNode)billLinkDownNodes.get(billObjId);
                List allChildNodes = ctBFRowLinkDownNode.findAllChildNodes();
                for (CtBFRowLinkDownNode node : allChildNodes) {
                    CtBFRowId ctBFRowId = node.getRowId();
                    if (!matchBillType.equals(ctBFRowId.getMainEntityKey())) continue;
                    crossTenantInfo.setTenantId(ctBFRowId.getTenantId());
                    crossTenantInfo.setAccountId(ctBFRowId.getAccountId());
                    crossTenantInfo.addMatchBillIds(ctBFRowId.getBillId());
                }
            }
            return crossTenantInfo;
        }
        return null;
    }

    public static List<DynamicObject> loadCrossTenantLinkBills(BillDecisionQueryParamApi param, CrossTenantInfo crossTenantInfo, boolean forceGetToken) {
        List linkBills;
        DynamicObject tenant = BusinessDataServiceHelper.loadSingle((String)"ctsy_tenant", (QFilter[])new QFilter[]{new QFilter("tenantid", "=", (Object)crossTenantInfo.getTenantId()), new QFilter("accountid", "=", (Object)crossTenantInfo.getAccountId())});
        StringBuilder openApiUrl = new StringBuilder();
        openApiUrl.append(tenant.getString("serverip")).append(":").append(tenant.getString("serverport")).append(tenant.getString("web_app"));
        String tokenUrlPrefix = openApiUrl.toString();
        openApiUrl.append("/kapi/v2/idi/getEntityDataApi");
        HashMap<String, String> header = new HashMap<String, String>(4);
        header.put("Content-Type", "application/json");
        header.put("accesstoken", ExecutorHelper.getAccessToken(tokenUrlPrefix, crossTenantInfo, tenant.getString("user"), forceGetToken));
        SchemaExecutorLogger.info("idi_getAccessToken urlPrefix : " + tokenUrlPrefix, new Object[0]);
        String post = HttpUtils.post((String)openApiUrl.toString(), header, (String)JSON.toJSONString((Object)param));
        CustomApiResult customApiResult = (CustomApiResult)JSON.parseObject((String)post, CustomApiResult.class);
        if (customApiResult.isStatus()) {
            SchemaExecutorLogger.info("customApiResult data :" + customApiResult.getData(), new Object[0]);
            if (customApiResult.getData() == null || StringUtils.isEmpty((String)customApiResult.getData().toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4efb\u4f55\u4e00\u5f20\u76ee\u6807\u5355\u3002", (String)"ExecutorHelper_1", (String)"data-idi-core", (Object[])new Object[0]));
            }
            linkBills = (List)SerializationUtils.deSerializeFromBase64((String)customApiResult.getData().toString());
        } else if (!forceGetToken && ("401".equals(customApiResult.getErrorCode()) || "403".equals(customApiResult.getErrorCode()))) {
            linkBills = ExecutorHelper.loadCrossTenantLinkBills(param, crossTenantInfo, true);
        } else {
            SchemaExecutorLogger.info(customApiResult.getMessage(), new Object[0]);
            throw new KDBizException(customApiResult.getMessage());
        }
        return linkBills;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAccessToken(String urlPrefix, CrossTenantInfo crossTenantInfo, String userName, boolean forceGetToken) {
        JSONObject postResultJson;
        LocalMemoryCache localMemoryCache = CacheManager.getLocalMemoryCache(6600);
        String key = "IDI_OPENAPI_ACCESS_TOKEN";
        String timeKey = "IDI_OPENAPI_TIME_OUT";
        String result = null;
        Object timeout = localMemoryCache.get(timeKey);
        if (!forceGetToken && localMemoryCache.get(key) != null && !ObjectUtils.isEmpty((Object)localMemoryCache.get(key))) {
            if (timeout == null) return localMemoryCache.get(key).toString();
            if (Long.parseLong(timeout.toString()) > System.currentTimeMillis()) return localMemoryCache.get(key).toString();
        }
        String appSecret = SystemParamHelper.getAccessTokenAppSecret();
        HashMap<String, String> param = new HashMap<String, String>(10);
        param.put("appId", "idi_corss_tenant");
        param.put("appSecret", appSecret);
        param.put("tenantid", crossTenantInfo.getTenantId());
        param.put("accountId", crossTenantInfo.getAccountId());
        SchemaExecutorLogger.info("IDI_GET_ACCESSTOKEN PARAM:" + JSON.toJSONString(param), new Object[0]);
        SchemaExecutorLogger.info("IDI_GET_ACCESSTOKEN urlPrefix:" + urlPrefix, new Object[0]);
        HashMap<String, String> header = new HashMap<String, String>(4);
        header.put("Content-Type", "application/json");
        String post = HttpUtils.post((String)(urlPrefix + "/api/getAppToken.do"), header, (String)JSON.toJSONString(param));
        JSONObject jsonObject = JSON.parseObject((String)post);
        if (jsonObject.getBooleanValue("status")) {
            HashMap<String, String> loginParam = new HashMap<String, String>(10);
            loginParam.put("user", userName);
            loginParam.put("usertype", "UserName");
            loginParam.put("apptoken", jsonObject.getJSONObject("data").getString("app_token"));
            loginParam.put("tenantid", crossTenantInfo.getTenantId());
            loginParam.put("accountId", crossTenantInfo.getAccountId());
            loginParam.put("language", "zh_CN");
            String postResult = HttpUtils.post((String)(urlPrefix + "/api/login.do"), header, (String)JSON.toJSONString(loginParam));
            postResultJson = JSON.parseObject((String)postResult);
            if (!postResultJson.getBooleanValue("status")) {
                SchemaExecutorLogger.info("IDI_GET_ACCESSTOKEN ERROR:" + postResultJson.getString("errorCode") + " : " + postResultJson.getString("message"), new Object[0]);
                throw new KDBizException(postResultJson.getString("message"));
            }
        } else {
            SchemaExecutorLogger.info("IDI_GET_ACCESSTOKEN ERROR:" + jsonObject.getString("errorCode") + " : " + jsonObject.getString("message"), new Object[0]);
            throw new KDBizException(jsonObject.getString("message"));
        }
        result = postResultJson.getJSONObject("data").getString("access_token");
        localMemoryCache.put(key, (Object)result);
        long timeOut = System.currentTimeMillis() + 6600000L;
        localMemoryCache.put(timeKey, (Object)timeOut);
        return result;
    }

    public static DynamicObjectCollection queryEntityDataByPage(EntityDataQueryParamApi entityDataQueryParamApi) {
        int limit = entityDataQueryParamApi.getLimit();
        List<Object> filterList = entityDataQueryParamApi.achieveFilter();
        if (filterList == null) {
            SchemaExecutorLogger.error("filterList is nulll. filterList:" + IDIJSONUtils.toJsonString(filterList));
            filterList = new ArrayList<QFilter>(10);
        } else {
            SchemaExecutorLogger.error("filterList has nulll element, filterList:" + IDIJSONUtils.toJsonString(filterList));
            filterList = filterList.stream().filter(f -> f != null).collect(Collectors.toList());
        }
        String entityNumber = entityDataQueryParamApi.getEntityNumber();
        entityNumber = entityNumber == null ? "" : entityNumber;
        String selectFields = entityDataQueryParamApi.getSelectors();
        selectFields = selectFields == null ? "" : selectFields;
        String orderByExpress = entityDataQueryParamApi.getOrderByExpress();
        String string = orderByExpress = orderByExpress == null ? "" : orderByExpress;
        if (limit == -1) {
            DynamicObject[] datas = BusinessDataServiceHelper.load((String)entityNumber, (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]), (String)orderByExpress);
            if (datas == null || datas.length <= 0) {
                return null;
            }
            return new DynamicObjectCollection(datas[0].getDynamicObjectType(), null, Arrays.asList(datas));
        }
        ORM orm = ORM.create();
        try (DataSet dataSet = orm.queryDataSet("queryEntityDataByPage", entityNumber, "id", filterList.toArray(new QFilter[0]), orderByExpress, entityDataQueryParamApi.getStart(), entityDataQueryParamApi.getLimit());){
            DynamicObjectCollection dynamicObjectCollection;
            DynamicObject[] datas;
            ArrayList<Object> idList = new ArrayList<Object>(10);
            if (dataSet != null) {
                for (Row row : dataSet) {
                    idList.add(row.get("id"));
                }
            }
            if ((datas = BusinessDataServiceHelper.load((String)entityNumber, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, (String)orderByExpress)) == null || datas.length <= 0) {
                dynamicObjectCollection = null;
                return dynamicObjectCollection;
            }
            dynamicObjectCollection = new DynamicObjectCollection(datas[0].getDynamicObjectType(), null, Arrays.asList(datas));
            return dynamicObjectCollection;
        }
    }

    public static DynamicObjectCollection loadCrossTenantEntityData(DynamicObject tenant, EntityDataQueryParamApi param, boolean forceGetToken) {
        DynamicObjectCollection result;
        StringBuilder openApiUrl = new StringBuilder();
        openApiUrl.append(tenant.getString("serverip")).append(":").append(tenant.getString("serverport")).append(tenant.getString("web_app"));
        String tokenUrlPrefix = openApiUrl.toString();
        openApiUrl.append("/kapi/v2/idi/queryEntityDataByPageApi");
        HashMap<String, String> header = new HashMap<String, String>(4);
        header.put("Content-Type", "application/json");
        CrossTenantInfo crossTenantInfo = new CrossTenantInfo();
        crossTenantInfo.setTenantId(tenant.getString("tenantid"));
        crossTenantInfo.setAccountId(tenant.getString("accountid"));
        header.put("accesstoken", ExecutorHelper.getAccessToken(tokenUrlPrefix, crossTenantInfo, tenant.getString("user"), forceGetToken));
        SchemaExecutorLogger.info("idi_getAccessToken urlPrefix : " + tokenUrlPrefix, new Object[0]);
        String post = HttpUtils.post((String)openApiUrl.toString(), header, (String)JSON.toJSONString((Object)param));
        CustomApiResult customApiResult = (CustomApiResult)JSON.parseObject((String)post, CustomApiResult.class);
        if (customApiResult.isStatus()) {
            SchemaExecutorLogger.info("customApiResult \"queryEntityDataByPageApi\" data :" + customApiResult.getData(), new Object[0]);
            if (customApiResult.getData() == null || StringUtils.isEmpty((String)customApiResult.getData().toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4efb\u4f55\u6570\u636e\u3002", (String)"ExecutorHelper_2", (String)"data-idi-core", (Object[])new Object[0]));
            }
            result = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)customApiResult.getData().toString());
        } else if (!forceGetToken && ("401".equals(customApiResult.getErrorCode()) || "403".equals(customApiResult.getErrorCode()))) {
            result = ExecutorHelper.loadCrossTenantEntityData(tenant, param, true);
        } else {
            SchemaExecutorLogger.error(customApiResult.getMessage());
            throw new KDBizException(customApiResult.getMessage());
        }
        return result;
    }

    public static MainEntityType loadCrossTenantEntityType(DynamicObject tenant, String entityNumber, boolean forceGetToken) {
        MainEntityType result;
        StringBuilder openApiUrl = new StringBuilder();
        openApiUrl.append(tenant.getString("serverip")).append(":").append(tenant.getString("serverport")).append(tenant.getString("web_app"));
        String tokenUrlPrefix = openApiUrl.toString();
        openApiUrl.append("/kapi/v2/idi/getEntityMainTypeApi");
        HashMap<String, String> header = new HashMap<String, String>(4);
        header.put("Content-Type", "application/json");
        CrossTenantInfo crossTenantInfo = new CrossTenantInfo();
        crossTenantInfo.setTenantId(tenant.getString("tenantid"));
        crossTenantInfo.setAccountId(tenant.getString("accountid"));
        header.put("accesstoken", ExecutorHelper.getAccessToken(tokenUrlPrefix, crossTenantInfo, tenant.getString("user"), forceGetToken));
        SchemaExecutorLogger.info("idi_getAccessToken urlPrefix : " + tokenUrlPrefix, new Object[0]);
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("entityNumber", entityNumber);
        String post = HttpUtils.post((String)openApiUrl.toString(), header, (String)JSON.toJSONString(param));
        CustomApiResult customApiResult = (CustomApiResult)JSON.parseObject((String)post, CustomApiResult.class);
        if (customApiResult.isStatus()) {
            SchemaExecutorLogger.info("customApiResult \"getEntityMainTypeApi\" data :" + customApiResult.getData(), new Object[0]);
            if (customApiResult.getData() == null || StringUtils.isEmpty((String)customApiResult.getData().toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4efb\u4f55\u6570\u636e\u3002", (String)"ExecutorHelper_2", (String)"data-idi-core", (Object[])new Object[0]));
            }
            result = (MainEntityType)SerializationUtils.deSerializeFromBase64((String)customApiResult.getData().toString());
        } else if (!forceGetToken && ("401".equals(customApiResult.getErrorCode()) || "403".equals(customApiResult.getErrorCode()))) {
            result = ExecutorHelper.loadCrossTenantEntityType(tenant, entityNumber, true);
        } else {
            SchemaExecutorLogger.error(customApiResult.getMessage());
            throw new KDBizException(customApiResult.getMessage());
        }
        return result;
    }

    public static class ValueAndName {
        private Object value = null;
        private String name = null;
        private boolean isUser = false;
        private Object refValue = null;
        private List<Object> entryIds;
        private IDataEntityProperty entityProperty;

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isUser() {
            return this.isUser;
        }

        public void setUser(boolean isUser) {
            this.isUser = isUser;
        }

        public Object getRefValue() {
            return this.refValue;
        }

        public void setRefValue(Object refValue) {
            this.refValue = refValue;
        }

        public List<Object> getEntryIds() {
            return this.entryIds;
        }

        public void setEntryIds(List<Object> entryIds) {
            this.entryIds = entryIds;
        }

        public IDataEntityProperty getEntityProperty() {
            return this.entityProperty;
        }

        public void setEntityProperty(IDataEntityProperty entityProperty) {
            this.entityProperty = entityProperty;
        }
    }
}

