/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.data.idi.data.BillInfo;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.TableDataResult;
import kd.data.idi.data.TimeLine;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SelectDecisionExecutor;

public class FutureExecutor
extends SelectDecisionExecutor
implements DecisionExecutor {
    /*
     * WARNING - void declaration
     */
    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        BillInfo matchBill;
        SelectDecisionExecutor.StartConditionParam param;
        TimeLine timeLine = decision.getTimeLine();
        if (timeLine == null) {
            return null;
        }
        IDICondition startCondition = decision.getStartCondition();
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript()) && !this.checkStartCondition(param = new SelectDecisionExecutor.StartConditionParam(context.getSelfBill(), context.getSrcEntityType(), startCondition, false))) {
            DecisionResult result = new DecisionResult();
            result.setStatus("empty");
            result.setDecision(decision);
            result.setShowText(String.format(ResManager.loadKDString((String)"%s : \u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"GeneralLedgerExecutor_7", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()));
            return result;
        }
        DynamicObject billObj = null;
        Map<String, HashSet<Long>> linkUpBillIds = ExecutorHelper.getLinkUpBills((Long)context.getBillId(), context.getEntityType());
        HashSet<Long> matchBillIds = linkUpBillIds.get((matchBill = decision.getMatchBill()).getEntityNumber());
        if (matchBillIds != null && matchBillIds.size() > 0) {
            Long billId = matchBillIds.iterator().next();
            HashSet<String> propSet = new HashSet<String>();
            timeLine.extractProperties(propSet, matchBill.getEntityNumber());
            billObj = ExecutorHelper.loadObject(billId, matchBill.getEntityNumber(), propSet);
        }
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setDecision(decision);
        if (billObj != null) {
            String valueStr;
            String content;
            Object itemValue;
            int i;
            ArrayList<HoverContent> fieldValueList;
            List refValueList;
            Object value;
            IDataEntityProperty entityProperty;
            ExecutorHelper.ValueAndName valueAndName;
            TableDataResult tableDataResult = new TableDataResult();
            tableDataResult.setTitle(decision.getName());
            decisionResult.setTableDataResult(tableDataResult);
            ArrayList<List<HoverContent>> billData = new ArrayList<List<HoverContent>>();
            List<HoverContent> remarkData = null;
            int maxRow = 0;
            for (String field : timeLine.getRowFields()) {
                valueAndName = ExecutorHelper.getValueAndNameByName(billObj, field, true);
                entityProperty = valueAndName.getEntityProperty();
                value = valueAndName.getValue();
                if (value instanceof List) {
                    List list = (List)value;
                    refValueList = (List)valueAndName.getRefValue();
                    fieldValueList = new ArrayList<HoverContent>(list.size());
                    for (i = 0; i < list.size(); ++i) {
                        itemValue = list.get(i);
                        Object formatValue2 = ExecutorHelper.tryToString(billObj, billObj, itemValue, entityProperty);
                        content = formatValue2 == null ? " " : formatValue2.toString();
                        fieldValueList.add(valueAndName.isUser() ? HoverContent.createChat(content, refValueList.get(i)) : HoverContent.createText(content));
                    }
                    billData.add(fieldValueList);
                    if (list.size() <= maxRow) continue;
                    maxRow = list.size();
                    continue;
                }
                Object object = ExecutorHelper.tryToString(billObj, billObj, value, entityProperty);
                valueStr = object == null ? " " : object.toString();
                billData.add(Collections.singletonList(valueAndName.isUser() ? HoverContent.createChat(valueStr, valueAndName.getRefValue()) : HoverContent.createText(valueStr)));
                if (true <= maxRow) continue;
                maxRow = 1;
            }
            BillEntityType billEntityType = (BillEntityType)billObj.getDataEntityType();
            if (StringUtils.isNotEmpty((String)timeLine.getRemark())) {
                boolean isBillNo = timeLine.getRemark().equalsIgnoreCase(billEntityType.getBillNo());
                valueAndName = ExecutorHelper.getValueAndNameByName(billObj, timeLine.getRemark(), true);
                entityProperty = valueAndName.getEntityProperty();
                value = valueAndName.getValue();
                if (value instanceof List) {
                    List list = (List)value;
                    refValueList = (List)valueAndName.getRefValue();
                    fieldValueList = new ArrayList(list.size());
                    for (i = 0; i < list.size(); ++i) {
                        itemValue = list.get(i);
                        Object formatValue = ExecutorHelper.tryToString(billObj, billObj, itemValue, entityProperty);
                        String string = content = formatValue == null ? " " : formatValue.toString();
                        fieldValueList.add(valueAndName.isUser() ? HoverContent.createChat(content, refValueList.get(i)) : (isBillNo ? HoverContent.createHref(content, billObj) : HoverContent.createText(content)));
                    }
                    remarkData = fieldValueList;
                } else {
                    Object object = ExecutorHelper.tryToString(billObj, billObj, value, entityProperty);
                    String string = valueStr = object == null ? " " : object.toString();
                    remarkData = Collections.singletonList(valueAndName.isUser() ? HoverContent.createChat(valueStr, valueAndName.getRefValue()) : (isBillNo ? HoverContent.createHref(valueStr, billObj) : HoverContent.createText(valueStr)));
                }
                if (remarkData.size() > maxRow) {
                    maxRow = remarkData.size();
                }
            }
            for (int i2 = 0; i2 < maxRow; ++i2) {
                void var16_32;
                HoverContent val;
                ArrayList<HoverContent> rowData = new ArrayList<HoverContent>(billData.size());
                int notEmptyCount = 0;
                for (List list : billData) {
                    HoverContent s;
                    HoverContent val2;
                    HoverContent hoverContent = val2 = list.size() > i2 ? (HoverContent)list.get(i2) : null;
                    if (val2 == null) {
                        s = HoverContent.createText(" ");
                    } else {
                        ++notEmptyCount;
                        s = val2;
                    }
                    rowData.add(s);
                }
                if (notEmptyCount == 0) continue;
                tableDataResult.addData(rowData);
                HoverContent hoverContent = val = remarkData != null && remarkData.size() > i2 ? (HoverContent)remarkData.get(i2) : null;
                if (val == null) {
                    HoverContent hoverContent2 = HoverContent.createText(" ");
                } else {
                    HoverContent hoverContent3 = val;
                }
                tableDataResult.addPopover((HoverContent)var16_32);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u672a\u627e\u5230", (String)"FutureExecutor_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        return decisionResult;
    }
}

