/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;
import kd.data.idi.api.external.impl.CompanyApiAbutmentImpl;
import kd.data.idi.api.external.impl.CompanyParam;
import kd.data.idi.api.external.impl.UrlParam;
import kd.data.idi.data.Company;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.News;
import kd.data.idi.data.NewsConfig;
import kd.data.idi.data.NewsInfo;
import kd.data.idi.data.NewsResult;
import kd.data.idi.data.NewsType;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.show.BusinessCatalogs;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.SelectDecisionExecutor;
import kd.data.idi.util.IDIDisclaimerUtil;
import kd.data.idi.util.IDIHttpUtils;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.MetadataUtil;

public class NewsExecutor
extends SelectDecisionExecutor
implements DecisionExecutor {
    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        IDICondition startCondition = decision.getStartCondition();
        int matchEntryIndex = 0;
        String startConditionEntry = null;
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript())) {
            SelectDecisionExecutor.StartConditionParam param = new SelectDecisionExecutor.StartConditionParam(context.getSelfBill(), context.getSrcEntityType(), startCondition, true);
            if (!this.checkStartCondition(param)) {
                DecisionResult result = new DecisionResult();
                result.setStatus("empty");
                result.setDecision(decision);
                result.setShowText(String.format(ResManager.loadKDString((String)"%s : \u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"GeneralLedgerExecutor_7", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()));
                return result;
            }
            startConditionEntry = param.getStartEntry();
            if (StringUtils.isNotEmpty((String)startConditionEntry)) {
                matchEntryIndex = param.getMatchEntryIndexList().get(0);
            }
        }
        if (!IDIDisclaimerUtil.disclaimerStatus()) {
            DecisionResult decisionResult = new DecisionResult();
            decisionResult.setShowText(ResManager.loadKDString((String)"\u56e0\u4e3a\u6570\u636e\u5b89\u5168\u95ee\u9898\uff0c\u529f\u80fd\u6682\u65f6\u5173\u95ed\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u91cd\u65b0\u542f\u7528\u68c0\u67e5\u9879\u7c7b\u578b\u4e3a\u201c\u65b0\u95fb\u7c7b\u201d\u7684\u68c0\u67e5\u9879\uff0c\u5982\u5df2\u542f\u7528\u5219\u9700\u5148\u7981\u7528\u518d\u542f\u7528\u3002", (String)"NewsExecutor_6", (String)"data-idi-core", (Object[])new Object[0]));
            decisionResult.setStatus("warnning");
            decisionResult.setDecision(decision);
            return decisionResult;
        }
        NewsConfig newsConfig = decision.getNews();
        if (newsConfig == null) {
            SchemaExecutorLogger.info("newsConfig is empty", new Object[0]);
            return null;
        }
        List<NewsInfo> urlList = newsConfig.getNewsType();
        if (urlList == null || urlList.isEmpty()) {
            return null;
        }
        String newsUrl = this.findUrlByType(urlList, NewsType.NEWS.getType());
        String companyUrl = this.findUrlByType(urlList, NewsType.BUSINFO.getType());
        String keyword = this.getKeyword(context, newsConfig.getFiledName(), startConditionEntry, matchEntryIndex);
        if (StringUtils.isEmpty((String)keyword)) {
            SchemaExecutorLogger.info("keyword is empty", new Object[0]);
            throw new KDBizException(ResManager.loadKDString((String)"\u5173\u952e\u8bcd\u5b57\u6bb5\u503c\u4e3a\u7a7a", (String)"NewsExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        String keyContent = IDIJSONUtils.toJsonString((Object)newsConfig).hashCode() + keyword;
        HashFunction hf = Hashing.murmur3_32((int)0);
        String cacheKey = hf.hashString((CharSequence)keyContent, Charsets.UTF_8).toString();
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setDecision(decision);
        String cacheJson = CacheManager.get("news", cacheKey);
        SchemaExecutorLogger.info("news cache:" + cacheJson, new Object[0]);
        if (StringUtils.isNotEmpty((String)cacheJson)) {
            NewsResult newsResult = (NewsResult)IDIJSONUtils.cast((String)cacheJson, NewsResult.class);
            if (StringUtils.isEmpty((String)newsUrl)) {
                newsResult.setNewsList(null);
            }
            if (StringUtils.isEmpty((String)companyUrl)) {
                newsResult.setCompanyList(null);
            }
            this.checkNewsList(newsConfig, newsResult);
            decisionResult.setNewsResult(newsResult);
            return decisionResult;
        }
        NewsResult newsResult = new NewsResult();
        if (!StringUtils.isEmpty((String)newsUrl)) {
            newsResult.setNewsList(this.getNews(newsUrl, keyword));
        }
        if (!StringUtils.isEmpty((String)companyUrl)) {
            newsResult.setCompanyList(this.getCompany(companyUrl, keyword, newsConfig.getBusinessCatalogs()));
        }
        if (newsResult.getCompanyList() != null && !newsResult.getCompanyList().isEmpty() && newsResult.getNewsList() != null && !newsResult.getNewsList().isEmpty()) {
            CacheManager.put("news", cacheKey, IDIJSONUtils.toJsonString((Object)newsResult));
        }
        this.checkNewsList(newsConfig, newsResult);
        decisionResult.setNewsResult(newsResult);
        return decisionResult;
    }

    private void checkNewsList(NewsConfig newsConfig, NewsResult newsResult) {
        List<News> newsList = newsResult.getNewsList();
        if (newsList == null || newsList.isEmpty()) {
            return;
        }
        String countStr = this.findNewsCountByType(newsConfig.getNewsType(), NewsType.NEWS.getType());
        int count = 2;
        if (StringUtils.isNumericString((String)countStr)) {
            try {
                count = Integer.parseInt(countStr);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (newsList.size() > count) {
            newsList = newsList.subList(0, count);
        }
        newsResult.setNewsList(newsList);
    }

    private String findNewsCountByType(List<NewsInfo> urlList, String newsType) {
        for (NewsInfo e : urlList) {
            if (!newsType.equals(e.getNewsType())) continue;
            return e.getNewsCount();
        }
        return "2";
    }

    private String getKeyword(SchemaContext context, String fieldName, String startConditionEntry, int matchEntryIndex) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        DynamicObject billObj = ExecutorHelper.getSelfBill(context);
        Object fieldValue = ExecutorHelper.getValueAndNameByName(billObj, fieldName, false).getValue();
        if (fieldValue == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5173\u952e\u8bcd\u5b57\u6bb5\u503c\u4e3a\u7a7a", (String)"NewsExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        if (fieldValue instanceof List) {
            List objs;
            Map<String, String> entryInfoMap = MetadataUtil.getEntryMapByScriptStr(context.getSrcEntityType(), fieldName);
            String fieldEntry = entryInfoMap.get("entryKey");
            int fieldEntryIndex = fieldEntry.equals(startConditionEntry) ? matchEntryIndex : 0;
            if (fieldEntryIndex >= (objs = (List)fieldValue).size()) {
                SchemaExecutorLogger.info("index of start condition entry large than index of key word entry", new Object[0]);
                fieldValue = null;
            } else {
                Object object = fieldValue = objs.size() > 0 ? objs.get(fieldEntryIndex).toString() : null;
            }
        }
        if (fieldValue != null) {
            if (fieldValue instanceof DynamicObject) {
                return ((DynamicObject)fieldValue).getString("name");
            }
            return fieldValue.toString();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5173\u952e\u8bcd\u5b57\u6bb5\u503c\u4e3a\u7a7a", (String)"NewsExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
    }

    private String findUrlByType(List<NewsInfo> urlList, String newsType) {
        boolean hasConfig = false;
        String matchUrl = null;
        for (NewsInfo e : urlList) {
            if (!newsType.equals(e.getNewsType())) continue;
            hasConfig = true;
            if (!StringUtils.isNotEmpty((String)e.getUrl()) || !StringUtils.isEmpty((String)matchUrl)) continue;
            matchUrl = e.getUrl();
        }
        if (hasConfig) {
            if (StringUtils.isEmpty(matchUrl)) {
                matchUrl = ParamFactory.getString(newsType + "_url");
            }
            return matchUrl;
        }
        return null;
    }

    private List<News> getNews(String url, String keyword) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("keyWord", keyword);
        params.put("cls.label", Arrays.asList(0, 1));
        params.put("sa", Arrays.asList(0, 1, 2));
        this.putTenantInfo(params);
        try {
            String paramJson = IDIJSONUtils.toJsonString(params);
            SchemaExecutorLogger.info("getNews params: " + paramJson, new Object[0]);
            long start = System.currentTimeMillis();
            int timeOut = ParamFactory.getTimeOut();
            int readOut = ParamFactory.getReadTimeOut();
            String resp = IDIHttpUtils.sendHttpRequestByPost((String)url, (String)JSONObject.toJSONString(params), (int)timeOut, (int)readOut);
            long end = System.currentTimeMillis();
            SchemaExecutorLogger.info(String.format("getNews takes time: %sms", end - start), new Object[0]);
            SchemaExecutorLogger.info("getNews resp: " + resp, new Object[0]);
            if (StringUtils.isEmpty((String)resp)) {
                return null;
            }
            NewsQueryResult newsQueryResult = (NewsQueryResult)IDIJSONUtils.cast((String)resp, NewsQueryResult.class);
            return newsQueryResult == null ? null : this.toNews(newsQueryResult.getData());
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u65b0\u95fb\u67e5\u8be2\u5f02\u5e38", (String)"NewsExecutor_3", (String)"data-idi-core", (Object[])new Object[0])), new Object[0]);
        }
    }

    private List<Company> getCompany(String url, String keyword, List<String> businessCatalogs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("keyWord", keyword);
        if (businessCatalogs == null || businessCatalogs.isEmpty()) {
            businessCatalogs = new ArrayList<String>();
            businessCatalogs.add("state");
        }
        ArrayList<String> newBusinessCatalogs = new ArrayList<String>(businessCatalogs.size() + 1);
        for (String catalog : businessCatalogs) {
            newBusinessCatalogs.add(BusinessCatalogs.newsCatalogChange(catalog));
        }
        if (!newBusinessCatalogs.contains("companyName")) {
            newBusinessCatalogs.add("companyName");
        }
        params.put("catalog", newBusinessCatalogs);
        this.putTenantInfo(params);
        try {
            long start = System.currentTimeMillis();
            CompanyParam companyParam = CompanyParam.createCompanyParam(params);
            CompanyApiAbutmentImpl companyApiAbutment = new CompanyApiAbutmentImpl();
            UrlParam urlParam = companyApiAbutment.getUrlParam("daas_company", null);
            String resp = companyApiAbutment.apiAction(urlParam, companyParam);
            long end = System.currentTimeMillis();
            SchemaExecutorLogger.info(String.format("getCompany takes time: %sms", end - start), new Object[0]);
            SchemaExecutorLogger.info("getCompany resp: " + resp, new Object[0]);
            if (StringUtils.isEmpty((String)resp)) {
                return null;
            }
            CompanyQueryResult queryResult = (CompanyQueryResult)IDIJSONUtils.cast((String)resp, CompanyQueryResult.class);
            return queryResult == null ? null : queryResult.getData();
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u5de5\u5546\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38", (String)"NewsExecutor_5", (String)"data-idi-core", (Object[])new Object[0])), new Object[0]);
        }
    }

    private void putTenantInfo(Map<String, Object> params) {
        RequestContext rc = RequestContext.get();
        params.put("client_company_id", rc.getTenantId());
        TenantInfo tenantInfo = AccountUtils.getTenantByid((String)rc.getTenantId());
        if (tenantInfo != null) {
            params.put("client_company_name", tenantInfo.getName());
        } else {
            params.put("client_company_name", rc.getTenantId());
        }
    }

    private List<News> toNews(List<Map<String, String>> data) {
        if (data == null) {
            return new ArrayList<News>();
        }
        ArrayList<News> newsList = new ArrayList<News>(data.size());
        for (Map<String, String> map : data) {
            News news = new News();
            news.setTitle(map.get("title"));
            news.setKeyword(map.get("keyword"));
            news.setNewsUrl(map.get("news_url"));
            news.setNewsSource(map.get("news_source"));
            news.setNewsType(map.get("news_type"));
            news.setPublishTime(map.get("publish_time"));
            news.setInsertTime(map.get("insert_time"));
            newsList.add(news);
        }
        return newsList;
    }

    protected static class CompanyQueryResult {
        private List<Company> data;
        private String status;

        protected CompanyQueryResult() {
        }

        public List<Company> getData() {
            return this.data;
        }

        public void setData(List<Company> data) {
            this.data = data;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }

    protected static class NewsQueryResult {
        private List<Map<String, String>> data;
        private String status;

        protected NewsQueryResult() {
        }

        public List<Map<String, String>> getData() {
            return this.data;
        }

        public void setData(List<Map<String, String>> data) {
            this.data = data;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

