/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.format.FormatObject;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Area;
import kd.data.idi.data.AreaResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.decision.constant.DecisionExtType;
import kd.data.idi.decision.executor.MServiceDecisionExecutor;
import kd.data.idi.decision.executor.PluginDecisionExecutor;
import kd.data.idi.decision.model.ExtDecisionInfo;
import kd.data.idi.decision.service.DecisionTypeExtInfoService;
import kd.data.idi.engine.AIAttachmentExecutor;
import kd.data.idi.engine.AlarmExecutor;
import kd.data.idi.engine.AttachmentExecutor;
import kd.data.idi.engine.BillFlowExecutor;
import kd.data.idi.engine.BudgetExecutor;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.CourierExecutor;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.FasindexExecutor;
import kd.data.idi.engine.FutureExecutor;
import kd.data.idi.engine.GeneralLedgerExecutor;
import kd.data.idi.engine.InvoiceExecutor;
import kd.data.idi.engine.KeywordDecisionExecutor;
import kd.data.idi.engine.LinkUpBillDecisionExecutor;
import kd.data.idi.engine.NewsExecutor;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptEngine;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptLocaleFieldHandler;
import kd.data.idi.engine.StatisticsExecutor;
import kd.data.idi.exception.AITipException;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.SchemaExeResultHelper;

public class SchemaExecutor {
    private DecisionTypeExtInfoService decisionTypeExtInfoService = new DecisionTypeExtInfoService();

    protected DecisionExecutor findDecisionExecutor(String type) {
        DecisionExecutor executor = null;
        if (MatchType.LINKUP_BILL.getType().equalsIgnoreCase(type)) {
            executor = new LinkUpBillDecisionExecutor();
        } else if (MatchType.NEWS.getType().equalsIgnoreCase(type)) {
            executor = new NewsExecutor();
        } else if (MatchType.ALARM.getType().equalsIgnoreCase(type)) {
            executor = new AlarmExecutor();
        } else if (MatchType.GENERALLEDGER.getType().equalsIgnoreCase(type)) {
            executor = new GeneralLedgerExecutor();
        } else if (MatchType.FUTURE.getType().equalsIgnoreCase(type)) {
            executor = new FutureExecutor();
        } else if (MatchType.KEYWORD.getType().equalsIgnoreCase(type)) {
            executor = new KeywordDecisionExecutor();
        } else if (MatchType.INVOICE.getType().equalsIgnoreCase(type)) {
            executor = new InvoiceExecutor();
        } else if (MatchType.BUDGET.getType().equalsIgnoreCase(type)) {
            executor = new BudgetExecutor();
        } else if (MatchType.LOGISTICSINFORMATION.getType().equalsIgnoreCase(type)) {
            executor = new CourierExecutor();
        } else if (MatchType.BILLFLOW.getType().equalsIgnoreCase(type)) {
            executor = new BillFlowExecutor();
        } else if (MatchType.STATISTICS.getType().equalsIgnoreCase(type)) {
            executor = new StatisticsExecutor();
        } else if (MatchType.FASINDEX.getType().equalsIgnoreCase(type)) {
            executor = new FasindexExecutor();
        } else if (MatchType.ATTACHMENT.getType().equalsIgnoreCase(type)) {
            executor = new AttachmentExecutor();
        } else if (MatchType.AIATTACHMENT.getType().equalsIgnoreCase(type)) {
            executor = new AIAttachmentExecutor();
        } else if (!MatchType.containsType(type)) {
            ExtDecisionInfo extDecisionInfo = this.decisionTypeExtInfoService.queryByMatchType(type);
            if (extDecisionInfo == null) {
                throw new KDBizException("not support rule " + type);
            }
            if (DecisionExtType.MSERVICE == extDecisionInfo.getExtType()) {
                executor = new MServiceDecisionExecutor(extDecisionInfo);
            } else if (DecisionExtType.PLUGIN == extDecisionInfo.getExtType()) {
                executor = new PluginDecisionExecutor(extDecisionInfo);
            }
        } else {
            throw new KDBizException("not support rule " + type);
        }
        return executor;
    }

    public SchemaResult execute(Schema schema, String entityType, Long billId, DynamicObject bizObj, boolean isBackstage) {
        return this.execute(schema, entityType, billId, bizObj, null, isBackstage);
    }

    public SchemaResult execute(Schema schema, String entityType, Long billId, DynamicObject bizObj, String pageId, boolean isBackstage) {
        SchemaContext schemaContext = this.buildContext(schema, entityType, billId, pageId, isBackstage);
        SchemaExecutorLogger.info("schema is " + IDIJSONUtils.toJsonString((Object)schema), new Object[0]);
        return this.executeSchema(schema, schemaContext);
    }

    public SchemaResult execute(ExecuteParam executeParam) {
        SchemaContext schemaContext = this.buildContext(executeParam);
        SchemaExecutorLogger.info("schema is " + IDIJSONUtils.toJsonString((Object)executeParam.getSchema()), new Object[0]);
        return this.executeSchema(executeParam.getSchema(), schemaContext);
    }

    public SchemaContext buildContext(Schema schema, String entityType, Object billId, String pageId, boolean isBackstage) {
        SchemaContext schemaContext = SchemaContext.create();
        this.buildContextCoreByBill(schemaContext, schema, entityType, billId, pageId, isBackstage);
        return schemaContext;
    }

    public SchemaContext buildContext(ExecuteParam executeParam) {
        SchemaContext schemaContext = SchemaContext.create();
        this.buildContextCoreByBill(schemaContext, executeParam.getSchema(), executeParam.getEntityType(), executeParam.getBillId(), executeParam.getPageId(), executeParam.isBackstage());
        schemaContext.setNeedAiAttachment(executeParam.isNeedAiAttachment());
        schemaContext.setNeedRefreshAiResult(executeParam.isNeedRefreshAiResult());
        return schemaContext;
    }

    protected void buildContextCoreByBill(SchemaContext schemaContext, Schema schema, String entityType, Object billId, String pageId, boolean isBackstage) {
        this.buildContextCore(schemaContext, schema, entityType, pageId, isBackstage);
        schemaContext.setBillId(billId);
        long tS1 = System.currentTimeMillis();
        Set<String> propSet = schema.extractProperties(entityType);
        DynamicObject bizObj = ExecutorHelper.loadObject(billId, entityType, propSet);
        SchemaExecutorLogger.info("loadbillobject %s cost: %dms", billId, System.currentTimeMillis() - tS1);
        schemaContext.setSelfBill(bizObj);
    }

    public SchemaContext buildContext(Schema schema, String entityType, DynamicObject sourceBill) {
        SchemaContext schemaContext = SchemaContext.create();
        this.buildContextCore(schemaContext, schema, entityType, null, true);
        schemaContext.setSelfBill(sourceBill);
        schemaContext.setBillControl(true);
        return schemaContext;
    }

    protected void buildContextCore(SchemaContext schemaContext, Schema schema, String entityType, String pageId, boolean isBackstage) {
        schemaContext.setSchema(schema);
        schemaContext.setEntityType(entityType);
        boolean debug = ParamFactory.getBoolean("debug", false);
        schemaContext.setDebug(debug);
        SchemaExecutorLogger.isDebug = debug;
        FormatObject formatObject = InteServiceHelper.getUserFormat((Long)Long.parseLong(RequestContext.get().getUserId()));
        schemaContext.setUserFormatObject(formatObject);
        RequestContext rc = RequestContext.get();
        schemaContext.setTraceId(rc.getTraceId());
        if (schemaContext.getSrcEntityType() == null && StringUtils.isNotEmpty((String)entityType)) {
            schemaContext.setSrcEntityType(EntityMetadataCache.getDataEntityType((String)entityType));
        }
        schemaContext.setPageId(pageId);
        schemaContext.setNeedHighLight(!isBackstage && schema.isHighLight());
        schemaContext.setBackstage(isBackstage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaResult executeSchema(Schema schema, SchemaContext schemaContext) {
        SchemaResult schemaResult;
        Map<Long, Set<String>> lcTemplateFieldMap = schema.achieveLcTemplateField(schemaContext.getEntityType());
        schemaContext.setLcTemplateFieldMap(lcTemplateFieldMap);
        boolean hasException = false;
        DynamicObject schemaResultObj = null;
        ArrayList<DynamicObject> itemResultList = new ArrayList<DynamicObject>(5);
        SchemaExeResultHelper.deleteRecord(String.valueOf(schemaContext.getSelfBill().getPkValue()), schemaContext.getEntityType(), schema.getId());
        if (schemaContext.isNeedHighLight() || !schemaContext.isBackstage() && schemaContext.isNeedAiAttachment()) {
            schemaResultObj = SchemaExeResultHelper.createSchemaResultObj(schema.getId(), (Long)schemaContext.getSelfBill().getPkValue(), schemaContext.getEntityType(), StringUtils.isEmpty((String)schemaContext.getPageId()) ? schemaContext.getTraceId() : schemaContext.getPageId());
            itemResultList = new ArrayList(10);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"idi_itemexeresult");
        try {
            List<Area> areaList = schema.getArea();
            Set<Integer> matchAreaIndexSet = this.matchAreaStartCondition(areaList, schemaContext.getEntityType(), schemaContext.getSelfBill());
            long tS1 = System.currentTimeMillis();
            BigDecimal score = null;
            ArrayList<AreaResult> areaResultList = new ArrayList<AreaResult>(areaList.size());
            int areaIndex = -1;
            for (Area area : areaList) {
                ++areaIndex;
                AreaResult areaResult = new AreaResult();
                areaResult.setArea(area);
                areaResultList.add(areaResult);
                List<Decision> decisionList = area.getDecision();
                if (decisionList == null) continue;
                for (Decision decision : decisionList) {
                    String matchType = decision.getMatchType();
                    if (!matchAreaIndexSet.contains(areaIndex) || !schemaContext.isNeedAiAttachment() && MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType)) {
                        if (score == null) {
                            score = BigDecimal.ZERO;
                        }
                        score = score.add(new BigDecimal(decision.getMark(), DecisionResult.DECIMAL4));
                        continue;
                    }
                    if (!decision.isEnabled()) {
                        SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u51b3\u7b56\u9879%s\u5df2\u7981\u7528!", (String)"SchemaExecutor_0", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()), new Object[0]);
                        continue;
                    }
                    if (!schemaContext.isNeedAiAttachment() && MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType)) {
                        SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u51b3\u7b56\u9879\u201c%s\u201d\u4e3aAI\u9644\u4ef6\u5ba1\u6838\uff0c\u4e0d\u9700\u8981\u6267\u884c\u3002", (String)"SchemaExecutor_3", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()), new Object[0]);
                        continue;
                    }
                    DecisionExecutor decisionExecutor = this.findDecisionExecutor(matchType);
                    DynamicObject itemResult = null;
                    if (schemaContext.isNeedHighLight() || !schemaContext.isBackstage() && schemaContext.isNeedAiAttachment()) {
                        itemResult = SchemaExeResultHelper.createItemResultObj((DynamicObjectType)type, 0L, area.getPk(), area.getTitle(), decision);
                        itemResultList.add(itemResult);
                    }
                    try {
                        long t1 = System.currentTimeMillis();
                        DecisionResult result = decisionExecutor.execute(schemaContext, decision);
                        SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u6267\u884c%s\u8017\u65f6%dms", (String)"SchemaExecutor_1", (String)"data-idi-core", (Object[])new Object[0]), decisionExecutor.toString(), System.currentTimeMillis() - t1), new Object[0]);
                        areaResult.addDecisionResult(result);
                        BigDecimal decisionScore = BigDecimal.ZERO;
                        if (result != null && result.getDeductPercent() != null) {
                            if (score == null) {
                                score = BigDecimal.ZERO;
                            }
                            decisionScore = this.calculate(decision.getMark(), result.getDeductPercent());
                            score = score.add(decisionScore);
                        }
                        if (!schemaContext.isNeedHighLight() && (schemaContext.isBackstage() || !schemaContext.isNeedAiAttachment())) continue;
                        SchemaExeResultHelper.updateItemResultObjStatus(itemResult, "succeed", result, decisionScore);
                    }
                    catch (Exception ex) {
                        String errorMsg;
                        SchemaExecutorLogger.error(ex);
                        hasException = true;
                        DecisionResult result = new DecisionResult();
                        result.setStatus("none");
                        result.setDecision(decision);
                        String matchTypeMessage = decision.getName() + ":";
                        if (ex instanceof AITipException) {
                            matchTypeMessage = matchTypeMessage + ex.getMessage();
                        } else if (MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType)) {
                            errorMsg = ResManager.loadKDString((String)"AI\u68c0\u67e5\u5f02\u5e38", (String)"SchemaExecutor_4", (String)"data-idi-core", (Object[])new Object[0]);
                            matchTypeMessage = matchTypeMessage + errorMsg;
                        } else if (ex instanceof KDBizException) {
                            matchTypeMessage = matchTypeMessage + ex.getMessage();
                        } else {
                            errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"SchemaExecutor_2", (String)"data-idi-core", (Object[])new Object[0]);
                            matchTypeMessage = matchTypeMessage + errorMsg;
                        }
                        result.setShowText(matchTypeMessage);
                        result.setDeductPercent(new BigDecimal(100));
                        areaResult.addDecisionResult(result);
                        if (!schemaContext.isNeedHighLight() && (schemaContext.isBackstage() || !schemaContext.isNeedAiAttachment())) continue;
                        SchemaExeResultHelper.updateItemResultObjStatus(itemResult, "failed", result, new BigDecimal(decision.getMark()));
                    }
                }
            }
            SchemaExecutorLogger.info("executeSchema %s cost: %dms", schema.getName(), System.currentTimeMillis() - tS1);
            SchemaResult schemaResult2 = new SchemaResult();
            schemaResult2.setAreaResults(areaResultList);
            if (score != null) {
                score = score.setScale(0, RoundingMode.HALF_UP);
                schemaResult2.setScore(score.intValue());
            } else {
                schemaResult2.setScore(-1);
            }
            schemaResult = schemaResult2;
            ScriptEngine.getEngine().clear();
        }
        catch (Throwable throwable) {
            ScriptEngine.getEngine().clear();
            String requestNo = RequestContext.get().getTraceId();
            CacheManager.del("lc", requestNo);
            if (schemaContext.isNeedHighLight() || !schemaContext.isBackstage() && schemaContext.isNeedAiAttachment()) {
                try (TXHandle tx = TX.required();){
                    try {
                        SchemaExeResultHelper.saveStatus(schemaResultObj, hasException ? "failed" : "succeed");
                        SchemaExeResultHelper.saveItemResultSchemaResultId(schemaResultObj, itemResultList);
                    }
                    catch (Exception ex) {
                        tx.markRollback();
                    }
                }
            }
            throw throwable;
        }
        String requestNo = RequestContext.get().getTraceId();
        CacheManager.del("lc", requestNo);
        if (schemaContext.isNeedHighLight() || !schemaContext.isBackstage() && schemaContext.isNeedAiAttachment()) {
            TXHandle tx = TX.required();
            Object object = null;
            try {
                try {
                    SchemaExeResultHelper.saveStatus(schemaResultObj, hasException ? "failed" : "succeed");
                    SchemaExeResultHelper.saveItemResultSchemaResultId(schemaResultObj, itemResultList);
                }
                catch (Exception ex) {
                    tx.markRollback();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        return schemaResult;
    }

    protected BigDecimal calculate(int decisionScore, BigDecimal deductPercent) {
        BigDecimal decisionScoreBig = new BigDecimal(decisionScore, DecisionResult.DECIMAL4);
        if (deductPercent.compareTo(DecisionResult.HUNDRED) > 0) {
            return BigDecimal.ZERO;
        }
        return decisionScoreBig.subtract(decisionScoreBig.multiply(deductPercent, DecisionResult.DECIMAL4).divide(DecisionResult.HUNDRED, DecisionResult.DECIMAL4));
    }

    protected Set<Integer> matchAreaStartCondition(List<Area> areaList, String billType, DynamicObject bizObj) {
        HashSet<Integer> matchAreaIndexSet = new HashSet<Integer>(10);
        if (CollectionUtils.isEmpty(areaList)) {
            return matchAreaIndexSet;
        }
        StringBuilder scriptBuilder = new StringBuilder();
        ScriptLocaleFieldHandler scriptLocaleFieldHandler = new ScriptLocaleFieldHandler();
        String[] billTypes = new String[]{billType};
        int index = -1;
        for (Area area : areaList) {
            ++index;
            IDICondition startCondition = area.getStartCondition();
            if (startCondition == null) {
                matchAreaIndexSet.add(index);
                continue;
            }
            String sourceExpr = startCondition.getScript();
            String localeScript = scriptLocaleFieldHandler.processLocaleField(sourceExpr, billTypes, bizObj);
            if (StringUtils.isEmpty((String)localeScript)) {
                matchAreaIndexSet.add(index);
                continue;
            }
            String ifStm = String.format("if (%s) {\n  matchAreaIndexSet.add(%d);\n}\n", localeScript, index);
            scriptBuilder.append(ifStm);
        }
        if (scriptBuilder.length() > 0) {
            String script = scriptBuilder.toString();
            SchemaExecutorLogger.info("area start condition script:" + script, new Object[0]);
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put(billType + "_billObj", bizObj);
            ctx.put("matchAreaIndexSet", matchAreaIndexSet);
            ScriptFormIdHandler.runScript(billType, null, ctx, script);
        }
        return matchAreaIndexSet;
    }

    public static class ExecuteParam {
        private Schema schema;
        private String entityType;
        private Object billId;
        private DynamicObject bizObj;
        private String pageId;
        private boolean backstage;
        private boolean needAiAttachment;
        private boolean needRefreshAiResult;

        public ExecuteParam(Schema schema, String entityType, Object billId, DynamicObject bizObj, String pageId, boolean backstage, boolean needAiAttachment, boolean needRefreshAiResult) {
            this.schema = schema;
            this.entityType = entityType;
            this.billId = billId;
            this.bizObj = bizObj;
            this.pageId = pageId;
            this.backstage = backstage;
            this.needAiAttachment = needAiAttachment;
            this.needRefreshAiResult = needRefreshAiResult;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public void setSchema(Schema schema) {
            this.schema = schema;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        public Object getBillId() {
            return this.billId;
        }

        public void setBillId(Object billId) {
            this.billId = billId;
        }

        public DynamicObject getBizObj() {
            return this.bizObj;
        }

        public void setBizObj(DynamicObject bizObj) {
            this.bizObj = bizObj;
        }

        public String getPageId() {
            return this.pageId;
        }

        public void setPageId(String pageId) {
            this.pageId = pageId;
        }

        public boolean isBackstage() {
            return this.backstage;
        }

        public void setBackstage(boolean backstage) {
            this.backstage = backstage;
        }

        public boolean isNeedAiAttachment() {
            return this.needAiAttachment;
        }

        public void setNeedAiAttachment(boolean needAiAttachment) {
            this.needAiAttachment = needAiAttachment;
        }

        public boolean isNeedRefreshAiResult() {
            return this.needRefreshAiResult;
        }

        public void setNeedRefreshAiResult(boolean needRefreshAiResult) {
            this.needRefreshAiResult = needRefreshAiResult;
        }
    }
}

