/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.Area;
import kd.data.idi.data.AreaResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.SchemaParallelContext;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.IDITaskManager;
import kd.data.idi.engine.SchemaExecutor;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptEngine;
import kd.data.idi.exception.AITipException;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.SchemaExeResultHelper;

public class SchemaParallelExecutor
extends SchemaExecutor {
    private AtomicInteger taskCount = new AtomicInteger(0);

    @Override
    public SchemaParallelContext buildContext(Schema schema, String entityType, Object billId, String pageId, boolean isBackstage) {
        SchemaParallelContext schemaParallelContext = new SchemaParallelContext();
        this.buildContextCoreByBill(schemaParallelContext, schema, entityType, billId, pageId, isBackstage);
        return schemaParallelContext;
    }

    public SchemaResult execute(Schema schema, String entityType, Long billId, String pageId, boolean isBackstage) {
        SchemaResult schemaResult;
        SchemaExeResultHelper.deleteRecord(String.valueOf(billId), entityType, schema.getId());
        long schemaResultId = SchemaExeResultHelper.createSchemaResult(schema.getId(), billId, entityType, pageId);
        try {
            SchemaParallelContext schemaContext = this.buildContext(schema, entityType, billId, pageId, isBackstage);
            schemaContext.setSchemaResultId(schemaResultId);
            SchemaExecutorLogger.info("schema is " + IDIJSONUtils.toJsonString((Object)schema), new Object[0]);
            schemaResult = this.executeSchema(schema, schemaContext);
        }
        catch (Exception e) {
            SchemaExecutorLogger.error(e);
            SchemaExeResultHelper.updateStatus(schemaResultId, "failed");
            schemaResult = new SchemaResult();
            schemaResult.setStatus("exception");
        }
        return schemaResult;
    }

    @Override
    public SchemaResult execute(SchemaExecutor.ExecuteParam executeParam) {
        SchemaResult schemaResult;
        Schema schema = executeParam.getSchema();
        Object billId = executeParam.getBillId();
        String entityType = executeParam.getEntityType();
        String pageId = executeParam.getPageId();
        boolean isBackstage = executeParam.isBackstage();
        SchemaExeResultHelper.deleteRecord(String.valueOf(billId), executeParam.getEntityType(), schema.getId());
        long schemaResultId = SchemaExeResultHelper.createSchemaResult(schema.getId(), billId, entityType, pageId);
        try {
            SchemaParallelContext schemaContext = this.buildContext(schema, entityType, billId, pageId, isBackstage);
            schemaContext.setSchemaResultId(schemaResultId);
            schemaContext.setNeedAiAttachment(executeParam.isNeedAiAttachment());
            schemaContext.setNeedRefreshAiResult(executeParam.isNeedRefreshAiResult());
            SchemaExecutorLogger.info("schema is " + IDIJSONUtils.toJsonString((Object)schema), new Object[0]);
            schemaResult = this.executeSchema(schema, schemaContext);
        }
        catch (Exception e) {
            SchemaExecutorLogger.error(e);
            SchemaExeResultHelper.updateStatus(schemaResultId, "failed");
            schemaResult = new SchemaResult();
            schemaResult.setStatus("exception");
        }
        return schemaResult;
    }

    public SchemaResult executeSchema(Schema schema, SchemaParallelContext schemaContext) {
        long tS1 = System.currentTimeMillis();
        List<Area> areaList = schema.getArea();
        RequestContext rc = RequestContext.get();
        Map<Long, Set<String>> lcTemplateFieldMap = schema.achieveLcTemplateField(schemaContext.getEntityType());
        schemaContext.setLcTemplateFieldMap(lcTemplateFieldMap);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"idi_itemexeresult");
        Set<Integer> matchAreaIndexSet = this.matchAreaStartCondition(areaList, schemaContext.getEntityType(), schemaContext.getSelfBill());
        int areaIndex = -1;
        for (Area area : areaList) {
            List<Decision> decisionList;
            if (!matchAreaIndexSet.contains(++areaIndex) || (decisionList = area.getDecision()) == null) continue;
            for (Decision decision : decisionList) {
                if (!decision.isEnabled()) continue;
                String matchType = decision.getMatchType();
                if (!schemaContext.isNeedAiAttachment() && MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType)) continue;
                this.taskCount.incrementAndGet();
            }
        }
        ArrayList<AreaResult> areaResultList = new ArrayList<AreaResult>(areaList.size());
        ArrayList<DecisionExecutorTask> taskList = new ArrayList<DecisionExecutorTask>(this.taskCount.get());
        DynamicObject[] itemResults = new DynamicObject[this.taskCount.get()];
        int taskIndex = 0;
        boolean schemaHasExeDecision = false;
        areaIndex = -1;
        for (Area area : areaList) {
            if (!matchAreaIndexSet.contains(++areaIndex)) continue;
            AreaResult areaResult = new AreaResult();
            areaResult.setArea(area);
            areaResultList.add(areaResult);
            List<Decision> decisionList = area.getDecision();
            if (decisionList == null) continue;
            boolean hasExeDecision = false;
            for (Decision decision : decisionList) {
                if (!decision.isEnabled()) {
                    SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u51b3\u7b56\u9879%s\u5df2\u7981\u7528!", (String)"SchemaExecutor_0", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()), new Object[0]);
                    continue;
                }
                String matchType = decision.getMatchType();
                if (!schemaContext.isNeedAiAttachment() && MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType)) {
                    SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u51b3\u7b56\u9879\u201c%s\u201d\u4e3aAI\u9644\u4ef6\u5ba1\u6838\uff0c\u4e0d\u9700\u8981\u6267\u884c\u3002", (String)"SchemaExecutor_3", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()), new Object[0]);
                    continue;
                }
                DecisionExecutor decisionExecutor = this.findDecisionExecutor(matchType);
                DecisionExecutorTask task = new DecisionExecutorTask(schemaContext, area.getPk(), area.getTitle(), decision, decisionExecutor, (DynamicObjectType)type, taskIndex, itemResults);
                ++taskIndex;
                taskList.add(task);
                hasExeDecision = true;
                schemaHasExeDecision = true;
            }
            if (!hasExeDecision) continue;
            DecisionResult result = new DecisionResult();
            result.setStatus("loading");
            String loadMessage = ResManager.loadKDString((String)"\u68c0\u67e5\u7ed3\u679c\u52a0\u8f7d\u4e2d\u2026\u2026", (String)"SchemaParallelExecutor_0", (String)"data-idi-core", (Object[])new Object[0]);
            result.setShowText(loadMessage);
            areaResult.addDecisionResult(result);
        }
        SchemaExecutorLogger.info("executeSchema %s cost: %dms", schema.getName(), System.currentTimeMillis() - tS1);
        SchemaResult schemaResult = new SchemaResult();
        schemaResult.setAreaResults(areaResultList);
        schemaResult.setScore(-2);
        if (!schemaHasExeDecision) {
            SchemaExeResultHelper.updateSchemaStatusItemExitFailed(schemaContext.getSchemaResultId());
            SchemaExeResultHelper.updateStatus(schemaContext.getSchemaResultId(), "succeed");
        }
        if (CollectionUtils.isNotEmpty(taskList)) {
            for (DecisionExecutorTask task : taskList) {
                IDITaskManager.executeDecision(task, rc);
            }
        }
        return schemaResult;
    }

    private class DecisionExecutorTask
    implements Runnable {
        private SchemaParallelContext schemaContext;
        private String areaId;
        private String areaName;
        private Decision decision;
        private DecisionExecutor decisionExecutor;
        private DynamicObjectType itemResultType;
        private int taskIndex;
        private DynamicObject[] itemResults;

        public DecisionExecutorTask(SchemaParallelContext schemaContext, String areaId, String areaName, Decision decision, DecisionExecutor decisionExecutor, DynamicObjectType itemResultType, int taskIndex, DynamicObject[] itemResults) {
            this.schemaContext = schemaContext;
            this.areaId = areaId;
            this.areaName = areaName;
            this.decision = decision;
            this.decisionExecutor = decisionExecutor;
            this.itemResultType = itemResultType;
            this.taskIndex = taskIndex;
            this.itemResults = itemResults;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DynamicObject itemResult;
            SchemaContext.create(this.schemaContext);
            this.itemResults[this.taskIndex] = itemResult = SchemaExeResultHelper.createItemResultObj(this.itemResultType, this.schemaContext.getSchemaResultId(), this.areaId, this.areaName, this.decision);
            String matchType = this.decision.getMatchType();
            try {
                long t1 = System.currentTimeMillis();
                SchemaExecutorLogger.info("[DATA-IDI] SchemaParallelExecutor run start!", new Object[0]);
                SchemaExecutorLogger.info(String.format("[DATA-IDI] SchemaParallelExecutor mainThread traceId\uff1a%s!", this.schemaContext.getTraceId()), new Object[0]);
                DecisionResult result = this.decisionExecutor.execute(this.schemaContext, this.decision);
                SchemaExecutorLogger.info("[DATA-IDI] SchemaParallelExecutor run end!", new Object[0]);
                SchemaExecutorLogger.info(String.format(ResManager.loadKDString((String)"\u6267\u884c%s\u8017\u65f6%dms", (String)"SchemaExecutor_1", (String)"data-idi-core", (Object[])new Object[0]), this.decisionExecutor.toString(), System.currentTimeMillis() - t1), new Object[0]);
                BigDecimal score = BigDecimal.ZERO;
                if (result != null) {
                    if (result.getDeductPercent() != null) {
                        score = SchemaParallelExecutor.this.calculate(this.decision.getMark(), result.getDeductPercent());
                    }
                    result.setDecision(null);
                }
                SchemaExeResultHelper.updateItemResultObjStatus(itemResult, "succeed", result, score);
            }
            catch (Exception ex) {
                SchemaExecutorLogger.info("[DATA-IDI] SchemaParallelExecutor run error!", new Object[0]);
                SchemaExecutorLogger.error(ex);
                DecisionResult result = new DecisionResult();
                result.setStatus("none");
                String matchTypeMessage = this.decision.getName() + ":";
                if (ex instanceof AITipException) {
                    matchTypeMessage = matchTypeMessage + ex.getMessage();
                } else if (MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType)) {
                    String errorMsg = ResManager.loadKDString((String)"AI\u68c0\u67e5\u5f02\u5e38", (String)"SchemaExecutor_4", (String)"data-idi-core", (Object[])new Object[0]);
                    matchTypeMessage = matchTypeMessage + errorMsg;
                } else if (ex instanceof KDBizException) {
                    matchTypeMessage = matchTypeMessage + ex.getMessage();
                } else {
                    String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"SchemaExecutor_2", (String)"data-idi-core", (Object[])new Object[0]);
                    matchTypeMessage = matchTypeMessage + errorMsg;
                }
                result.setShowText(matchTypeMessage);
                result.setDeductPercent(new BigDecimal(100));
                SchemaExeResultHelper.updateItemResultObjStatus(itemResult, "failed", result, new BigDecimal(this.decision.getMark()));
            }
            finally {
                int count = SchemaParallelExecutor.this.taskCount.decrementAndGet();
                if (count == 0) {
                    ScriptEngine.getEngine().clear();
                    SaveServiceHelper.save((DynamicObject[])this.itemResults);
                    SchemaExeResultHelper.updateSchemaStatusItemExitFailed(this.schemaContext.getSchemaResultId());
                    CacheManager.del("lc", this.schemaContext.getTraceId());
                }
            }
        }
    }
}

