/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptFormIdHandler;

public class ScriptLocaleFieldHandler {
    public String processLocaleField(String script, String[] billTypes, DynamicObject billObj) {
        return this.processLocaleField(script, billTypes, billObj.getDynamicObjectType());
    }

    public String processLocaleField(String script, String[] billTypes, DynamicObjectType objType) {
        Set<String> vars;
        SchemaExecutorLogger.info("script %s before handle locale field", script);
        String processScript = script;
        if (StringUtils.isNotEmpty((String)script) && (vars = ScriptFormIdHandler.extractVariables(script, billTypes)) != null && !vars.isEmpty()) {
            HashSet<String> popSet = new HashSet<String>(vars.size());
            String billType = objType.getName();
            for (String scriptBillType : billTypes) {
                if (!scriptBillType.startsWith("targetisself_") || !scriptBillType.contains(billType)) continue;
                billType = scriptBillType;
                break;
            }
            String typePrefix = billType + "_billObj.";
            for (String var : vars) {
                if (!var.startsWith(typePrefix)) continue;
                popSet.add(var.substring(typePrefix.length()));
            }
            String functionFix = "valueToString(%s)";
            for (String var : popSet) {
                DynamicProperty prop = ExecutorHelper.getLastProp(objType, var);
                if (!(prop instanceof MuliLangTextProp)) continue;
                String fullField = typePrefix + var;
                String functionField = String.format(functionFix, fullField);
                processScript = processScript.replaceAll(fullField, functionField);
            }
        }
        SchemaExecutorLogger.info("script %s after handle locale field", script);
        return processScript;
    }
}

