/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.data.idi.data.IDICondition;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptLocaleFieldHandler;
import kd.data.idi.engine.ScriptUtils;

public class SelectDecisionExecutor {
    public boolean checkStartCondition(StartConditionParam param) {
        if (param == null) {
            return false;
        }
        if (param.singleEntry) {
            this.processStartEntry(param);
        }
        return this.scriptMatchData(param);
    }

    protected boolean scriptMatchData(StartConditionParam param) {
        boolean matchData;
        String startConditionEntry = null;
        List<Integer> matchStartConditionEntryIndexList = param.getMatchEntryIndexList();
        if (matchStartConditionEntryIndexList == null) {
            matchStartConditionEntryIndexList = new ArrayList<Integer>(5);
            param.setMatchEntryIndexList(matchStartConditionEntryIndexList);
        }
        IDICondition startCondition = param.getCondition();
        MainEntityType srcEntityType = param.getBillType();
        String billEntityNumber = srcEntityType.getName();
        DynamicObject billObj = param.getBillObj();
        Set<String> propSet = ScriptUtils.getEntries(srcEntityType, startCondition.getScript(), new String[]{billEntityNumber});
        if (propSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u652f\u6301\u8de8\u6e90\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"LinkUpBillDecisionExecutor_12", (String)"data-idi-core", (Object[])new Object[0]));
        }
        if (propSet.size() == 1) {
            startConditionEntry = propSet.iterator().next();
            param.setStartEntry(startConditionEntry);
        }
        String script = startCondition.getScript();
        HashMap<String, Object> ctx = new HashMap<String, Object>(1);
        ctx.put(billEntityNumber + "_billObj", billObj);
        int sourceEntrySize = StringUtils.isEmpty((String)startConditionEntry) ? 1 : billObj.getDynamicObjectCollection(startConditionEntry).size();
        ctx.put("rowSize", sourceEntrySize);
        ctx.put("__matchEntryIndexList__", matchStartConditionEntryIndexList);
        ScriptLocaleFieldHandler scriptLocaleFieldHandler = new ScriptLocaleFieldHandler();
        String localeScript = scriptLocaleFieldHandler.processLocaleField(script, new String[]{billEntityNumber}, billObj);
        String entryScript = ScriptUtils.supportEntryPropertyStringIndex((DynamicObjectType)srcEntityType, localeScript, "i");
        String ifStem = "if(%s){\n  __matchEntryIndexList__.add(i);\n}";
        String ifScript = String.format(ifStem, entryScript);
        String forStem = "for(var i=0; i<rowSize; i++){\n%s}";
        String forScript = String.format(forStem, ifScript);
        ScriptFormIdHandler.runScript(billEntityNumber, null, ctx, forScript);
        boolean bl = matchData = !matchStartConditionEntryIndexList.isEmpty();
        if (StringUtils.isEmpty((String)startConditionEntry)) {
            matchStartConditionEntryIndexList.clear();
        }
        return matchData;
    }

    protected String processStartEntry(StartConditionParam param) {
        MainEntityType srcEntityType = param.getBillType();
        IDICondition startCondition = param.getCondition();
        String billEntityNumber = srcEntityType.getName();
        Set<String> propSet = ScriptUtils.getEntries(srcEntityType, startCondition.getScript(), new String[]{billEntityNumber});
        if (propSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u652f\u6301\u8de8\u6e90\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"LinkUpBillDecisionExecutor_12", (String)"data-idi-core", (Object[])new Object[0]));
        }
        if (propSet.size() == 1) {
            String startConditionEntry = propSet.iterator().next();
            param.setStartEntry(startConditionEntry);
            return startConditionEntry;
        }
        return "";
    }

    public static class StartConditionParam {
        private DynamicObject billObj;
        private MainEntityType billType;
        private IDICondition condition;
        private String startEntry;
        private List<Integer> matchEntryIndexList;
        private boolean singleEntry;

        public StartConditionParam(DynamicObject billObj, MainEntityType billType, IDICondition condition, boolean singleEntry) {
            this.billObj = billObj;
            this.billType = billType;
            this.condition = condition;
            this.singleEntry = singleEntry;
        }

        public DynamicObject getBillObj() {
            return this.billObj;
        }

        public void setBillObj(DynamicObject billObj) {
            this.billObj = billObj;
        }

        public MainEntityType getBillType() {
            return this.billType;
        }

        public void setBillType(MainEntityType billType) {
            this.billType = billType;
        }

        public IDICondition getCondition() {
            return this.condition;
        }

        public void setCondition(IDICondition condition) {
            this.condition = condition;
        }

        public String getStartEntry() {
            return this.startEntry;
        }

        public void setStartEntry(String startEntry) {
            this.startEntry = startEntry;
        }

        public List<Integer> getMatchEntryIndexList() {
            return this.matchEntryIndexList;
        }

        public void setMatchEntryIndexList(List<Integer> matchEntryIndexList) {
            this.matchEntryIndexList = matchEntryIndexList;
        }

        public boolean isSingleEntry() {
            return this.singleEntry;
        }

        public void setSingleEntry(boolean singleEntry) {
            this.singleEntry = singleEntry;
        }
    }
}

