/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptFormIdHandler;

public class SelfBillDecisionExecutor
implements DecisionExecutor {
    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        DynamicObject billObj = ExecutorHelper.getSelfBill(context);
        String script = this.buildScript(decision.getRules());
        if (StringUtils.isEmpty((String)script)) {
            return null;
        }
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put(context.getEntityType() + "_billObj", billObj);
        ScriptFormIdHandler.runScript(context.getEntityType(), null, ctx, script);
        DecisionResult decisionResult = this.buildResult(decision, script, ctx);
        this.log(context, decision, decisionResult, ctx);
        return decisionResult;
    }

    String buildScript(List<DecisionRule> ruleList) {
        if (ruleList == null) {
            return "";
        }
        StringBuilder scriptBuilder = new StringBuilder();
        int defaultScore = -1;
        int defaultRuleIndex = -1;
        int ruleIndex = -1;
        for (DecisionRule rule : ruleList) {
            ++ruleIndex;
            String expr = this.buildExpr(rule.getRule());
            if (StringUtils.isEmpty((String)expr)) {
                if (defaultScore >= 0) continue;
                defaultScore = rule.getDeductionGradePercent();
                defaultRuleIndex = ruleIndex;
                continue;
            }
            String preScript = String.format("__MatchRuleIndex__=%d;", ruleIndex);
            if (rule.isCheckVote()) {
                preScript = preScript + "__OneVoteVeto__=\"true\";";
            }
            String ifStm = String.format("if (%s) {\n  %s return %d;\n}\n", expr, preScript, rule.getDeductionGradePercent());
            scriptBuilder.append(ifStm);
        }
        if (defaultScore >= 0) {
            scriptBuilder.append("__MatchRuleIndex__=").append(defaultRuleIndex).append(";\n");
            scriptBuilder.append("return ").append(defaultScore).append(';');
        }
        return scriptBuilder.toString();
    }

    String buildScriptFor(String ifScript) {
        if (StringUtils.isEmpty((String)ifScript)) {
            return ifScript;
        }
        String forStr = "for(var relationIndex = 0; relationIndex < _exerelation_.size(); relationIndex++){\n    var _exerelationtemp_ = _exerelation_.get(relationIndex);\n %s}\n";
        String script = String.format(forStr, ifScript);
        return script;
    }

    String buildRuleScriptFor(List<DecisionRule> ruleList) {
        if (CollectionUtils.isEmpty(ruleList)) {
            return "";
        }
        String ifStr = "if (%s) {\n  _exerelationtemp_.setMatchRuleIndex(%d);continuekeyword;\n}\n";
        StringBuilder ifScriptBuilder = new StringBuilder();
        int ruleIndex = -1;
        for (DecisionRule rule : ruleList) {
            String expr = this.buildExpr(rule.getRule());
            String ifStm = String.format(ifStr, StringUtils.isEmpty((String)expr) ? "true" : expr, ++ruleIndex);
            ifScriptBuilder.append(ifStm);
        }
        ifScriptBuilder.append("\n_exerelationtemp_.setMatchRuleIndex(-1);\n");
        return ifScriptBuilder.toString();
    }

    protected String buildExpr(IDICondition condition) {
        if (condition == null) {
            return "";
        }
        return condition.getScript();
    }

    DecisionResult buildResult(Decision decision, String script, Map<String, Object> ctx) {
        Object matchRuleIndex;
        DecisionResult rtn = new DecisionResult();
        rtn.setDecision(decision);
        rtn.setScript(script);
        if ("true".equalsIgnoreCase(String.valueOf(ctx.get("__OneVoteVeto__")))) {
            rtn.setOneVoteVeto(true);
        }
        if ((matchRuleIndex = ctx.get("__MatchRuleIndex__")) != null) {
            rtn.setMatchRule(Integer.parseInt(matchRuleIndex.toString()));
            DecisionRule decisionRule = decision.getRules().get(rtn.getMatchRule());
            rtn.setShowText(decisionRule.achieveName());
            rtn.setStatus(decisionRule.getDecisionStatus());
        }
        return rtn;
    }

    void log(SchemaContext context, Decision decision, DecisionResult decisionResult, Map<String, Object> ctx) {
        if (!context.isDebug() || StringUtils.isEmpty((String)decisionResult.getScript())) {
            return;
        }
        try {
            StringBuilder logStr = new StringBuilder();
            logStr.append(decision.getName()).append('\n').append("match rule:").append(ctx.get("__MatchRuleIndex__")).append('\n');
            Set<String> varList = ScriptFormIdHandler.extractVariables(decisionResult.getScript(), new String[]{context.getEntityType()});
            logStr.append("param:\n");
            if (varList.isEmpty()) {
                logStr.append("<empty>\n");
            }
            for (String var : varList) {
                String[] s = var.split("\\.", 2);
                if (s.length != 2 || !s[0].contains("_billObj")) continue;
                Object o = ctx.get(s[0]);
                logStr.append(var).append(':');
                if (o != null) {
                    Object value = ExecutorHelper.getValueByName((DynamicObject)o, s[1], true);
                    logStr.append(value);
                } else {
                    logStr.append("null");
                }
                logStr.append('\n');
            }
            SchemaExecutorLogger.info(logStr.toString(), new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

