/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.StatisticsConfig;
import kd.data.idi.data.StatisticsResult;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.SelectDecisionExecutor;

public class StatisticsExecutor
extends SelectDecisionExecutor
implements DecisionExecutor {
    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        SelectDecisionExecutor.StartConditionParam param;
        if (decision.getStatisticsConfig() == null) {
            return null;
        }
        IDICondition startCondition = decision.getStartCondition();
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript()) && !this.checkStartCondition(param = new SelectDecisionExecutor.StartConditionParam(context.getSelfBill(), context.getSrcEntityType(), startCondition, false))) {
            DecisionResult result = new DecisionResult();
            result.setStatus("empty");
            result.setDecision(decision);
            result.setShowText(String.format(ResManager.loadKDString((String)"%s : \u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"GeneralLedgerExecutor_7", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()));
            return result;
        }
        StatisticsConfig statisticsConfig = decision.getStatisticsConfig();
        IDICondition condition = statisticsConfig.getCondition();
        String showField = statisticsConfig.getShowField();
        String renameShowField = statisticsConfig.getRenameShowField();
        DynamicObject srcBillObj = context.getSelfBill();
        String lastCompareType = null;
        FilterCondition valueFilterCondition = new FilterCondition();
        List rows = condition.getFilterCondition().getFilterRow();
        String datePropName = null;
        for (SimpleFilterRow filterRow : rows) {
            boolean isValueFilter = true;
            if (CompareTypeEnum.FIELDEQUAL.getId().equals(filterRow.getCompareType())) {
                isValueFilter = ExecutorHelper.parseFieldEqualCondition(filterRow, srcBillObj);
            } else if ("lastTime".equals(filterRow.getCompareType()) || "lastThreeTimes".equals(filterRow.getCompareType()) || "lastCustomTimes".equals(filterRow.getCompareType())) {
                isValueFilter = false;
                lastCompareType = filterRow.getCompareType();
                datePropName = filterRow.getFieldName();
            } else {
                ExecutorHelper.parseDateTimeCondition(filterRow);
            }
            if (!isValueFilter) continue;
            valueFilterCondition.addFilterRow(filterRow);
        }
        MainEntityType targetType = EntityMetadataCache.getDataEntityType((String)statisticsConfig.getTargetBillType());
        if (valueFilterCondition.getFilterRow().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a", (String)"StatisticsExecutor_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        FilterBuilder filterBuilder = new FilterBuilder(targetType, valueFilterCondition);
        filterBuilder.buildFilter(false);
        QFilter filter = filterBuilder.getQFilter();
        StatisticsResult statisticsResult = lastCompareType != null ? this.processData4Lastmode(context, statisticsConfig, filter, lastCompareType, datePropName) : this.processData4Dim(context, statisticsConfig, filter);
        ArrayList<String> titleList = new ArrayList<String>(statisticsConfig.getProcessConfigList().size());
        if (StatisticsConfig.DimFieldType.ENTRY == statisticsConfig.getDimFieldType()) {
            List filterFields = new EntityTypeUtil().getFilterFields((IDataEntityType)targetType, false);
            List<String> dimPropNames = statisticsConfig.getDimPropNameList();
            List<Object> renameDimPropNames = statisticsConfig.getRenameDimPropNames() == null ? Collections.emptyList() : statisticsConfig.getRenameDimPropNames();
            for (int i = 0; i < dimPropNames.size(); ++i) {
                String name;
                String string = name = renameDimPropNames.size() > i ? (String)renameDimPropNames.get(i) : null;
                if (StringUtils.isEmpty((String)name)) {
                    Iterator iterator = filterFields.iterator();
                    while (iterator.hasNext()) {
                        FilterField filterField = (FilterField)iterator.next();
                        if (!filterField.getFullFieldName().equals(dimPropNames.get(i))) continue;
                        name = filterField.getCaption().getLocaleValue();
                        break;
                    }
                }
                titleList.add(name);
            }
            statisticsResult.setHeadMode(false);
        } else {
            titleList.add(null);
            statisticsResult.setHeadMode(true);
        }
        if (StringUtils.isNotEmpty((String)showField)) {
            titleList.add(StringUtils.isEmpty((String)renameShowField) ? ExecutorHelper.getFullName((DynamicObjectType)targetType, showField) : renameShowField);
        }
        for (StatisticsConfig.DataProcessConfig processConfig : statisticsConfig.getProcessConfigList()) {
            if (StringUtils.isEmpty((String)processConfig.getDisplayName())) {
                titleList.add(ExecutorHelper.getFullName((DynamicObjectType)targetType, processConfig.getPropName()));
                continue;
            }
            titleList.add(processConfig.getDisplayName());
        }
        statisticsResult.setTitleList(titleList);
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setDecision(decision);
        decisionResult.setStatus("green");
        decisionResult.setStatisticsResult(statisticsResult);
        return decisionResult;
    }

    private StatisticsResult processData4Lastmode(SchemaContext context, StatisticsConfig statisticsConfig, QFilter filter, String lastCompareType, String datePropName) {
        AmountProp amountProp;
        String controlPropName;
        Object property;
        QFilter[] qfilters;
        int top = -1;
        switch (lastCompareType) {
            case "lastTime": {
                top = 1;
                break;
            }
            case "lastThreeTimes": {
                top = 3;
                break;
            }
            case "lastCustomTimes": {
                top = statisticsConfig.getCustomTimes();
            }
        }
        if (top <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6700\u8fd1\u6b21\u6570\u914d\u7f6e\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"StatisticsExecutor_2", (String)"data-idi-core", (Object[])new Object[0]));
        }
        DynamicObject soureBill = context.getSelfBill();
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)context.getEntityType());
        if (context.getEntityType().equals(statisticsConfig.getTargetBillType())) {
            qfilters = new QFilter[]{filter, new QFilter("id", "!=", soureBill.getPkValue())};
        } else {
            qfilters = new QFilter[]{filter};
            billType = EntityMetadataCache.getDataEntityType((String)statisticsConfig.getTargetBillType());
        }
        String billField = null;
        if (billType instanceof BillEntityType) {
            BillEntityType billEntityType = (BillEntityType)billType;
            billField = billEntityType.getBillNo();
        }
        HashSet<String> currencyPropSet = new HashSet<String>();
        StringBuilder selectors = new StringBuilder();
        String showField = statisticsConfig.getShowField();
        if (StringUtils.isNotEmpty((String)showField) && (property = ExecutorHelper.getLastProp((DynamicObjectType)billType, showField)) instanceof AmountProp && currencyPropSet.add(controlPropName = (amountProp = (AmountProp)property).getControlPropName())) {
            selectors.append(controlPropName).append(".id,").append(controlPropName).append(".sign,").append(controlPropName).append(".number,").append(controlPropName).append(".amtprecision,");
        }
        for (StatisticsConfig.DataProcessConfig processConfig : statisticsConfig.getProcessConfigList()) {
            AmountProp amountProp2;
            selectors.append(processConfig.getPropName()).append(',');
            DynamicProperty property2 = ExecutorHelper.getLastProp((DynamicObjectType)billType, processConfig.getPropName());
            if (!(property2 instanceof AmountProp) || !currencyPropSet.add((amountProp2 = (AmountProp)property2).getControlPropName())) continue;
            selectors.append(amountProp2.getControlPropName()).append(".id,").append(amountProp2.getControlPropName()).append(".sign,").append(amountProp2.getControlPropName()).append(".number,").append(amountProp2.getControlPropName()).append(".amtprecision,");
        }
        selectors.append("id");
        String selectorStr = selectors.toString();
        StatisticsResult statisticsResult = new StatisticsResult();
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)statisticsConfig.getTargetBillType(), (String)selectorStr, (QFilter[])qfilters, (String)(datePropName + " desc"), (int)top);
        ArrayList<List<Object>> dataTable = new ArrayList<List<Object>>(3);
        statisticsResult.setDataTable(dataTable);
        for (DynamicObject bill : bills) {
            ArrayList tableRow = Lists.newArrayListWithExpectedSize((int)statisticsConfig.getProcessConfigList().size());
            dataTable.add(tableRow);
            tableRow.add(null);
            if (StringUtils.isNotEmpty((String)showField)) {
                ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.getValueAndNameByName(bill, showField, true);
                IDataEntityProperty entityProperty = valueAndName.getEntityProperty();
                Object value = valueAndName.getValue();
                if (value != null) {
                    if (billField != null && billField.equals(showField)) {
                        HashMap<String, Object> dataMap = new HashMap<String, Object>();
                        dataMap.put("billId", String.valueOf(bill.get("id")));
                        dataMap.put("entityNumber", statisticsConfig.getTargetBillType());
                        value = HoverContent.createHref(this.valueToString(value), dataMap);
                    } else {
                        Object formatValue;
                        value = valueAndName.isUser() ? HoverContent.createChat(this.valueToString(value), valueAndName.getRefValue()) : ((formatValue = ExecutorHelper.tryToString(bill, bill, value, entityProperty)) == null ? " " : this.valueToString(formatValue));
                    }
                }
                tableRow.add(value);
            }
            for (StatisticsConfig.DataProcessConfig processConfig : statisticsConfig.getProcessConfigList()) {
                ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.getValueAndNameByName(bill, processConfig.getPropName(), true);
                IDataEntityProperty entityProperty = valueAndName.getEntityProperty();
                Object value = valueAndName.getValue();
                if (value != null) {
                    if (billField != null && billField.equals(processConfig.getPropName())) {
                        HashMap<String, Object> dataMap = new HashMap<String, Object>();
                        dataMap.put("billId", String.valueOf(bill.get("id")));
                        dataMap.put("entityNumber", statisticsConfig.getTargetBillType());
                        value = HoverContent.createHref(this.valueToString(value), dataMap);
                    } else {
                        Object formatValue;
                        value = valueAndName.isUser() ? HoverContent.createChat(this.valueToString(value), valueAndName.getRefValue()) : ((formatValue = ExecutorHelper.tryToString(bill, bill, value, entityProperty)) == null ? " " : this.valueToString(formatValue));
                    }
                }
                tableRow.add(value);
            }
        }
        return statisticsResult;
    }

    private String valueToString(Object value) {
        String valStr = value instanceof OrmLocaleValue ? ((OrmLocaleValue)value).getLocaleValue() : value.toString();
        return valStr;
    }

    private StatisticsResult processData4Dim(SchemaContext context, StatisticsConfig statisticsConfig, QFilter filter) {
        Throwable row2;
        Object parentEntity;
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)statisticsConfig.getTargetBillType());
        Map allFieldMap = billType.getAllFields();
        HashSet selectorSet = Sets.newHashSetWithExpectedSize((int)(statisticsConfig.getProcessConfigList().size() + 2));
        String orderBy = "id";
        selectorSet.add("id");
        String showField = statisticsConfig.getShowField();
        boolean hasShowField = StringUtils.isNotEmpty((String)showField);
        String showFieldCurrencySignProp = null;
        String showFieldCurrencySign = null;
        String showFieldCurrencyPrecisionProp = null;
        int showFieldCurrencyPrecision = 4;
        if (StatisticsConfig.DimFieldType.ENTRY == statisticsConfig.getDimFieldType()) {
            List<String> dimPropNames = statisticsConfig.getDimPropNameList();
            orderBy = String.join((CharSequence)",", dimPropNames);
            selectorSet.addAll(dimPropNames);
            if (context.getEntityType().equals(statisticsConfig.getTargetBillType())) {
                for (String dimPropName : dimPropNames) {
                    this.filterEntryData(filter, context, dimPropName);
                }
            }
            if (hasShowField) {
                selectorSet.add(showField);
                DynamicProperty property = ExecutorHelper.getLastProp((DynamicObjectType)billType, showField);
                if (property instanceof AmountProp) {
                    AmountProp amountProp = (AmountProp)property;
                    IDataEntityType parentEntity2 = amountProp.getParent();
                    boolean flag = parentEntity2 != null && !parentEntity2.getName().equals(statisticsConfig.getTargetBillType());
                    showFieldCurrencySignProp = (flag ? parentEntity2.getName() + '.' : "") + amountProp.getControlPropName() + ".sign";
                    showFieldCurrencyPrecisionProp = (flag ? parentEntity2.getName() + '.' : "") + amountProp.getControlPropName() + ".amtprecision";
                    selectorSet.add(showFieldCurrencySignProp);
                    selectorSet.add(showFieldCurrencyPrecisionProp);
                }
            }
        }
        String currencySignProp = null;
        String currencyPrecProp = null;
        ArrayList<ICalcFun> calcFuns = new ArrayList<ICalcFun>(statisticsConfig.getProcessConfigList().size());
        for (StatisticsConfig.DataProcessConfig processConfig : statisticsConfig.getProcessConfigList()) {
            AmountProp amountProp;
            String currencyName;
            DynamicProperty property;
            String propName = processConfig.getPropName();
            selectorSet.add(propName);
            switch (processConfig.getMethod()) {
                case MIN: {
                    calcFuns.add(new MinFun(propName));
                    break;
                }
                case MAX: {
                    calcFuns.add(new MaxFun(propName));
                    break;
                }
                case SUM: {
                    calcFuns.add(new SumFun(propName));
                    break;
                }
                case AVG: {
                    calcFuns.add(new AvgFun(propName));
                    break;
                }
                case COUNT: {
                    calcFuns.add(new CountFun("id"));
                    break;
                }
                case LAST: {
                    selectorSet.add(processConfig.getLastTimePropName());
                    calcFuns.add(new LastFun(propName, processConfig.getLastTimePropName()));
                    break;
                }
                case RANK: {
                    if (StatisticsConfig.DimFieldType.HEADER != statisticsConfig.getDimFieldType()) break;
                    BigDecimal compareValue = context.getSelfBill().getBigDecimal(propName);
                    if (compareValue != null) {
                        calcFuns.add(new RankFun(propName, compareValue));
                        break;
                    }
                    SchemaExecutorLogger.info(ResManager.loadKDString((String)"\u5355\u5934\u5c5e\u6027[%s]\u503c\u4e3a\u7a7a,\u4e0d\u8fdb\u884c\u6392\u540d\u8ba1\u7b97", (String)"StatisticsExecutor_1", (String)"data-idi-core", (Object[])new Object[0]), propName);
                    break;
                }
            }
            if (propName == null || currencySignProp != null || !((property = ExecutorHelper.getLastProp((DynamicObjectType)billType, propName)) instanceof AmountProp) || !StringUtils.isNotEmpty((String)(currencyName = (amountProp = (AmountProp)property).getControlPropName()))) continue;
            IDataEntityProperty currencyProp = (IDataEntityProperty)allFieldMap.get(currencyName);
            parentEntity = currencyProp.getParent();
            if (parentEntity != null && !parentEntity.getName().equals(statisticsConfig.getTargetBillType())) {
                currencySignProp = parentEntity.getName() + '.' + amountProp.getControlPropName() + ".sign";
                currencyPrecProp = parentEntity.getName() + '.' + amountProp.getControlPropName() + ".amtprecision";
            } else {
                currencySignProp = amountProp.getControlPropName() + ".sign";
                currencyPrecProp = amountProp.getControlPropName() + ".amtprecision";
            }
            selectorSet.add(currencySignProp);
            selectorSet.add(currencyPrecProp);
        }
        StringBuilder selectors = new StringBuilder();
        for (String s : selectorSet) {
            if (!StringUtils.isNotEmpty((String)s)) continue;
            selectors.append(s).append(',');
        }
        String selectorStr = selectors.substring(0, selectors.length() - 1);
        HashSet<String> combinationEntryValue = new HashSet<String>(10);
        HashMap<String, Object> combinationEntryValueMap = new HashMap<String, Object>(10);
        if (context.getEntityType().equals(statisticsConfig.getTargetBillType()) && StatisticsConfig.DimFieldType.ENTRY == statisticsConfig.getDimFieldType()) {
            String[] split = statisticsConfig.getDimPropNameList().get(0).split("\\.");
            DynamicObject targetBill = BusinessDataServiceHelper.loadSingleFromCache((Object)context.getSelfBill().get("id"), (DynamicObjectType)billType);
            if (targetBill != null && targetBill.getDynamicObjectCollection(split[0]) != null && !targetBill.getDynamicObjectCollection(split[0]).isEmpty()) {
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.data.idi.engine.StatisticsExecutorSource", (String)statisticsConfig.getTargetBillType(), (String)selectorStr, (QFilter[])new QFilter[]{new QFilter("id", "in", context.getSelfBill().get("id"))}, null);
                parentEntity = null;
                try {
                    for (Throwable row2 : dataSet) {
                        String theDimFieldValue = this.getTheDimFieldValue((Row)row2, statisticsConfig.getDimPropNameList(), billType);
                        combinationEntryValue.add(theDimFieldValue);
                        if (!hasShowField) continue;
                        combinationEntryValueMap.put(theDimFieldValue, row2.get(showField));
                    }
                }
                catch (Throwable throwable) {
                    parentEntity = throwable;
                    throw throwable;
                }
                finally {
                    if (dataSet != null) {
                        if (parentEntity != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)parentEntity).addSuppressed(throwable);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
        }
        String currencySign = null;
        int currencyPrec = 4;
        ArrayList<ProcessResult> processResults = new ArrayList<ProcessResult>(4);
        ArrayList<Object> showFieldRowList = new ArrayList<Object>(4);
        row2 = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.data.idi.engine.StatisticsExecutor2", (String)statisticsConfig.getTargetBillType(), (String)selectorStr, (QFilter[])new QFilter[]{filter}, (String)orderBy);){
            if (StatisticsConfig.DimFieldType.ENTRY == statisticsConfig.getDimFieldType()) {
                List<String> dimPropNames = statisticsConfig.getDimPropNameList();
                String dimFieldValue = null;
                ProcessResult processResult = null;
                for (Row row3 : dataSet) {
                    String theDimFieldValue = this.getTheDimFieldValue(row3, dimPropNames, billType);
                    if (context.getEntityType().equals(statisticsConfig.getTargetBillType()) && !combinationEntryValue.contains(theDimFieldValue)) continue;
                    if (dimFieldValue == null || !dimFieldValue.equals(theDimFieldValue)) {
                        dimFieldValue = theDimFieldValue;
                        processResult = new ProcessResult();
                        processResult.dimValue = dimFieldValue;
                        processResults.add(processResult);
                        if (hasShowField) {
                            showFieldRowList.add(row3.get(showField));
                            if (showFieldCurrencySignProp != null && showFieldCurrencySign == null) {
                                showFieldCurrencySign = row3.getString(showFieldCurrencySignProp);
                                showFieldCurrencyPrecision = row3.getInteger(showFieldCurrencyPrecisionProp);
                            }
                        }
                    }
                    this.calcAllFuns(calcFuns, processResult, row3);
                    if (currencySignProp == null || currencySign != null) continue;
                    currencySign = row3.getString(currencySignProp);
                    Integer currentPrecProp = row3.getInteger(currencyPrecProp);
                    currencyPrec = currentPrecProp == null ? currencyPrec : currentPrecProp;
                }
                Set existDim = processResults.stream().map(x -> ((ProcessResult)x).dimValue).collect(Collectors.toSet());
                HashSet copyCombinationValue = new HashSet(combinationEntryValue);
                copyCombinationValue.removeAll(existDim);
                for (String dimValue : copyCombinationValue) {
                    ProcessResult result = new ProcessResult();
                    result.dimValue = dimValue;
                    processResults.add(result);
                    this.calcAllFuns(calcFuns, result, null);
                    if (!hasShowField) continue;
                    showFieldRowList.add(combinationEntryValueMap.get(dimValue));
                }
            } else {
                ProcessResult processResult = new ProcessResult();
                processResults.add(processResult);
                Object preBillId = null;
                int count = 0;
                for (Row row3 : dataSet) {
                    ++count;
                    if (preBillId == null || !preBillId.equals(row3.get("id"))) {
                        this.calcAllFuns(calcFuns, processResult, row3);
                        preBillId = row3.get("id");
                    }
                    if (currencySignProp == null || currencySign != null) continue;
                    currencySign = row3.getString(currencySignProp);
                    Integer currentPrecProp = row3.getInteger(currencyPrecProp);
                    currencyPrec = currentPrecProp == null ? currencyPrec : currentPrecProp;
                }
                if (count == 0) {
                    processResults.clear();
                }
            }
        }
        catch (Throwable processResult) {
            row2 = processResult;
            throw processResult;
        }
        StatisticsResult statisticsResult = new StatisticsResult();
        ArrayList<List<Object>> dataTable = new ArrayList<List<Object>>(processResults.size());
        statisticsResult.setDataTable(dataTable);
        for (int i = 0; i < processResults.size(); ++i) {
            ProcessResult processResult = (ProcessResult)processResults.get(i);
            ArrayList<Object> row4 = new ArrayList<Object>(statisticsConfig.getProcessConfigList().size());
            dataTable.add(row4);
            List<String> dimValueTransList = this.dimValueTransList(processResult.dimValue);
            row4.addAll(dimValueTransList);
            if (hasShowField && !showFieldRowList.isEmpty()) {
                Object showFieldValue = showFieldRowList.get(i);
                if (showFieldCurrencySignProp != null && showFieldValue instanceof BigDecimal) {
                    showFieldValue = ExecutorHelper.currencyToString(context, (BigDecimal)showFieldValue, null, showFieldCurrencySign, showFieldCurrencyPrecision);
                }
                row4.add(showFieldValue);
            }
            for (StatisticsConfig.DataProcessConfig processConfig : statisticsConfig.getProcessConfigList()) {
                String propName = processConfig.getPropName();
                Object value = null;
                switch (processConfig.getMethod()) {
                    case MIN: {
                        value = processResult.getMin(propName);
                        break;
                    }
                    case MAX: {
                        value = processResult.getMax(propName);
                        break;
                    }
                    case SUM: {
                        value = processResult.getSum(propName);
                        break;
                    }
                    case AVG: {
                        value = processResult.getAvg(propName);
                        break;
                    }
                    case COUNT: {
                        value = processResult.getCount("id");
                        break;
                    }
                    case LAST: {
                        value = processResult.getLastValue(propName);
                        break;
                    }
                    case RANK: {
                        value = processResult.getRank(propName);
                        break;
                    }
                }
                if (value == null) continue;
                if (currencySign != null && value instanceof BigDecimal) {
                    value = ExecutorHelper.currencyToString(context, (BigDecimal)value, null, currencySign, currencyPrec);
                }
                row4.add(value);
            }
        }
        return statisticsResult;
    }

    private void filterEntryData(QFilter filter, SchemaContext context, String dimProp) {
        String prop;
        DynamicObject srcBill = context.getSelfBill();
        String[] propArr = dimProp.split("\\.");
        if (propArr.length <= 2) {
            prop = dimProp;
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < propArr.length - 1; ++i) {
                sb.append(propArr[i]).append('.');
            }
            sb.append("id");
            prop = sb.toString();
        }
        ExecutorHelper.ValueAndName value = ExecutorHelper.getValueAndNameByName(srcBill, prop, false);
        List dataList = (List)value.getValue();
        if (dataList != null && !dataList.isEmpty()) {
            HashSet<Long> dataSet = new HashSet<Long>();
            dataSet.addAll(dataList);
            if (dataList.get(0) instanceof Long) {
                dataSet.add(0L);
            }
            filter.and(prop, "in", dataSet);
        }
    }

    private void calcAllFuns(List<ICalcFun> calcFuns, ProcessResult processResult, Row row) {
        for (ICalcFun calcFun : calcFuns) {
            calcFun.visitOneRow(processResult, row);
        }
    }

    public String getTheDimFieldValue(Row row, List<String> dimPropNames, MainEntityType targetType) {
        if (dimPropNames == null || dimPropNames.isEmpty()) {
            return "";
        }
        StringBuilder dimFieldValue = new StringBuilder();
        int i = 1;
        for (String dimPropName : dimPropNames) {
            DynamicProperty property;
            String value;
            String string = value = row.get(dimPropName) == null ? "" : row.getString(dimPropName);
            if (targetType != null && !((property = ExecutorHelper.getLastProp((DynamicObjectType)targetType, dimPropName)) instanceof DecimalProp)) {
                value = (String)ExecutorHelper.tryToString(null, null, value, (IDataEntityProperty)property);
            }
            dimFieldValue.append("scv").append(i).append("_").append(value).append(",");
            ++i;
        }
        return dimFieldValue.toString();
    }

    public List<String> dimValueTransList(String dimValue) {
        if (StringUtils.isEmpty((String)dimValue)) {
            return Collections.emptyList();
        }
        List collect = Arrays.stream(dimValue.split("scv")).filter(x -> !x.isEmpty()).collect(Collectors.toList());
        ArrayList<String> ans = new ArrayList<String>(collect.size());
        for (String value : collect) {
            if (value.length() >= 3) {
                ans.add(value.substring(2, value.length() - 1));
                continue;
            }
            ans.add(value);
        }
        return ans;
    }

    private static class RankFun
    implements ICalcFun {
        private BigDecimal compareValue;
        private String propName;

        RankFun(String propName, BigDecimal compareValue) {
            this.propName = propName;
            this.compareValue = compareValue;
        }

        @Override
        public void visitOneRow(ProcessResult processResult, Row row) {
            BigDecimal val = row.getBigDecimal(this.propName);
            List rankList = processResult.rankListMap.computeIfAbsent(this.propName, k -> new ArrayList());
            if (val.compareTo(this.compareValue) > 0) {
                this.insertList(rankList, val, 0, rankList.size() - 1);
            }
        }

        private void insertList(List<BigDecimal> rankList, BigDecimal val, int from, int to) {
            if (rankList.isEmpty()) {
                SchemaExecutorLogger.info(String.format("rankList is empty, add value:%s", val.toString()), new Object[0]);
                rankList.add(val);
                return;
            }
            int ret = rankList.get(from).compareTo(val);
            if (ret == 0) {
                return;
            }
            if (ret < 0) {
                SchemaExecutorLogger.info(String.format("from:%s,value:%s", from, val.toString()), new Object[0]);
                rankList.add(from, val);
                return;
            }
            if (from == to) {
                SchemaExecutorLogger.info(String.format("from+1:%s,value:%s", from + 1, val.toString()), new Object[0]);
                rankList.add(from + 1, val);
                return;
            }
            ret = rankList.get(to).compareTo(val);
            if (ret == 0) {
                return;
            }
            if (ret > 0) {
                SchemaExecutorLogger.info(val.toString(), new Object[0]);
                rankList.add(val);
                return;
            }
            int pos = (from + to) / 2;
            BigDecimal posVal = rankList.get(pos);
            ret = posVal.compareTo(val);
            if (ret > 0) {
                this.insertList(rankList, val, pos + 1, to);
            } else if (ret < 0) {
                this.insertList(rankList, val, from, pos - 1);
            }
        }
    }

    private static class LastFun
    implements ICalcFun {
        private String lastTimePropName = null;
        private String propName = null;

        LastFun(String propName, String lastTimePropName) {
            this.propName = propName;
            this.lastTimePropName = lastTimePropName;
        }

        @Override
        public void visitOneRow(ProcessResult processResult, Row row) {
            if (row == null) {
                processResult.lastTimeMap.put(this.propName, 0L);
                processResult.valueOfLastTimeMap.put(this.propName, "");
                return;
            }
            Date theTime = row.getDate(this.lastTimePropName);
            Long lastTime = (Long)processResult.lastTimeMap.get(this.propName);
            if (lastTime == null) {
                lastTime = 0L;
            }
            if (theTime != null && row.get(this.propName) != null && theTime.getTime() > lastTime) {
                processResult.lastTimeMap.put(this.propName, theTime.getTime());
                processResult.valueOfLastTimeMap.put(this.propName, row.get(this.propName));
            }
        }
    }

    private static class CountFun
    implements ICalcFun {
        private String propName = null;

        CountFun(String propName) {
            this.propName = propName;
        }

        @Override
        public void visitOneRow(ProcessResult processResult, Row row) {
            if (row == null) {
                processResult.idSetMap.put(this.propName, Collections.emptySet());
                return;
            }
            HashSet<Long> idSet = (HashSet<Long>)processResult.idSetMap.get(this.propName);
            if (idSet == null) {
                idSet = new HashSet<Long>();
            }
            idSet.add(row.getLong(this.propName));
            processResult.idSetMap.put(this.propName, idSet);
        }
    }

    private static class AvgFun
    implements ICalcFun {
        private String propName = null;

        AvgFun(String propName) {
            this.propName = propName;
        }

        @Override
        public void visitOneRow(ProcessResult processResult, Row row) {
            if (row == null) {
                processResult.avgMap.put(this.propName, BigDecimal.ZERO);
                processResult.countOfAvgMap.put(this.propName, 0);
                return;
            }
            BigDecimal val = row.getBigDecimal(this.propName);
            if (val != null) {
                BigDecimal sum = (BigDecimal)processResult.avgMap.get(this.propName);
                processResult.avgMap.put(this.propName, sum == null ? val : val.add(sum));
                Integer count = (Integer)processResult.countOfAvgMap.get(this.propName);
                processResult.countOfAvgMap.put(this.propName, count == null ? 1 : count + 1);
            }
        }
    }

    private static class SumFun
    implements ICalcFun {
        private String propName = null;

        SumFun(String propName) {
            this.propName = propName;
        }

        @Override
        public void visitOneRow(ProcessResult processResult, Row row) {
            if (row == null) {
                processResult.sumMap.put(this.propName, BigDecimal.ZERO);
                return;
            }
            BigDecimal val = row.getBigDecimal(this.propName);
            if (val != null) {
                BigDecimal sum = (BigDecimal)processResult.sumMap.get(this.propName);
                processResult.sumMap.put(this.propName, sum == null ? val : val.add(sum));
            }
        }
    }

    private static class MaxFun
    implements ICalcFun {
        private String propName = null;

        MaxFun(String propName) {
            this.propName = propName;
        }

        @Override
        public void visitOneRow(ProcessResult processResult, Row row) {
            BigDecimal max;
            if (row == null) {
                processResult.maxMap.put(this.propName, BigDecimal.ZERO);
                return;
            }
            BigDecimal val = row.getBigDecimal(this.propName);
            if (val != null && ((max = (BigDecimal)processResult.maxMap.get(this.propName)) == null || max.compareTo(val) < 0)) {
                processResult.maxMap.put(this.propName, val);
            }
        }
    }

    private static class MinFun
    implements ICalcFun {
        private String propName = null;

        MinFun(String propName) {
            this.propName = propName;
        }

        @Override
        public void visitOneRow(ProcessResult processResult, Row row) {
            BigDecimal min;
            if (row == null) {
                processResult.minMap.put(this.propName, BigDecimal.ZERO);
                return;
            }
            BigDecimal val = row.getBigDecimal(this.propName);
            if (val != null && ((min = (BigDecimal)processResult.minMap.get(this.propName)) == null || min.compareTo(val) > 0)) {
                processResult.minMap.put(this.propName, val);
            }
        }
    }

    static interface ICalcFun {
        public void visitOneRow(ProcessResult var1, Row var2);
    }

    private static class ProcessResult {
        private String dimValue;
        private Map<String, BigDecimal> minMap = new HashMap<String, BigDecimal>(3);
        private Map<String, BigDecimal> maxMap = new HashMap<String, BigDecimal>(3);
        private Map<String, BigDecimal> sumMap = new HashMap<String, BigDecimal>(3);
        private Map<String, Integer> countOfAvgMap = new HashMap<String, Integer>(3);
        private Map<String, BigDecimal> avgMap = new HashMap<String, BigDecimal>(3);
        private Map<String, Set<Long>> idSetMap = new HashMap<String, Set<Long>>(3);
        private Map<String, Long> lastTimeMap = new HashMap<String, Long>(3);
        private Map<String, Object> valueOfLastTimeMap = new HashMap<String, Object>(3);
        private Map<String, List<BigDecimal>> rankListMap = new HashMap<String, List<BigDecimal>>(3);

        private ProcessResult() {
        }

        BigDecimal getMin(String propName) {
            if (this.minMap.get(propName) != null) {
                return this.minMap.get(propName).setScale(2, 4);
            }
            return null;
        }

        BigDecimal getMax(String propName) {
            if (this.maxMap.get(propName) != null) {
                return this.maxMap.get(propName).setScale(2, 4);
            }
            return null;
        }

        BigDecimal getSum(String propName) {
            if (this.sumMap.get(propName) != null) {
                return this.sumMap.get(propName).setScale(2, 4);
            }
            return null;
        }

        BigDecimal getAvg(String propName) {
            if (!this.avgMap.containsKey(propName)) {
                return BigDecimal.ZERO;
            }
            BigDecimal sum = this.avgMap.get(propName);
            int count = this.countOfAvgMap.get(propName);
            return count == 0 ? BigDecimal.ZERO : sum.divide(new BigDecimal(count), 2, 4);
        }

        int getCount(String propName) {
            Set<Long> idSet = this.idSetMap.get(propName);
            return idSet == null ? 0 : idSet.size();
        }

        Object getLastValue(String propName) {
            return this.valueOfLastTimeMap.get(propName);
        }

        String getRank(String propName) {
            List<BigDecimal> rankList = this.rankListMap.get(propName);
            int rank = rankList != null ? rankList.size() + 1 : 1;
            String rankStr = "";
            switch (rank) {
                case 1: {
                    rankStr = "1st";
                    break;
                }
                case 2: {
                    rankStr = "2nd";
                    break;
                }
                case 3: {
                    rankStr = "3rd";
                    break;
                }
                default: {
                    rankStr = rank + "th";
                }
            }
            return rankStr;
        }
    }
}

