/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.ai.service;

import java.util.List;
import java.util.Locale;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.sysparam.KeyWordProviderEnum;
import kd.data.idi.engine.ai.service.KeywordDetectImpl;
import kd.data.idi.engine.ai.service.PreciseKeywordDetectImpl;
import kd.data.idi.util.SystemParamHelper;

public interface IKeywordDetect {
    public static final String regex = "\\s+";

    public static IKeywordDetect getInstance() {
        String keyWordProvider = (String)SystemParamHelper.getParam("keywordprovider");
        KeyWordProviderEnum keyWordProviderEnum = KeyWordProviderEnum.convert(keyWordProvider);
        return keyWordProviderEnum == KeyWordProviderEnum.IDI ? new PreciseKeywordDetectImpl() : new KeywordDetectImpl();
    }

    public List<String> detect(String var1, String var2, List<String> var3, List<String> var4);

    default public String handleWhiteList(String text, List<String> whitelists) {
        if (StringUtils.isEmpty((String)text) || CollectionUtils.isEmpty(whitelists)) {
            return text;
        }
        String tempStr = text.toLowerCase(Locale.ENGLISH);
        for (String whitelist : whitelists) {
            String newWhitelist = whitelist.toLowerCase(Locale.ENGLISH).replaceAll(regex, "");
            tempStr = tempStr.replaceAll(newWhitelist, "@@@");
        }
        return tempStr;
    }

    default public boolean notNecessaryDetect(String text) {
        return text.matches("^@+$");
    }
}

