/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.ai.service;

import com.cronutils.utils.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.ai.service.IKeywordDetect;
import org.ahocorasick.trie.Emit;
import org.ahocorasick.trie.Trie;

public class PreciseKeywordDetectImpl
implements IKeywordDetect {
    private static Map<String, Trie> modelMap = new ConcurrentHashMap<String, Trie>();

    @Override
    public List<String> detect(String text, String modelId, List<String> keywords, List<String> whitelists) {
        if (StringUtils.isEmpty((String)text)) {
            return new ArrayList<String>(1);
        }
        String normalizedText = PreciseKeywordDetectImpl.trimIllegalChar(text);
        String secondText = this.handleWhiteList(normalizedText, whitelists);
        if (this.notNecessaryDetect(secondText)) {
            return new ArrayList<String>(1);
        }
        Preconditions.checkArgument((keywords != null && keywords.size() > 0 ? 1 : 0) != 0, (Object)"keywords is Empty");
        Trie trie = PreciseKeywordDetectImpl.createModel(modelId, keywords, false);
        Collection<Emit> emits = trie.parseText(secondText.toLowerCase());
        ArrayList<String> result = new ArrayList<String>(emits.size());
        if (!emits.isEmpty()) {
            for (Emit emit : emits) {
                result.add(emit.getKeyword());
            }
        }
        return result;
    }

    public static String trimIllegalChar(String text) {
        String s1 = text.toLowerCase(Locale.ENGLISH).replaceAll("\\s+", "");
        StringBuilder sb = new StringBuilder(s1.length());
        char[] characters = s1.toCharArray();
        int len = characters.length;
        for (int i = 0; i < len; ++i) {
            sb.append(characters[i]);
        }
        return sb.toString();
    }

    public static Trie createModel(String modelId, List<String> keywords, boolean rebuild) {
        Trie trie;
        if (rebuild) {
            trie = PreciseKeywordDetectImpl.createModel(keywords);
            modelMap.put(modelId, trie);
        } else {
            trie = modelMap.get(modelId);
            if (trie == null) {
                trie = PreciseKeywordDetectImpl.createModel(keywords);
            }
        }
        return trie;
    }

    private static Trie createModel(List<String> keywords) {
        Trie trie = new Trie(false);
        for (String keyword : keywords) {
            String newKeyword = keyword.toLowerCase(Locale.ENGLISH).replaceAll("\\s+", "");
            trie.addKeyword(newKeyword);
        }
        return trie;
    }
}

