/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.attachment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.function.Function;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIEncryptUtils;

public class Attachment
implements Serializable {
    private static final long serialVersionUID = 2896836879638117933L;
    private String attrId;
    private String url;
    private String fileType;
    private String fileName;
    private long size;
    private String fileId;
    private String fileMD5;
    private String attachmentPanelName;

    public Attachment() {
    }

    public Attachment(String attrId, String url, String fileType, String fileName, long size, String fileId, String attachmentPanelName) {
        this.attrId = attrId;
        this.url = url;
        this.fileType = fileType;
        this.fileName = fileName;
        this.size = size;
        this.fileId = fileId;
        this.attachmentPanelName = attachmentPanelName;
    }

    public String getAttrId() {
        return this.attrId;
    }

    public void setAttrId(String attrId) {
        this.attrId = attrId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileMD5() {
        return this.fileMD5;
    }

    public String getAttachmentPanelName() {
        return this.attachmentPanelName;
    }

    public void setAttachmentPanelName(String attachmentPanelName) {
        this.attachmentPanelName = attachmentPanelName;
    }

    public void buildFileMD5() {
        this.fileMD5 = IDIEncryptUtils.getMD5((String)this.toBase64());
    }

    public String toBase64() {
        Object result = this.processFile(bytes -> Base64.getEncoder().encodeToString((byte[])bytes));
        return (String)result;
    }

    private Object processFile(Function<byte[], Object> dataCovertFunction) {
        if (StringUtils.isEmpty((String)this.url)) {
            return null;
        }
        InputStream inputStream = null;
        ByteArrayOutputStream out = null;
        try {
            int len;
            URL imageUrl = new URL(this.url);
            URLConnection conn = imageUrl.openConnection();
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            byte[] bs = new byte[1024];
            inputStream = conn.getInputStream();
            out = new ByteArrayOutputStream();
            while ((len = inputStream.read(bs)) != -1) {
                out.write(bs, 0, len);
            }
            byte[] result = out.toByteArray();
            Object object = dataCovertFunction.apply(result);
            return object;
        }
        catch (Throwable e) {
            throw new KDBizException(e, new ErrorCode("", ""), new Object[0]);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    SchemaExecutorLogger.error(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    SchemaExecutorLogger.error(e);
                }
            }
        }
    }
}

