/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.attachment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.attachment.CheckMethodEnum;
import kd.data.idi.engine.attachment.AIParam;
import kd.data.idi.engine.attachment.AIRecognizerErrorInfo;
import kd.data.idi.engine.attachment.AIRecognizerResult;
import kd.data.idi.engine.attachment.AIRecognizerResultBase;
import kd.data.idi.engine.attachment.AIRecognizerSuccessInfo;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.Attachment;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.engine.attachment.AttachmentServiceFactory;

public enum AttachmentTypeEnum {
    BANK("1"){

        @Override
        public AIRecognizerResultBase parseAttachment(String dataText, AITemplate template, Attachment attachmentInfo) {
            AIRecognizerResultBase resultBase;
            if (StringUtils.isEmpty((String)dataText)) {
                throw new KDBizException("unspport parse. result is null on ai interface");
            }
            JSONObject jsonObject = JSONObject.parseObject((String)dataText);
            if ("0".equals(jsonObject.getString("errorCode"))) {
                JSONArray datas = jsonObject.getJSONArray("data");
                if (datas == null || datas.isEmpty()) {
                    resultBase = new AIRecognizerErrorInfo(attachmentInfo.getFileName());
                } else {
                    ArrayList<AIRecognizerErrorInfo> list = new ArrayList<AIRecognizerErrorInfo>(datas.size());
                    for (int index = 0; index < datas.size(); ++index) {
                        AIRecognizerResultBase tempResult;
                        JSONObject dataObj = datas.getJSONObject(index);
                        boolean status = dataObj.getBoolean("recongnizeStatus");
                        String fileName = attachmentInfo.getFileName() + '_' + dataObj.getString("othersInfo");
                        if (status) {
                            tempResult = new AIRecognizerSuccessInfo(fileName, template, (Map)dataObj.getObject("confidence", Map.class), (Map)dataObj.getObject("recongnizeDetail", Map.class));
                        } else {
                            tempResult = new AIRecognizerErrorInfo(fileName);
                            tempResult.setDescription(dataObj.getString("errorInfo"));
                        }
                        list.add((AIRecognizerErrorInfo)tempResult);
                    }
                    if (list.size() <= 1) {
                        resultBase = (AIRecognizerResultBase)list.get(0);
                    } else {
                        AIRecognizerResult finalResultBase = new AIRecognizerResult();
                        resultBase = finalResultBase;
                        list.forEach(item -> finalResultBase.addInfo((AIRecognizerResultBase)item));
                    }
                }
            } else {
                resultBase = new AIRecognizerErrorInfo(attachmentInfo.getFileName());
            }
            resultBase.setRequestId(jsonObject.getString("requestId"));
            resultBase.setErrorCode(jsonObject.getString("errorCode"));
            if (StringUtils.isEmpty((String)resultBase.getDescription())) {
                resultBase.setDescription(jsonObject.getString("description"));
            }
            return resultBase;
        }
    }
    ,
    OTHER("0"),
    CUSTOMER("2"){

        @Override
        public AIRecognizerResultBase parseAttachment(String dataText, AITemplate template, Attachment attachmentInfo) {
            AIRecognizerResultBase resultBase;
            if (StringUtils.isEmpty((String)dataText)) {
                throw new KDBizException("unspport parse. result is null on ai interface");
            }
            JSONObject jsonObject = JSONObject.parseObject((String)dataText);
            if ("0".equals(jsonObject.getString("errorCode"))) {
                JSONObject dataJson = jsonObject.getJSONObject("data");
                HashMap<String, Object> detailMap = new HashMap<String, Object>(10);
                Map headData = (Map)dataJson.getObject("recognitionArea", Map.class);
                detailMap.putAll(headData);
                JSONObject tableJson = dataJson.getJSONObject("table");
                Set tableKeySet = tableJson.keySet();
                for (String tableKey : tableKeySet) {
                    JSONArray tableDataArray = tableJson.getJSONArray(tableKey);
                    if (!CollectionUtils.isNotEmpty((Collection)tableDataArray)) continue;
                    JSONArray tableTitle = tableDataArray.getJSONArray(0);
                    int columnCount = tableTitle.size();
                    ArrayList dataList = new ArrayList(5);
                    for (int row = 1; row < tableDataArray.size(); ++row) {
                        JSONArray rowData = tableDataArray.getJSONArray(row);
                        HashMap<String, String> rowDataMap = new HashMap<String, String>(columnCount);
                        for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                            rowDataMap.put(tableTitle.getString(columnIndex), rowData.getString(columnIndex));
                        }
                        dataList.add(rowDataMap);
                    }
                    detailMap.put(tableKey, dataList);
                }
                JSONObject confidenceJson = dataJson.getJSONObject("confidence");
                HashMap<String, Object> confidenceMap = new HashMap<String, Object>(10);
                if (confidenceJson != null) {
                    Map confidenceHeadData = (Map)confidenceJson.getObject("recognitionArea", Map.class);
                    confidenceMap.putAll(confidenceHeadData);
                    JSONObject confidenceTableJson = confidenceJson.getJSONObject("table");
                    if (confidenceTableJson != null) {
                        Set confidenceTableKeySet = confidenceTableJson.keySet();
                        for (String tableKey : confidenceTableKeySet) {
                            JSONArray realTableDataArray = tableJson.getJSONArray(tableKey);
                            JSONArray confidenceTableDataArray = confidenceTableJson.getJSONArray(tableKey);
                            if (realTableDataArray == null || realTableDataArray.isEmpty() || confidenceTableDataArray == null || confidenceTableDataArray.isEmpty()) continue;
                            JSONArray tableTitle = realTableDataArray.getJSONArray(0);
                            int columnCount = tableTitle.size();
                            ArrayList confidenceDataList = new ArrayList(10);
                            for (int row = 0; row < confidenceTableDataArray.size(); ++row) {
                                JSONArray confidenceRowData = confidenceTableDataArray.getJSONArray(row);
                                HashMap<String, String> confidenceRowDataMap = new HashMap<String, String>(columnCount);
                                for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                                    confidenceRowDataMap.put(tableTitle.getString(columnIndex), confidenceRowData.getString(columnIndex));
                                }
                                confidenceDataList.add(confidenceRowDataMap);
                            }
                            confidenceMap.put(tableKey, confidenceDataList);
                        }
                    }
                }
                resultBase = new AIRecognizerSuccessInfo(attachmentInfo.getFileName(), template, confidenceMap, detailMap);
            } else {
                resultBase = new AIRecognizerErrorInfo(attachmentInfo.getFileName());
            }
            resultBase.setRequestId(jsonObject.getString("requestId"));
            resultBase.setErrorCode(jsonObject.getString("errorCode"));
            resultBase.setDescription(jsonObject.getString("description"));
            return resultBase;
        }
    }
    ,
    RECOGNIZER("3"){

        @Override
        public AIRecognizerResultBase parseAttachment(String dataText, AITemplate template, Attachment attachmentInfo) {
            AIRecognizerResultBase resultBase;
            if (StringUtils.isEmpty((String)dataText)) {
                throw new KDBizException("unspport parse. result is null on ai interface");
            }
            JSONObject jsonObject = JSONObject.parseObject((String)dataText);
            if ("0".equals(jsonObject.getString("errorCode"))) {
                JSONObject data = jsonObject.getJSONObject("data");
                if (data == null || data.isEmpty()) {
                    resultBase = new AIRecognizerErrorInfo(attachmentInfo.getFileName());
                } else {
                    String templateIdStr = data.getString("templateId");
                    String templateNumber = data.getString("templateNumber");
                    AITemplate matchTemplate = new AITemplate();
                    matchTemplate.setId(Long.parseLong(templateIdStr));
                    matchTemplate.setNumber(templateNumber);
                    JSONObject resultJson = data.getJSONObject("result");
                    HashMap<String, Object> detailMap = new HashMap<String, Object>(10);
                    Map headData = (Map)resultJson.getObject("recognitionArea", Map.class);
                    detailMap.putAll(headData);
                    JSONObject tableJson = resultJson.getJSONObject("table");
                    Set tableKeySet = tableJson.keySet();
                    for (String tableKey : tableKeySet) {
                        JSONArray tableDataArray = tableJson.getJSONArray(tableKey);
                        if (!CollectionUtils.isNotEmpty((Collection)tableDataArray)) continue;
                        JSONArray tableTitle = tableDataArray.getJSONArray(0);
                        int columnCount = tableTitle.size();
                        ArrayList dataList = new ArrayList(5);
                        for (int row = 1; row < tableDataArray.size(); ++row) {
                            JSONArray rowData = tableDataArray.getJSONArray(row);
                            HashMap<String, String> rowDataMap = new HashMap<String, String>(columnCount);
                            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                                rowDataMap.put(tableTitle.getString(columnIndex), rowData.getString(columnIndex));
                            }
                            dataList.add(rowDataMap);
                        }
                        detailMap.put(tableKey, dataList);
                    }
                    JSONObject confidenceJson = resultJson.getJSONObject("confidence");
                    HashMap<String, Object> confidenceMap = new HashMap<String, Object>(10);
                    if (confidenceJson != null) {
                        Map confidenceHeadData = (Map)confidenceJson.getObject("recognitionArea", Map.class);
                        confidenceMap.putAll(confidenceHeadData);
                        JSONObject confidenceTableJson = confidenceJson.getJSONObject("table");
                        if (confidenceTableJson != null) {
                            Set confidenceTableKeySet = confidenceTableJson.keySet();
                            for (String tableKey : confidenceTableKeySet) {
                                JSONArray realTableDataArray = tableJson.getJSONArray(tableKey);
                                JSONArray confidenceTableDataArray = confidenceTableJson.getJSONArray(tableKey);
                                if (realTableDataArray == null || realTableDataArray.isEmpty() || confidenceTableDataArray == null || confidenceTableDataArray.isEmpty()) continue;
                                JSONArray tableTitle = realTableDataArray.getJSONArray(0);
                                int columnCount = tableTitle.size();
                                ArrayList confidenceDataList = new ArrayList(10);
                                for (int row = 0; row < confidenceTableDataArray.size(); ++row) {
                                    JSONArray confidenceRowData = confidenceTableDataArray.getJSONArray(row);
                                    HashMap<String, String> confidenceRowDataMap = new HashMap<String, String>(columnCount);
                                    for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                                        confidenceRowDataMap.put(tableTitle.getString(columnIndex), confidenceRowData.getString(columnIndex));
                                    }
                                    confidenceDataList.add(confidenceRowDataMap);
                                }
                                confidenceMap.put(tableKey, confidenceDataList);
                            }
                        }
                    }
                    resultBase = new AIRecognizerSuccessInfo(attachmentInfo.getFileName(), matchTemplate, confidenceMap, detailMap);
                }
            } else {
                resultBase = new AIRecognizerErrorInfo(attachmentInfo.getFileName());
            }
            resultBase.setRequestId(jsonObject.getString("requestId"));
            resultBase.setErrorCode(jsonObject.getString("errorCode"));
            if (StringUtils.isEmpty((String)resultBase.getDescription())) {
                resultBase.setDescription(jsonObject.getString("description"));
            }
            return resultBase;
        }
    }
    ,
    WORD("4"){

        @Override
        public AIRecognizerResultBase parseAttachment(String dataText, AITemplate template, Attachment attachmentInfo) {
            AIRecognizerResultBase resultBase;
            if (StringUtils.isEmpty((String)dataText)) {
                throw new KDBizException("unspport parse. result is null on ai interface");
            }
            JSONObject jsonObject = JSONObject.parseObject((String)dataText);
            if ("0".equals(jsonObject.getString("errorCode"))) {
                HashMap<String, Object> dataDetailMap = new HashMap<String, Object>(2);
                JSONObject dataJson = jsonObject.getJSONObject("data");
                String allWord = dataJson.getString("combined_result");
                AIParam fieldQueryParam = new AIParam(CheckMethodEnum.PRESET, template.getId(), "", 0L, "", 0L, "", 0L, "idi_schema");
                List<AttachmentField> fieldList = AttachmentServiceFactory.getServiceInstance(CheckMethodEnum.PRESET).queryTemplateField(fieldQueryParam);
                if (CollectionUtils.isEmpty(fieldList)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u901a\u7528\u6587\u5b57\u5b57\u6bb5", (String)"AttachmentTypeEnum_0", (String)"data-idi-core", (Object[])new Object[0]));
                }
                if (fieldList.size() > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u901a\u7528\u6587\u5b57\u5b57\u6bb5\u5b58\u5728\u591a\u4e2a\uff0c\u9644\u4ef6\u5b57\u6bb5\u6570\u636e\u5f02\u5e38", (String)"AttachmentTypeEnum_1", (String)"data-idi-core", (Object[])new Object[0]));
                }
                AttachmentField af = fieldList.get(0);
                String fieldName = af.getName();
                dataDetailMap.put(fieldName, allWord);
                HashMap<String, Object> recognitionDataMap = new HashMap<String, Object>(2);
                recognitionDataMap.put(fieldName, 1);
                resultBase = new AIRecognizerSuccessInfo(attachmentInfo.getFileName(), template, recognitionDataMap, dataDetailMap);
            } else {
                resultBase = new AIRecognizerErrorInfo(attachmentInfo.getFileName(), template);
            }
            resultBase.setRequestId(jsonObject.getString("requestId"));
            resultBase.setErrorCode(jsonObject.getString("errorCode"));
            resultBase.setDescription(jsonObject.getString("description"));
            return resultBase;
        }
    };

    private String type;

    private AttachmentTypeEnum(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static AttachmentTypeEnum convertFromMatchType(String type) {
        if (type != null) {
            for (AttachmentTypeEnum e : AttachmentTypeEnum.values()) {
                if (!type.equals(e.type)) continue;
                return e;
            }
        }
        return null;
    }

    public static AttachmentTypeEnum getEnum(CheckMethodEnum checkMethodEnum, String templateNumber) {
        if (checkMethodEnum == CheckMethodEnum.CUSTOM) {
            return CUSTOMER;
        }
        if (checkMethodEnum == CheckMethodEnum.PRESET) {
            if ("OPM-GeneralSpotting".equals(templateNumber)) {
                return WORD;
            }
            if ("OPM-BankReceipt".equals(templateNumber)) {
                return BANK;
            }
        }
        return OTHER;
    }

    public AIRecognizerResultBase parseAttachment(String dataText, AITemplate template, Attachment attachmentInfo) {
        AIRecognizerResultBase resultBase;
        if (StringUtils.isEmpty((String)dataText)) {
            throw new KDBizException("unspport parse. result is null on ai interface");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)dataText);
        if ("0".equals(jsonObject.getString("errorCode"))) {
            Map dataDetailMap = (Map)jsonObject.getObject("data", Map.class);
            JSONObject dataJson = jsonObject.getJSONObject("data");
            Map recognitionDataMap = (Map)dataJson.getObject("confidence", Map.class);
            dataDetailMap.remove("confidence");
            resultBase = new AIRecognizerSuccessInfo(attachmentInfo.getFileName(), template, recognitionDataMap, dataDetailMap);
        } else {
            resultBase = new AIRecognizerErrorInfo(attachmentInfo.getFileName(), template);
        }
        resultBase.setRequestId(jsonObject.getString("requestId"));
        resultBase.setErrorCode(jsonObject.getString("errorCode"));
        resultBase.setDescription(jsonObject.getString("description"));
        return resultBase;
    }
}

