/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.attachment;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.data.idi.engine.attachment.AIParam;
import kd.data.idi.engine.attachment.AIRecognizerParam;
import kd.data.idi.engine.attachment.Attachment;
import kd.data.idi.engine.attachment.AttachmentField;

public interface IAttachmentService<T> {
    public List<AttachmentField> queryTemplateField(AIParam var1);

    default public List<Attachment> queryAttachmentInfo(Long billId, String billType, boolean decrypt) {
        ArrayList<Attachment> list = new ArrayList<Attachment>(10);
        Map panelAttachmentMap = AttachmentServiceHelper.getAttachmentsForApi((String)billType, (Object)String.valueOf(billId));
        if (panelAttachmentMap == null || panelAttachmentMap.isEmpty()) {
            return list;
        }
        Set panelAttachmentSet = panelAttachmentMap.entrySet();
        Map.Entry entry = panelAttachmentSet.iterator().next();
        String panelKey = (String)entry.getKey();
        List attachments = AttachmentServiceHelper.getAttachments((String)billType, (Object)String.valueOf(billId), (String)panelKey, (boolean)decrypt);
        for (Map attachment : attachments) {
            String filePath = null;
            if (!decrypt) {
                String url = (String)attachment.get("url");
                String path = url.substring(url.indexOf("path=") + 6);
                try {
                    filePath = URLDecoder.decode(path, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
                }
            }
            Attachment attachmentInfo = new Attachment((String)attachment.get("uid"), (String)attachment.get("url"), (String)attachment.get("type"), (String)attachment.get("name"), (Long)attachment.get("size"), filePath, panelKey);
            attachmentInfo.buildFileMD5();
            list.add(attachmentInfo);
        }
        return list;
    }

    public T recognizer(AIRecognizerParam var1);
}

