/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.courier.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.data.idi.api.external.IExternalApiAbutment;
import kd.data.idi.api.external.impl.CourierLogisticsApiAbutmentImpl;
import kd.data.idi.api.external.impl.UrlParam;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.engine.IDITaskManager;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.courier.service.CourierLogisticParser;
import kd.data.idi.engine.courier.service.CourierParam;
import kd.data.idi.engine.courier.service.ICourierService;

public class CourierServiceImpl
implements ICourierService {
    @Override
    public List<DynamicObject> query(List<CourierParam> params) {
        Future checkFuture;
        if (params == null || params.isEmpty()) {
            return null;
        }
        int size = params.size();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(size);
        RequestContext context = RequestContext.get();
        SchemaContext sc = SchemaContext.get();
        CourierLogisticsApiAbutmentImpl courierLogisticsApiAbutment = new CourierLogisticsApiAbutmentImpl();
        UrlParam urlParam = courierLogisticsApiAbutment.getUrlParam("KDGJ", null);
        SchemaExecutorLogger.info("param for execute query :" + params, new Object[0]);
        long beginTime = System.currentTimeMillis();
        LinkedBlockingDeque<Future<DynamicObject>> futureList = new LinkedBlockingDeque<Future<DynamicObject>>(params.size());
        HashMap<Future<DynamicObject>, CourierParam> futureMap = new HashMap<Future<DynamicObject>, CourierParam>(params.size());
        for (CourierParam param : params) {
            CourierQueryTask courierTask = new CourierQueryTask(param, urlParam, context, courierLogisticsApiAbutment, sc);
            Future<DynamicObject> future = IDITaskManager.submitCourier(courierTask, context);
            futureList.push(future);
            futureMap.put(future, param);
        }
        while (!futureList.isEmpty() && (checkFuture = (Future)futureList.pop()) != null) {
            try {
                DynamicObject data = (DynamicObject)checkFuture.get(30L, TimeUnit.SECONDS);
                if (data == null) continue;
                result.add(data);
            }
            catch (Exception e) {
                String errorMessage = e.getMessage();
                if (StringUtils.isNotEmpty((String)errorMessage) && errorMessage.contains("KDBizException")) {
                    errorMessage = errorMessage.substring(errorMessage.lastIndexOf(": ") + ": ".length());
                }
                checkFuture.cancel(true);
                SchemaExecutorLogger.error(e);
                CourierParam param = (CourierParam)futureMap.get(checkFuture);
                errorMessage = errorMessage.length() > 255 ? errorMessage.substring(0, 255) : errorMessage;
                DynamicObject error = CourierLogisticParser.createError(errorMessage, param);
                result.add(error);
            }
        }
        SchemaExecutorLogger.info("cost time:" + (System.currentTimeMillis() - beginTime), new Object[0]);
        return result;
    }

    protected static class CourierQueryTask
    implements Callable<DynamicObject> {
        private CourierParam param;
        private UrlParam urlParam;
        private RequestContext taskContext;
        private IExternalApiAbutment<CourierParam, DynamicObject> courierLogisticsApiAbutment;
        private SchemaContext schemaContext;

        public CourierQueryTask(CourierParam param, UrlParam urlParam, RequestContext taskContext, IExternalApiAbutment<CourierParam, DynamicObject> courierLogisticsApiAbutment, SchemaContext schemaContext) {
            this.param = param;
            this.urlParam = urlParam;
            this.taskContext = taskContext;
            this.courierLogisticsApiAbutment = courierLogisticsApiAbutment;
            this.schemaContext = schemaContext;
        }

        @Override
        public DynamicObject call() throws Exception {
            SchemaContext.create(this.schemaContext);
            DynamicObject result = null;
            try {
                RequestContext.copyAndSet((RequestContext)this.taskContext);
                String content = this.courierLogisticsApiAbutment.apiAction(this.urlParam, this.param);
                result = this.courierLogisticsApiAbutment.parseResult(content, this.param);
            }
            catch (Exception e) {
                SchemaExecutorLogger.error(e);
                throw e;
            }
            finally {
                SchemaContext.remove();
            }
            return result;
        }
    }
}

