/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.customrule;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.engine.BillCheckResult;
import kd.data.idi.engine.BillLinkRelation;
import kd.data.idi.engine.DeductionGrade;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptLocaleFieldHandler;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.customrule.EntryRowRelation;
import kd.data.idi.engine.customrule.EntryRowRelationDTO;

public class NoEntryRowRelation {
    private static final int MAX_SRC_ENTRY_SIZE = 2000;

    public static EntryRowRelationDTO checkExecute(SchemaContext context, Decision decision, List<BillLinkRelation> relations, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, Map<Integer, List<BillCheckResult>> ruleBillMap, List<LinkUpBillResult> linkUpBillResults, DeductionGrade deductionGrade, Map<String, Object> funcValueMap) {
        EntryRowRelationDTO relationDTO = null;
        String srcEntityTypeNumber = context.getEntityType();
        MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)srcEntityTypeNumber);
        IDICondition crossEntryRule = decision.getLinkUpBillConfig().getCrossEntryRule();
        String script = NoEntryRowRelation.buildScript(decision.getRules());
        Set<String> srcEntryNumberSet = ScriptUtils.getLeastLevelEntries(srcEntityType, script, new String[]{srcEntityTypeNumber});
        if (srcEntryNumberSet.size() > 2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301\u8de82\u4e2a\u5206\u5f55\u3001\u5b50\u5206\u5f55\uff0c\u8bf7\u4fee\u6539\u68c0\u67e5\u89c4\u5219\u3002", (String)"NoEntryRowRelation_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        DynamicObject srcBillObj = context.getSelfBill();
        String entity = context.getEntityType();
        if (srcEntryNumberSet.size() == 2) {
            ArrayList<String> entryNumberList = new ArrayList<String>(srcEntryNumberSet);
            if (crossEntryRule != null && !funcValueMap.isEmpty()) {
                relationDTO = EntryRowRelation.getEntryRowIndexRelation(crossEntryRule, srcBillObj, entity, startConditionEntry, matchStartConditionEntryIndexList, linkUpBillResults, decision, context.isBillControl());
            } else {
                if (!context.isBillControl()) {
                    srcBillObj = BusinessDataServiceHelper.loadSingle((Object)srcBillObj.get("id"), (String)srcBillObj.getDynamicObjectType().getName());
                }
                relationDTO = NoEntryRowRelation.getEntryRowRelationDTO(entryNumberList.get(0), entryNumberList.get(1), srcBillObj, entity, startConditionEntry, matchStartConditionEntryIndexList);
            }
            int totalCount = relationDTO.getDataCount();
            int matchStartConditionEntryRow = Math.min(Math.max(1, totalCount), 2000);
            BigDecimal percent = DecisionResult.HUNDRED.divide(BigDecimal.valueOf(matchStartConditionEntryRow, 0), 6, RoundingMode.HALF_UP);
            block0: for (BillLinkRelation relation : relations) {
                ScriptLocaleFieldHandler localeFieldHandler = new ScriptLocaleFieldHandler();
                String[] billTypes = new String[]{srcEntityTypeNumber};
                String srcLocaleScript = localeFieldHandler.processLocaleField(script, billTypes, relation.getSrcBillObj());
                srcLocaleScript = srcLocaleScript.replaceAll(" ", "");
                if (!funcValueMap.isEmpty()) {
                    for (Map.Entry<String, Object> replaceEntry : funcValueMap.entrySet()) {
                        srcLocaleScript = srcLocaleScript.replace(replaceEntry.getKey(), replaceEntry.getValue().toString());
                    }
                }
                SchemaExecutorLogger.info("process localeString in srcbill. Decision Rule Script  : %s", srcLocaleScript);
                LinkedHashMap<Integer, Set<Integer>> entryIdMap = relationDTO.getEntryIdMap();
                String entryFlag = relationDTO.getEntryFlag();
                String targetEntryFlag = relationDTO.getTargetEntryFlag();
                boolean notEntryFlag = false;
                boolean notTargetEntryFlag = false;
                if (!srcLocaleScript.contains(entryFlag)) {
                    notEntryFlag = true;
                }
                if (!srcLocaleScript.contains(targetEntryFlag)) {
                    notTargetEntryFlag = true;
                }
                if (notEntryFlag && notTargetEntryFlag) {
                    for (Map.Entry entry : entryIdMap.entrySet()) {
                        Set value = (Set)entry.getValue();
                        Integer keyIndex = (Integer)entry.getKey();
                        for (Integer valueIndex : value) {
                            String srcExecuteScript = ScriptUtils.replaceEntryIndex(srcLocaleScript, entryFlag, keyIndex, targetEntryFlag, valueIndex);
                            boolean matchedEntry = NoEntryRowRelation.executeRule(srcBillObj, srcEntityTypeNumber, relationDTO.getEntryFlag(), entryIdMap.size(), keyIndex, relationDTO.getTargetEntryFlag(), value.size(), valueIndex, srcExecuteScript, percent, ruleBillMap, linkUpBillResults, decision, deductionGrade);
                            if (!matchedEntry) {
                                deductionGrade.deduct(decision.getLinkUpBillConfig().getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.NO_MATCH_RULE, percent);
                            }
                            if (!NoEntryRowRelation.isOutOfCount(linkUpBillResults, ruleBillMap)) continue;
                            break block0;
                        }
                    }
                    continue;
                }
                HashSet<Integer> keyIndexSet = new HashSet<Integer>(10);
                HashSet<Integer> valueIndexSet = new HashSet<Integer>(10);
                for (Map.Entry entry : entryIdMap.entrySet()) {
                    Set value = (Set)entry.getValue();
                    Integer keyIndex = (Integer)entry.getKey();
                    for (Integer valueIndex : value) {
                        if (keyIndexSet.contains(keyIndex) || valueIndexSet.contains(valueIndex)) continue;
                        if (notEntryFlag) {
                            keyIndexSet.add(keyIndex);
                        }
                        if (notTargetEntryFlag) {
                            valueIndexSet.add(valueIndex);
                        }
                        String srcExecuteScript = ScriptUtils.replaceEntryIndex(srcLocaleScript, entryFlag, keyIndex, targetEntryFlag, valueIndex);
                        boolean matchedEntry = NoEntryRowRelation.executeRule(srcBillObj, srcEntityTypeNumber, relationDTO.getEntryFlag(), entryIdMap.size(), keyIndex, relationDTO.getTargetEntryFlag(), value.size(), valueIndex, srcExecuteScript, percent, ruleBillMap, linkUpBillResults, decision, deductionGrade);
                        if (!matchedEntry) {
                            deductionGrade.deduct(decision.getLinkUpBillConfig().getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.NO_MATCH_RULE, percent);
                        }
                        if (!NoEntryRowRelation.isOutOfCount(linkUpBillResults, ruleBillMap)) continue;
                        break block0;
                    }
                }
            }
        }
        return relationDTO;
    }

    public static boolean isOutOfCount(List<LinkUpBillResult> results, Map<Integer, List<BillCheckResult>> ruleBillMap) {
        int count = 0;
        for (LinkUpBillResult billResult : results) {
            if (billResult.isPass()) continue;
            ++count;
        }
        int resultCount = 0;
        for (List<BillCheckResult> list : ruleBillMap.values()) {
            resultCount += list.size();
        }
        return count > 100 || resultCount > 100;
    }

    public static boolean executeRule(DynamicObject srcBill, String srcEntityTypeNumber, String srcEntryName, int srcEntrySize, int srcIndex, String secondEntryName, int secondEntrySize, int secondIndex, String exeScript, BigDecimal percent, Map<Integer, List<BillCheckResult>> ruleBillMap, List<LinkUpBillResult> linkUpBillResults, Decision decision, DeductionGrade deductionGrade) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        SchemaExecutorLogger.info("Decision Rule Script : %s", exeScript);
        ctx.put(srcEntityTypeNumber + "_billObj", srcBill);
        ScriptFormIdHandler.runScript(srcEntityTypeNumber, null, ctx, exeScript);
        boolean matched = false;
        Object matchRuleIndexObj = ctx.get("__MatchRuleIndex__");
        if (matchRuleIndexObj != null) {
            BillCheckResult billCheckResult = new BillCheckResult();
            billCheckResult.setSrcObj(srcBill);
            billCheckResult.setSrcEntryName(srcEntryName);
            billCheckResult.setSrcEntryIndex(srcEntrySize > 0 ? srcIndex : -1);
            billCheckResult.setLinkObj(srcBill);
            billCheckResult.setLinkEntryName(secondEntryName);
            billCheckResult.setLinkEntryIndex(secondEntrySize > 0 ? secondIndex : -1);
            int matchRuleIndex = Integer.parseInt(matchRuleIndexObj.toString());
            LinkUpBillResult billResult = null;
            for (LinkUpBillResult result1 : linkUpBillResults) {
                if (result1.getMatchRule() != matchRuleIndex) continue;
                billResult = result1;
                break;
            }
            DecisionRule decisionRule = decision.getRules().get(matchRuleIndex);
            if (billResult == null) {
                billResult = new LinkUpBillResult();
                billResult.setMatchRule(matchRuleIndex);
                billResult.setPass(decisionRule.isPass());
                billResult.setShowText(decisionRule.achieveName());
                billResult.setStatus(decisionRule.getDecisionStatus());
                linkUpBillResults.add(billResult);
            }
            BigDecimal deductPercent = deductionGrade.deductPercent(decisionRule.getDeductionGradePercent(), percent);
            billResult.addDeductPercent(deductPercent);
            billCheckResult.setDeductPercent(deductPercent);
            ruleBillMap.computeIfAbsent(matchRuleIndex, k -> new ArrayList()).add(billCheckResult);
            matched = true;
        }
        return matched;
    }

    public static EntryRowRelationDTO getEntryRowRelationDTO(String firstEntryNumber, String secondEntryNumber, DynamicObject srcBillObj, String entityType, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList) {
        EntryRowRelationDTO relationDTO;
        block12: {
            Map allEntities;
            block11: {
                relationDTO = new EntryRowRelationDTO();
                allEntities = EntityMetadataCache.getDataEntityType((String)entityType).getAllEntities();
                boolean trueSubEntry = false;
                String parentEntryNumber = null;
                String subEntryNumber = null;
                if (secondEntryNumber.equals(((EntityType)allEntities.get(firstEntryNumber)).getParent().getName()) || firstEntryNumber.equals(((EntityType)allEntities.get(secondEntryNumber)).getParent().getName())) {
                    trueSubEntry = true;
                    parentEntryNumber = allEntities.get(firstEntryNumber) instanceof SubEntryType ? secondEntryNumber : firstEntryNumber;
                    String string = subEntryNumber = allEntities.get(firstEntryNumber) instanceof SubEntryType ? firstEntryNumber : secondEntryNumber;
                }
                if (!trueSubEntry) break block11;
                DynamicObjectCollection parentEntry = srcBillObj.getDynamicObjectCollection(parentEntryNumber);
                relationDTO.setEntryFlag(parentEntryNumber);
                relationDTO.setTargetEntryFlag(subEntryNumber);
                relationDTO.addSubParentEntryMap(subEntryNumber, parentEntryNumber);
                relationDTO.setTrueSubEntry(true);
                relationDTO.addEntryCollectionMap(parentEntryNumber, parentEntry);
                block0: for (int parentIndex = 0; parentIndex < parentEntry.size(); ++parentIndex) {
                    DynamicObject parentObj = (DynamicObject)parentEntry.get(parentIndex);
                    DynamicObjectCollection subEntry = parentObj.getDynamicObjectCollection(subEntryNumber);
                    relationDTO.addTrueSubEntryCollection(parentIndex, subEntry);
                    for (int subIndex = 0; subIndex < subEntry.size(); ++subIndex) {
                        if (startConditionEntry != null && !matchStartConditionEntryIndexList.isEmpty()) {
                            if (startConditionEntry.equals(parentEntryNumber) && !matchStartConditionEntryIndexList.contains(parentIndex)) continue block0;
                            if (startConditionEntry.equals(subEntryNumber) && !matchStartConditionEntryIndexList.contains(subIndex)) continue;
                        }
                        relationDTO.addEntryIdMap(parentIndex, subIndex);
                    }
                }
                break block12;
            }
            relationDTO.setEntryFlag(firstEntryNumber);
            relationDTO.setTargetEntryFlag(secondEntryNumber);
            DynamicObjectCollection firstEntry = null;
            DynamicObjectCollection secondEntry = null;
            if (allEntities.get(firstEntryNumber) instanceof SubEntryType) {
                String fieldParentName = ((EntityType)allEntities.get(firstEntryNumber)).getParent().getName();
                firstEntry = relationDTO.gatherSubEntryData(srcBillObj, fieldParentName, firstEntryNumber, firstEntry);
            } else {
                firstEntry = srcBillObj.getDynamicObjectCollection(firstEntryNumber);
            }
            if (allEntities.get(secondEntryNumber) instanceof SubEntryType) {
                String valueParentName = ((EntityType)allEntities.get(secondEntryNumber)).getParent().getName();
                secondEntry = relationDTO.gatherSubEntryData(srcBillObj, valueParentName, secondEntryNumber, secondEntry);
            } else {
                secondEntry = srcBillObj.getDynamicObjectCollection(secondEntryNumber);
            }
            relationDTO.addEntryCollectionMap(firstEntryNumber, firstEntry);
            relationDTO.addEntryCollectionMap(secondEntryNumber, secondEntry);
            Map<String, String> subParentEntryMap = relationDTO.getSubParentEntryMap();
            Map<String, Map<Integer, Integer>> parentEntryIndexMap = relationDTO.getParentEntryIndexMap();
            if (firstEntry == null || secondEntry == null) break block12;
            block2: for (int firstIndex = 0; firstIndex < firstEntry.size(); ++firstIndex) {
                for (int secondIndex = 0; secondIndex < secondEntry.size(); ++secondIndex) {
                    if (startConditionEntry != null && !matchStartConditionEntryIndexList.isEmpty()) {
                        if (startConditionEntry.equals(firstEntryNumber) && !matchStartConditionEntryIndexList.contains(firstIndex) || startConditionEntry.equals(subParentEntryMap.get(firstEntryNumber)) && parentEntryIndexMap.get(startConditionEntry) != null && !matchStartConditionEntryIndexList.contains(parentEntryIndexMap.get(startConditionEntry).get(firstIndex))) continue block2;
                        if (startConditionEntry.equals(secondEntryNumber) && !matchStartConditionEntryIndexList.contains(secondIndex) || startConditionEntry.equals(subParentEntryMap.get(secondEntryNumber)) && parentEntryIndexMap.get(startConditionEntry) != null && !matchStartConditionEntryIndexList.contains(parentEntryIndexMap.get(startConditionEntry).get(secondIndex))) continue;
                    }
                    relationDTO.addEntryIdMap(firstIndex, secondIndex);
                }
            }
        }
        return relationDTO;
    }

    public static String buildScript(List<DecisionRule> ruleList) {
        if (ruleList == null) {
            return "";
        }
        StringBuilder scriptBuilder = new StringBuilder();
        int defaultScore = -1;
        int defaultRuleIndex = -1;
        int ruleIndex = -1;
        for (DecisionRule rule : ruleList) {
            ++ruleIndex;
            String expr = NoEntryRowRelation.buildExpr(rule.getRule());
            if (StringUtils.isEmpty((String)expr)) {
                if (defaultScore >= 0) continue;
                defaultScore = rule.getDeductionGradePercent();
                defaultRuleIndex = ruleIndex;
                continue;
            }
            String preScript = String.format("__MatchRuleIndex__=%d;", ruleIndex);
            if (rule.isCheckVote()) {
                preScript = preScript + "__OneVoteVeto__=\"true\";";
            }
            String ifStm = String.format("if (%s) {\n  %s return \"\";\n}\n", expr, preScript, rule.getDeductionGradePercent());
            scriptBuilder.append(ifStm);
        }
        if (defaultScore >= 0) {
            scriptBuilder.append("__MatchRuleIndex__=").append(defaultRuleIndex).append(";\n");
            scriptBuilder.append("return ").append(defaultScore).append(';');
        }
        return scriptBuilder.toString();
    }

    public static String buildExpr(IDICondition condition) {
        if (condition == null) {
            return "";
        }
        return condition.getScript();
    }
}

