/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.functions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.customrule.EntryRowRelationDTO;
import kd.data.idi.engine.functions.CustomFuncEnum;
import kd.data.idi.engine.functions.CustomFuncInfoChain;
import kd.data.idi.engine.functions.CustomFuncSpecialDeal;
import kd.data.idi.util.MetadataUtil;

public class SumEntryFunc {
    private static final String sumEntryFunc = "sum_entry";

    public static void dealFunc(CustomFuncInfoChain customFuncChain, DynamicObject srcObj, DynamicObject targetObj, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, EntryRowRelationDTO entryRowIndexRelationDto, MainEntityType targetMainType) {
        String regex = sumEntryFunc;
        String script = customFuncChain.getDealScript();
        Map<String, Object> funcValueMap = customFuncChain.getFuncValueMap();
        Map<String, Object> intactFuncValueMap = customFuncChain.getIntactFuncValueMap();
        Set<String> entrySet = customFuncChain.getEntrySet();
        String srcEntity = srcObj.getDataEntityType().getName();
        MainEntityType srcMainType = null;
        String targetEntity = targetObj != null ? targetObj.getDataEntityType().getName() : null;
        String[] extractCustomAns = new String[4];
        extractCustomAns[3] = "0";
        while (extractCustomAns[3] != null && (extractCustomAns = ScriptUtils.extractCustomFunc(script, regex, Integer.parseInt(extractCustomAns[3])))[1] != null) {
            srcMainType = srcMainType == null ? EntityMetadataCache.getDataEntityType((String)srcEntity) : srcMainType;
            String beforeSpecialDealScript = extractCustomAns[1];
            String funcStr = CustomFuncSpecialDeal.specialDeal(beforeSpecialDealScript.replace(" ", ""));
            String funcInnerStr = funcStr.substring(0, funcStr.length() - 1).replace("sum_entry(", "");
            String billEntity = funcInnerStr.substring(0, funcInnerStr.indexOf("_billObj"));
            boolean isSourceBill = billEntity.equals(srcEntity);
            if (isSourceBill) {
                entrySet.addAll(ScriptUtils.getEntries(srcMainType, funcInnerStr, new String[]{srcEntity}));
            } else {
                if (targetEntity == null) continue;
                entrySet.addAll(ScriptUtils.getEntries(targetMainType, funcInnerStr.startsWith("targetisself_") ? funcInnerStr.replace("targetisself_", "") : funcInnerStr, new String[]{targetEntity}));
            }
            String[] split = funcInnerStr.split(",");
            int scale = 2;
            String key = funcStr;
            if (split.length == 2) {
                scale = Math.min(Integer.parseInt(split[1]), 10);
                key = CustomFuncEnum.SUM_ENTRY.getFuncName() + "(" + split[0] + ")";
            }
            Map<String, String> entryInfoMap = MetadataUtil.getEntryMapByScriptStr(isSourceBill ? srcMainType : targetMainType, split.length == 2 ? split[0] : funcInnerStr);
            List<Object> fieldValueList = isSourceBill ? MetadataUtil.getFieldValueList(srcObj, entryInfoMap, startConditionEntry, matchStartConditionEntryIndexList, entryRowIndexRelationDto) : MetadataUtil.getFieldValueList(targetObj, entryInfoMap, null, null, null);
            BigDecimal sumValue = SumEntryFunc.sumField(fieldValueList, scale);
            if (isSourceBill) {
                funcValueMap.put(key, sumValue);
                intactFuncValueMap.put(funcStr, sumValue);
            } else {
                Map targetSumDataMap = (Map)funcValueMap.computeIfAbsent(key, k -> new HashMap(2));
                targetSumDataMap.put(targetObj, sumValue);
                targetSumDataMap = (Map)intactFuncValueMap.computeIfAbsent(funcStr, k -> new HashMap(2));
                targetSumDataMap.put(targetObj, sumValue);
            }
            String funcValue = sumValue.toString();
            ScriptUtils.replaceStartIndexAndNewValue(funcValue, extractCustomAns);
            script = ScriptUtils.assembleArray(extractCustomAns);
        }
        customFuncChain.setDealScript(script);
    }

    public static BigDecimal sumField(List<Object> fieldValueList, int scale) {
        BigDecimal fieldSumValue = BigDecimal.ZERO;
        try {
            for (Object val : fieldValueList) {
                BigDecimal decimalVal = null;
                if (val instanceof BigDecimal) {
                    decimalVal = (BigDecimal)val;
                } else if (val instanceof String) {
                    decimalVal = new BigDecimal((String)val);
                } else if (val instanceof BigInteger) {
                    decimalVal = new BigDecimal((BigInteger)val);
                } else if (val instanceof Number) {
                    decimalVal = BigDecimal.valueOf(((Number)val).doubleValue());
                }
                if (decimalVal == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"sum_entry\u51fd\u6570\u4ec5\u652f\u6301\u5bf9\u6570\u503c\u7c7b\u578b\u5b57\u6bb5\u6c42\u548c\u3002", (String)"SumEntryFunc_0", (String)"data-idi-core", (Object[])new Object[0]));
                }
                fieldSumValue = fieldSumValue.add(decimalVal);
            }
        }
        catch (Exception ex) {
            throw new KDBizException(ResManager.loadKDString((String)"sum_entry\u51fd\u6570\u4ec5\u652f\u6301\u5bf9\u6570\u503c\u7c7b\u578b\u5b57\u6bb5\u6c42\u548c\u3002", (String)"SumEntryFunc_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        return fieldSumValue.setScale(scale, 4);
    }
}

