/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.export.DynamicExImport;

public abstract class DynamicExImportProcessor {
    protected final Map<String, Map<Object, DynamicObject>> dynMaps = new LinkedHashMap<String, Map<Object, DynamicObject>>();
    protected final List<DynamicExImport> exImportList = new ArrayList<DynamicExImport>();
    protected final Object[] primaryKeyValues;

    protected abstract void setExImportList(List<DynamicExImport> var1);

    public DynamicExImportProcessor(Object[] primaryKeyValues) {
        this.primaryKeyValues = primaryKeyValues;
        this.init();
    }

    protected final void init() {
        this.setExImportList(this.exImportList);
    }

    public OperationResult executeSave() {
        for (DynamicExImport exImport : this.exImportList) {
            try {
                Map<Object, DynamicObject> objectMap;
                if (!exImport.byImport() || (objectMap = this.dynMaps.get(exImport.getKey())) == null) continue;
                Collection<DynamicObject> values = objectMap.values();
                return OperationServiceHelper.executeOperate((String)"save", (String)exImport.getEntityName(), (DynamicObject[])values.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
            catch (Exception ex) {
                SchemaExecutorLogger.error("import schema save error", ex);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s:\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff0c%2$s\u3002", (String)"DynamicExImportProcessor_0", (String)"data-idi-core", (Object[])new Object[0]), exImport.getTip(), ex.getMessage()));
            }
        }
        return new OperationResult();
    }
}

