/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.export.schema;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.export.DynamicExImport;
import kd.data.idi.export.schema.SchemaExImportProcessor;
import org.apache.commons.io.IOUtils;

public class SchemaImportParser
extends SchemaExImportProcessor {
    public static SchemaImportParser create(String url) {
        List<String> dataList = SchemaImportParser.parseTemplateFile(url);
        long[] ids = DB.genGlobalLongIds((int)dataList.size());
        Object[] primaryKeyValues = new Object[dataList.size()];
        for (int i = 0; i < ids.length; ++i) {
            primaryKeyValues[i] = ids[i];
        }
        return new SchemaImportParser(dataList, primaryKeyValues);
    }

    public SchemaImportParser(List<String> dataList, Object[] primaryKeyValues) {
        super(primaryKeyValues);
        for (int i = 0; i < this.exImportList.size(); ++i) {
            if (dataList.size() <= i) continue;
            DynamicExImport exImport = (DynamicExImport)this.exImportList.get(i);
            exImport.importString(dataList.get(i));
        }
    }

    public static List<String> parseTemplateFile(String url) {
        List list;
        InputStream in = null;
        try {
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            in = tempFileCache.getInputStream(url);
            list = IOUtils.readLines((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            try {
                SchemaExecutorLogger.error("parseTemplateFile error", e);
                throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SchemaImportParser_0", (String)"data-idi-core", (Object[])new Object[0]));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return list;
    }
}

