/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.mq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.mq.IDIMqMessagePublisher;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.InvoiceParser;

public class InvoiceConsumer
implements MessageConsumer {
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker messageAcker) {
        block12: {
            try {
                SchemaExecutorLogger.info(String.valueOf(body), new Object[0]);
                if (body instanceof Map) {
                    String type;
                    Map dataMap = (Map)body;
                    switch (type = (String)dataMap.get("type")) {
                        case "single": {
                            this.doSingleInvoice(dataMap, messageId, messageAcker);
                            break;
                        }
                        case "batch": {
                            this.doBatchInvoice(dataMap, messageId, messageAcker);
                            break;
                        }
                        default: {
                            throw new KDBizException("unsupport type" + type);
                        }
                    }
                    break block12;
                }
                throw new KDBizException("unsupport param type:" + body.getClass().getName());
            }
            catch (Throwable e) {
                if (resend) {
                    messageAcker.discard(messageId);
                }
                messageAcker.deny(messageId);
            }
        }
    }

    private void doBatchInvoice(Map<?, ?> dataMap, String messageId, MessageAcker messageAcker) {
        String dataStr = (String)dataMap.get("dataStr");
        boolean needDelete = Boolean.parseBoolean((String)dataMap.get("needDelete"));
        if (StringUtils.isNotEmpty((String)dataStr)) {
            List invoiceDataList = IDIJSONUtils.jsonCastToList((String)dataStr, IDIMqMessagePublisher.BatchInvoiceParam.class);
            if (CollectionUtils.isEmpty((Collection)invoiceDataList)) {
                messageAcker.ack(messageId);
                return;
            }
            ArrayList<DynamicObject> allInvoiceObjList = new ArrayList<DynamicObject>(10);
            for (IDIMqMessagePublisher.BatchInvoiceParam batchInvoiceParam : invoiceDataList) {
                String billId = batchInvoiceParam.getBillId();
                List<String> dataStrList = batchInvoiceParam.getInvoiceDataStrList();
                String clientId = batchInvoiceParam.getClientId();
                String secret = batchInvoiceParam.getSecret();
                String billType = batchInvoiceParam.getBillType();
                String bxdKey = batchInvoiceParam.getBxdKey();
                if (CollectionUtils.isEmpty(dataStrList)) continue;
                for (String invoiceDataStr : dataStrList) {
                    List<DynamicObject> invoiceObjList = InvoiceParser.parseInvoiceResult(invoiceDataStr, billId);
                    if (CollectionUtils.isEmpty(invoiceObjList)) continue;
                    if (StringUtils.isNotEmpty((String)clientId) && StringUtils.isNotEmpty((String)secret) && StringUtils.isNotEmpty((String)billType) && StringUtils.isNotEmpty((String)bxdKey)) {
                        for (DynamicObject invoiceDynamicObject : invoiceObjList) {
                            invoiceDynamicObject.set("clientid", (Object)clientId);
                            invoiceDynamicObject.set("secret", (Object)secret);
                            invoiceDynamicObject.set("bxdkey", (Object)bxdKey);
                            invoiceDynamicObject.set("billtype", (Object)billType);
                        }
                    }
                    allInvoiceObjList.addAll(invoiceObjList);
                }
            }
            if (needDelete) {
                Object[] ids = invoiceDataList.stream().map(IDIMqMessagePublisher.BatchInvoiceParam::getBillId).toArray();
                DeleteServiceHelper.delete((String)"idi_invoice", (QFilter[])new QFilter[]{new QFilter("billid", "in", (Object)ids)});
            }
            SaveServiceHelper.save((DynamicObject[])allInvoiceObjList.toArray(new DynamicObject[0]));
            messageAcker.ack(messageId);
        }
    }

    private void doSingleInvoice(Map<?, ?> dataMap, String messageId, MessageAcker messageAcker) {
        String billId = (String)dataMap.get("billId");
        String dataStr = (String)dataMap.get("dataStr");
        String clientId = (String)dataMap.get("clientId");
        String secret = (String)dataMap.get("secret");
        String billType = (String)dataMap.get("billType");
        boolean needDelete = Boolean.parseBoolean((String)dataMap.get("needDelete"));
        if (needDelete) {
            DeleteServiceHelper.delete((String)"idi_invoice", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)billId)});
        }
        List<DynamicObject> invoiceDataList = InvoiceParser.parseInvoiceResult(dataStr, billId);
        for (DynamicObject invoiceDynamicObject : invoiceDataList) {
            invoiceDynamicObject.set("clientid", (Object)clientId);
            invoiceDynamicObject.set("secret", (Object)secret);
            invoiceDynamicObject.set("billtype", (Object)billType);
        }
        SaveServiceHelper.save((DynamicObject[])invoiceDataList.toArray(new DynamicObject[0]));
        messageAcker.ack(messageId);
    }
}

