/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.idi.data.IDICoreConstant;
import kd.data.idi.data.attachment.AttachmentFieldTypeEnum;
import kd.data.idi.data.attachment.LcDataDetail;
import kd.data.idi.data.attachment.LcField;
import kd.data.idi.data.attachment.LcProcessResult;
import kd.data.idi.data.attachment.OriginAttachRecord;
import kd.data.idi.data.attachment.ProcessAttachRecord;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.attachment.AIRecognizerSuccessInfo;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.Attachment;
import kd.data.idi.engine.attachment.AttachmentDataSourceEnum;
import kd.data.idi.util.AttachmentFieldValueHelper;

public class AttachmentResultRecordHelper {
    private static final long lockTimeMills = 120000L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AIRecognizerSuccessInfo getAiRecord(Long templateId, String fileMd5) {
        QFilter filter = new QFilter("filemd5", "=", (Object)fileMd5).and("datasource", "=", (Object)AttachmentDataSourceEnum.AI.getDataSource());
        if (templateId != null) {
            filter.and("templateid", "=", (Object)templateId);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AttachmentResultRecordHelper.getAiRecord", (String)"idi_processattachrecord", (String)"processresult_tag", (QFilter[])filter.toArray(), (String)"id desc", (int)1);){
            if (dataSet == null) return null;
            if (!dataSet.hasNext()) return null;
            Row next = dataSet.next();
            String processJson = next.getString("processresult_tag");
            if (processJson == null) return null;
            if (processJson.isEmpty()) return null;
            AIRecognizerSuccessInfo aIRecognizerSuccessInfo = (AIRecognizerSuccessInfo)JSON.parseObject((String)processJson, (TypeReference)new TypeReference<AIRecognizerSuccessInfo>(){}, (Feature[])new Feature[0]);
            return aIRecognizerSuccessInfo;
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error("AttachmentResultRecordHelper getAiRecord error", ex);
        }
        return null;
    }

    public static List<LcDataDetail> getLcRecord(Map<Long, Set<String>> templateAndFieldMap, Map<Long, AITemplate> templateMap, List<Attachment> fileList, Map<Long, Map<String, Set<String>>> existFieldMap) {
        try {
            HashSet<String> fileMd5Set = new HashSet<String>(fileList.size());
            for (Attachment attachment : fileList) {
                attachment.buildFileMD5();
                fileMd5Set.add(attachment.getFileMD5());
            }
            for (Long templateId : templateMap.keySet()) {
                Map templateAttachExistFieldMap = existFieldMap.computeIfAbsent(templateId, k -> new HashMap(4));
                for (String fileMd5 : fileMd5Set) {
                    templateAttachExistFieldMap.computeIfAbsent(fileMd5, k -> new HashSet(4));
                }
            }
            QFilter filter = new QFilter("templateid", "in", templateAndFieldMap.keySet()).and("filemd5", "in", fileMd5Set).and("datasource", "=", (Object)AttachmentDataSourceEnum.LC.getDataSource());
            DynamicObjectCollection processResults = QueryServiceHelper.query((String)"idi_processattachrecord", (String)"templateid,filemd5,processresult_tag", (QFilter[])filter.toArray());
            if (processResults != null && !processResults.isEmpty()) {
                ArrayList<LcDataDetail> resultList = new ArrayList<LcDataDetail>(processResults.size());
                for (DynamicObject dynObj : processResults) {
                    String processJson = dynObj.getString("processresult_tag");
                    Long templateId = dynObj.getLong("templateid");
                    String fileMd5 = dynObj.getString("filemd5");
                    Map templateAttachExistFieldMap = existFieldMap.computeIfAbsent(templateId, k -> new HashMap(4));
                    Set attachExistFieldSet = templateAttachExistFieldMap.computeIfAbsent(fileMd5, k -> new HashSet(4));
                    List detailList = (List)JSON.parseObject((String)processJson, (TypeReference)new TypeReference<List<LcField>>(){}, (Feature[])new Feature[0]);
                    if (detailList == null || detailList.isEmpty()) continue;
                    LcDataDetail lcDataDetail = new LcDataDetail();
                    lcDataDetail.setDetailList(detailList);
                    Optional<Attachment> attachment = fileList.stream().filter(p -> fileMd5.equals(p.getFileMD5())).findFirst();
                    lcDataDetail.setFileSourceKey(attachment.isPresent() ? attachment.get().getFileName() : "");
                    lcDataDetail.setVoucherCode(templateMap.get(templateId).getNumber());
                    Set<String> queryFields = templateAndFieldMap.get(templateId);
                    for (LcField headField : detailList) {
                        List<LcField> tableFields = headField.getTableFields();
                        String headFieldKey = headField.getFieldKey();
                        if (tableFields == null) {
                            if (!queryFields.isEmpty() && !queryFields.contains(headFieldKey)) continue;
                            attachExistFieldSet.add(headFieldKey);
                            continue;
                        }
                        for (LcField tableField : tableFields) {
                            String tableFieldKey = tableField.getFieldKey();
                            if (!queryFields.isEmpty() && !queryFields.contains(headFieldKey + "." + tableFieldKey)) continue;
                            attachExistFieldSet.add(tableFieldKey);
                        }
                    }
                    resultList.add(lcDataDetail);
                }
                return resultList;
            }
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error("AttachmentResultRecordHelper getLcRecord error", ex);
        }
        return null;
    }

    public static AIRecognizerSuccessInfo convertLcDataDetailToRecognizer(LcDataDetail lcDataDetail, AITemplate template) {
        AIRecognizerSuccessInfo result = new AIRecognizerSuccessInfo();
        try {
            QFilter idFilter;
            Map fieldAndTypeDynamic;
            result.setFileName(lcDataDetail.getFileSourceKey());
            result.setErrorCode("0");
            result.setTemplate(template);
            HashMap<String, Object> dataDetailMap = new HashMap<String, Object>(4);
            result.setDataDetailMap(dataDetailMap);
            HashMap<String, Object> confidenceMap = new HashMap<String, Object>(4);
            result.setRecognitionDataMap(confidenceMap);
            List<LcField> detailList = lcDataDetail.getDetailList();
            if (detailList != null && !detailList.isEmpty() && (fieldAndTypeDynamic = BusinessDataServiceHelper.loadFromCache((String)"idi_attachmentfield", (String)"number,fieldtype", (QFilter[])(idFilter = new QFilter("group", "=", (Object)template.getId())).toArray(), null)) != null && !fieldAndTypeDynamic.isEmpty()) {
                HashMap<String, String> fieldAndTypeMap = new HashMap<String, String>(16);
                for (Map.Entry entry : fieldAndTypeDynamic.entrySet()) {
                    DynamicObject dynamicObj = (DynamicObject)entry.getValue();
                    fieldAndTypeMap.put(dynamicObj.getString("number"), dynamicObj.getString("fieldtype"));
                }
                for (LcField lcField : detailList) {
                    String fieldKey = lcField.getFieldKey();
                    BigDecimal confidence = lcField.getConfidence();
                    List<LcField> tableFields = lcField.getTableFields();
                    if (tableFields == null) {
                        AttachmentFieldTypeEnum fieldTypeEnum = AttachmentFieldValueHelper.getFieldType(fieldKey, lcField.getFieldType(), fieldAndTypeMap);
                        Object formatValue = AttachmentFieldValueHelper.getValueByFieldType(fieldTypeEnum, lcField.getValue());
                        dataDetailMap.put(fieldKey, formatValue);
                        confidenceMap.put(fieldKey, confidence);
                        continue;
                    }
                    List tableFieldList = (List)dataDetailMap.computeIfAbsent(fieldKey, k -> new ArrayList(4));
                    List tableFieldConfidenceList = (List)confidenceMap.computeIfAbsent(fieldKey, k -> new ArrayList(4));
                    HashMap<String, Object> tableFieldMap = new HashMap<String, Object>(tableFields.size());
                    HashMap<String, BigDecimal> tableFieldConfidenceMap = new HashMap<String, BigDecimal>(tableFields.size());
                    for (LcField tableField : tableFields) {
                        String tableFieldKey = tableField.getFieldKey();
                        BigDecimal tableConfidence = tableField.getConfidence();
                        AttachmentFieldTypeEnum fieldTypeEnum = AttachmentFieldValueHelper.getFieldType(tableFieldKey, tableField.getFieldType(), fieldAndTypeMap);
                        Object formatValue = AttachmentFieldValueHelper.getValueByFieldType(fieldTypeEnum, tableField.getValue());
                        tableFieldMap.put(tableFieldKey, formatValue);
                        tableFieldConfidenceMap.put(tableFieldKey, tableConfidence);
                    }
                    tableFieldList.add(tableFieldMap);
                    tableFieldConfidenceList.add(tableFieldConfidenceMap);
                }
            }
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error("AttachmentResultRecordHelper convertLcDataDetailToRecognizer error", ex);
        }
        return result;
    }

    public static LcProcessResult processLcOriginJson(String originJson) {
        if (originJson == null || originJson.isEmpty()) {
            return null;
        }
        LcProcessResult lcProcessResult = new LcProcessResult();
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)originJson);
            lcProcessResult.setRequestNo(jsonObject.getString("requestNo"));
            lcProcessResult.setBillNo(jsonObject.getString("billNo"));
            lcProcessResult.setAuditCode(jsonObject.getString("auditCode"));
            JSONObject dataJson = jsonObject.getJSONObject("data");
            List<LcDataDetail> invoiceList = AttachmentResultRecordHelper.parseLcJson(dataJson.getJSONArray("invoices"));
            lcProcessResult.setInvoiceList(invoiceList);
            List<LcDataDetail> otherList = AttachmentResultRecordHelper.parseLcJson(dataJson.getJSONArray("others"));
            lcProcessResult.setOthersList(otherList);
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error("AttachmentResultRecordHelper processLcOriginJson error", ex);
        }
        return lcProcessResult;
    }

    public static List<LcDataDetail> lcProcessResultToDetailField(LcProcessResult lcProcessResult) {
        ArrayList<LcDataDetail> result = new ArrayList<LcDataDetail>(4);
        result.addAll(lcProcessResult.getInvoiceList());
        result.addAll(lcProcessResult.getOthersList());
        return result;
    }

    public static List<LcDataDetail> parseLcJson(JSONArray jsonArray) {
        int size = jsonArray.size();
        ArrayList<LcDataDetail> lcDataDetailList = new ArrayList<LcDataDetail>(size);
        for (int index = 0; index < size; ++index) {
            LcDataDetail detail = new LcDataDetail();
            JSONObject jsonData = jsonArray.getJSONObject(index);
            detail.setFileKey(jsonData.getString("fileKey"));
            detail.setFileSourceKey(jsonData.getString("fileSourceKey"));
            detail.setImageId(jsonData.getString("imageId"));
            detail.setInvoiceId(jsonData.getString("invoiceId"));
            detail.setVoucherCode(jsonData.getString("voucherCode"));
            JSONObject jsonDetail = jsonData.getJSONObject("detail");
            Set detailFieldSet = jsonDetail.keySet();
            ArrayList<LcField> fieldList = new ArrayList<LcField>(detailFieldSet.size());
            for (String fieldKey : detailFieldSet) {
                LcField lcHeadField = new LcField();
                JSONObject jsonField = jsonDetail.getJSONObject(fieldKey);
                lcHeadField.setFieldKey(fieldKey);
                lcHeadField.setConfidence(jsonField.getBigDecimal("confidence"));
                lcHeadField.setSource(jsonField.getString("source"));
                lcHeadField.setFieldType(jsonField.getString("fieldType"));
                lcHeadField.setFieldSign(jsonField.getString("fieldSign"));
                Object fieldValueObj = jsonField.get((Object)"value");
                if (String.valueOf(fieldValueObj).startsWith("[{")) {
                    JSONArray jsonArrayTableValue = jsonField.getJSONArray("value");
                    int tableSize = jsonArrayTableValue.size();
                    ArrayList<LcField> tableFields = new ArrayList<LcField>(tableSize);
                    for (int i = 0; i < tableSize; ++i) {
                        JSONObject rowJson = jsonArrayTableValue.getJSONObject(i);
                        Set subFieldSet = rowJson.keySet();
                        for (String subField : subFieldSet) {
                            LcField lcTableField = new LcField();
                            lcTableField.setFieldKey(subField);
                            JSONObject jsonSubField = rowJson.getJSONObject(subField);
                            lcTableField.setConfidence(jsonSubField.getBigDecimal("confidence"));
                            lcTableField.setSource(jsonSubField.getString("source"));
                            lcTableField.setValue(jsonSubField.get((Object)"value"));
                            lcTableField.setFieldSign(jsonSubField.getString("fieldSign"));
                            Object tableFieldType = jsonSubField.get((Object)"fieldType");
                            if (tableFieldType != null) {
                                lcTableField.setFieldType(String.valueOf(tableFieldType));
                            }
                            tableFields.add(lcTableField);
                        }
                    }
                    lcHeadField.setTableFields(tableFields);
                } else {
                    lcHeadField.setValue(fieldValueObj);
                }
                fieldList.add(lcHeadField);
            }
            detail.setDetailList(fieldList);
            lcDataDetailList.add(detail);
        }
        return lcDataDetailList;
    }

    public static void saveOriginAttachRecord(OriginAttachRecord record) {
        try {
            AttachmentResultRecordHelper.saveOrUpdateRecord(AttachmentResultRecordHelper.buildOriginAttachRecordDynamicObject(record));
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error("AttachmentResultRecordHelper saveOriginAttachRecord error", ex);
        }
    }

    private static DynamicObject buildOriginAttachRecordDynamicObject(OriginAttachRecord record) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"idi_originattachrecord");
        dynamicObject.set("requestno", (Object)record.getRequestNo());
        dynamicObject.set("billentity", (Object)record.getBillEntity());
        dynamicObject.set("billnumber", (Object)record.getBillNumber());
        dynamicObject.set("createrfield_id", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("datasource", (Object)record.getDataSource());
        dynamicObject.set("result_tag", (Object)record.getResult());
        return dynamicObject;
    }

    private static DynamicObject buildProcessAttachRecordDynamicObject(ProcessAttachRecord record) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"idi_processattachrecord");
        dynamicObject.set("templateid", (Object)record.getTemplateId());
        dynamicObject.set("filemd5", (Object)record.getFileMd5());
        dynamicObject.set("datasource", (Object)record.getDataSource());
        dynamicObject.set("processresult_tag", (Object)record.getResult());
        return dynamicObject;
    }

    public static void saveAiProcessResultIfNotExist(Long templateId, String fileMd5, String json) {
        try (DLock dLock = DLock.create((String)IDICoreConstant.buildTemplateAndFileLockKey(templateId, fileMd5));){
            QFilter filter;
            DynamicObject aiProcessResultObj;
            if (dLock.tryLock(120000L) && (aiProcessResultObj = BusinessDataServiceHelper.loadSingle((String)"idi_processattachrecord", (String)"id,processresult_tag", (QFilter[])(filter = new QFilter("templateid", "=", (Object)templateId).and("filemd5", "=", (Object)fileMd5).and("datasource", "=", (Object)AttachmentDataSourceEnum.AI.getDataSource())).toArray())) == null) {
                ProcessAttachRecord processAttachRecord = new ProcessAttachRecord(templateId, fileMd5, AttachmentDataSourceEnum.AI.getDataSource(), json);
                AttachmentResultRecordHelper.saveOrUpdateRecord(AttachmentResultRecordHelper.buildProcessAttachRecordDynamicObject(processAttachRecord));
            }
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error("AttachmentResultRecordHelper updateAiProcessResult error", ex);
        }
    }

    public static void updateLcProcessResult(Map<String, Long> templateNameIdMap, Map<String, String> fileNameMd5Map, String json) {
        try {
            LcProcessResult newProcessResult = AttachmentResultRecordHelper.processLcOriginJson(json);
            if (newProcessResult == null) {
                return;
            }
            List<LcDataDetail> lcDataDetailList = AttachmentResultRecordHelper.lcProcessResultToDetailField(newProcessResult);
            if (lcDataDetailList.isEmpty()) {
                return;
            }
            for (LcDataDetail lcDataDetail : lcDataDetailList) {
                Long templateId = templateNameIdMap.get(lcDataDetail.getVoucherCode());
                String fileMd5 = fileNameMd5Map.get(lcDataDetail.getFileSourceKey());
                if (templateId == null || fileMd5 == null) continue;
                DLock dLock = DLock.create((String)IDICoreConstant.buildTemplateAndFileLockKey(templateId, fileMd5));
                Throwable throwable = null;
                try {
                    if (!dLock.tryLock(120000L)) continue;
                    List<LcField> detailList = lcDataDetail.getDetailList();
                    DynamicObject matchProcessResultObj = AttachmentResultRecordHelper.getProcessRecord(templateId, fileMd5, AttachmentDataSourceEnum.LC.getDataSource());
                    if (matchProcessResultObj == null) {
                        ProcessAttachRecord record = new ProcessAttachRecord(templateId, fileMd5, AttachmentDataSourceEnum.LC.getDataSource(), JSON.toJSONString(detailList));
                        AttachmentResultRecordHelper.saveOrUpdateRecord(AttachmentResultRecordHelper.buildProcessAttachRecordDynamicObject(record));
                        continue;
                    }
                    List oldDetailList = (List)JSON.parseObject((String)matchProcessResultObj.getString("processresult_tag"), (TypeReference)new TypeReference<List<LcField>>(){}, (Feature[])new Feature[0]);
                    ArrayList<LcField> mergeList = new ArrayList<LcField>(oldDetailList);
                    for (LcField lcField : detailList) {
                        boolean headFieldExist = false;
                        String fieldKey = lcField.getFieldKey();
                        List<LcField> tableFields = lcField.getTableFields();
                        for (int index = 0; index < oldDetailList.size(); ++index) {
                            LcField oldField = (LcField)mergeList.get(index);
                            String oldFieldKey = oldField.getFieldKey();
                            List<LcField> oldTableFields = oldField.getTableFields();
                            if (!fieldKey.equals(oldFieldKey)) continue;
                            headFieldExist = true;
                            oldField.setFieldType(lcField.getFieldType());
                            oldField.setFieldSign(lcField.getFieldSign());
                            oldField.setSource(lcField.getSource());
                            oldField.setConfidence(lcField.getConfidence());
                            oldField.setValue(lcField.getValue());
                            if (oldTableFields == null && tableFields != null) {
                                oldField.setTableFields(tableFields);
                                continue;
                            }
                            if (oldTableFields == null || tableFields == null) continue;
                            for (LcField tableField : tableFields) {
                                boolean tableFieldExist = false;
                                String tableFieldKey = tableField.getFieldKey();
                                for (int i = 0; i < oldTableFields.size(); ++i) {
                                    LcField oldTableField = oldTableFields.get(i);
                                    String oldTableFieldKey = oldTableField.getFieldKey();
                                    if (!tableFieldKey.equals(oldTableFieldKey)) continue;
                                    tableFieldExist = true;
                                    oldTableFields.set(i, tableField);
                                    break;
                                }
                                if (tableFieldExist) continue;
                                oldTableFields.add(tableField);
                            }
                        }
                        if (headFieldExist) continue;
                        mergeList.add(lcField);
                    }
                    matchProcessResultObj.set("processresult_tag", (Object)JSON.toJSONString(mergeList));
                    matchProcessResultObj.set("modifydatefield", (Object)new Date());
                    AttachmentResultRecordHelper.saveOrUpdateRecord(matchProcessResultObj);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dLock == null) continue;
                    if (throwable != null) {
                        try {
                            dLock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dLock.close();
                }
            }
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error("AttachmentResultRecordHelper updateLcProcessResult error", ex);
        }
    }

    public static void mergeRecognizerAndLcDetail(List<AIRecognizerSuccessInfo> recognizerList, List<LcDataDetail> lcRecordList) {
        try {
            Set templateNumberSet = lcRecordList.stream().map(LcDataDetail::getVoucherCode).collect(Collectors.toSet());
            QFilter numberFilter = new QFilter("number", "in", templateNumberSet);
            List idList = QueryServiceHelper.queryPrimaryKeys((String)"idi_fieldgroup", (QFilter[])numberFilter.toArray(), null, (int)-1);
            if (idList.isEmpty()) {
                return;
            }
            HashMap<String, Map> templateFieldTypeMap = new HashMap<String, Map>(idList.size());
            QFilter idFilter = new QFilter("group", "in", (Object)idList);
            Map fieldAndTypeDynamic = BusinessDataServiceHelper.loadFromCache((String)"idi_attachmentfield", (String)"group,number,fieldtype", (QFilter[])idFilter.toArray(), null);
            if (fieldAndTypeDynamic != null && !fieldAndTypeDynamic.isEmpty()) {
                for (Map.Entry entry : fieldAndTypeDynamic.entrySet()) {
                    DynamicObject dyObj = (DynamicObject)entry.getValue();
                    String templateNumber = dyObj.getDynamicObject("group").getString("number");
                    String number = dyObj.getString("number");
                    String fieldType = dyObj.getString("fieldtype");
                    Map fieldTypeMap = templateFieldTypeMap.computeIfAbsent(templateNumber, k -> new HashMap(16));
                    fieldTypeMap.put(number, fieldType);
                }
            }
            if (templateFieldTypeMap.isEmpty()) {
                return;
            }
            for (AIRecognizerSuccessInfo aIRecognizerSuccessInfo : recognizerList) {
                String templateNumber = aIRecognizerSuccessInfo.getTemplate().getNumber();
                String fileName = aIRecognizerSuccessInfo.getFileName();
                Map fieldAndTypeMap = (Map)templateFieldTypeMap.get(templateNumber);
                if (fieldAndTypeMap == null || fieldAndTypeMap.isEmpty()) continue;
                Map<String, Object> detailMap = aIRecognizerSuccessInfo.getDataDetailMap();
                Map<String, Object> confidenceMap = aIRecognizerSuccessInfo.getRecognitionDataMap();
                for (LcDataDetail lcDataDetail : lcRecordList) {
                    if (!templateNumber.equals(lcDataDetail.getVoucherCode()) || !fileName.equals(lcDataDetail.getFileSourceKey())) continue;
                    List<LcField> detailList = lcDataDetail.getDetailList();
                    if (detailMap == null || detailList == null) continue;
                    if (confidenceMap == null) {
                        confidenceMap = new HashMap<String, Object>(16);
                        aIRecognizerSuccessInfo.setRecognitionDataMap(confidenceMap);
                    }
                    for (LcField headField : detailList) {
                        String headFieldKey = headField.getFieldKey();
                        List<LcField> tableFields = headField.getTableFields();
                        if (tableFields == null) {
                            AttachmentFieldTypeEnum fieldTypeEnum = AttachmentFieldValueHelper.getFieldType(headFieldKey, headField.getFieldType(), fieldAndTypeMap);
                            Object formatValue = AttachmentFieldValueHelper.getValueByFieldType(fieldTypeEnum, headField.getValue());
                            if (!detailMap.containsKey(headFieldKey)) {
                                detailMap.put(headFieldKey, formatValue);
                            }
                            if (confidenceMap.containsKey(headFieldKey)) continue;
                            confidenceMap.put(headFieldKey, headField.getConfidence());
                            continue;
                        }
                        List tableFieldList = (List)detailMap.computeIfAbsent(headFieldKey, k -> new ArrayList(4));
                        List tableFieldConfidenceList = (List)confidenceMap.computeIfAbsent(headFieldKey, k -> new ArrayList(4));
                        for (LcField tableField : tableFields) {
                            boolean hasTableField = false;
                            String tableFieldKey = tableField.getFieldKey();
                            for (Map tableFieldMap : tableFieldList) {
                                if (!tableFieldMap.containsKey(tableFieldKey)) continue;
                                hasTableField = true;
                                break;
                            }
                            if (hasTableField) continue;
                            BigDecimal tableConfidence = tableField.getConfidence();
                            AttachmentFieldTypeEnum fieldTypeEnum = AttachmentFieldValueHelper.getFieldType(tableFieldKey, tableField.getFieldType(), fieldAndTypeMap);
                            Object formatValue = AttachmentFieldValueHelper.getValueByFieldType(fieldTypeEnum, tableField.getValue());
                            HashMap<String, Object> tableFieldMap = new HashMap<String, Object>(1);
                            HashMap<String, BigDecimal> tableFieldConfidenceMap = new HashMap<String, BigDecimal>(1);
                            tableFieldMap.put(tableFieldKey, formatValue);
                            tableFieldConfidenceMap.put(tableFieldKey, tableConfidence);
                            tableFieldList.add(tableFieldMap);
                            tableFieldConfidenceList.add(tableFieldConfidenceMap);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error("AttachmentResultRecordHelper mergeRecognizerAndLcDetail error", ex);
        }
    }

    private static void saveOrUpdateRecord(DynamicObject obj) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    private static DynamicObject getProcessRecord(Long templateId, String fileMd5, String dataSource) {
        QFilter filter = new QFilter("templateid", "=", (Object)templateId).and("filemd5", "=", (Object)fileMd5).and("datasource", "=", (Object)dataSource);
        return BusinessDataServiceHelper.loadSingle((String)"idi_processattachrecord", (String)"id,modifydatefield,processresult_tag", (QFilter[])filter.toArray());
    }
}

