/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.data.idi.data.IDICondition;
import kd.data.idi.engine.ScriptBuilder;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.util.AttachmentFieldHelper;
import kd.data.idi.util.IDIStringUtils;

public class ExpressionTranslator {
    public static void tranFilterCondition(IDICondition formulaObj, String targetEntityNumber, String sourceEntityNumber, String attachmentJson, Object onlyAttachmentFileName, boolean targetSelf, String fieldTreeRootNode) {
        FilterCondition filterCondition;
        if (formulaObj == null) {
            return;
        }
        StringBuilder script = new StringBuilder();
        StringBuilder scriptDesc = new StringBuilder();
        boolean hasExpression = StringUtils.isNotEmpty((CharSequence)formulaObj.getExpression());
        boolean hasFilterCondition = false;
        if (StringUtils.isNotEmpty((CharSequence)targetEntityNumber) && (filterCondition = formulaObj.getFilterCondition()) != null && filterCondition.getFilterRow().size() > 0) {
            ScriptBuilder.ValueAndDesc buildScripts;
            if (StringUtils.isNotEmpty((CharSequence)attachmentJson) || onlyAttachmentFileName != null && ((Boolean)onlyAttachmentFileName).booleanValue()) {
                buildScripts = ExpressionTranslator.getAttachmentScripts((List<SimpleFilterRow>)filterCondition.getFilterRow(), attachmentJson, false);
            } else {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
                ScriptBuilder scriptBuilder = new ScriptBuilder(mainType, filterCondition);
                if (targetSelf) {
                    scriptBuilder.setBillPrefix("targetisself_");
                }
                buildScripts = scriptBuilder.buildScript();
            }
            if (StringUtils.isNotEmpty((CharSequence)buildScripts.getValue())) {
                hasFilterCondition = true;
                if (hasExpression) {
                    script.append('(');
                }
                script.append(buildScripts.getValue());
                if (hasExpression) {
                    script.append(')');
                }
                scriptDesc.append(buildScripts.getDesc());
            }
        }
        if (hasExpression) {
            if (hasFilterCondition) {
                script.append(" && (");
                scriptDesc.append(ResManager.loadKDString((String)" \u4e14 ", (String)"IDIConditionEdit_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
            script.append(formulaObj.getExpression());
            String tranExpr = ExpressionTranslator.tranExpression(formulaObj.getExpression(), sourceEntityNumber, targetEntityNumber, fieldTreeRootNode);
            scriptDesc.append(tranExpr);
            if (hasFilterCondition) {
                script.append(')');
            }
        }
        formulaObj.setScript(script.toString());
        formulaObj.setExprTran(scriptDesc.toString());
    }

    public static void tranFilterCondition(IDICondition formulaObj, String targetEntityNumber, String sourceEntityNumber, Map<AITemplate, List<AttachmentField>> fieldClassifyMap, Object onlyAttachmentFileName, boolean targetSelf, TreeNode rootNode) {
        ExpressionTranslator.tranFilterCondition(formulaObj, targetEntityNumber, sourceEntityNumber, fieldClassifyMap, onlyAttachmentFileName, targetSelf, rootNode, false, false);
    }

    public static void tranFilterCondition(IDICondition formulaObj, String targetEntityNumber, String sourceEntityNumber, Map<AITemplate, List<AttachmentField>> fieldClassifyMap, Object onlyAttachmentFileName, boolean targetSelf, TreeNode rootNode, boolean userTemplateNumber, boolean isFromAiAttachment) {
        FilterCondition filterCondition;
        if (formulaObj == null) {
            return;
        }
        StringBuilder script = new StringBuilder();
        StringBuilder scriptDesc = new StringBuilder();
        boolean hasExpression = StringUtils.isNotEmpty((CharSequence)formulaObj.getExpression());
        boolean hasFilterCondition = false;
        if (StringUtils.isNotEmpty((CharSequence)targetEntityNumber) && (filterCondition = formulaObj.getFilterCondition()) != null && filterCondition.getFilterRow().size() > 0) {
            ScriptBuilder.ValueAndDesc buildScripts;
            if (fieldClassifyMap != null && !fieldClassifyMap.isEmpty() || onlyAttachmentFileName != null && ((Boolean)onlyAttachmentFileName).booleanValue()) {
                if (isFromAiAttachment) {
                    MainEntityType mainType = AttachmentFieldHelper.createAttachmentEntityType(fieldClassifyMap);
                    ScriptBuilder scriptBuilder = new ScriptBuilder(mainType, filterCondition);
                    buildScripts = scriptBuilder.buildScript();
                } else {
                    buildScripts = ExpressionTranslator.getAttachmentScripts((List<SimpleFilterRow>)filterCondition.getFilterRow(), fieldClassifyMap, userTemplateNumber);
                }
            } else {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
                ScriptBuilder scriptBuilder = new ScriptBuilder(mainType, filterCondition);
                if (targetSelf) {
                    scriptBuilder.setBillPrefix("targetisself_");
                }
                buildScripts = scriptBuilder.buildScript();
            }
            if (StringUtils.isNotEmpty((CharSequence)buildScripts.getValue())) {
                hasFilterCondition = true;
                if (hasExpression) {
                    script.append('(');
                }
                script.append(buildScripts.getValue());
                if (hasExpression) {
                    script.append(')');
                }
                scriptDesc.append(buildScripts.getDesc());
            }
        }
        if (hasExpression) {
            if (hasFilterCondition) {
                script.append(" && (");
                scriptDesc.append(ResManager.loadKDString((String)" \u4e14 ", (String)"IDIConditionEdit_2", (String)"data-idi-formplugin", (Object[])new Object[0]));
            }
            script.append(formulaObj.getExpression());
            String tranExpr = ExpressionTranslator.tranExpression(formulaObj.getExpression(), sourceEntityNumber, targetEntityNumber, rootNode);
            scriptDesc.append(tranExpr);
            if (hasFilterCondition) {
                script.append(')');
            }
        }
        formulaObj.setScript(script.toString());
        formulaObj.setExprTran(scriptDesc.toString());
    }

    private static ScriptBuilder.ValueAndDesc getAttachmentScripts(List<SimpleFilterRow> filterRow, Map<AITemplate, List<AttachmentField>> fieldClassifyMap, boolean userTemplateNumber) {
        HashMap<String, String> attachmentCompareType = new HashMap<String, String>(6);
        attachmentCompareType.put(CompareTypeEnum.EQUAL.getId(), ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"IDIConditionEdit_3", (String)"data-idi-formplugin", (Object[])new Object[0]));
        attachmentCompareType.put(CompareTypeEnum.NOTEQUAL.getId(), ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"IDIConditionEdit_4", (String)"data-idi-formplugin", (Object[])new Object[0]));
        attachmentCompareType.put(CompareTypeEnum.LIKE.getId(), ResManager.loadKDString((String)"\u5305\u542b", (String)"IDIConditionEdit_5", (String)"data-idi-formplugin", (Object[])new Object[0]));
        attachmentCompareType.put(CompareTypeEnum.NOTLIKE.getId(), ResManager.loadKDString((String)"\u4e0d\u5305\u542b", (String)"IDIConditionEdit_6", (String)"data-idi-formplugin", (Object[])new Object[0]));
        attachmentCompareType.put(CompareTypeEnum.ISNULL.getId(), ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"IDIConditionEdit_7", (String)"data-idi-formplugin", (Object[])new Object[0]));
        attachmentCompareType.put(CompareTypeEnum.ISNOTNULL.getId(), ResManager.loadKDString((String)"\u4e0d\u4e3a\u7a7a", (String)"IDIConditionEdit_8", (String)"data-idi-formplugin", (Object[])new Object[0]));
        HashMap<String, Tuple> attachmentLogic = new HashMap<String, Tuple>(2);
        attachmentLogic.put("0", Tuple.create((Object)"&&", (Object)ResManager.loadKDString((String)"\u4e14", (String)"IDIConditionEdit_9", (String)"data-idi-formplugin", (Object[])new Object[0])));
        attachmentLogic.put("1", Tuple.create((Object)"||", (Object)ResManager.loadKDString((String)"\u6216", (String)"IDIConditionEdit_10", (String)"data-idi-formplugin", (Object[])new Object[0])));
        HashMap<String, String> attachmentFieldAndName = new HashMap<String, String>(16);
        if (fieldClassifyMap != null && !fieldClassifyMap.isEmpty()) {
            if (fieldClassifyMap != null && !fieldClassifyMap.isEmpty()) {
                fieldClassifyMap.forEach((templateData, fields) -> {
                    String templatePrefix = userTemplateNumber ? IDIStringUtils.templatePrefix((String)templateData.getNumber()) : IDIStringUtils.templatePrefix((Long)templateData.getId());
                    for (AttachmentField attachmentField : fields) {
                        attachmentFieldAndName.put(templatePrefix + attachmentField.getFullName(), new LocaleString(attachmentField.getFullDisplayName()).toString());
                    }
                });
            }
        } else {
            attachmentFieldAndName.put("filename", ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u79f0", (String)"IDIFieldListFormPlugin_0", (String)"data-idi-formplugin", (Object[])new Object[0]));
        }
        StringBuilder leftBracketCount = new StringBuilder();
        StringBuilder rightBracketCount = new StringBuilder();
        StringBuilder valueBuilder = new StringBuilder();
        StringBuilder descBuilder = new StringBuilder();
        for (int i = 0; i < filterRow.size(); ++i) {
            String inputValue;
            SimpleFilterRow simpleFilterRow = filterRow.get(i);
            String fieldName = simpleFilterRow.getFieldName();
            if (StringUtils.isEmpty((CharSequence)fieldName)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u7840\u6761\u4ef6\u7b2c%d\u884c\u5b57\u6bb5\u3002", (String)"IDIConditionEdit_11", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1));
            }
            String compareType = simpleFilterRow.getCompareType();
            List valueList = simpleFilterRow.getValue();
            String string = inputValue = valueList == null || valueList.isEmpty() ? "" : ((FilterValue)valueList.get(0)).getValue().toString();
            if (!CompareTypeEnum.ISNULL.getId().equals(compareType) && !CompareTypeEnum.ISNOTNULL.getId().equals(compareType) && StringUtils.isEmpty((CharSequence)inputValue)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u7840\u6761\u4ef6\u7b2c%d\u884c\u503c\u3002", (String)"IDIConditionEdit_12", (String)"data-idi-formplugin", (Object[])new Object[0]), i + 1));
            }
            String leftBracket = StringUtils.isEmpty((CharSequence)simpleFilterRow.getLeftBracket()) ? "" : simpleFilterRow.getLeftBracket();
            String rightBracket = StringUtils.isEmpty((CharSequence)simpleFilterRow.getRightBracket()) ? "" : simpleFilterRow.getRightBracket();
            String logic = simpleFilterRow.getLogic();
            valueBuilder.append(leftBracket);
            leftBracketCount.append(leftBracket);
            descBuilder.append(leftBracket);
            CompareTypeEnum compareTypeEnum = CompareTypeEnum.createCompareTypeEnum((String)compareType);
            String fieldNameDesc = (String)attachmentFieldAndName.get(fieldName);
            String compareDesc = (String)attachmentCompareType.get(compareType);
            switch (compareTypeEnum) {
                case LIKE: {
                    valueBuilder.append(fieldName).append(".contains(").append("\"").append(inputValue).append("\")");
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc).append(" ").append(inputValue);
                    break;
                }
                case NOTLIKE: {
                    valueBuilder.append("!").append(fieldName).append(".contains(").append("\"").append(inputValue).append("\")");
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc).append(" ").append(inputValue);
                    break;
                }
                case EQUAL: {
                    valueBuilder.append(fieldName).append(".equals(").append("\"").append(inputValue).append("\")");
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc).append(" ").append(inputValue);
                    break;
                }
                case NOTEQUAL: {
                    valueBuilder.append("!").append(fieldName).append(".equals(").append("\"").append(inputValue).append("\")");
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc).append(" ").append(inputValue);
                    break;
                }
                case ISNULL: {
                    valueBuilder.append(String.format("isNull(%s)", fieldName));
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc);
                    break;
                }
                case ISNOTNULL: {
                    valueBuilder.append(String.format("!isNull(%s)", fieldName));
                    descBuilder.append(fieldNameDesc).append(" ").append(compareDesc);
                }
            }
            valueBuilder.append(rightBracket).append(" ");
            descBuilder.append(rightBracket).append(" ");
            rightBracketCount.append(rightBracket);
            Tuple logicTuple = (Tuple)attachmentLogic.get(logic);
            if (logicTuple == null || i >= filterRow.size() - 1) continue;
            valueBuilder.append((String)logicTuple.item1).append(" ");
            descBuilder.append((String)logicTuple.item2).append(" ");
        }
        if (leftBracketCount.length() != rightBracketCount.length()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de6\u62ec\u53f7\u4e0e\u53f3\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ScriptBuilder_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        ScriptBuilder.ValueAndDesc resultScript = new ScriptBuilder.ValueAndDesc();
        resultScript.setValue(valueBuilder.toString());
        resultScript.setDesc(descBuilder.toString());
        return resultScript;
    }

    private static ScriptBuilder.ValueAndDesc getAttachmentScripts(List<SimpleFilterRow> filterRow, String attachmentJson, boolean userTemplateNumber) {
        Map fieldClassifyMap = null;
        if (attachmentJson != null && !attachmentJson.isEmpty()) {
            fieldClassifyMap = (Map)JSON.parseObject((String)attachmentJson, (TypeReference)new TypeReference<Map<AITemplate, List<AttachmentField>>>(){}, (Feature[])new Feature[0]);
        }
        return ExpressionTranslator.getAttachmentScripts(filterRow, fieldClassifyMap, userTemplateNumber);
    }

    public static String tranExpression(String expression, String sourceNumber, String targetNumber, String fieldTreeRootNode) {
        TreeNode rootNode = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)fieldTreeRootNode)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)fieldTreeRootNode, TreeNode.class);
        }
        return ExpressionTranslator.tranExpression(expression, sourceNumber, targetNumber, rootNode);
    }

    public static String tranExpression(String expression, String sourceNumber, String targetNumber, TreeNode rootNode) {
        String[] stringArray;
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        if (targetNumber.equals(sourceNumber)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = targetNumber;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = targetNumber;
            stringArray = stringArray3;
            stringArray3[1] = sourceNumber;
        }
        Set<String> vars = ScriptFormIdHandler.extractVariables(expression, stringArray);
        if (vars.isEmpty()) {
            return expressionDesc;
        }
        if (rootNode == null) {
            rootNode = new TreeNode();
        }
        ArrayList<String> orderVars = new ArrayList<String>(vars);
        orderVars.sort((o1, o2) -> {
            if (o1.length() > o2.length()) {
                return -1;
            }
            if (o1.length() < o2.length()) {
                return 1;
            }
            return o2.compareTo((String)o1);
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(orderVars.size());
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%d###", i);
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }
}

