/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;

public class FilterGridHelper {
    public static List<Map<String, Object>> getFilterColumns(MainEntityType dataEntityType, boolean isOnlyMainEntityField) {
        ArrayList<Map<String, Object>> filterColumns = new ArrayList<Map<String, Object>>(10);
        List filterFields = new EntityTypeUtil().getFilterFields((IDataEntityType)dataEntityType, isOnlyMainEntityField);
        for (FilterField filterField : filterFields) {
            String entityKey = filterField.getEntityKey();
            String fieldName = filterField.getFieldName();
            String fullFieldName = filterField.getFullFieldName();
            if (!String.format("%s.%s", entityKey, fieldName).equals(fullFieldName) && !fieldName.equals(fullFieldName)) continue;
            Map filterColumn = filterField.createFilterColumn();
            filterColumns.add(filterColumn);
        }
        return filterColumns;
    }

    public static List<Map<String, Object>> getAllFilterColumns(MainEntityType dataEntityType) {
        ArrayList<Map<String, Object>> filterColumns = new ArrayList<Map<String, Object>>(10);
        List filterFields = new EntityTypeUtil().getFilterFields((IDataEntityType)dataEntityType, false);
        for (FilterField filterField : filterFields) {
            Map filterColumn = filterField.createFilterColumn();
            filterColumns.add(filterColumn);
        }
        return filterColumns;
    }

    public static List<Map<String, Object>> getAllFilterColumnsAndMulBase(MainEntityType dataEntityType) {
        ArrayList<Map<String, Object>> filterColumns = new ArrayList<Map<String, Object>>(10);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)dataEntityType);
        getFilterFieldsParameter.setbCompatibleProductMode(false);
        getFilterFieldsParameter.setOnlyMainEntityField(false);
        getFilterFieldsParameter.setNeedMulBasedataField(true);
        List filterFields = EntityTypeUtil.getFilterFields((GetFilterFieldsParameter)getFilterFieldsParameter);
        for (FilterField filterField : filterFields) {
            Map filterColumn = filterField.createFilterColumn();
            filterColumns.add(filterColumn);
        }
        return filterColumns;
    }
}

