/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.data.idi.model.AttachmentHighLight;
import kd.bos.ext.data.idi.model.BaseHighLight;
import kd.bos.ext.data.idi.model.EntryColumnHighLight;
import kd.bos.ext.data.idi.model.EntryHighLight;
import kd.bos.ext.data.idi.model.InvoiceHighLight;
import kd.bos.ext.data.idi.model.KeyWordHighLight;
import kd.bos.ext.data.idi.model.LinkUpBillHighLight;
import kd.bos.ext.data.idi.model.RowBaseHighLight;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.InvoiceImageRuleResult;
import kd.data.idi.engine.BillCheckResult;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.functions.CustomFuncEnum;
import kd.data.idi.util.Pair;

public class HighLightBuilder {
    public List<BaseHighLight> buildKeywordHighLight(List<String> headFieldList, Map<String, List<String>> entryFieldMap, Map<String, Map<String, List<String>>> subEntryFieldMap, Map<String, List<Integer>> entryIndexMap, Map<String, Map<Integer, List<Integer>>> subEntryIndexMap, List<BaseHighLight> allHighLightList, MainEntityType srcMainType) {
        if (CollectionUtils.isEmpty(headFieldList) && (entryFieldMap == null || entryFieldMap.isEmpty())) {
            return allHighLightList;
        }
        if (allHighLightList == null) {
            allHighLightList = new ArrayList<BaseHighLight>(10);
        }
        KeyWordHighLight keyWordHighLight = this.createKeyWordHighLight(headFieldList, entryFieldMap, subEntryFieldMap, srcMainType);
        EntryColumnHighLight[] entryColumnHighLights = keyWordHighLight.getEntryColumnHighLights();
        if (entryIndexMap != null && !entryIndexMap.isEmpty() && entryColumnHighLights != null && entryColumnHighLights.length > 0) {
            Map<String, EntryColumnHighLight> entryColumnHighLightMap = Arrays.stream(entryColumnHighLights).collect(Collectors.toMap(EntryColumnHighLight::getEntryName, eh -> eh));
            Set<Map.Entry<String, List<Integer>>> entryIndexEntrySet = entryIndexMap.entrySet();
            HashSet<EntryColumnHighLight> newEntryColumnHighLightSet = new HashSet<EntryColumnHighLight>(entryColumnHighLights.length);
            for (Map.Entry<String, List<Integer>> fieldToIndexEntry : entryIndexEntrySet) {
                String entryField = fieldToIndexEntry.getKey();
                List<Integer> indexList = fieldToIndexEntry.getValue();
                if (CollectionUtils.isEmpty(indexList)) continue;
                String[] fields = entryField.split("\\.");
                if (fields.length < 2) {
                    String error = ResManager.loadKDString((String)"\u654f\u611f\u8bcd\u9ad8\u4eae\u5904\u7406\u5206\u5f55\u5b57\u6bb5\u62c6\u5206\u5f02\u5e38\uff0c\u5b57\u6bb5:%s", (String)"HighLightBuilder_0", (String)"data-idi-core", (Object[])new Object[0]);
                    throw new KDBizException(String.format(error, entryField));
                }
                String entryName = fields[0];
                EntryColumnHighLight entryColumnHighLight = entryColumnHighLightMap.get(entryName);
                if (entryColumnHighLight == null) {
                    String error = ResManager.loadKDString((String)"\u654f\u611f\u8bcd\u9ad8\u4eae\u5904\u7406\u5206\u5f55\u5b57\u6bb5\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u5206\u5f55\u9ad8\u4eae\u4fe1\u606f\uff0c\u5b57\u6bb5\uff1a%1$s\u3002", (String)"HighLightBuilder_1", (String)"data-idi-core", (Object[])new Object[0]);
                    throw new KDBizException(String.format(error, entryField));
                }
                newEntryColumnHighLightSet.add(entryColumnHighLight);
                String field = fields[1];
                HashMap<String, int[]> indexMap = entryColumnHighLight.getFieldCellIndexMap();
                if (indexMap == null) {
                    indexMap = new HashMap<String, int[]>(3);
                    entryColumnHighLight.setFieldCellIndexMap(indexMap);
                }
                indexMap.put(field, this.toIntArrays(indexList));
            }
            if (newEntryColumnHighLightSet.size() < entryColumnHighLights.length) {
                ArrayList<EntryColumnHighLight> newEntryColumnHighLightList = new ArrayList<EntryColumnHighLight>(entryColumnHighLights.length);
                for (EntryColumnHighLight entryColumnHighLight : entryColumnHighLights) {
                    if (!newEntryColumnHighLightSet.contains(entryColumnHighLight)) continue;
                    newEntryColumnHighLightList.add(entryColumnHighLight);
                }
                keyWordHighLight.setEntryColumnHighLights(newEntryColumnHighLightList.toArray(new EntryColumnHighLight[0]));
            }
        }
        allHighLightList.add((BaseHighLight)keyWordHighLight);
        return allHighLightList;
    }

    private KeyWordHighLight createKeyWordHighLight(List<String> headFieldList, Map<String, List<String>> entryFieldMap, Map<String, Map<String, List<String>>> subEntryFieldMap, MainEntityType srcMainType) {
        KeyWordHighLight keyWordHighLight = new KeyWordHighLight();
        Map<String, Integer> headPropIndexMap = this.createFieldIndex((DynamicObjectType)srcMainType);
        ArrayList<String> noRefHeadFieldList = new ArrayList(5);
        if (CollectionUtils.isNotEmpty(headFieldList)) {
            noRefHeadFieldList = this.deleteRefField(headFieldList, srcMainType);
        }
        HashMap entryColumnHighLightMap = new HashMap(5);
        ArrayList<Pair> sortEntryList = new ArrayList<Pair>(5);
        if (entryFieldMap != null && !entryFieldMap.isEmpty()) {
            entryFieldMap.forEach((entryName, entryFieldList) -> {
                if (CollectionUtils.isNotEmpty((Collection)entryFieldList)) {
                    EntryColumnHighLight entryColumnHighLight = (EntryColumnHighLight)entryColumnHighLightMap.get(entryName);
                    if (entryColumnHighLight == null) {
                        sortEntryList.add(new Pair((String)entryName, headPropIndexMap.get(entryName)));
                        entryColumnHighLight = new EntryColumnHighLight();
                        entryColumnHighLight.setEntryName(entryName);
                        entryColumnHighLightMap.put(entryName, entryColumnHighLight);
                    }
                    DynamicProperty entryProp = srcMainType.getProperty(entryName);
                    DynamicObjectType entryType = ((EntryProp)entryProp)._collectionItemPropertyType;
                    Map<String, Integer> entryPropIndexMap = this.createFieldIndex(entryType);
                    List<String> noRefEntryFieldList = this.deleteRefField((List<String>)entryFieldList, srcMainType);
                    String entryPrefix = entryName + ".";
                    ArrayList<String> realEntryFieldList = new ArrayList<String>(noRefEntryFieldList.size());
                    for (String s : noRefEntryFieldList) {
                        String realEntryField = s.substring(entryPrefix.length());
                        realEntryFieldList.add(realEntryField);
                    }
                    List<String> sortEntryFieldNameList = this.sortField(realEntryFieldList, entryPropIndexMap);
                    entryColumnHighLight.setEntryFields(sortEntryFieldNameList.toArray(new String[0]));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(sortEntryList)) {
            if (sortEntryList.size() > 1) {
                sortEntryList.sort(Comparator.comparingInt(Pair::getValue));
            }
            EntryColumnHighLight[] entryHighLights = new EntryColumnHighLight[sortEntryList.size()];
            for (int i = 0; i < sortEntryList.size(); ++i) {
                entryHighLights[i] = (EntryColumnHighLight)entryColumnHighLightMap.get(((Pair)sortEntryList.get(i)).getKey());
                if (!CollectionUtils.isNotEmpty(noRefHeadFieldList)) continue;
                noRefHeadFieldList.add((String)((Pair)sortEntryList.get(i)).getKey());
            }
            keyWordHighLight.setEntryColumnHighLights(entryHighLights);
        }
        if (CollectionUtils.isNotEmpty(noRefHeadFieldList)) {
            List<String> sortHeadFieldList = this.sortField(noRefHeadFieldList, headPropIndexMap);
            keyWordHighLight.setHeadFields(sortHeadFieldList.toArray(new String[0]));
        }
        return keyWordHighLight;
    }

    public List<BaseHighLight> buildAttachmentHighLight(int ruleIndex, String originalScript, String srcEntityNumber, MainEntityType srcMainType, List<Integer> entryIndexList, List<BaseHighLight> allHighLightList, String[] attachmentPanels) {
        if (ruleIndex < 0) {
            return allHighLightList;
        }
        if (StringUtils.isEmpty((String)originalScript)) {
            if (attachmentPanels != null && attachmentPanels.length > 0) {
                AttachmentHighLight attachmentHighLight = this.createAttachmentFieldTemplate(new ArrayList<String>(0), srcMainType);
                attachmentHighLight.setRuleIndex(ruleIndex);
                attachmentHighLight.setAttachmentPanels(attachmentPanels);
                allHighLightList.add((BaseHighLight)attachmentHighLight);
            }
            return allHighLightList;
        }
        String[] billTypes = new String[]{srcEntityNumber};
        Set<String> fieldSet = ScriptFormIdHandler.extractVariables(originalScript, billTypes);
        if (fieldSet.isEmpty()) {
            return allHighLightList;
        }
        if (allHighLightList == null) {
            allHighLightList = new ArrayList<BaseHighLight>(10);
        }
        String srcVarNamePrefix = srcEntityNumber + "_billObj.";
        List<String> sourceFieldList = fieldSet.stream().filter(field -> field.startsWith(srcEntityNumber)).map(field -> field.substring(srcVarNamePrefix.length())).collect(Collectors.toList());
        sourceFieldList = this.deleteRefField(sourceFieldList, srcMainType);
        AttachmentHighLight attachmentHighLight = this.createAttachmentFieldTemplate(sourceFieldList, srcMainType);
        attachmentHighLight.setRuleIndex(ruleIndex);
        attachmentHighLight.setAttachmentPanels(attachmentPanels);
        EntryHighLight[] entryHighLights = attachmentHighLight.getEntryHighLight();
        if (entryHighLights != null && entryHighLights.length > 0) {
            if (CollectionUtils.isNotEmpty(entryIndexList)) {
                int[] indexes = new int[entryIndexList.size()];
                for (int i = 0; i < entryIndexList.size(); ++i) {
                    indexes[i] = entryIndexList.get(i);
                }
                for (EntryHighLight entryHighLight : entryHighLights) {
                    entryHighLight.setEntryIndexes(indexes);
                }
            } else {
                attachmentHighLight.setEntryHighLight(new EntryHighLight[0]);
            }
        }
        allHighLightList.add((BaseHighLight)attachmentHighLight);
        return allHighLightList;
    }

    private AttachmentHighLight createAttachmentFieldTemplate(List<String> fieldList, MainEntityType srcMainType) {
        AttachmentHighLight template = new AttachmentHighLight();
        this.createInvoiceOrAttachmentFieldTemplateCore((RowBaseHighLight)template, fieldList, srcMainType);
        return template;
    }

    public List<BaseHighLight> buildInvoiceHighLight(String originalScript, String srcEntityNumber, MainEntityType srcMainType, DynamicObject srcBillObj, InvoiceImageRuleResult invoiceImageRuleResult, List<BaseHighLight> allHighLightList, int entryIndex) {
        if (invoiceImageRuleResult == null) {
            return allHighLightList;
        }
        if (StringUtils.isEmpty((String)originalScript)) {
            return allHighLightList;
        }
        String[] billTypes = new String[]{srcEntityNumber};
        Set<String> fieldSet = ScriptFormIdHandler.extractVariables(originalScript, billTypes);
        if (fieldSet.isEmpty()) {
            return allHighLightList;
        }
        if (allHighLightList == null) {
            allHighLightList = new ArrayList<BaseHighLight>(10);
        }
        String srcVarNamePrefix = srcEntityNumber + "_billObj.";
        List<String> sourceFieldList = fieldSet.stream().filter(field -> field.startsWith(srcEntityNumber)).map(field -> field.substring(srcVarNamePrefix.length())).collect(Collectors.toList());
        sourceFieldList = this.deleteRefField(sourceFieldList, srcMainType);
        InvoiceHighLight invoiceHighLight = this.createInvoiceFieldTemplate(sourceFieldList, srcMainType);
        invoiceHighLight.setRuleNo(invoiceImageRuleResult.getRuleNo());
        EntryHighLight[] entryHighLight = invoiceHighLight.getEntryHighLight();
        if (entryHighLight != null && entryHighLight.length > 0) {
            for (EntryHighLight highLight : entryHighLight) {
                if (entryIndex >= 0) {
                    highLight.setEntryIndexes(new int[]{entryIndex});
                    continue;
                }
                if (entryIndex == -2) {
                    DynamicObjectCollection entryCols = srcBillObj.getDynamicObjectCollection(highLight.getEntryName());
                    if (CollectionUtils.isNotEmpty((Collection)entryCols)) {
                        highLight.setEntryIndexes(this.createIndexArray(entryCols.size()));
                        continue;
                    }
                    invoiceHighLight.setEntryHighLight(new EntryHighLight[0]);
                    continue;
                }
                invoiceHighLight.setEntryHighLight(new EntryHighLight[0]);
            }
        }
        allHighLightList.add((BaseHighLight)invoiceHighLight);
        return allHighLightList;
    }

    private int[] createIndexArray(int entrySize) {
        int[] result = new int[entrySize];
        for (int i = 0; i < entrySize; ++i) {
            result[i] = i;
        }
        return result;
    }

    private InvoiceHighLight createInvoiceFieldTemplate(List<String> fieldList, MainEntityType srcMainType) {
        InvoiceHighLight invoiceHighLight = new InvoiceHighLight();
        this.createInvoiceOrAttachmentFieldTemplateCore((RowBaseHighLight)invoiceHighLight, fieldList, srcMainType);
        return invoiceHighLight;
    }

    private void createInvoiceOrAttachmentFieldTemplateCore(RowBaseHighLight highLight, List<String> fieldList, MainEntityType mainType) {
        List<String> headFieldList = fieldList.stream().filter(field -> field.indexOf(".") < 0).collect(Collectors.toList());
        Map<String, Integer> headPropIndexMap = this.createFieldIndex((DynamicObjectType)mainType);
        if (CollectionUtils.isNotEmpty(headFieldList)) {
            fieldList.removeAll(headFieldList);
        }
        HashMap entryHighLightMap = new HashMap(5);
        ArrayList<Pair> sortEntryList = new ArrayList<Pair>(5);
        if (CollectionUtils.isNotEmpty(fieldList)) {
            Map<String, List<String>> entryFieldClassifyMap = fieldList.stream().collect(Collectors.groupingBy(field -> field.substring(0, field.indexOf("."))));
            entryFieldClassifyMap.forEach((entryKey, entryFieldList) -> {
                if (CollectionUtils.isNotEmpty((Collection)entryFieldList)) {
                    sortEntryList.add(new Pair((String)entryKey, headPropIndexMap.get(entryKey)));
                    EntryHighLight entryHighLightTemplate = (EntryHighLight)entryHighLightMap.get(entryKey);
                    if (entryHighLightTemplate == null) {
                        entryHighLightTemplate = this.createEntryHighLight((String)entryKey, entryHighLightMap, null);
                    }
                    DynamicProperty entryProp = mainType.getProperty(entryKey);
                    DynamicObjectType entryType = ((EntryProp)entryProp)._collectionItemPropertyType;
                    Map<String, Integer> entryPropIndexMap = this.createFieldIndex(entryType);
                    String entryPrefix = entryKey + ".";
                    ArrayList<String> realEntryFieldList = new ArrayList<String>(entryFieldList.size());
                    for (String s : entryFieldList) {
                        String realEntryField = s.substring(entryPrefix.length());
                        realEntryFieldList.add(realEntryField);
                    }
                    List<String> sortEntryFieldNameList = this.sortField(realEntryFieldList, entryPropIndexMap);
                    entryHighLightTemplate.setEntryFields(sortEntryFieldNameList.toArray(new String[0]));
                    fieldList.removeAll((Collection<?>)entryFieldList);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(sortEntryList)) {
            if (sortEntryList.size() > 1) {
                sortEntryList.sort(Comparator.comparingInt(Pair::getValue));
            }
            EntryHighLight[] entryHighLights = new EntryHighLight[sortEntryList.size()];
            for (int i = 0; i < sortEntryList.size(); ++i) {
                entryHighLights[i] = (EntryHighLight)entryHighLightMap.get(((Pair)sortEntryList.get(i)).getKey());
                if (!CollectionUtils.isNotEmpty(headFieldList)) continue;
                headFieldList.add((String)((Pair)sortEntryList.get(i)).getKey());
            }
            highLight.setEntryHighLight(entryHighLights);
        }
        if (CollectionUtils.isNotEmpty(headFieldList)) {
            List<String> sortHeadFieldList = this.sortField(headFieldList, headPropIndexMap);
            highLight.setHeadFields(sortHeadFieldList.toArray(new String[0]));
        }
    }

    public List<BaseHighLight> buildLinkUpBillDecisionHighLight(int ruleIndex, String originalScript, String srcEntityNumber, String linkEntityNumber, MainEntityType srcMainType, MainEntityType linkMainType, List<BillCheckResult> billCheckResults, boolean isTargetSelf, List<BaseHighLight> allHighLightList, Map<String, Object> funcValueMap, boolean isCrossEntry) {
        if (allHighLightList == null) {
            allHighLightList = new ArrayList<BaseHighLight>(10);
        }
        if (CollectionUtils.isEmpty(billCheckResults)) {
            return allHighLightList;
        }
        String[] billTypes = StringUtils.isEmpty((String)linkEntityNumber) ? new String[]{srcEntityNumber} : new String[]{srcEntityNumber, isTargetSelf ? "targetisself_" + linkEntityNumber : linkEntityNumber};
        Set<String> fieldSet = ScriptFormIdHandler.extractVariables(originalScript, billTypes);
        if (fieldSet.isEmpty()) {
            return allHighLightList;
        }
        String srcVarNamePrefix = srcEntityNumber + "_billObj.";
        List<String> sourceFieldList = fieldSet.stream().filter(field -> field.startsWith(srcEntityNumber)).map(field -> field.substring(srcVarNamePrefix.length())).collect(Collectors.toList());
        sourceFieldList = this.deleteRefField(sourceFieldList, srcMainType);
        Map<String, Set<String>> functionFieldMap = this.extractFunctionField(funcValueMap, srcMainType, "");
        LinkUpBillHighLight srcBillHighLight = this.createLinkUpFieldTemplate(sourceFieldList, srcMainType, functionFieldMap);
        srcBillHighLight.setSource(true);
        srcBillHighLight.setRuleIndex(ruleIndex);
        this.assemblySrcData(billCheckResults, isCrossEntry, srcBillHighLight);
        allHighLightList.add((BaseHighLight)srcBillHighLight);
        List<String> targetFieldList = null;
        if (StringUtils.isNotEmpty((String)linkEntityNumber)) {
            String linkVarNamePrefix = isTargetSelf ? "targetisself_" + linkEntityNumber + "_billObj." : linkEntityNumber + "_billObj.";
            targetFieldList = fieldSet.stream().filter(field -> field.startsWith(isTargetSelf ? "targetisself_" + linkEntityNumber : linkEntityNumber)).map(field -> field.substring(linkVarNamePrefix.length())).collect(Collectors.toList());
            targetFieldList = this.deleteRefField(targetFieldList, linkMainType);
            Map<String, Set<String>> linkFunctionFieldMap = this.extractFunctionField(funcValueMap, linkMainType, "targetisself_");
            LinkUpBillHighLight linkBillHighLight = this.createLinkUpFieldTemplate(targetFieldList, linkMainType, linkFunctionFieldMap);
            linkBillHighLight.setSource(false);
            Map<DynamicObject, List<BillCheckResult>> billResultClassifyMap = billCheckResults.stream().collect(Collectors.groupingBy(BillCheckResult::getLinkObj));
            Set<Map.Entry<DynamicObject, List<BillCheckResult>>> billResultClassifySet = billResultClassifyMap.entrySet();
            for (Map.Entry<DynamicObject, List<BillCheckResult>> dynamicObjectListEntry : billResultClassifySet) {
                List<BillCheckResult> linkBillResultList = dynamicObjectListEntry.getValue();
                LinkUpBillHighLight newLinkUpBillHighLight = linkBillHighLight.clone();
                this.assemblyLinkData(linkBillResultList, newLinkUpBillHighLight);
                newLinkUpBillHighLight.setRuleIndex(ruleIndex);
                allHighLightList.add((BaseHighLight)newLinkUpBillHighLight);
            }
        }
        return allHighLightList;
    }

    private void assemblyLinkData(List<BillCheckResult> billCheckResults, LinkUpBillHighLight linkBillHighLight) {
        String linkBillId = null;
        HashMap<String, List<Integer>> entryInteger = new HashMap<String, List<Integer>>(5);
        HashMap<String, Map<Integer, List<Integer>>> subEntryIndexMap = new HashMap<String, Map<Integer, List<Integer>>>(5);
        DynamicObject linkBill = null;
        for (BillCheckResult billCheckResult : billCheckResults) {
            linkBill = billCheckResult.getLinkObj();
            linkBillId = String.valueOf(linkBill.get("id"));
            String linkEntryName = billCheckResult.getLinkEntryName();
            int linkEntryIndex = billCheckResult.getLinkEntryIndex();
            if (linkEntryIndex <= -1) continue;
            List entryIndexList = entryInteger.computeIfAbsent(linkEntryName, key -> new ArrayList(10));
            entryIndexList.add(linkEntryIndex);
        }
        linkBillHighLight.setBillId(linkBillId);
        if (linkBill != null) {
            this.assemblyData(linkBillHighLight, entryInteger, subEntryIndexMap, linkBill);
        }
    }

    private void assemblySrcData(List<BillCheckResult> billCheckResults, boolean isCrossEntry, LinkUpBillHighLight srcBillHighLight) {
        String sourceBillId = null;
        HashMap<String, List<Integer>> entryInteger = new HashMap<String, List<Integer>>(5);
        HashMap<String, Map<Integer, List<Integer>>> subEntryIndexMap = new HashMap<String, Map<Integer, List<Integer>>>(5);
        DynamicObject srcBill = null;
        for (BillCheckResult billCheckResult : billCheckResults) {
            srcBill = billCheckResult.getSrcObj();
            sourceBillId = String.valueOf(srcBill.get("id"));
            String srcEntryName = billCheckResult.getSrcEntryName();
            int srcEntryIndex = billCheckResult.getSrcEntryIndex();
            if (srcEntryIndex > -1) {
                List entryIndexList = entryInteger.computeIfAbsent(srcEntryName, key -> new ArrayList(10));
                entryIndexList.add(srcEntryIndex);
            }
            if (!isCrossEntry) continue;
            String linkEntryName = billCheckResult.getLinkEntryName();
            int linkEntryIndex = billCheckResult.getLinkEntryIndex();
            if (linkEntryIndex <= -1) continue;
            List entryIndexList = entryInteger.computeIfAbsent(linkEntryName, key -> new ArrayList(10));
            entryIndexList.add(linkEntryIndex);
        }
        srcBillHighLight.setBillId(sourceBillId);
        this.assemblyData(srcBillHighLight, entryInteger, subEntryIndexMap, srcBill);
    }

    private void assemblyData(LinkUpBillHighLight billHighLight, Map<String, List<Integer>> entryInteger, Map<String, Map<Integer, List<Integer>>> subEntryIndexMap, DynamicObject billObj) {
        EntryHighLight[] entryHighLights = billHighLight.getEntryHighLight();
        if (entryHighLights != null && entryHighLights.length > 0) {
            ArrayList<EntryHighLight> newEntryHighLightList = new ArrayList<EntryHighLight>(entryHighLights.length);
            for (EntryHighLight entryHighLight : entryHighLights) {
                DynamicObjectCollection entryCols;
                String entryName = entryHighLight.getEntryName();
                List<Integer> entryIndexList = entryInteger.get(entryName);
                if (CollectionUtils.isNotEmpty(entryIndexList)) {
                    entryHighLight.setEntryIndexes(this.repeatIndex(entryIndexList));
                    entryCols = billObj.getDynamicObjectCollection(entryName);
                    if (CollectionUtils.isEmpty((Collection)entryCols)) {
                        String error = ResManager.loadKDString((String)"\u5355\u636e\u68c0\u67e5\u6570\u636e\u5f02\u5e38\uff0c\u83b7\u53d6\u5230\u5206\u5f55\u884c\u53f7\uff0c\u4f46\u5374\u6ca1\u6709\u5206\u5f55\u6570\u636e\uff0c\u5206\u5f55%s", (String)"HighLightBuilder_3", (String)"data-idi-core", (Object[])new Object[0]);
                        throw new KDBizException(String.format(error, entryName));
                    }
                    if (CollectionUtils.isNotEmpty((Collection)entryHighLight.getCustomFuncEntryFieldSet())) {
                        entryHighLight.setEntrySize(entryCols.size());
                    }
                } else if (CollectionUtils.isNotEmpty((Collection)entryHighLight.getCustomFuncEntryFieldSet()) && !CollectionUtils.isEmpty((Collection)(entryCols = billObj.getDynamicObjectCollection(entryName)))) {
                    entryHighLight.setEntrySize(entryCols.size());
                }
                if ((entryHighLight.getEntryIndexes() == null || entryHighLight.getEntryIndexes().length <= 0) && entryHighLight.getEntrySize() <= 0) continue;
                newEntryHighLightList.add(entryHighLight);
            }
            if (newEntryHighLightList.size() < entryHighLights.length) {
                billHighLight.setEntryHighLight(newEntryHighLightList.toArray(new EntryHighLight[0]));
            }
        }
    }

    private int[] repeatIndex(List<Integer> indexList) {
        HashSet<Integer> noRepeatIndexSet = new HashSet<Integer>(indexList);
        ArrayList<Integer> sortIndexList = new ArrayList<Integer>(noRepeatIndexSet);
        sortIndexList.sort(Integer::compare);
        return this.toIntArrays(sortIndexList);
    }

    private int[] toIntArrays(List<Integer> indexList) {
        int[] newIndexes = new int[indexList.size()];
        for (int i = 0; i < newIndexes.length; ++i) {
            newIndexes[i] = indexList.get(i);
        }
        return newIndexes;
    }

    private Map<String, Set<String>> extractFunctionField(Map<String, Object> funcValueMap, MainEntityType mainType, String preFix) {
        HashSet<String> fieldSet = new HashSet<String>(10);
        String entityNumber = mainType.getName();
        String varEntityNumber = preFix + entityNumber + "_billObj.";
        for (Map.Entry<String, Object> entry : funcValueMap.entrySet()) {
            String[] split;
            String funcScript = entry.getKey();
            int startIndex = funcScript.indexOf("(");
            int endIndex = funcScript.indexOf(")");
            String scriptStr = funcScript.substring(startIndex + 1, endIndex);
            String[] fields = split = scriptStr.split(",");
            if ((funcScript.contains(CustomFuncEnum.SUM_ENTRY.getFuncName()) || funcScript.contains(CustomFuncEnum.EXACT.getFuncName())) && split.length > 1) {
                fields = new String[1];
                System.arraycopy(split, 0, fields, 0, 1);
            }
            for (String field : fields) {
                String noSpaceField = field.trim();
                if (!noSpaceField.startsWith(varEntityNumber)) continue;
                fieldSet.add(noSpaceField.replace(varEntityNumber, ""));
            }
        }
        if (CollectionUtils.isNotEmpty(fieldSet)) {
            ArrayList<String> fieldList = new ArrayList<String>(10);
            fieldList.addAll(fieldSet);
            List<String> noRefFieldList = this.deleteRefField(fieldList, mainType);
            HashMap<String, Set<String>> functionFieldMap = new HashMap<String, Set<String>>(10);
            block7: for (String field : noRefFieldList) {
                String[] splits = field.split("\\.");
                switch (splits.length) {
                    case 1: {
                        continue block7;
                    }
                    case 2: {
                        Set entryFieldSet = functionFieldMap.computeIfAbsent(splits[0], k -> new HashSet(3));
                        entryFieldSet.add(splits[1]);
                        continue block7;
                    }
                    case 3: {
                        Set entryFieldSet2 = functionFieldMap.computeIfAbsent(splits[1], k -> new HashSet(3));
                        entryFieldSet2.add(splits[2]);
                        continue block7;
                    }
                }
                String error = ResManager.loadKDString((String)"\u5b57\u6bb5\u5f15\u7528\u5904\u7406\u9519\u8bef\uff0c\u5b57\u6bb5%s", (String)"HighLightBuilder_4", (String)"data-idi-core", (Object[])new Object[0]);
                throw new KDBizException(String.format(error, field));
            }
            return functionFieldMap;
        }
        return null;
    }

    private LinkUpBillHighLight createLinkUpFieldTemplate(List<String> fieldList, MainEntityType mainType, Map<String, Set<String>> functionFieldMap) {
        LinkUpBillHighLight template = new LinkUpBillHighLight();
        template.setBillType(mainType.getName());
        List<String> headFieldList = fieldList.stream().filter(field -> field.indexOf(".") < 0).collect(Collectors.toList());
        Map<String, Integer> headPropIndexMap = this.createFieldIndex((DynamicObjectType)mainType);
        if (CollectionUtils.isNotEmpty(headFieldList)) {
            fieldList.removeAll(headFieldList);
        }
        HashMap entryHighLightMap = new HashMap(5);
        ArrayList<Pair> sortEntryList = new ArrayList<Pair>(5);
        if (CollectionUtils.isNotEmpty(fieldList)) {
            List subEntryFullFieldList = fieldList.stream().filter(field -> field.indexOf(".") > 0 && field.indexOf(".") != field.lastIndexOf(".")).collect(Collectors.toList());
            fieldList.removeAll(subEntryFullFieldList);
        }
        if (CollectionUtils.isNotEmpty(fieldList)) {
            Map<String, List<String>> entryFieldClassifyMap = fieldList.stream().collect(Collectors.groupingBy(field -> field.substring(0, field.indexOf("."))));
            entryFieldClassifyMap.forEach((entryKey, entryFieldList) -> {
                if (CollectionUtils.isNotEmpty((Collection)entryFieldList)) {
                    EntryHighLight entryHighLightTemplate = (EntryHighLight)entryHighLightMap.get(entryKey);
                    if (entryHighLightTemplate == null) {
                        sortEntryList.add(new Pair((String)entryKey, headPropIndexMap.get(entryKey)));
                        entryHighLightTemplate = this.createEntryHighLight((String)entryKey, entryHighLightMap, functionFieldMap);
                    }
                    DynamicProperty entryProp = mainType.getProperty(entryKey);
                    DynamicObjectType entryType = ((EntryProp)entryProp)._collectionItemPropertyType;
                    Map<String, Integer> entryPropIndexMap = this.createFieldIndex(entryType);
                    String entryPrefix = entryKey + ".";
                    ArrayList<String> realEntryFieldList = new ArrayList<String>(entryFieldList.size());
                    for (String s : entryFieldList) {
                        String realEntryField = s.substring(entryPrefix.length());
                        realEntryFieldList.add(realEntryField);
                    }
                    List<String> sortEntryFieldNameList = this.sortField(realEntryFieldList, entryPropIndexMap);
                    entryHighLightTemplate.setEntryFields(sortEntryFieldNameList.toArray(new String[0]));
                    fieldList.removeAll((Collection<?>)entryFieldList);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(sortEntryList)) {
            if (sortEntryList.size() > 1) {
                sortEntryList.sort(Comparator.comparingInt(Pair::getValue));
            }
            EntryHighLight[] entryHighLights = new EntryHighLight[sortEntryList.size()];
            for (int i = 0; i < sortEntryList.size(); ++i) {
                entryHighLights[i] = (EntryHighLight)entryHighLightMap.get(((Pair)sortEntryList.get(i)).getKey());
                if (!CollectionUtils.isNotEmpty(headFieldList)) continue;
                headFieldList.add((String)((Pair)sortEntryList.get(i)).getKey());
            }
            template.setEntryHighLight(entryHighLights);
        }
        if (CollectionUtils.isNotEmpty(headFieldList)) {
            List<String> sortHeadFieldList = this.sortField(headFieldList, headPropIndexMap);
            template.setHeadFields(sortHeadFieldList.toArray(new String[0]));
        }
        return template;
    }

    private EntryHighLight createEntryHighLight(String entryKey, Map<String, EntryHighLight> entryHighLightMap, Map<String, Set<String>> functionFieldMap) {
        EntryHighLight entryHighLightTemplate = new EntryHighLight();
        entryHighLightTemplate.setEntryName(entryKey);
        entryHighLightMap.put(entryKey, entryHighLightTemplate);
        if (functionFieldMap != null) {
            Set<String> functionFieldSet = functionFieldMap.get(entryKey);
            entryHighLightTemplate.setCustomFuncEntryFieldSet(functionFieldSet);
        }
        return entryHighLightTemplate;
    }

    private List<String> sortField(List<String> fieldList, Map<String, Integer> headPropIndexMap) {
        ArrayList<Pair> sortFieldList = new ArrayList<Pair>(10);
        for (String headField : fieldList) {
            Integer index = headPropIndexMap.get(headField);
            if (index == null) {
                SchemaExecutorLogger.error("index is null. field:" + headField);
            }
            sortFieldList.add(new Pair<String, Integer>(headField, index));
        }
        if (sortFieldList.size() > 1) {
            sortFieldList.sort(Comparator.comparingInt(Pair::getValue));
        }
        List<String> sortRealFieldList = sortFieldList.stream().map(Pair::getKey).collect(Collectors.toList());
        return sortRealFieldList;
    }

    private Map<String, Integer> createFieldIndex(DynamicObjectType entityType) {
        HashMap<String, Integer> propIndexMap = new HashMap<String, Integer>(10);
        int fieldIndex = 0;
        DataEntityPropertyCollection entityPropCols = entityType.getProperties();
        for (IDataEntityProperty subProp : entityPropCols) {
            propIndexMap.put(subProp.getName(), fieldIndex++);
        }
        return propIndexMap;
    }

    private List<String> deleteRefField(List<String> fieldList, MainEntityType mainType) {
        ArrayList<String> sourceFieldNoRefList = new ArrayList<String>(fieldList.size());
        for (String srcField : fieldList) {
            String[] properties = srcField.split("\\.");
            if (properties.length >= 2) {
                ArrayList<String> entryFieldList = new ArrayList<String>(3);
                MainEntityType parentType = mainType;
                for (String property : properties) {
                    DynamicProperty prop = parentType.getProperty(property);
                    if (!(prop instanceof EntryProp)) {
                        if (entryFieldList.isEmpty()) {
                            sourceFieldNoRefList.add(property);
                            break;
                        }
                        entryFieldList.add(property);
                        break;
                    }
                    entryFieldList.add(property);
                    parentType = ((DynamicCollectionProperty)prop).getDynamicCollectionItemPropertyType();
                }
                if (entryFieldList.isEmpty()) continue;
                sourceFieldNoRefList.add(String.join((CharSequence)".", entryFieldList));
                continue;
            }
            sourceFieldNoRefList.add(srcField);
        }
        return sourceFieldNoRefList;
    }
}

