/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.data.idi.data.IDICompareType;
import kd.data.idi.engine.SchemaExecutorLogger;

public class ObjectValueCompareUtil {
    public static boolean valueCompare(Object source, Object target, IDICompareType idiCompareType) {
        try {
            if (source == null && target == null) {
                return true;
            }
            if (source == null || target == null) {
                return false;
            }
            if (source.getClass().isAssignableFrom(target.getClass())) {
                if (source instanceof Number) {
                    BigDecimal sourceDecimal = new BigDecimal(String.valueOf(source));
                    BigDecimal targetDecimal = new BigDecimal(String.valueOf(target));
                    return ObjectValueCompareUtil.compareResult(sourceDecimal.compareTo(targetDecimal), idiCompareType);
                }
                if (source instanceof Date) {
                    Date sourceDate = (Date)source;
                    Date targetDate = (Date)target;
                    return ObjectValueCompareUtil.compareResult(sourceDate.compareTo(targetDate), idiCompareType);
                }
                if (source instanceof DynamicObject) {
                    String sourceVal = String.valueOf(((DynamicObject)source).getPkValue());
                    String targetVal = String.valueOf(((DynamicObject)target).getPkValue());
                    switch (idiCompareType) {
                        case BOOLEAN_EQUALS: {
                            return sourceVal.equals(targetVal);
                        }
                        case NOT_EQUALS: {
                            return !sourceVal.equals(targetVal);
                        }
                    }
                } else if (source instanceof OrmLocaleValue) {
                    switch (idiCompareType) {
                        case BOOLEAN_EQUALS: {
                            return ((OrmLocaleValue)source).getLocaleValue().equals(((OrmLocaleValue)target).getLocaleValue());
                        }
                        case NOT_EQUALS: {
                            return !((OrmLocaleValue)source).getLocaleValue().equals(((OrmLocaleValue)target).getLocaleValue());
                        }
                    }
                } else if (source instanceof String) {
                    String sourceStr = String.valueOf(source);
                    String targetStr = String.valueOf(target);
                    switch (idiCompareType) {
                        case BOOLEAN_EQUALS: {
                            return sourceStr.equals(targetStr);
                        }
                        case NOT_EQUALS: {
                            return !sourceStr.equals(targetStr);
                        }
                    }
                }
            } else {
                if (source instanceof Number && target instanceof Number || source instanceof Number && target instanceof String || source instanceof String && target instanceof Number) {
                    BigDecimal sourceDecimal = new BigDecimal(String.valueOf(source));
                    BigDecimal targetDecimal = new BigDecimal(String.valueOf(target));
                    return ObjectValueCompareUtil.compareResult(sourceDecimal.compareTo(targetDecimal), idiCompareType);
                }
                if (source instanceof OrmLocaleValue && target instanceof String) {
                    switch (idiCompareType) {
                        case BOOLEAN_EQUALS: {
                            return ((OrmLocaleValue)source).getLocaleValue().equals(String.valueOf(target));
                        }
                        case NOT_EQUALS: {
                            return !((OrmLocaleValue)source).getLocaleValue().equals(String.valueOf(target));
                        }
                    }
                } else if (source instanceof String && target instanceof OrmLocaleValue) {
                    switch (idiCompareType) {
                        case BOOLEAN_EQUALS: {
                            return String.valueOf(source).equals(((OrmLocaleValue)target).getLocaleValue());
                        }
                        case NOT_EQUALS: {
                            return !String.valueOf(source).equals(((OrmLocaleValue)target).getLocaleValue());
                        }
                    }
                }
            }
        }
        catch (Exception convertDataTypeEx) {
            SchemaExecutorLogger.error(String.format("try to convert dataType error, source : %s, target : %s", source.getClass(), target.getClass()));
        }
        return false;
    }

    private static boolean compareResult(int compareTo, IDICompareType idiCompareType) {
        switch (idiCompareType) {
            case BOOLEAN_EQUALS: {
                return compareTo == 0;
            }
            case NOT_EQUALS: {
                return compareTo != 0;
            }
            case LARGE: {
                return compareTo > 0;
            }
            case LESS: {
                return compareTo < 0;
            }
            case LARGE_EQUALS: {
                return compareTo >= 0;
            }
            case LESS_EQUALS: {
                return compareTo <= 0;
            }
        }
        return false;
    }
}

