/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.ext.data.idi.model.BaseHighLight;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AnalysisMode;
import kd.data.idi.data.Area;
import kd.data.idi.data.AreaResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.Pair;

public class SchemaExeResultHelper {
    public static final String STATUS_RUNNING = "running";
    public static final String STATUS_SUCCEED = "succeed";
    public static final String STATUS_FAILED = "failed";

    public static long createSchemaResult(long schemaId, Object billId, String billType, String pageId) {
        DynamicObject schemaResult = SchemaExeResultHelper.createSchemaResultCommon();
        schemaResult.set("schema_id", (Object)schemaId);
        schemaResult.set("billid", (Object)String.valueOf(billId));
        schemaResult.set("billtype_id", (Object)billType);
        schemaResult.set("pageid", (Object)pageId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemaResult});
        return schemaResult.getLong("id");
    }

    public static DynamicObject createSchemaResultObj(long schemaId, Object billId, String billType, String pageId) {
        DynamicObject schemaResult = SchemaExeResultHelper.createSchemaResultCommon();
        schemaResult.set("schema_id", (Object)schemaId);
        schemaResult.set("billid", (Object)String.valueOf(billId));
        schemaResult.set("billtype_id", (Object)billType);
        schemaResult.set("pageid", (Object)pageId);
        return schemaResult;
    }

    public static void saveStatus(DynamicObject schemaResult, String status) {
        if (schemaResult == null) {
            return;
        }
        schemaResult.set("status", (Object)status);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemaResult});
    }

    public static DynamicObject createSchemaResultCommon() {
        DynamicObject schemaResult = BusinessDataServiceHelper.newDynamicObject((String)"idi_schemaexeresult");
        RequestContext rc = RequestContext.get();
        schemaResult.set("creater_id", (Object)rc.getCurrUserId());
        schemaResult.set("createdate", (Object)new Date());
        schemaResult.set("org_id", (Object)rc.getOrgId());
        schemaResult.set("traceid", (Object)rc.getTraceId());
        schemaResult.set("status", (Object)STATUS_RUNNING);
        return schemaResult;
    }

    public static void updateStatus(long id, String status) {
        DynamicObject schemaResult = BusinessDataServiceHelper.loadSingle((Object)id, (String)"idi_schemaexeresult", (String)"id,status");
        schemaResult.set("status", (Object)status);
        SaveServiceHelper.update((DynamicObject)schemaResult);
    }

    public static DynamicObject createItemResultObj(DynamicObjectType itemResultType, long schemaResultId, String areaId, String areaName, Decision decision) {
        DynamicObject itemResult = (DynamicObject)itemResultType.createInstance();
        return SchemaExeResultHelper.createItemResultObj(itemResult, schemaResultId, areaId, areaName, decision);
    }

    public static DynamicObject createItemResultObj(DynamicObject itemResult, long schemaResultId, String areaId, String areaName, Decision decision) {
        itemResult.set("schemaresultid", (Object)schemaResultId);
        itemResult.set("areaid", (Object)areaId);
        itemResult.set("area", (Object)areaName);
        itemResult.set("itemid", (Object)decision.getPk());
        itemResult.set("item", (Object)decision.getName());
        itemResult.set("matchtype", (Object)decision.getMatchType());
        itemResult.set("config_tag", (Object)IDIJSONUtils.toJsonString((Object)decision));
        itemResult.set("status", (Object)STATUS_RUNNING);
        itemResult.set("createdate", (Object)new Date());
        return itemResult;
    }

    public static void updateItemResultObjStatus(DynamicObject itemResult, String status, DecisionResult result, BigDecimal deduction) {
        List<BaseHighLight> highLightList;
        if (itemResult == null) {
            return;
        }
        itemResult.set("status", (Object)status);
        if (result != null && !CollectionUtils.isEmpty(highLightList = result.getHighLightList())) {
            itemResult.set("highlightresult_tag", (Object)IDIJSONUtils.toJsonString(highLightList));
            result.setHighLightList(null);
        }
        itemResult.set("result_tag", (Object)(result == null ? null : IDIJSONUtils.toJsonString((Object)result)));
        itemResult.set("deduction", (Object)deduction);
    }

    public static void saveItemResultSchemaResultId(DynamicObject schemaResult, List<DynamicObject> itemResultList) {
        if (schemaResult != null && !CollectionUtils.isEmpty(itemResultList)) {
            Long schemaResultId = schemaResult.getLong("id");
            for (DynamicObject itemResult : itemResultList) {
                itemResult.set("schemaresultid", (Object)schemaResultId);
            }
            SaveServiceHelper.save((DynamicObject[])itemResultList.toArray(new DynamicObject[0]));
        }
    }

    public static void updateSchemaStatusItemExitFailed(long schemaResultId) {
        if (QueryServiceHelper.exists((String)"idi_itemexeresult", (QFilter[])new QFilter[]{new QFilter("schemaresultid", "=", (Object)schemaResultId), new QFilter("status", "=", (Object)STATUS_FAILED)})) {
            SchemaExeResultHelper.updateStatus(schemaResultId, STATUS_FAILED);
        } else {
            SchemaExeResultHelper.updateStatus(schemaResultId, STATUS_SUCCEED);
        }
    }

    public static DynamicObject queryLastSchemaResult(Schema schema, Object billId, String billType, String pageId) {
        DynamicObjectCollection list;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(4);
        if (schema != null) {
            long schemaId = schema.getId();
            QFilter schemaFilter = new QFilter("schema", "=", (Object)schemaId);
            filterList.add(schemaFilter);
        }
        if (!StringUtils.isEmpty((String)pageId)) {
            QFilter pageFilter = new QFilter("pageid", "=", (Object)pageId);
            filterList.add(pageFilter);
        }
        if (billId != null) {
            QFilter billIdFilter = new QFilter("billid", "=", (Object)String.valueOf(billId));
            filterList.add(billIdFilter);
        }
        if (!StringUtils.isEmpty((String)billType)) {
            QFilter billTypeFilter = new QFilter("billtype", "=", (Object)billType);
            filterList.add(billTypeFilter);
        }
        return (list = QueryServiceHelper.query((String)"SchemaExeResultHelper.querySchemaResult", (String)"idi_schemaexeresult", (String)"id,schema,pageid,billid,billtype,status", (QFilter[])filterList.toArray(new QFilter[0]), (String)"createdate desc", (int)1)).size() == 0 ? null : (DynamicObject)list.get(0);
    }

    public static Map<DynamicObject, List<DynamicObject>> querySchemaResultByBill(String billId, String entityNumber) {
        QFilter idFilter = new QFilter("billid", "=", (Object)billId);
        QFilter[] filters = StringUtils.isEmpty((String)entityNumber) ? new QFilter[]{idFilter} : new QFilter[]{idFilter, new QFilter("billtype", "=", (Object)entityNumber)};
        DynamicObjectCollection schemaResultCol = QueryServiceHelper.query((String)"idi_schemaexeresult", (String)"id,billid,billtype,schema,createdate,status", (QFilter[])filters);
        ArrayList<Long> schemaResultIdList = new ArrayList<Long>(schemaResultCol.size());
        HashMap<DynamicObject, List<DynamicObject>> resultMap = new HashMap<DynamicObject, List<DynamicObject>>(schemaResultCol.size());
        LinkedHashMap<Long, DynamicObject> idToObjMap = new LinkedHashMap<Long, DynamicObject>(schemaResultCol.size());
        for (DynamicObject schemaObject : schemaResultCol) {
            schemaResultIdList.add(schemaObject.getLong("id"));
            resultMap.put(schemaObject, new ArrayList(10));
            idToObjMap.put(schemaObject.getLong("id"), schemaObject);
        }
        DynamicObjectCollection itemResultCol = QueryServiceHelper.query((String)"idi_itemexeresult", (String)"schemaresultid,area,item,matchtype,result_tag,status", (QFilter[])new QFilter[]{new QFilter("schemaresultid", "in", schemaResultIdList)});
        for (DynamicObject itemResultObject : itemResultCol) {
            Long schemaResultId = itemResultObject.getLong("schemaresultid");
            DynamicObject schemaObject = (DynamicObject)idToObjMap.get(schemaResultId);
            List list = (List)resultMap.get(schemaObject);
            list.add(itemResultObject);
        }
        return resultMap;
    }

    public static Map<String, String> querySchemaResultByPageIdAndPK(String pageId, String areaId, String itemId) {
        DynamicObject schemaResult;
        if (StringUtils.isEmpty((String)pageId)) {
            SchemaExecutorLogger.info("pageId is null", new Object[0]);
            return null;
        }
        DynamicObjectCollection list = QueryServiceHelper.query((String)"SchemaExeResultHelper.querySchemaResultByPageIdAndPK", (String)"idi_schemaexeresult", (String)"id,schema,pageid,billid,billtype,status", (QFilter[])new QFilter[]{new QFilter("pageid", "=", (Object)pageId)}, (String)"createdate desc", (int)1);
        DynamicObject dynamicObject = schemaResult = list.size() == 0 ? null : (DynamicObject)list.get(0);
        if (schemaResult == null) {
            SchemaExecutorLogger.info("schemaresult is null", new Object[0]);
            return null;
        }
        Object schemaResultId = schemaResult.get("id");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(4);
        filterList.add(new QFilter("schemaresultid", "=", schemaResultId));
        if (StringUtils.isEmpty((String)areaId)) {
            SchemaExecutorLogger.info("areaId is null", new Object[0]);
            return null;
        }
        filterList.add(new QFilter("areaid", "=", (Object)areaId));
        if (StringUtils.isEmpty((String)itemId)) {
            SchemaExecutorLogger.info("itemId is null", new Object[0]);
            return null;
        }
        filterList.add(new QFilter("itemid", "=", (Object)itemId));
        filterList.add(new QFilter("status", "=", (Object)STATUS_SUCCEED));
        DynamicObjectCollection itemResultCol = QueryServiceHelper.query((String)"idi_itemexeresult", (String)"matchtype,highlightresult_tag", (QFilter[])filterList.toArray(new QFilter[0]));
        if (CollectionUtils.isEmpty((Collection)itemResultCol)) {
            return null;
        }
        DynamicObject itemResult = (DynamicObject)itemResultCol.get(0);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(itemResult.getString("matchtype"), itemResult.getString("highlightresult_tag"));
        return map;
    }

    public static boolean isRunning(Schema schema, long billId, String billType, String pageId) {
        DynamicObject schemaResultObj = SchemaExeResultHelper.queryLastSchemaResult(schema, billId, billType, pageId);
        if (schemaResultObj != null) {
            String schemaStatus = schemaResultObj.getString("status");
            boolean isRunning = STATUS_RUNNING.equals(schemaStatus);
            if (isRunning) {
                SchemaExecutorLogger.info("is running pageId:" + pageId, new Object[0]);
            }
            return isRunning;
        }
        return false;
    }

    public static Pair<SchemaResult, Boolean> build(DynamicObject schemaResult, Schema schema, Object billId, String billType, String pageId) {
        boolean end = true;
        if (schemaResult != null) {
            long schemaResultId = schemaResult.getLong("id");
            String schemaStatus = schemaResult.getString("status");
            DynamicObjectCollection itemResult = QueryServiceHelper.query((String)"idi_itemexeresult", (String)"areaid,itemid,result_tag,deduction,status", (QFilter[])new QFilter[]{new QFilter("schemaresultid", "=", (Object)schemaResultId)});
            HashMap<String, HashMap<String, DynamicObject>> itemMap = new HashMap<String, HashMap<String, DynamicObject>>(10);
            for (DynamicObject itemDynamicObject : itemResult) {
                String areaId = itemDynamicObject.getString("areaid");
                String itemId = itemDynamicObject.getString("itemid");
                HashMap<String, DynamicObject> map = (HashMap<String, DynamicObject>)itemMap.get(areaId);
                if (CollectionUtils.isEmpty((Map)map)) {
                    map = new HashMap<String, DynamicObject>(5);
                    itemMap.put(areaId, map);
                }
                map.put(itemId, itemDynamicObject);
            }
            SchemaResult sr = new SchemaResult();
            sr.setStatus("success");
            end = !STATUS_RUNNING.equals(schemaStatus);
            BigDecimal score = DecisionResult.HUNDRED;
            List<Area> areaList = schema.getArea();
            ArrayList<AreaResult> areaResultList = new ArrayList<AreaResult>(areaList.size());
            sr.setAreaResults(areaResultList);
            for (Area area : areaList) {
                AreaResult areaResult = new AreaResult();
                areaResult.setArea(area);
                areaResultList.add(areaResult);
                List<Decision> decisionList = area.getDecision();
                if (decisionList == null) continue;
                Map itemResultMap = (Map)itemMap.get(area.getPk());
                if (CollectionUtils.isEmpty((Map)itemResultMap)) {
                    if (!STATUS_RUNNING.equals(schemaStatus)) continue;
                    SchemaExecutorLogger.info("modified area when schema running", new Object[0]);
                    DecisionResult result = new DecisionResult();
                    result.setStatus("loading");
                    String loadMessage = ResManager.loadKDString((String)"\u68c0\u67e5\u7ed3\u679c\u52a0\u8f7d\u4e2d\u2026\u2026", (String)"SchemaParallelExecutor_0", (String)"data-idi-core", (Object[])new Object[0]);
                    result.setShowText(loadMessage);
                    areaResult.addDecisionResult(result);
                    continue;
                }
                boolean hasRunning = false;
                for (Decision decision : decisionList) {
                    DecisionResult result;
                    if (!decision.isEnabled()) continue;
                    DynamicObject itemResultObj = (DynamicObject)itemResultMap.get(decision.getPk());
                    if (itemResultObj == null) {
                        SchemaExecutorLogger.info("modified decision when schema running", new Object[0]);
                        continue;
                    }
                    if (STATUS_RUNNING.equals(itemResultObj.getString("status"))) {
                        hasRunning = true;
                        continue;
                    }
                    String resultTag = itemResultObj.getString("result_tag");
                    if (StringUtils.isEmpty((String)resultTag) || (result = (DecisionResult)IDIJSONUtils.cast((String)resultTag, DecisionResult.class)) == null) continue;
                    result.setDecision(decision);
                    BigDecimal decisionScoreBig = new BigDecimal(decision.getMark(), DecisionResult.DECIMAL4);
                    BigDecimal deduction = decisionScoreBig.subtract(itemResultObj.getBigDecimal("deduction"));
                    score = score.subtract(deduction);
                    areaResult.addDecisionResult(result);
                }
                if (!hasRunning) continue;
                DecisionResult result = new DecisionResult();
                result.setStatus("loading");
                String loadMessage = ResManager.loadKDString((String)"\u68c0\u67e5\u7ed3\u679c\u52a0\u8f7d\u4e2d\u2026\u2026", (String)"SchemaParallelExecutor_0", (String)"data-idi-core", (Object[])new Object[0]);
                result.setShowText(loadMessage);
                areaResult.addDecisionResult(result);
            }
            if (end) {
                if (AnalysisMode.SCORE.getType().equals(schema.getAnalysisMode())) {
                    score = score.setScale(0, RoundingMode.HALF_UP);
                    sr.setScore(score.intValue());
                } else {
                    sr.setScore(-1);
                }
            } else {
                sr.setScore(-2);
            }
            return new Pair<SchemaResult, Boolean>(sr, end);
        }
        SchemaResult sr = new SchemaResult();
        sr.setStatus("exception");
        return new Pair<SchemaResult, Boolean>(sr, end);
    }

    public static void deleteRecord(String billId, String billType, Long schemaId) {
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        if (StringUtils.isEmpty((String)billType)) {
            return;
        }
        if (schemaId == null) {
            return;
        }
        List SchemaResultIdList = QueryServiceHelper.queryPrimaryKeys((String)"idi_schemaexeresult", (QFilter[])new QFilter[]{new QFilter("schema", "=", (Object)schemaId), new QFilter("billid", "=", (Object)billId), new QFilter("billtype", "=", (Object)billType)}, null, (int)-1);
        if (!CollectionUtils.isEmpty((Collection)SchemaResultIdList)) {
            DeleteServiceHelper.delete((String)"idi_itemexeresult", (QFilter[])new QFilter[]{new QFilter("schemaresultid", "in", (Object)SchemaResultIdList)});
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"idi_schemaexeresult"), (Object[])SchemaResultIdList.toArray(new Object[0]));
        }
    }

    public static void deleteRecord() {
        Date now = KDDateUtils.now();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(now);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(KDDateUtils.getSysTimeZone());
        String formatDateTime = simpleDateFormat.format(calendar.getTime());
        Date firstTimeOfDay = KDDateUtils.parseDateTime((String)formatDateTime);
        List SchemaResultIdList = QueryServiceHelper.queryPrimaryKeys((String)"idi_schemaexeresult", (QFilter[])new QFilter[]{new QFilter("createdate", "<", (Object)firstTimeOfDay)}, null, (int)-1);
        if (!CollectionUtils.isEmpty((Collection)SchemaResultIdList)) {
            DeleteServiceHelper.delete((String)"idi_itemexeresult", (QFilter[])new QFilter[]{new QFilter("schemaresultid", "in", (Object)SchemaResultIdList)});
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"idi_schemaexeresult"), (Object[])SchemaResultIdList.toArray(new Object[0]));
        }
    }
}

