/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Schema;
import kd.data.idi.decision.model.SchemaDecisionRelation;
import kd.data.idi.decision.service.SchemaDecisionService;
import kd.data.idi.opplugin.IDISchemaSaveValidator;
import kd.data.idi.util.FGPTASRefrenceHelper;
import kd.data.idi.util.IDIJSONUtils;

public class IDISchemaSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new IDISchemaSaveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        ArrayList<String> deleteSchemaNums = new ArrayList<String>(e.getDataEntities().length);
        ArrayList<SchemaDecisionRelation> saveRelations = new ArrayList<SchemaDecisionRelation>(8);
        ArrayList refList = new ArrayList(10);
        ArrayList<Long> schemaIdList = new ArrayList<Long>(10);
        for (DynamicObject schema : e.getDataEntities()) {
            String decisionTypeNums;
            String schemaNum;
            Object schemaId = schema.get("id");
            String schemaConfigStr = schema.getString("rule_tag");
            Schema schemaConfig = (Schema)IDIJSONUtils.cast((String)schemaConfigStr, Schema.class);
            if (schemaId != null && schemaConfig != null) {
                List subRefList = FGPTASRefrenceHelper.createRefrence((Long)((Long)schemaId), (Schema)schemaConfig);
                if (CollectionUtils.isNotEmpty((Collection)subRefList)) {
                    refList.addAll(subRefList);
                }
                schemaIdList.add((Long)schemaId);
            }
            if (StringUtils.isEmpty((String)(schemaNum = schema.getString("number")))) continue;
            deleteSchemaNums.add(schemaNum);
            String decisionTypeKey = schemaNum + ".decisionTypeNums";
            if (!this.getOption().containsVariable(decisionTypeKey) || StringUtils.isEmpty((String)(decisionTypeNums = this.getOption().getVariableValue(decisionTypeKey)))) continue;
            List decisionTypeNumList = (List)SerializationUtils.fromJsonString((String)decisionTypeNums, List.class);
            for (String decisionTypeNum : decisionTypeNumList) {
                SchemaDecisionRelation relation = new SchemaDecisionRelation();
                relation.setSchemaNum(schemaNum);
                relation.setDecisionNum(decisionTypeNum);
                saveRelations.add(relation);
            }
        }
        SchemaDecisionService schemaDecisionService = new SchemaDecisionService();
        schemaDecisionService.deleteBySchemaNum(deleteSchemaNums.toArray(new String[0]));
        schemaDecisionService.save(saveRelations);
        FGPTASRefrenceHelper.deleteRefrence(schemaIdList);
        if (CollectionUtils.isNotEmpty(refList)) {
            SaveServiceHelper.save((DynamicObject[])refList.toArray(new DynamicObject[0]));
        }
    }
}

