/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.pkcs;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.BERSequence;
import cn.com.infosec.asn1.BERTaggedObject;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class ContentInfo
extends ASN1Encodable
implements PKCSObjectIdentifiers {
    private DERObjectIdentifier contentType;
    private DEREncodable content;

    public static ContentInfo getInstance(Object object) {
        if (object instanceof ContentInfo) {
            return (ContentInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ContentInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public ContentInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.contentType = (DERObjectIdentifier)enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            this.content = ((DERTaggedObject)enumeration.nextElement()).getObject();
        }
    }

    public ContentInfo(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.contentType = dERObjectIdentifier;
        this.content = dEREncodable;
    }

    public DERObjectIdentifier getContentType() {
        return this.contentType;
    }

    public DEREncodable getContent() {
        return this.content;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.contentType);
        if (this.content != null) {
            aSN1EncodableVector.add(new BERTaggedObject(0, this.content));
        }
        return new BERSequence(aSN1EncodableVector);
    }
}

