/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.test;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.BERConstructedOctetString;
import cn.com.infosec.asn1.BERSequence;
import cn.com.infosec.asn1.BERSet;
import cn.com.infosec.asn1.BERTaggedObject;
import cn.com.infosec.asn1.DERApplicationSpecific;
import cn.com.infosec.asn1.DERBMPString;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DERBoolean;
import cn.com.infosec.asn1.DEREnumerated;
import cn.com.infosec.asn1.DERGeneralString;
import cn.com.infosec.asn1.DERGeneralizedTime;
import cn.com.infosec.asn1.DERIA5String;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERNull;
import cn.com.infosec.asn1.DERNumericString;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERPrintableString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERSet;
import cn.com.infosec.asn1.DERT61String;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.DERUTCTime;
import cn.com.infosec.asn1.DERUTF8String;
import cn.com.infosec.asn1.DERUniversalString;
import cn.com.infosec.asn1.DERUnknownTag;
import cn.com.infosec.asn1.DERVisibleString;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Date;

public class EqualsAndHashCodeTest
implements Test {
    public TestResult perform() {
        byte[] byArray = new byte[]{0, 1, 0, 1, 0, 0, 1};
        DERObject[] dERObjectArray = new DERObject[]{new BERConstructedOctetString(byArray), new BERSequence(new DERPrintableString("hello world")), new BERSet(new DERPrintableString("hello world")), new BERTaggedObject(0, new DERPrintableString("hello world")), new DERApplicationSpecific(64, byArray), new DERBitString(byArray), new DERBMPString("hello world"), new DERBoolean(true), new DERBoolean(false), new DEREnumerated(100), new DERGeneralizedTime(new Date()), new DERGeneralString("hello world"), new DERIA5String("hello"), new DERInteger(1000), new DERNull(), new DERNumericString("123456"), new DERObjectIdentifier("1.1.1.10000.1"), new DEROctetString(byArray), new DERPrintableString("hello world"), new DERSequence(new DERPrintableString("hello world")), new DERSet(new DERPrintableString("hello world")), new DERT61String("hello world"), new DERTaggedObject(0, new DERPrintableString("hello world")), new DERUniversalString(byArray), new DERUnknownTag(63, byArray), new DERUTCTime(new Date()), new DERUTF8String("hello world"), new DERVisibleString("hello world")};
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            int n = 0;
            while (n != dERObjectArray.length) {
                aSN1OutputStream.writeObject(dERObjectArray[n]);
                ++n;
            }
            DERObject[] dERObjectArray2 = new DERObject[dERObjectArray.length];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            int n2 = 0;
            while (n2 != dERObjectArray.length) {
                DERObject dERObject = aSN1InputStream.readObject();
                if (!dERObject.equals(dERObjectArray[n2])) {
                    return new SimpleTestResult(false, this.getName() + ": Failed equality test for " + dERObject);
                }
                if (dERObject.hashCode() != dERObjectArray[n2].hashCode()) {
                    return new SimpleTestResult(false, this.getName() + ": Failed hashCode test for " + dERObject);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString(), exception);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "EqualsAndHashCode";
    }

    public static void main(String[] stringArray) {
        EqualsAndHashCodeTest equalsAndHashCodeTest = new EqualsAndHashCodeTest();
        TestResult testResult = equalsAndHashCodeTest.perform();
        System.out.println(testResult);
    }
}

