/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.DERBMPString;
import cn.com.infosec.asn1.DERIA5String;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERString;
import cn.com.infosec.asn1.DERUTF8String;
import cn.com.infosec.asn1.DERVisibleString;

public class DisplayText
extends ASN1Encodable {
    public static final int CONTENT_TYPE_IA5STRING = 0;
    public static final int CONTENT_TYPE_BMPSTRING = 1;
    public static final int CONTENT_TYPE_UTF8STRING = 2;
    public static final int CONTENT_TYPE_VISIBLESTRING = 3;
    public static final int DISPLAY_TEXT_MAXIMUM_SIZE = 200;
    int contentType;
    DERString contents;

    public DisplayText(int n, String string) {
        if (string.length() > 200) {
            string = string.substring(0, 200);
        }
        this.contentType = n;
        switch (n) {
            case 0: {
                this.contents = new DERIA5String(string);
                break;
            }
            case 2: {
                this.contents = new DERUTF8String(string);
                break;
            }
            case 3: {
                this.contents = new DERVisibleString(string);
                break;
            }
            case 1: {
                this.contents = new DERBMPString(string);
                break;
            }
            default: {
                this.contents = new DERUTF8String(string);
            }
        }
    }

    private boolean canBePrintable(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) > '\u007f') {
                return false;
            }
            --n;
        }
        return true;
    }

    private boolean canBeUTF8(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (string.charAt(n) > '\u00ff') {
                return false;
            }
            --n;
        }
        return true;
    }

    public DisplayText(String string) {
        if (string.length() > 200) {
            string = string.substring(0, 200);
        }
        if (this.canBeUTF8(string)) {
            this.contentType = 2;
            this.contents = new DERUTF8String(string);
        } else {
            this.contentType = 1;
            this.contents = new DERBMPString(string);
        }
    }

    public DisplayText(DERString dERString) {
        this.contents = dERString;
    }

    public static DisplayText getInstance(Object object) {
        if (object instanceof DERString) {
            return new DisplayText((DERString)object);
        }
        if (object instanceof DisplayText) {
            return (DisplayText)object;
        }
        throw new IllegalArgumentException("illegal object in getInstance");
    }

    public DERObject toASN1Object() {
        return (DERObject)((Object)this.contents);
    }

    public String getString() {
        return this.contents.getString();
    }
}

