/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERTaggedObject;
import java.util.Enumeration;

public class NameConstraints
extends ASN1Encodable {
    ASN1Sequence permitted;
    ASN1Sequence excluded;

    public NameConstraints(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.permitted = ASN1Sequence.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 1: {
                    this.excluded = ASN1Sequence.getInstance(aSN1TaggedObject, false);
                }
            }
        }
    }

    public ASN1Sequence getPermittedSubtrees() {
        return this.permitted;
    }

    public ASN1Sequence getExcludedSubtrees() {
        return this.excluded;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.permitted != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.permitted));
        }
        if (this.excluded != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.excluded));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

