/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class RSAPublicKeyStructure
extends ASN1Encodable {
    private BigInteger modulus;
    private BigInteger publicExponent;

    public static RSAPublicKeyStructure getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RSAPublicKeyStructure.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static RSAPublicKeyStructure getInstance(Object object) {
        if (object == null || object instanceof RSAPublicKeyStructure) {
            return (RSAPublicKeyStructure)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RSAPublicKeyStructure((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid RSAPublicKeyStructure: " + object.getClass().getName());
    }

    public RSAPublicKeyStructure(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
    }

    public RSAPublicKeyStructure(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.modulus = ((DERInteger)enumeration.nextElement()).getPositiveValue();
        this.publicExponent = ((DERInteger)enumeration.nextElement()).getPositiveValue();
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(this.getModulus()));
        aSN1EncodableVector.add(new DERInteger(this.getPublicExponent()));
        return new DERSequence(aSN1EncodableVector);
    }
}

