/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.params.ElGamalKeyGenerationParameters;
import cn.com.infosec.crypto.params.ElGamalParameters;
import cn.com.infosec.crypto.params.ElGamalPrivateKeyParameters;
import cn.com.infosec.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        int n = this.param.getStrength() - 1;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        BigInteger bigInteger = elGamalParameters.getP();
        BigInteger bigInteger2 = elGamalParameters.getG();
        BigInteger bigInteger3 = new BigInteger(n, this.param.getRandom());
        BigInteger bigInteger4 = bigInteger2.modPow(bigInteger3, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger4, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger3, elGamalParameters));
    }
}

