/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.test;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class CipherStreamTest
implements Test {
    private TestResult runTest(String string) {
        String string2 = "ABCDEFGHIJKLMNOPQRSTUVWXY0123456789";
        try {
            KeyGenerator keyGenerator = null;
            keyGenerator = string.indexOf(47) < 0 ? KeyGenerator.getInstance(string, "INFOSEC") : KeyGenerator.getInstance(string.substring(0, string.indexOf(47)), "INFOSEC");
            Cipher cipher = Cipher.getInstance(string, "INFOSEC");
            Cipher cipher2 = Cipher.getInstance(string, "INFOSEC");
            SecretKey secretKey = keyGenerator.generateKey();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cipher.init(1, secretKey);
            if (cipher.getIV() != null) {
                cipher2.init(2, (Key)secretKey, new IvParameterSpec(cipher.getIV()));
            } else {
                cipher2.init(2, secretKey);
            }
            CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher);
            CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher2);
            int n = 0;
            while ((n = cipherInputStream.read()) >= 0) {
                cipherOutputStream.write(n);
            }
            cipherInputStream.close();
            cipherOutputStream.flush();
            cipherOutputStream.close();
            String string3 = new String(byteArrayOutputStream.toByteArray());
            if (!string3.equals(string2)) {
                return new SimpleTestResult(false, this.getName() + ": Failed - decrypted data doesn't match.");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        TestResult testResult = this.runTest("RC4");
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.runTest("DES/ECB/PKCS7Padding");
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.runTest("DES/CFB8/NoPadding");
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "CipherStreamTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new InfosecProvider());
        CipherStreamTest cipherStreamTest = new CipherStreamTest();
        TestResult testResult = cipherStreamTest.perform();
        System.out.println(testResult.toString());
    }
}

