/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.mozilla.test;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.DERIA5String;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.mozilla.PublicKeyAndChallenge;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.mozilla.SignedPublicKeyAndChallenge;
import cn.com.infosec.util.encoders.Base64;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.PublicKey;
import java.security.Security;

public class SPKACTest
implements Test {
    byte[] spkac = Base64.decode("MIIBOjCBpDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEApne7ti0ibPhV8Iht7Pws5iRckM7x4mtZYxEpeX5/IO8tDsBFdY86ewuY2f2KCca0oMWr43kdkZbPyzf4CSV+0fZm9MJyNMywygZjoOCC+rS8kr0Ef31iHChhYsyejJnjw116Jnn96syhdHY6lVD1rK0nn5ZkHjxU74gjoZu6BJMCAwEAARYAMA0GCSqGSIb3DQEBBAUAA4GBAKFLg/luv0C7gMTI8ZKfFoSyi7Q7kiSQcmSj1WJgT56ouIRJO5NdvB/1n4GNik8VOAU0NRztvGy3ZGqgbSav7lrxcNEvXH+dLbtS97s7yiaozpsOcEHqsBribpLOTRzYa8ciCwkPmIiYqcby11diKLpd+W9RFYNme2v0rrbM2CyV");

    public String getName() {
        return "SignedPubicKeyAndChallenge";
    }

    public TestResult spkacTest(String string, byte[] byArray) {
        SignedPublicKeyAndChallenge signedPublicKeyAndChallenge;
        try {
            signedPublicKeyAndChallenge = new SignedPublicKeyAndChallenge(byArray);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ":Exception - " + string + " failed decode test.");
        }
        try {
            PublicKeyAndChallenge publicKeyAndChallenge = signedPublicKeyAndChallenge.getPublicKeyAndChallenge();
            PublicKey publicKey = signedPublicKeyAndChallenge.getPublicKey("INFOSEC");
            DERObject dERObject = publicKeyAndChallenge.getDERObject();
            if (dERObject == null) {
                return new SimpleTestResult(false, this.getName() + ":Error - " + string + " PKAC DERObject was null.");
            }
            dERObject = signedPublicKeyAndChallenge.getDERObject();
            if (dERObject == null) {
                return new SimpleTestResult(false, this.getName() + ":Error - " + string + " SPKAC DERObject was null.");
            }
            SubjectPublicKeyInfo subjectPublicKeyInfo = publicKeyAndChallenge.getSubjectPublicKeyInfo();
            if (subjectPublicKeyInfo == null) {
                return new SimpleTestResult(false, this.getName() + ":Error - " + string + " SubjectPublicKeyInfo was null.");
            }
            DERIA5String dERIA5String = publicKeyAndChallenge.getChallenge();
            if (dERIA5String == null) {
                return new SimpleTestResult(false, this.getName() + ":Error - " + string + " challenge was null.");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(signedPublicKeyAndChallenge.getDERObject());
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            if (byArray2.length != byArray.length) {
                return new SimpleTestResult(false, this.getName() + ": " + string + " failed length test");
            }
            int n = 0;
            while (n != byArray.length) {
                if (byArray2[n] != byArray[n]) {
                    return new SimpleTestResult(false, this.getName() + ": " + string + " failed comparison test");
                }
                ++n;
            }
            if (!signedPublicKeyAndChallenge.verify("INFOSEC")) {
                return new SimpleTestResult(false, this.getName() + ": " + string + " verification failed");
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Exception - " + string + " " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        return this.spkacTest("spkac", this.spkac);
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new InfosecProvider());
        SPKACTest sPKACTest = new SPKACTest();
        TestResult testResult = sPKACTest.perform();
        System.out.println(testResult);
    }
}

