/*
 * Decompiled with CFR 0.152.
 */
package cfca.internal.tool;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.DEROutputStream;
import cfca.sm2rsa.common.PKIException;
import cfca.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ASN1Parser {
    private static final byte[] decodingTable = new byte[128];

    static final void initialiseDecodingTable() {
        int i;
        byte[] encoding = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        for (i = 0; i < decodingTable.length; ++i) {
            ASN1Parser.decodingTable[i] = -1;
        }
        for (i = 0; i < encoding.length; ++i) {
            ASN1Parser.decodingTable[encoding[i]] = (byte)i;
        }
        byte[] others = new byte[]{61, 32, 13, 10, 9};
        for (int i2 = 0; i2 < others.length; ++i2) {
            ASN1Parser.decodingTable[others[i2]] = (byte)i2;
        }
    }

    public static byte[] writeDERObj2Bytes(ASN1Encodable obj) throws PKIException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        try {
            dos.writeObject(obj);
            return bos.toByteArray();
        }
        catch (Exception ex) {
            throw new PKIException("850306", "\u83b7\u53d6DER\u5bf9\u8c61byte\u7f16\u7801\u5931\u8d25", ex);
        }
    }

    public static ASN1Object writeBytes2DERObj(byte[] data) throws PKIException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ASN1InputStream dis = new ASN1InputStream(bis);
        ASN1Primitive derObj = null;
        try {
            ASN1Primitive aSN1Primitive = derObj = dis.readObject();
            return aSN1Primitive;
        }
        catch (Exception ex) {
            throw new PKIException("850307", "\u4f7f\u7528byte\u6784\u9020DER\u5bf9\u8c61\u5931\u8d25", ex);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new PKIException(e);
                }
            }
        }
    }

    public static boolean isBase64Encode(byte[] data) {
        boolean passed = true;
        if (data == null) {
            passed = false;
        } else {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] < 0) {
                    passed = false;
                    break;
                }
                if (decodingTable[data[i]] >= 0) continue;
                passed = false;
                break;
            }
        }
        return passed;
    }

    public static byte[] convertBase64(byte[] data) {
        byte[] value = null;
        value = data != null && ASN1Parser.isBase64Encode(data) ? ASN1Parser.deleteCRLF(data) : data;
        return value;
    }

    public static final boolean isDERSequence(byte[] encoding) throws PKIException {
        int length;
        if (encoding == null) {
            throw new PKIException("encoding should not be null");
        }
        if (encoding.length < 2) {
            throw new PKIException("encoding length less than 4");
        }
        if (encoding[0] != 48) {
            return false;
        }
        int offset = 1;
        if ((length = encoding[offset++] & 0xFF) == 128) {
            return false;
        }
        if (length > 127) {
            int dLength = length & 0x7F;
            if (dLength > 4) {
                return false;
            }
            length = 0;
            int next = 0;
            for (int i = 0; i < dLength; ++i) {
                next = encoding[offset++] & 0xFF;
                length = (length << 8) + next;
            }
            if (length < 0) {
                return false;
            }
        }
        return encoding.length == offset + length;
    }

    public static final byte[] deleteCRLF(byte[] data) {
        byte[] values = null;
        if (data != null) {
            byte value;
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((value = (byte)in.read()) != -1) {
                if (value == 10 || value == 13) continue;
                out.write(value);
            }
            values = out.toByteArray();
        }
        return values;
    }

    public static final ASN1Sequence getDERSequenceFrom(byte[] encoding) throws PKIException {
        try {
            byte[] data;
            if (ASN1Parser.isDERSequence(encoding)) {
                return ASN1Sequence.getInstance(encoding);
            }
            if (ASN1Parser.isBERSequence(encoding)) {
                return ASN1Sequence.getInstance(encoding);
            }
            try {
                data = Base64.decode(encoding);
            }
            catch (Exception e) {
                throw new PKIException("encoding required base64 encoding", e);
            }
            return ASN1Sequence.getInstance(data);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("encoding required DERSequence encoding", e);
        }
    }

    public static final boolean isBERSequence(byte[] encoding) throws PKIException {
        int length;
        if (encoding == null) {
            throw new PKIException("encoding should not be null");
        }
        if (encoding.length < 4) {
            throw new PKIException("encoding length less than 4");
        }
        if (encoding[0] != 48) {
            return false;
        }
        int offset = 1;
        if ((length = encoding[offset++] & 0xFF) != 128) {
            return false;
        }
        return encoding[encoding.length - 1] == 0 && encoding[encoding.length - 2] == 0;
    }

    static {
        ASN1Parser.initialiseDecodingTable();
    }
}

