/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.asn1;

import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1TaggedObject;
import cfca.org.bouncycastle.asn1.OIDTokenizer;
import cfca.org.bouncycastle.asn1.StreamUtil;
import cfca.org.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DERObjectIdentifier
extends ASN1Primitive {
    String identifier;
    private byte[] body;
    private static ASN1ObjectIdentifier[][] cache = new ASN1ObjectIdentifier[255][];

    public static ASN1ObjectIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)obj;
        }
        if (obj instanceof DERObjectIdentifier) {
            return new ASN1ObjectIdentifier(((DERObjectIdentifier)obj).getId());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1ObjectIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERObjectIdentifier) {
            return DERObjectIdentifier.getInstance(o);
        }
        return ASN1ObjectIdentifier.fromOctetString(ASN1OctetString.getInstance(obj.getObject()).getOctets());
    }

    DERObjectIdentifier(byte[] bytes) {
        StringBuffer objId = new StringBuffer();
        long value = 0L;
        BigInteger bigValue = null;
        boolean first = true;
        for (int i = 0; i != bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            if (value < 0x80000000000000L) {
                value = value * 128L + (long)(b & 0x7F);
                if ((b & 0x80) != 0) continue;
                if (first) {
                    switch ((int)value / 40) {
                        case 0: {
                            objId.append('0');
                            break;
                        }
                        case 1: {
                            objId.append('1');
                            value -= 40L;
                            break;
                        }
                        default: {
                            objId.append('2');
                            value -= 80L;
                        }
                    }
                    first = false;
                }
                objId.append('.');
                objId.append(value);
                value = 0L;
                continue;
            }
            if (bigValue == null) {
                bigValue = BigInteger.valueOf(value);
            }
            bigValue = bigValue.shiftLeft(7);
            bigValue = bigValue.or(BigInteger.valueOf(b & 0x7F));
            if ((b & 0x80) != 0) continue;
            objId.append('.');
            objId.append(bigValue);
            bigValue = null;
            value = 0L;
        }
        this.identifier = objId.toString();
    }

    public DERObjectIdentifier(String identifier) {
        if (!DERObjectIdentifier.isValidIdentifier(identifier)) {
            throw new IllegalArgumentException("string " + identifier + " not an OID");
        }
        this.identifier = identifier;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(ByteArrayOutputStream out, long fieldValue) {
        byte[] result = new byte[9];
        int pos = 8;
        result[pos] = (byte)((int)fieldValue & 0x7F);
        while (fieldValue >= 128L) {
            result[--pos] = (byte)((int)(fieldValue >>= 7) & 0x7F | 0x80);
        }
        out.write(result, pos, 9 - pos);
    }

    private void writeField(ByteArrayOutputStream out, BigInteger fieldValue) {
        int byteCount = (fieldValue.bitLength() + 6) / 7;
        if (byteCount == 0) {
            out.write(0);
        } else {
            BigInteger tmpValue = fieldValue;
            byte[] tmp = new byte[byteCount];
            for (int i = byteCount - 1; i >= 0; --i) {
                tmp[i] = (byte)(tmpValue.intValue() & 0x7F | 0x80);
                tmpValue = tmpValue.shiftRight(7);
            }
            int n = byteCount - 1;
            tmp[n] = (byte)(tmp[n] & 0x7F);
            out.write(tmp, 0, tmp.length);
        }
    }

    private void doOutput(ByteArrayOutputStream aOut) {
        OIDTokenizer tok = new OIDTokenizer(this.identifier);
        this.writeField(aOut, Integer.parseInt(tok.nextToken()) * 40 + Integer.parseInt(tok.nextToken()));
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.length() < 18) {
                this.writeField(aOut, Long.parseLong(token));
                continue;
            }
            this.writeField(aOut, new BigInteger(token));
        }
    }

    protected byte[] getBody() {
        if (this.body == null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            this.doOutput(bOut);
            this.body = bOut.toByteArray();
        }
        return this.body;
    }

    public boolean isConstructed() {
        return false;
    }

    public long encodedLength() throws IOException {
        int length = this.getBody().length;
        return 1 + StreamUtil.calculateBodyLength(length) + length;
    }

    public void encode(ASN1OutputStream out) throws IOException {
        byte[] enc = this.getBody();
        out.write(6);
        out.writeLength(enc.length);
        out.write(enc);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)o).identifier);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean isValidIdentifier(String identifier) {
        if (identifier.length() < 3 || identifier.charAt(1) != '.') {
            return false;
        }
        char first = identifier.charAt(0);
        if (first < '0' || first > '2') {
            return false;
        }
        boolean periodAllowed = false;
        for (int i = identifier.length() - 1; i >= 2; --i) {
            char ch = identifier.charAt(i);
            if ('0' <= ch && ch <= '9') {
                periodAllowed = true;
                continue;
            }
            if (ch == '.') {
                if (!periodAllowed) {
                    return false;
                }
                periodAllowed = false;
                continue;
            }
            return false;
        }
        return periodAllowed;
    }

    static ASN1ObjectIdentifier fromOctetString(byte[] enc) {
        int idx2;
        ASN1ObjectIdentifier possibleMatch;
        if (enc.length < 3) {
            return new ASN1ObjectIdentifier(enc);
        }
        int idx1 = enc[enc.length - 2] & 0xFF;
        ASN1ObjectIdentifier[] first = cache[idx1];
        if (first == null) {
            DERObjectIdentifier.cache[idx1] = new ASN1ObjectIdentifier[255];
            first = DERObjectIdentifier.cache[idx1];
        }
        if ((possibleMatch = first[idx2 = enc[enc.length - 1] & 0xFF]) == null) {
            possibleMatch = first[idx2] = new ASN1ObjectIdentifier(enc);
            return possibleMatch;
        }
        if (Arrays.areEqual(enc, possibleMatch.getBody())) {
            return possibleMatch;
        }
        first = cache[idx1 = (idx1 + 1) % 256];
        if (first == null) {
            DERObjectIdentifier.cache[idx1] = new ASN1ObjectIdentifier[255];
            first = DERObjectIdentifier.cache[idx1];
        }
        if ((possibleMatch = first[idx2]) == null) {
            possibleMatch = first[idx2] = new ASN1ObjectIdentifier(enc);
            return possibleMatch;
        }
        if (Arrays.areEqual(enc, possibleMatch.getBody())) {
            return possibleMatch;
        }
        possibleMatch = first[idx2 = (idx2 + 1) % 256];
        if (possibleMatch == null) {
            possibleMatch = first[idx2] = new ASN1ObjectIdentifier(enc);
            return possibleMatch;
        }
        if (Arrays.areEqual(enc, possibleMatch.getBody())) {
            return possibleMatch;
        }
        return new ASN1ObjectIdentifier(enc);
    }
}

