/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cert.ocsp;

import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.DERBitString;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.org.bouncycastle.asn1.ocsp.OCSPRequest;
import cfca.org.bouncycastle.asn1.ocsp.Request;
import cfca.org.bouncycastle.asn1.ocsp.Signature;
import cfca.org.bouncycastle.asn1.ocsp.TBSRequest;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.Extensions;
import cfca.org.bouncycastle.asn1.x509.GeneralName;
import cfca.org.bouncycastle.cert.X509CertificateHolder;
import cfca.org.bouncycastle.cert.ocsp.CertificateID;
import cfca.org.bouncycastle.cert.ocsp.OCSPException;
import cfca.org.bouncycastle.cert.ocsp.OCSPReq;
import cfca.org.bouncycastle.operator.ContentSigner;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OCSPReqBuilder {
    private List list = new ArrayList();
    private GeneralName requestorName = null;
    private Extensions requestExtensions = null;

    public OCSPReqBuilder addRequest(CertificateID certId) {
        this.list.add(new RequestObject(certId, null));
        return this;
    }

    public OCSPReqBuilder addRequest(CertificateID certId, Extensions singleRequestExtensions) {
        this.list.add(new RequestObject(certId, singleRequestExtensions));
        return this;
    }

    public OCSPReqBuilder setRequestorName(X500Name requestorName) {
        this.requestorName = new GeneralName(4, requestorName);
        return this;
    }

    public OCSPReqBuilder setRequestorName(GeneralName requestorName) {
        this.requestorName = requestorName;
        return this;
    }

    public OCSPReqBuilder setRequestExtensions(Extensions requestExtensions) {
        this.requestExtensions = requestExtensions;
        return this;
    }

    private OCSPReq generateRequest(ContentSigner contentSigner, X509CertificateHolder[] chain) throws OCSPException {
        Iterator it = this.list.iterator();
        ASN1EncodableVector requests = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                requests.add(((RequestObject)it.next()).toRequest());
            }
            catch (Exception e) {
                throw new OCSPException("exception creating Request", e);
            }
        }
        TBSRequest tbsReq = new TBSRequest(this.requestorName, (ASN1Sequence)new DERSequence(requests), this.requestExtensions);
        Signature signature = null;
        if (contentSigner != null) {
            if (this.requestorName == null) {
                throw new OCSPException("requestorName must be specified if request is signed.");
            }
            try {
                OutputStream sOut = contentSigner.getOutputStream();
                sOut.write(tbsReq.getEncoded("DER"));
                sOut.close();
            }
            catch (Exception e) {
                throw new OCSPException("exception processing TBSRequest: " + e, e);
            }
            DERBitString bitSig = new DERBitString(contentSigner.getSignature());
            AlgorithmIdentifier sigAlgId = contentSigner.getAlgorithmIdentifier();
            if (chain != null && chain.length > 0) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                for (int i = 0; i != chain.length; ++i) {
                    v.add(chain[i].toASN1Structure());
                }
                signature = new Signature(sigAlgId, bitSig, new DERSequence(v));
            } else {
                signature = new Signature(sigAlgId, bitSig);
            }
        }
        return new OCSPReq(new OCSPRequest(tbsReq, signature));
    }

    public OCSPReq build() throws OCSPException {
        return this.generateRequest(null, null);
    }

    public OCSPReq build(ContentSigner signer, X509CertificateHolder[] chain) throws OCSPException, IllegalArgumentException {
        if (signer == null) {
            throw new IllegalArgumentException("no signer specified");
        }
        return this.generateRequest(signer, chain);
    }

    private class RequestObject {
        CertificateID certId;
        Extensions extensions;

        public RequestObject(CertificateID certId, Extensions extensions) {
            this.certId = certId;
            this.extensions = extensions;
        }

        public Request toRequest() throws Exception {
            return new Request(this.certId.toASN1Object(), this.extensions);
        }
    }
}

