/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms.jcajce;

import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import cfca.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.cms.CMSEnvelopedGenerator;
import cfca.org.bouncycastle.cms.CMSException;
import cfca.org.bouncycastle.cms.KeyAgreeRecipient;
import cfca.org.bouncycastle.cms.jcajce.CMSUtils;
import cfca.org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import cfca.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import cfca.org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import cfca.org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import cfca.org.bouncycastle.jce.spec.MQVPrivateKeySpec;
import cfca.org.bouncycastle.jce.spec.MQVPublicKeySpec;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public abstract class JceKeyAgreeRecipient
implements KeyAgreeRecipient {
    private PrivateKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;

    public JceKeyAgreeRecipient(PrivateKey recipientKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
        this.recipientKey = recipientKey;
    }

    public JceKeyAgreeRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyAgreeRecipient setProvider(String providerName) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(Provider provider) {
        this.contentHelper = CMSUtils.createContentHelper(provider);
        return this;
    }

    public JceKeyAgreeRecipient setContentProvider(String providerName) {
        this.contentHelper = CMSUtils.createContentHelper(providerName);
        return this;
    }

    private SecretKey calculateAgreedWrapKey(AlgorithmIdentifier keyEncAlg, ASN1ObjectIdentifier wrapAlg, PublicKey senderPublicKey, ASN1OctetString userKeyingMaterial, PrivateKey receiverPrivateKey) throws CMSException, GeneralSecurityException, IOException {
        String agreeAlg = keyEncAlg.getAlgorithm().getId();
        if (agreeAlg.equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            byte[] ukmEncoding = userKeyingMaterial.getOctets();
            MQVuserKeyingMaterial ukm = MQVuserKeyingMaterial.getInstance(ASN1Primitive.fromByteArray(ukmEncoding));
            SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(this.getPrivateKeyAlgorithmIdentifier(), ukm.getEphemeralPublicKey().getPublicKey().getBytes());
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(pubInfo.getEncoded());
            KeyFactory fact = this.helper.createKeyFactory(keyEncAlg.getAlgorithm());
            PublicKey ephemeralKey = fact.generatePublic(pubSpec);
            senderPublicKey = new MQVPublicKeySpec(senderPublicKey, ephemeralKey);
            receiverPrivateKey = new MQVPrivateKeySpec(receiverPrivateKey, receiverPrivateKey);
        }
        KeyAgreement agreement = this.helper.createKeyAgreement(keyEncAlg.getAlgorithm());
        agreement.init(receiverPrivateKey);
        agreement.doPhase(senderPublicKey, true);
        return agreement.generateSecret(wrapAlg.getId());
    }

    private Key unwrapSessionKey(ASN1ObjectIdentifier wrapAlg, SecretKey agreedKey, ASN1ObjectIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException, InvalidKeyException, NoSuchAlgorithmException {
        Cipher keyCipher = this.helper.createCipher(wrapAlg);
        keyCipher.init(4, agreedKey);
        return keyCipher.unwrap(encryptedContentEncryptionKey, this.helper.getBaseCipherName(contentEncryptionAlgorithm), 3);
    }

    protected Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, SubjectPublicKeyInfo senderKey, ASN1OctetString userKeyingMaterial, byte[] encryptedContentEncryptionKey) throws CMSException {
        try {
            ASN1ObjectIdentifier wrapAlg = AlgorithmIdentifier.getInstance(keyEncryptionAlgorithm.getParameters()).getAlgorithm();
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(senderKey.getEncoded());
            KeyFactory fact = this.helper.createKeyFactory(keyEncryptionAlgorithm.getAlgorithm());
            PublicKey senderPublicKey = fact.generatePublic(pubSpec);
            SecretKey agreedWrapKey = this.calculateAgreedWrapKey(keyEncryptionAlgorithm, wrapAlg, senderPublicKey, userKeyingMaterial, this.recipientKey);
            return this.unwrapSessionKey(wrapAlg, agreedWrapKey, contentEncryptionAlgorithm.getAlgorithm(), encryptedContentEncryptionKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CMSException("originator key spec invalid.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
        catch (Exception e) {
            throw new CMSException("originator key invalid.", e);
        }
    }

    public AlgorithmIdentifier getPrivateKeyAlgorithmIdentifier() {
        return PrivateKeyInfo.getInstance(this.recipientKey.getEncoded()).getAlgorithmId();
    }
}

