/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.jcajce.provider.symmetric;

import cfca.org.bouncycastle.crypto.CipherKeyGenerator;
import cfca.org.bouncycastle.crypto.engines.TEAEngine;
import cfca.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cfca.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cfca.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class TEA {
    private TEA() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = TEA.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.TEA", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.TEA", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.TEA", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "TEA IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("TEA", 128, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new TEAEngine());
        }
    }
}

