/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.openssl;

import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.DERInteger;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cfca.org.bouncycastle.asn1.x509.DSAParameter;
import cfca.org.bouncycastle.jce.PKCS10CertificationRequest;
import cfca.org.bouncycastle.openssl.PEMUtilities;
import cfca.org.bouncycastle.util.Strings;
import cfca.org.bouncycastle.util.io.pem.PemGenerationException;
import cfca.org.bouncycastle.util.io.pem.PemHeader;
import cfca.org.bouncycastle.util.io.pem.PemObject;
import cfca.org.bouncycastle.util.io.pem.PemObjectGenerator;
import cfca.org.bouncycastle.x509.X509AttributeCertificate;
import cfca.org.bouncycastle.x509.X509V2AttributeCertificate;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;

public class MiscPEMGenerator
implements PemObjectGenerator {
    private static final byte[] hexEncodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private Object obj;
    private String algorithm;
    private char[] password;
    private SecureRandom random;
    private Provider provider;

    public MiscPEMGenerator(Object o) {
        this.obj = o;
    }

    public MiscPEMGenerator(Object obj, String algorithm, char[] password, SecureRandom random, Provider provider) {
        this.obj = obj;
        this.algorithm = algorithm;
        this.password = password;
        this.random = random;
        this.provider = provider;
    }

    public MiscPEMGenerator(Object obj, String algorithm, char[] password, SecureRandom random, String provider) throws NoSuchProviderException {
        this.obj = obj;
        this.algorithm = algorithm;
        this.password = password;
        this.random = random;
        if (provider != null) {
            this.provider = Security.getProvider(provider);
            if (this.provider == null) {
                throw new NoSuchProviderException("cannot find provider: " + provider);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PemObject createPemObject(Object o) throws IOException {
        byte[] encoding;
        String type;
        if (o instanceof PemObject) {
            return (PemObject)o;
        }
        if (o instanceof PemObjectGenerator) {
            return ((PemObjectGenerator)o).generate();
        }
        if (o instanceof X509Certificate) {
            type = "CERTIFICATE";
            try {
                encoding = ((X509Certificate)o).getEncoded();
                return new PemObject(type, encoding);
            }
            catch (CertificateEncodingException e) {
                throw new PemGenerationException("Cannot encode object: " + e.toString());
            }
        } else if (o instanceof X509CRL) {
            type = "X509 CRL";
            try {
                encoding = ((X509CRL)o).getEncoded();
                return new PemObject(type, encoding);
            }
            catch (CRLException e) {
                throw new PemGenerationException("Cannot encode object: " + e.toString());
            }
        } else {
            if (o instanceof KeyPair) {
                return this.createPemObject(((KeyPair)o).getPrivate());
            }
            if (o instanceof PrivateKey) {
                PrivateKeyInfo info = new PrivateKeyInfo((ASN1Sequence)ASN1Primitive.fromByteArray(((Key)o).getEncoded()));
                if (o instanceof RSAPrivateKey) {
                    type = "RSA PRIVATE KEY";
                    encoding = info.parsePrivateKey().toASN1Primitive().getEncoded();
                    return new PemObject(type, encoding);
                } else if (o instanceof DSAPrivateKey) {
                    type = "DSA PRIVATE KEY";
                    DSAParameter p = DSAParameter.getInstance(info.getPrivateKeyAlgorithm().getParameters());
                    ASN1EncodableVector v = new ASN1EncodableVector();
                    v.add(new DERInteger(0));
                    v.add(new DERInteger(p.getP()));
                    v.add(new DERInteger(p.getQ()));
                    v.add(new DERInteger(p.getG()));
                    BigInteger x = ((DSAPrivateKey)o).getX();
                    BigInteger y = p.getG().modPow(x, p.getP());
                    v.add(new DERInteger(y));
                    v.add(new DERInteger(x));
                    encoding = new DERSequence(v).getEncoded();
                    return new PemObject(type, encoding);
                } else {
                    if (!((PrivateKey)o).getAlgorithm().equals("ECDSA")) throw new IOException("Cannot identify private key");
                    type = "EC PRIVATE KEY";
                    encoding = info.parsePrivateKey().toASN1Primitive().getEncoded();
                }
                return new PemObject(type, encoding);
            } else if (o instanceof PublicKey) {
                type = "PUBLIC KEY";
                encoding = ((PublicKey)o).getEncoded();
                return new PemObject(type, encoding);
            } else if (o instanceof X509AttributeCertificate) {
                type = "ATTRIBUTE CERTIFICATE";
                encoding = ((X509V2AttributeCertificate)o).getEncoded();
                return new PemObject(type, encoding);
            } else if (o instanceof PKCS10CertificationRequest) {
                type = "CERTIFICATE REQUEST";
                encoding = ((PKCS10CertificationRequest)o).getEncoded();
                return new PemObject(type, encoding);
            } else {
                if (!(o instanceof ContentInfo)) throw new PemGenerationException("unknown object passed - can't encode.");
                type = "PKCS7";
                encoding = ((ContentInfo)o).getEncoded();
            }
        }
        return new PemObject(type, encoding);
    }

    private String getHexEncoded(byte[] bytes) throws IOException {
        char[] chars = new char[bytes.length * 2];
        for (int i = 0; i != bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            chars[2 * i] = (char)hexEncodingTable[v >>> 4];
            chars[2 * i + 1] = (char)hexEncodingTable[v & 0xF];
        }
        return new String(chars);
    }

    private PemObject createPemObject(Object obj, String algorithm, char[] password, SecureRandom random) throws IOException {
        PrivateKey k;
        if (obj instanceof KeyPair) {
            return this.createPemObject(((KeyPair)obj).getPrivate(), algorithm, password, random);
        }
        String type = null;
        byte[] keyData = null;
        if (obj instanceof RSAPrivateCrtKey) {
            type = "RSA PRIVATE KEY";
            k = (RSAPrivateCrtKey)obj;
            cfca.org.bouncycastle.asn1.pkcs.RSAPrivateKey keyStruct = new cfca.org.bouncycastle.asn1.pkcs.RSAPrivateKey(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
            keyData = keyStruct.getEncoded();
        } else if (obj instanceof DSAPrivateKey) {
            type = "DSA PRIVATE KEY";
            k = (DSAPrivateKey)obj;
            DSAParams p = k.getParams();
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new DERInteger(0));
            v.add(new DERInteger(p.getP()));
            v.add(new DERInteger(p.getQ()));
            v.add(new DERInteger(p.getG()));
            BigInteger x = k.getX();
            BigInteger y = p.getG().modPow(x, p.getP());
            v.add(new DERInteger(y));
            v.add(new DERInteger(x));
            keyData = new DERSequence(v).getEncoded();
        } else if (obj instanceof PrivateKey && "ECDSA".equals(((PrivateKey)obj).getAlgorithm())) {
            type = "EC PRIVATE KEY";
            PrivateKeyInfo privInfo = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(((PrivateKey)obj).getEncoded()));
            keyData = privInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (type == null || keyData == null) {
            throw new IllegalArgumentException("Object type not supported: " + obj.getClass().getName());
        }
        String dekAlgName = Strings.toUpperCase(algorithm);
        if (dekAlgName.equals("DESEDE")) {
            dekAlgName = "DES-EDE3-CBC";
        }
        int ivLength = dekAlgName.startsWith("AES-") ? 16 : 8;
        byte[] iv = new byte[ivLength];
        random.nextBytes(iv);
        byte[] encData = PEMUtilities.crypt(true, this.provider, keyData, password, dekAlgName, iv);
        ArrayList<PemHeader> headers = new ArrayList<PemHeader>(2);
        headers.add(new PemHeader("Proc-Type", "4,ENCRYPTED"));
        headers.add(new PemHeader("DEK-Info", dekAlgName + "," + this.getHexEncoded(iv)));
        return new PemObject(type, headers, encData);
    }

    public PemObject generate() throws PemGenerationException {
        try {
            if (this.algorithm != null) {
                return this.createPemObject(this.obj, this.algorithm, this.password, this.random);
            }
            return this.createPemObject(this.obj);
        }
        catch (IOException e) {
            throw new PemGenerationException("encoding exception: " + e.getMessage(), e);
        }
    }
}

