/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.cmbc.tools;

import cfca.sadk.cmbc.tools.DecryptKitException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public final class DecryptKitConfig {
    String privateFile = null;
    String privateFilePassword = null;
    String peerCertFile = null;

    public DecryptKitConfig(String decryptKitPropertiesFile) throws DecryptKitException {
        this.loadFromFile(decryptKitPropertiesFile);
    }

    private void loadFromFile(String decryptKitPropertiesFile) throws DecryptKitException {
        this.loadFromFile(new File(decryptKitPropertiesFile));
    }

    private void loadFromFile(File decryptKitPropertiesFile) throws DecryptKitException {
        if (decryptKitPropertiesFile == null) {
            throw new DecryptKitException(1879117828);
        }
        if (!decryptKitPropertiesFile.isFile() || !decryptKitPropertiesFile.exists()) {
            throw new DecryptKitException(1879138304);
        }
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(decryptKitPropertiesFile);
            properties.load(fis);
        }
        catch (FileNotFoundException e) {
            throw new DecryptKitException(1879138304, (Throwable)e);
        }
        catch (IOException e) {
            throw new DecryptKitException(1879138304, (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {}
        }
        String myPrivateFile = properties.getProperty("PrivateFile");
        if (myPrivateFile == null || "".equals(myPrivateFile)) {
            throw new DecryptKitException(1879138305);
        }
        String myPrivateFilePassword = properties.getProperty("PrivateFilePassword");
        if (myPrivateFilePassword == null) {
            throw new DecryptKitException(1879138306);
        }
        String myPeerCertFile = properties.getProperty("PeerCertFile");
        if (myPeerCertFile == null || "".equals(myPeerCertFile)) {
            throw new DecryptKitException(1879138307);
        }
        this.privateFile = myPrivateFile;
        this.privateFilePassword = myPrivateFilePassword;
        this.peerCertFile = myPeerCertFile;
    }

    public String getPrivateFile() {
        return this.privateFile;
    }

    public String getPrivateFilePassword() {
        return this.privateFilePassword;
    }

    public String getPeerCertFile() {
        return this.peerCertFile;
    }
}

