/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk32.signature.sm2;

import cfca.sadk32.org.bouncycastle.util.BigIntegers;
import cfca.sadk32.signature.sm2.BCSoftSM2;
import cfca.sm2.signature.SM2PrivateKey;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.PKIException;
import cryptokit.jni.JNISM2;
import java.math.BigInteger;
import java.security.Key;

public final class SM2PackageUtil {
    public static byte[] encryptByBC(byte[] digestData, Key privateKey) throws Exception {
        if (privateKey == null) {
            throw new IllegalArgumentException("null not allowed for privateKey");
        }
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        if (!(privateKey instanceof SM2PrivateKey)) {
            throw new PKIException("The private key type is not sm2 type!");
        }
        return BCSoftSM2.sign(digestData, ((SM2PrivateKey)privateKey).getD());
    }

    public static boolean verifyByBC(byte[] digestData, byte[] signature, Key publicKey) throws Exception {
        if (publicKey == null) {
            throw new IllegalArgumentException("null not allowed for publicKey");
        }
        if (!(publicKey instanceof SM2PublicKey)) {
            throw new PKIException("the key type is not SM2 public key");
        }
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        if (signature == null || signature.length != 64) {
            throw new Exception("the signature data is null or not 64 bytes!");
        }
        return BCSoftSM2.verify(digestData, signature, ((SM2PublicKey)publicKey).getQ());
    }

    public static final byte[] encryptByJNI(byte[] digestData, BigInteger d) throws Exception {
        if (d == null) {
            throw new IllegalArgumentException("null not allowed for d(privatekey)");
        }
        return SM2PackageUtil.encryptByJNI(digestData, BigIntegers.asUnsignedByteArray(32, d));
    }

    public static final byte[] encryptByJNI(byte[] digestData, byte[] d) throws Exception {
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        if (d == null || d.length != 32) {
            throw new IllegalArgumentException("null/length not allowed for d(privatekey)");
        }
        byte[] sign = new byte[64];
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        JNISM2.sign(digestData, d, r, s);
        System.arraycopy(r, 0, sign, 0, 32);
        System.arraycopy(s, 0, sign, 32, 32);
        return sign;
    }

    public static boolean verifyByJNI(byte[] digestData, byte[] signature, byte[] pubX, byte[] pubY) throws Exception {
        if (digestData == null || digestData.length != 32) {
            throw new Exception("the digest data is null or not 32 bytes!");
        }
        if (signature == null || signature.length != 64) {
            throw new Exception("the signature data is null or not 64 bytes!");
        }
        if (pubX == null || pubY == null) {
            throw new IllegalArgumentException("null not allowed for pubX/pubY");
        }
        if (pubX.length != 32) {
            throw new IllegalArgumentException("length not allowed for pubX");
        }
        if (pubY.length != 32) {
            throw new IllegalArgumentException("length not allowed for pubY");
        }
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        System.arraycopy(signature, 0, r, 0, 32);
        System.arraycopy(signature, 32, s, 0, 32);
        return JNISM2.verify(r, s, pubX, pubY, digestData);
    }
}

